/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.utils;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ErrorJobInfo;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.zk.ZkConfig;

public class ErrorProcessUtils {
    private static final Log log = LogFactory.getLog(ErrorProcessUtils.class);
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("SCHEDULE", new DistributeCacheHAPolicy(true, true));
    private static final String SCHEDULE_ERROR_TAG = "sch_error_tag:";

    public static ErrorJobInfo buildErrorJobInfo(JobInfo jobInfo, Throwable t) {
        ErrorJobInfo errorJobInfo = new ErrorJobInfo();
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        t.printStackTrace(new PrintWriter(buf, true));
        String errorReason = buf.toString();
        errorJobInfo.setJobId(jobInfo.getId());
        errorJobInfo.setRetryTime(jobInfo.getRetryTime());
        if (StringUtils.isBlank((CharSequence)jobInfo.getTaskId())) {
            jobInfo.setTaskId(String.valueOf(DB.genLongId((String)"T_SCH_TASK")));
        }
        errorJobInfo.setTaskId(jobInfo.getTaskId());
        errorJobInfo.setErrorReason(ErrorProcessUtils.buildSchErrMsg(jobInfo.getTaskId(), errorReason));
        if (errorJobInfo.getRunat() == null) {
            String runAt = ZkConfig.getHostIpAddress();
            errorJobInfo.setRunat(runAt);
        }
        errorJobInfo.setJobInfo(jobInfo);
        return errorJobInfo;
    }

    public static int getJobInfoRetryTime(JobInfo jobInfo) {
        String retryTime = (String)cache.get(SCHEDULE_ERROR_TAG + jobInfo.getTaskId());
        if (StringUtils.isBlank((CharSequence)retryTime)) {
            return 0;
        }
        if (StringUtils.isNumeric((CharSequence)retryTime)) {
            return Integer.parseInt(retryTime);
        }
        return 0;
    }

    public static void updateFailRetryTime(JobInfo jobInfo, int curRetryTime) {
        int newRetryTime = ++curRetryTime;
        cache.put(SCHEDULE_ERROR_TAG + jobInfo.getTaskId(), (Object)String.valueOf(newRetryTime));
    }

    public static String buildSchErrMsg(String taskId, String errInfo) {
        return String.format("Schedule Task execue failed, AppName: %1$s,InstanceId: %2$s,taskId: %3$s ,errorInfo: %4$s", Instance.getAppName(), Instance.getInstanceId(), taskId, errInfo);
    }
}

