/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dc.utils.MCApiUtil;
import kd.bos.exception.KDException;
import kd.bos.instance.AppGroup;
import kd.bos.instance.Instance;
import kd.bos.instance.MainGroupChangeListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.endpoint.EndPointDispatchServiceHelper;
import kd.bos.orm.ORM;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.message.rpc.RPCHelper;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.HttpClientUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.zookeeper.CreateMode;

public class ScheduleGrayGroup {
    private static Log log = LogFactory.getLog(ScheduleGrayGroup.class);
    private static Map<String, Map<String, String>> graySchedule = new ConcurrentHashMap<String, Map<String, String>>(20);
    private static Map<String, Map<String, List<String>>> grayApp = new ConcurrentHashMap<String, Map<String, List<String>>>(10);
    private static Map<String, Boolean> accountDataInitStatus = new ConcurrentHashMap<String, Boolean>(10);
    private static AtomicBoolean serviceInitialized = new AtomicBoolean(false);
    public static Map<String, Set<String>> grayNodeStatu = new ConcurrentHashMap<String, Set<String>>(10);
    private static final String KEY_SCH_GRAYENABLE = "schedule.grayupgrade.enable";
    private static boolean OUTPUTLOG = Boolean.getBoolean("schedule.gray.log.enable");
    private static String LOGKEYWORD = "/*Schedule_GaryGroup*/";
    private static Map<MessageType, Map<String, String>> grayChangingAppIds = new EnumMap<MessageType, Map<String, String>>(MessageType.class);
    private static Map<String, Map<String, String>> grayProdNumMap;
    private static long mcIntervalMs;
    private static Date lastUpdateProdNumTs;
    private static List<PathChildrenCache> grayListener;

    public static boolean isGrayUpgrade() {
        return AppGroup.isGrayUpgrade() && Boolean.parseBoolean(System.getProperty(KEY_SCH_GRAYENABLE, "true"));
    }

    public static void logInfo(String message) {
        if (OUTPUTLOG) {
            log.info(message);
        }
    }

    public static void logError(String message, Exception e) {
        if (OUTPUTLOG) {
            log.error(message, (Throwable)e);
        }
    }

    private static String getAppGroup(String appId, String scheduleId) {
        Map<String, String> appGroupMapping;
        RequestContext rs = RequestContext.get();
        if (accountDataInitStatus.get(rs.getAccountId()) == null || !accountDataInitStatus.get(rs.getAccountId()).booleanValue()) {
            ScheduleGrayGroup.loadAccountConfig(rs);
        }
        int maxTimes = 3;
        while (!serviceInitialized.get()) {
            LockSupport.parkNanos(300000000L);
            if (--maxTimes >= 0) continue;
            log.error(LOGKEYWORD + "ScheduleGray init timeout");
            return "";
        }
        Set<String> activeGroups = grayNodeStatu.get(appId);
        if (activeGroups == null || activeGroups.isEmpty()) {
            ScheduleGrayGroup.logInfo(LOGKEYWORD + String.format("can not find gray node with app:%s", appId));
            return null;
        }
        String accountAppGroup = AppGroup.getGrayingAccountGroup((String)appId, (String)rs.getAccountId());
        if (StringUtils.isBlank((CharSequence)accountAppGroup) && ScheduleGrayGroup.checkAccountGrayNode()) {
            ScheduleGrayGroup.logInfo(LOGKEYWORD + String.format("accountappgroup is null , app=%s , rs=%s", appId, rs.getAccountId()));
            return null;
        }
        List<String> byAppProdNums = grayApp.get(rs.getAccountId()).get(appId);
        String grayProdNum = graySchedule.get(rs.getAccountId()).get(scheduleId);
        String appTypeRouteGroup = null;
        String schTypeRouteGroup = null;
        if (StringUtils.isNotBlank((CharSequence)grayProdNum)) {
            appGroupMapping = ScheduleGrayGroup.getGrayProdNumMap(false).get(grayProdNum);
            if (appGroupMapping != null && !appGroupMapping.isEmpty()) {
                schTypeRouteGroup = appGroupMapping.get(appId);
            }
            ScheduleGrayGroup.logInfo(LOGKEYWORD + "plan gray code:" + grayProdNum + ",plan gray group:" + schTypeRouteGroup);
        }
        if (byAppProdNums != null && !byAppProdNums.isEmpty()) {
            appGroupMapping = ScheduleGrayGroup.getGrayProdNumMap(false).get(byAppProdNums.get(0));
            if (appGroupMapping != null && !appGroupMapping.isEmpty()) {
                appTypeRouteGroup = appGroupMapping.get(appId);
            }
            ScheduleGrayGroup.logInfo(LOGKEYWORD + "app gray code:" + byAppProdNums.get(0) + ",app gray group:" + appTypeRouteGroup);
        }
        String group = null;
        if (schTypeRouteGroup != null && activeGroups.contains(schTypeRouteGroup)) {
            log.info(LOGKEYWORD + String.format("schedule-gray-route --schTypeRoteGroup: %s__%s", scheduleId, schTypeRouteGroup));
            group = schTypeRouteGroup;
        } else if (appTypeRouteGroup != null && activeGroups.contains(appTypeRouteGroup)) {
            log.info(LOGKEYWORD + String.format("schedule-gray-route --appTypeRouteGroup: %s__%s", scheduleId, appTypeRouteGroup));
            group = appTypeRouteGroup;
        } else if (OUTPUTLOG) {
            ScheduleGrayGroup.logInfo(LOGKEYWORD + String.format("plan's route:%s , app's route: %s \uff0ccan not find activity node.", schTypeRouteGroup, appTypeRouteGroup) + String.format("all-activitienode : %s , app-activitygroupnode : %s", SerializationUtils.toJsonString(grayNodeStatu), SerializationUtils.toJsonString(activeGroups)));
        }
        ScheduleGrayGroup.logInfo(LOGKEYWORD + "schedule group\uff1a" + group + ",maingroup" + AppGroup.getMainAppGroup((String)appId));
        if (StringUtils.equals(group, (CharSequence)AppGroup.getMainAppGroup((String)appId))) {
            return null;
        }
        return group;
    }

    private static boolean checkAccountGrayNode() {
        return Boolean.parseBoolean(System.getProperty("schedule.gray.accountcheck.enable", "true"));
    }

    public static String getJobAppGourp(JobInfo jobInfo, MessageType msgType) {
        boolean isExistGroup;
        if (!ScheduleGrayGroup.isGrayUpgrade()) {
            return null;
        }
        String serviceAppId = ZkConfig.isRouteToCustom() ? (StringUtils.isNotBlank((CharSequence)jobInfo.getAppId()) ? ServiceLookup.getServiceAppId((String)jobInfo.getAppId()) : "") : jobInfo.getAppId();
        Set existGroups = AppGroup.getGrayingAppGroup((String)serviceAppId);
        boolean bl = isExistGroup = existGroups != null && !existGroups.isEmpty();
        if (jobInfo.isFromScheduler()) {
            ScheduleGrayGroup.logInfo(LOGKEYWORD + "find task gray route,job : " + jobInfo.getNumber());
            String group = ScheduleGrayGroup.getAppGroup(serviceAppId, jobInfo.getScheduleId());
            if (StringUtils.isNotBlank((CharSequence)group) && isExistGroup) {
                return group;
            }
            if (StringUtils.isNotBlank((CharSequence)group) && !isExistGroup) {
                return null;
            }
            Map<String, String> cacheMark = grayChangingAppIds.get(msgType);
            if (cacheMark != null) {
                group = cacheMark.get(serviceAppId);
                group = StringUtils.equals((CharSequence)"defaultGroup", (CharSequence)group) ? null : group;
                ScheduleGrayGroup.logInfo("schedule-gray-route_maingroup:" + group + ",jobinfo:" + SerializationUtils.toJsonString((Object)jobInfo) + ",cacheMark:" + SerializationUtils.toJsonString(cacheMark));
                return group;
            }
            if (OUTPUTLOG) {
                ScheduleGrayGroup.logInfo("grayChangingAppIds=" + SerializationUtils.toJsonString(grayChangingAppIds));
            }
            return null;
        }
        if (jobInfo.getJobType() == JobType.WORKFLOW || jobInfo.getJobType() == JobType.REALTIME) {
            String group = AppGroup.getCurAppGroup();
            String accountAppGroup = AppGroup.getGrayingAccountGroup((String)serviceAppId, (String)RequestContext.get().getAccountId());
            if (StringUtils.isBlank((CharSequence)accountAppGroup) && ScheduleGrayGroup.checkAccountGrayNode()) {
                return null;
            }
            if (AppGroup.isCurrentGrayNode() && isExistGroup && existGroups.contains(group)) {
                ScheduleGrayGroup.logInfo(String.format("schedule-gray-route, jobId=%s,taskId=%s,msgType=%s,group=%s", jobInfo.getId(), jobInfo.getTaskId(), msgType.name(), group));
                return group;
            }
        }
        return null;
    }

    @Deprecated
    public static String getJobAppGourp(JobInfo jobInfo) {
        if (!ScheduleGrayGroup.isGrayUpgrade()) {
            return null;
        }
        String serviceAppId = ZkConfig.isRouteToCustom() ? (StringUtils.isNotBlank((CharSequence)jobInfo.getAppId()) ? ServiceLookup.getServiceAppId((String)jobInfo.getAppId()) : "") : jobInfo.getAppId();
        if (jobInfo.isFromScheduler()) {
            ScheduleGrayGroup.logInfo(LOGKEYWORD + "find task gray route,job : " + jobInfo.getNumber());
            String group = ScheduleGrayGroup.getAppGroup(serviceAppId, jobInfo.getScheduleId());
            String mainGroup = AppGroup.getMainAppGroup((String)serviceAppId);
            if (StringUtils.isNotBlank((CharSequence)group) && !group.equals(mainGroup)) {
                return group;
            }
        } else if (jobInfo.getJobType() == JobType.WORKFLOW || jobInfo.getJobType() == JobType.REALTIME) {
            String group = AppGroup.getCurAppGroup();
            String accountAppGroup = AppGroup.getGrayingAccountGroup((String)serviceAppId, (String)RequestContext.get().getAccountId());
            if (StringUtils.isBlank((CharSequence)accountAppGroup) && ScheduleGrayGroup.checkAccountGrayNode()) {
                return null;
            }
            if (AppGroup.isGrayUpgrade() && StringUtils.isNotBlank((CharSequence)group) && !StringUtils.equals((CharSequence)group, (CharSequence)"defaultGroup") && !StringUtils.equals((CharSequence)group, (CharSequence)AppGroup.getMainAppGroup((String)serviceAppId))) {
                return group;
            }
        }
        return null;
    }

    public static void init() {
        serviceInitialized.set(false);
    }

    public static void endInit() {
        serviceInitialized.set(true);
        ScheduleGrayGroup.logInfo(LOGKEYWORD + "node info\uff1a" + SerializationUtils.toJsonString(grayNodeStatu));
    }

    public static void updateGrayConfig(RequestContext rs) {
        accountDataInitStatus.remove(rs.getAccountId());
    }

    private static synchronized void loadAccountConfig(RequestContext rs) {
        Map<String, String> scheduleConfig;
        Map<String, List<String>> appConfig;
        block18: {
            grayApp.putIfAbsent(rs.getAccountId(), new ConcurrentHashMap());
            appConfig = grayApp.get(rs.getAccountId());
            appConfig.clear();
            graySchedule.putIfAbsent(rs.getAccountId(), new ConcurrentHashMap());
            scheduleConfig = graySchedule.get(rs.getAccountId());
            scheduleConfig.clear();
            try {
                if (DB.exitsTable((DBRoute)DBRoute.of((String)"sys"), (String)"t_sch_graysetting")) {
                    ORM orm = ORM.create();
                    try (DataSet ds = orm.queryDataSet("schdule_graysetting", "sch_graysetting", "bizapp.number,schedule.id,iswholeapp,grayver,appnumber", null);){
                        while (ds.hasNext()) {
                            Row row = ds.next();
                            String number = row.getString("appnumber");
                            if (StringUtils.isBlank((CharSequence)number)) {
                                number = String.valueOf(row.get("bizapp.number"));
                            }
                            boolean wholeapp = row.getBoolean("iswholeapp");
                            Object scheduleid = row.get("schedule.id");
                            Object ver = row.get("grayver");
                            if (wholeapp) {
                                appConfig.putIfAbsent(String.valueOf(number), new ArrayList(3));
                                List<String> vers = appConfig.get(String.valueOf(number));
                                vers.add(String.valueOf(ver));
                                continue;
                            }
                            scheduleConfig.put(String.valueOf(scheduleid), String.valueOf(ver));
                        }
                        break block18;
                    }
                }
                log.error(LOGKEYWORD + "t_sch_graysetting not exist");
            }
            catch (Exception e) {
                log.error(LOGKEYWORD + "schedule_gray load setting error");
            }
        }
        ScheduleGrayGroup.logInfo(LOGKEYWORD + "current account schedule gray config:  schedule:" + SerializationUtils.toJsonString(scheduleConfig) + ", app:" + SerializationUtils.toJsonString(appConfig));
        accountDataInitStatus.put(rs.getAccountId(), true);
    }

    private static Map<String, Map<String, String>> getGrayProdNumMap(boolean forceUpdate) {
        Date current = new Date();
        if (forceUpdate || current.getTime() - lastUpdateProdNumTs.getTime() > mcIntervalMs) {
            grayProdNumMap.clear();
            grayProdNumMap.putAll(ScheduleGrayGroup.getGrayProdNum());
            lastUpdateProdNumTs = current;
            ScheduleGrayGroup.logInfo(LOGKEYWORD + "gray version:" + SerializationUtils.toJsonString(grayProdNumMap));
        }
        return grayProdNumMap;
    }

    public static Map<String, Map<String, String>> getGrayProdNum() {
        Map res = Collections.EMPTY_MAP;
        try {
            Object grayAppGroup = ScheduleGrayGroup.getGrayAppGroup();
            if (grayAppGroup != null) {
                res = (Map)grayAppGroup;
            }
        }
        catch (Exception var3) {
            log.error(LOGKEYWORD + "get grayAppGroup from mc error ", (Throwable)var3);
        }
        return res;
    }

    public static Object getGrayAppGroup() throws KDException {
        try {
            String clusterName = Instance.getClusterName();
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("clusterNumber", clusterName);
            return MCApiUtil.getMCAPIInfo((String)"/kapi/app/mc/getGrayAppGroup", (boolean)true, ScheduleGrayGroup.genMCHeaders(), map);
        }
        catch (KDException e) {
            log.error(LOGKEYWORD + "getGrayAppGroup from mc error:", (Throwable)e);
            throw e;
        }
    }

    public static void stopGray(Map<String, Object> params) {
        try {
            String group = (String)params.get("group");
            if (Boolean.getBoolean("schedule.gray.upgrade.cleargrayconfig") && StringUtils.isNotBlank((CharSequence)group)) {
                RequestContext rc = RequestContext.get();
                log.info("clean gray info: group=" + group);
                String schDeleteSql = "delete from t_sch_graysetting where FGROUP = ?";
                Object[] schDeleteparams = new SqlParameter[]{new SqlParameter(":FGROUP", 12, (Object)group)};
                DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)schDeleteSql, (Object[])schDeleteparams);
                HashMap<String, String> msgMap = new HashMap<String, String>(3);
                msgMap.put("tenantId", rc.getTenantId());
                msgMap.put("accountId", rc.getAccountId());
                msgMap.put("userId", rc.getUserId());
                if (ZkConfig.isSupportZk()) {
                    ActiveKeyValueStore.create().write(ZkConfig.getGrayChangedMessagePath() + "/chg_", SerializationUtils.toJsonString(msgMap), CreateMode.PERSISTENT_SEQUENTIAL);
                } else {
                    String masterRpcIp = RPCHelper.getMasterRpcIp();
                    EndPointDispatchServiceHelper.invoke((String)masterRpcIp, (String)"kd.bos.schedule.server.ScheduleService", (String)"grayChanged", (Object[])new Object[]{SerializationUtils.toJsonString(msgMap)});
                }
            }
        }
        catch (Exception e) {
            log.error(String.format("%s%s,errinfo:%s", LOGKEYWORD, "gray stop fail", e.getMessage()), (Throwable)e);
        }
    }

    private static String getMCToken() {
        String mcUrl = System.getProperty("mc.server.url");
        String api = mcUrl + "/api/upgradeLogin.do";
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("accountId", "");
        String resp = "";
        try {
            resp = HttpClientUtils.postjson((String)api, null, (String)JSON.toJSONString(body));
            JSONObject json = JSON.parseObject((String)resp);
            String state = json.getString("state");
            if (!"success".equals(state)) {
                throw new IOException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u8fd4\u56de\u9519\u8bef[%s]", (String)"ScheduleGrayGroup_0", (String)"bos-schedule-message", (Object[])new Object[0]), json.getString("errorMsg")));
            }
            JSONObject data = JSON.parseObject((String)json.getString("data"));
            return data.getString("access_token");
        }
        catch (IOException e) {
            log.error(LOGKEYWORD + "getMCToken error, resp: {}", (Object)resp, (Object)e);
            return resp;
        }
    }

    private static Map<String, String> genMCHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(4);
        String token = ScheduleGrayGroup.getMCToken();
        headers.put("api", "true");
        headers.put("access_token", token);
        headers.put("accessToken", token);
        return headers;
    }

    public static void startConfigListener() {
        accountDataInitStatus.clear();
        grayApp.clear();
        graySchedule.clear();
        grayProdNumMap.clear();
        lastUpdateProdNumTs = new Date(new Date().getTime() - mcIntervalMs);
        ScheduleGrayGroup.startToListenScheduleChange();
        ScheduleGrayGroup.startToListenGrayInstanceChange();
    }

    public static void stopConfigListener() {
        try {
            for (PathChildrenCache changeListener : grayListener) {
                try {
                    if (changeListener == null) continue;
                    changeListener.close();
                }
                catch (Throwable e) {
                    log.error(LOGKEYWORD + "close changeListner err, errmsg:" + e.getMessage());
                }
            }
            accountDataInitStatus.clear();
            grayApp.clear();
            graySchedule.clear();
            grayProdNumMap.clear();
            grayChangingAppIds.clear();
            lastUpdateProdNumTs = new Date(new Date().getTime() - mcIntervalMs);
        }
        catch (Exception e) {
            log.error(LOGKEYWORD + "errmsg:" + e.getMessage());
        }
    }

    private static void startToListenScheduleChange() {
        if (!ZkConfig.isSupportZk()) {
            return;
        }
        final ActiveKeyValueStore zkStore = ActiveKeyValueStore.create();
        PathChildrenCache changeListener = new PathChildrenCache(zkStore.getCuratorFramework(), ZkConfig.getGrayChangedMessagePath(), true);
        PathChildrenCacheListener listener = new PathChildrenCacheListener(){

            public void childEvent(CuratorFramework curatorFramework, PathChildrenCacheEvent event) throws Exception {
                try {
                    if (event.getType() == PathChildrenCacheEvent.Type.CHILD_ADDED || event.getType() == PathChildrenCacheEvent.Type.CHILD_UPDATED) {
                        List<String> children = zkStore.getChildren(ZkConfig.getGrayChangedMessagePath());
                        for (String child : children) {
                            String changePath = ZkConfig.getGrayChangedMessagePath() + "/" + child;
                            String message = zkStore.read(changePath, null);
                            ScheduleGrayGroup.updateGrayConfig(message);
                            zkStore.delete(changePath);
                        }
                    }
                }
                catch (Exception e) {
                    log.error(LOGKEYWORD + "gray monitor error:" + e.getMessage(), (Throwable)e);
                }
            }
        };
        changeListener.getListenable().addListener((Object)listener);
        try {
            changeListener.start();
            grayListener.add(changeListener);
        }
        catch (Exception e) {
            log.error(LOGKEYWORD + "gray data monitor start fail");
        }
    }

    public static void updateGrayConfig(String message) {
        Map changeMsgMap = (Map)SerializationUtils.fromJsonString((String)message, Map.class);
        String accountId = (String)changeMsgMap.get("accountId");
        accountDataInitStatus.remove(accountId);
    }

    public static boolean canRemoteDispatch(JobType jobType, String appId) {
        String[] appids;
        if (JobType.REALTIME != jobType || !ScheduleGrayGroup.isGrayUpgrade() || StringUtils.isBlank((CharSequence)AppGroup.getCurAppGroup())) {
            return true;
        }
        String appidstr = System.getProperty("schedule.gray.localdispatch.appids", "imp-exp,svc-print");
        if (StringUtils.isBlank((CharSequence)appidstr)) {
            return true;
        }
        for (String id : appids = appidstr.split(",")) {
            if (!StringUtils.equals((CharSequence)id, (CharSequence)appId)) continue;
            return false;
        }
        return true;
    }

    public static void registGroupListener(MainGroupChangeListener listener) {
        AppGroup.registGroupListener((MainGroupChangeListener)listener);
    }

    private static void startToListenGrayInstanceChange() {
        try {
            if (!ScheduleGrayGroup.isGrayUpgrade()) {
                return;
            }
            ActiveKeyValueStore zkStore = ActiveKeyValueStore.create();
            zkStore.ensureExisted(ZkConfig.getGrayInstanceChangingPath(), String.valueOf(System.currentTimeMillis()));
            String wfPath = ZkConfig.getGrayInstanceChangingPath() + "/" + MessageType.WorkFlowJOB;
            String bizPath = ZkConfig.getGrayInstanceChangingPath() + "/" + MessageType.BIZJOB;
            String realtimePath = ZkConfig.getGrayInstanceChangingPath() + "/" + MessageType.REALTIMEJOB;
            zkStore.ensureExisted(wfPath, String.valueOf(System.currentTimeMillis()));
            zkStore.ensureExisted(bizPath, String.valueOf(System.currentTimeMillis()));
            zkStore.ensureExisted(realtimePath, String.valueOf(System.currentTimeMillis()));
            if (!ZkConfig.isSupportZk()) {
                return;
            }
            PathChildrenCache bizListenerCache = new PathChildrenCache(zkStore.getCuratorFramework(), bizPath, true);
            if (grayChangingAppIds == null) {
                grayChangingAppIds = new EnumMap<MessageType, Map<String, String>>(MessageType.class);
            }
            grayChangingAppIds.put(MessageType.BIZJOB, new ConcurrentHashMap(10));
            GrayChangingPathCacheListener bizjobListener = new GrayChangingPathCacheListener(MessageType.BIZJOB, bizPath, grayChangingAppIds.get(MessageType.BIZJOB));
            bizListenerCache.getListenable().addListener((Object)bizjobListener);
            bizListenerCache.start();
            grayListener.add(bizListenerCache);
        }
        catch (Exception e) {
            ScheduleGrayGroup.logError("gray node to formal node change monitoring failed to start", e);
        }
    }

    public static void updateGrayInstance(String message) {
        Map changeMsgMap = (Map)SerializationUtils.fromJsonString((String)message, Map.class);
        if (grayChangingAppIds == null) {
            grayChangingAppIds = new EnumMap<MessageType, Map<String, String>>(MessageType.class);
        } else {
            grayChangingAppIds.clear();
        }
        grayChangingAppIds.put(MessageType.BIZJOB, new ConcurrentHashMap(10));
        grayChangingAppIds.get(MessageType.BIZJOB).putAll(changeMsgMap);
        ScheduleGrayGroup.logInfo(String.format("gray changing node information\uff0cdata=%s", message));
    }

    static {
        ConfigurationUtil.observeChange((String)"schedule.gray.log.enable", (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                OUTPUTLOG = Boolean.parseBoolean(String.valueOf(newValue));
            }
        });
        ConfigurationUtil.observeChange((String)"schedule.gray.mcdata.interval", (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                mcIntervalMs = Long.parseLong(StringUtils.isBlank((Object)newValue) ? "900000" : newValue.toString());
            }
        });
        grayProdNumMap = new ConcurrentHashMap<String, Map<String, String>>();
        mcIntervalMs = Long.getLong("schedule.gray.mcdata.interval", 900000L);
        lastUpdateProdNumTs = new Date();
        grayListener = new ArrayList<PathChildrenCache>(10);
    }

    static class GrayChangingPathCacheListener
    implements PathChildrenCacheListener {
        private MessageType type;
        private String listeningPath;
        private Map<String, String> shareContext;

        public GrayChangingPathCacheListener(MessageType type, String path, Map<String, String> shareContext) {
            this.type = type;
            this.listeningPath = path;
            this.shareContext = shareContext;
        }

        public void childEvent(CuratorFramework paramCuratorFramework, PathChildrenCacheEvent event) throws Exception {
            try {
                if (event.getType() == PathChildrenCacheEvent.Type.CHILD_ADDED || event.getType() == PathChildrenCacheEvent.Type.CHILD_UPDATED || event.getType() == PathChildrenCacheEvent.Type.CHILD_REMOVED) {
                    ActiveKeyValueStore zkStore = ActiveKeyValueStore.create();
                    List<String> children = zkStore.getChildren(this.listeningPath);
                    HashMap currentData = new HashMap(10);
                    for (String child : children) {
                        String changePath = this.listeningPath + "/" + child;
                        try {
                            String message = zkStore.read(changePath, null);
                            Map changeMsgMap = (Map)SerializationUtils.fromJsonString((String)message, Map.class);
                            currentData.putAll(changeMsgMap);
                            ScheduleGrayGroup.logInfo(String.format("gray changing node information\uff0cpath=%s , data=%s", child, SerializationUtils.toJsonString((Object)changeMsgMap)));
                        }
                        catch (Exception e) {
                            ScheduleGrayGroup.logError("get message failed\uff0cpath=" + changePath, e);
                        }
                    }
                    this.shareContext.clear();
                    this.shareContext.putAll(currentData);
                    ScheduleGrayGroup.logInfo(String.format("gray changing node information\uff0cmessageType=%s , data=%s", this.type.name(), SerializationUtils.toJsonString(this.shareContext)));
                }
            }
            catch (Exception e) {
                ScheduleGrayGroup.logError("gray node change to formal node listening error:" + e.getMessage(), e);
            }
        }
    }
}

