/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.zk;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.schedule.api.ExecutorServerInfo;
import kd.bos.schedule.redis.RedisStore;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.schedule.zk.ZkStore;
import org.apache.curator.framework.CuratorFramework;

public interface ActiveKeyValueStore {
    public static final Charset CHARSET = Charset.forName("UTF-8");

    public static ActiveKeyValueStore create() {
        if (ZkConfig.isSupportZk()) {
            return ZkStore.create();
        }
        return RedisStore.create();
    }

    public CuratorFramework getCuratorFramework();

    public void ensureExisted(String var1, String var2);

    public void setData(String var1, String var2);

    public void write(String var1, String var2);

    public String create(String var1, String var2, Object var3);

    public String create(String var1, Object var2);

    public void write(String var1, String var2, Object var3);

    public String read(String var1, Object var2);

    public byte[] readByte(String var1, Object var2);

    public void delete(String var1);

    public List<String> getChildren(String var1);

    public List<String> getChildren(String var1, Object var2);

    public byte[] getData(String var1, Object var2, Object var3);

    public Object exists(String var1);

    public Object exists(String var1, Object var2);

    public void initAppIdExeServerMap();

    public void initAppIdExeServerMap(String var1);

    public void publishBroadcastMsg(String var1, String var2);

    public ConcurrentHashMap<String, ConcurrentHashMap<ExecutorServerInfo, Integer>> getAppIdExeServerMap();

    public TreeMap<String, Integer> getExeServerMap();

    public void writeChildren(String var1, String var2, String var3, Object var4);

    public Map<String, String> getChildrenData(String var1, Object var2);

    public void deleteChildren(String var1, String var2);
}

