/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.zk;

import java.util.List;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.schedule.zk.ZkDataProcess;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public class ListGroupForever {
    private static Log log = LogFactory.getLog((String)"kd.bos.schedule.zk.ListGroupForever");
    private String groupFullPathName = null;
    private boolean isStop = false;
    private ZkDataProcess process = null;

    public ListGroupForever(String groupFullPathName, ZkDataProcess process) {
        this.groupFullPathName = groupFullPathName;
        this.process = process;
    }

    public synchronized void stop() {
        log.info("ListGroupForever is stopped!");
        this.isStop = true;
    }

    public void start() {
        try {
            this.list(null);
        }
        catch (InterruptedException | KeeperException e) {
            log.error(e);
            ErrorCode ec = new ErrorCode("OPERATE_ZOOKEEPER_FAILED", e.getMessage());
            throw new KDException(ec, new Object[]{e});
        }
    }

    private void list(WatchedEvent event) throws KeeperException, InterruptedException {
        if (this.isStopped()) {
            return;
        }
        ActiveKeyValueStore zkStore = ActiveKeyValueStore.create();
        List<String> children = zkStore.getChildren(this.groupFullPathName, new Watcher(){

            public void process(WatchedEvent event) {
                if (!ListGroupForever.this.isStopped()) {
                    try {
                        ListGroupForever.this.list(event);
                    }
                    catch (KeeperException.ConnectionLossException e1) {
                        log.info(e1.getMessage());
                    }
                    catch (InterruptedException | KeeperException e) {
                        log.error(e);
                        ErrorCode ec = new ErrorCode("OPERATE_ZOOKEEPER_FAILED", e.getMessage());
                        throw new KDException(ec, new Object[]{e});
                    }
                }
            }
        });
        if (children.isEmpty()) {
            log.debug("No members in group " + this.groupFullPathName);
            return;
        }
        if (!this.isStopped()) {
            if (log.isInfoEnabled()) {
                log.info(" isStop = " + String.valueOf(this.isStopped()));
            }
            this.process.processData(children, event == null ? Watcher.Event.EventType.NodeChildrenChanged : event.getType());
        }
    }

    private synchronized boolean isStopped() {
        return this.isStop;
    }
}

