/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.zk;

import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.zk.ActiveKeyValueStore;

public class WatchDataForever {
    private static Log log = LogFactory.getLog((String)"kd.bos.schedule.zk.WatchDataForever");
    private String nodePathName = null;
    private boolean isStop = false;
    private MessageHandler handler = null;
    private ActiveKeyValueStore zkStore = ActiveKeyValueStore.create();

    public WatchDataForever(String nodePathName, MessageHandler handler) {
        this.nodePathName = nodePathName;
        this.handler = handler;
    }

    public void stop() {
        this.isStop = true;
    }

    public void start() throws KDException {
        this.monitorNode();
    }

    private void monitorNode() throws KDException {
        if (this.isStop) {
            return;
        }
        byte[] data = null;
        data = this.zkStore.getData(this.nodePathName, event -> {
            if (!this.isStop) {
                this.monitorNode();
            }
        }, null);
        if (data == null || data.length == 0) {
            log.debug("no data : " + this.nodePathName);
            return;
        }
        String msg = new String(data, ActiveKeyValueStore.CHARSET);
        MessageInfo message = (MessageInfo)SerializationUtils.fromJsonString((String)msg, MessageInfo.class);
        if (log.isInfoEnabled()) {
            log.info("message.tenantId:" + message.getTenantId());
        }
        this.handler.handle(message);
    }
}

