/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.zk;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.support.QueueManager;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.ScheduleDeployMode;
import kd.bos.schedule.message.AbstractService;
import kd.bos.util.NetAddressUtils;
import kd.bos.zk.ZKFactory;

public class ZkConfig {
    private static final Log logger = LogFactory.getLog(ZkConfig.class);
    public static final String KEY_CIRCLE_JOB_CALL_BACK = "Schedule.executor.circle4JobCallBack";
    public static final String KEY_ZK_SERVER = "Schedule.zk.server";
    public static final String KEY_ZK_PATH = "Schedule.zk.path";
    public static final String KEY_SCHEDULE_ENV = "Schedule.Env";
    public static final String KEY_SCHEDULE_MESSAGE_MODE = "Schedule.Message.Mode";
    public static final String KEY_SCHEDULE_EXECUTOR_SERVERNAME = "Schedule.Executor.ExecutorName";
    public static final String KEY_SCHEDULE_EXECUTOR_NUMOFWORKTHREAD = "Schedule.Executor.NumOfWorkThread";
    public static final String KEY_SCHEDULE_EXECUTOR_MAXNUMOFWORKTHREAD = "Schedule.Executor.MaxNumOfWorkThread";
    public static final String KEY_SCHEDULE_MESSAGE_ACCESSTYPE = "Schedule.Message.AccessType";
    public static final String KEY_SCHEDULE_SELFCHECK_TIME = "Schedule.monitor.selfcheck.timeinterval";
    public static final String KEY_SCHEDULE_PERSISJOBINFO = "Schedule.monitor.persisjobinfo";
    public static final String KEY_SCHEDULE_TEMPSTORAGEJOBTYPES = "Schedule.monitor.tempstoragejobtypes";
    public static final String KEY_SCHEDULE_STORE_TYPE = "Schedule.Store.Type";
    public static final String KEY_SCHEDULE_MQ_CONCURRENCY = "Schedule.Mq.ConsumeConcurrency";
    public static final String KEY_SCHEDULE_EXECUTOR_CHECKSERVERSTATUS = "Schedule.Executor.CheckServerStatus";
    public static final String KEY_SCHEDULE_EXECUTOR_ROUTETOCUSTOM = "Schedule.Executor.RouteToCustom";
    public static final String KEY_SCHEDULE_MQ_APPSPLIT = "Schedule.Mq.AppSplit";
    public static final String KEY_SCHEDULE_DISABLE_TO_WORK = "Schedule.disableToWork";
    public static final String KEY_MQ_CONSUMER_REGISTER = "mq.consumer.register";
    public static final String KEY_MQ_DEBUG_QUEUE_TAG = "mq.debug.queue.tag";
    public static final String LOCALHOST_IP = "127.0.0.1";
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    private static int selfCheck = 30;
    private static final String KEY_SCHEDULE_EXECUTOR_READYTASKSIZE = "Schedule.Executor.ReadyTasksSize";
    private static final String KEY_SCHEDULE_DISPATCHER_LOOKUP_LOCAL = "schedule.dispatcher.lookup.local";
    private static String hosts = null;
    private static String scheduleRootPath = null;
    private static String executorServerPath = null;
    private static String masterServerPath = null;
    private static String jobMessagePath = null;
    private static String scheduleChangedMessagePath = null;
    private static String jobChangedMessagePath = null;
    private static String grayChangedMessagePath = null;
    private static String grayInstanceChangingPath = null;
    private static String jobRootPath = null;
    private static String taskStatusRootPath = null;
    private static String executorServerName = null;
    private static AbstractService.RunMode runMode = AbstractService.RunMode.Product;
    private static int numOfWorkThread = 3;
    private static int maxNumOfWorkThread = 20;
    private static int mqConsumeConcurrency = 1;
    private static String messageMode = null;
    private static int circle4JobCallBack = 30;
    private static String zkPath;
    private static List<MessageType> accessMessageType;
    private static int generateNextTime;
    private static int interval4ScheduleGenerate;
    private static int delay4ScheduleGenerate;
    private static int interval4DispatchJob;
    private static boolean isStartAsynCallBackFlag;
    private static int numOfAsynCallBackThread;
    private static boolean persisJobInfo;
    private static String[] tempstoragejobtypes;
    public static final String defaultHostIp = "127.0.0.1";
    private static ScheduleDeployMode deployMode;
    private static String scheduleStoreType;
    private static int jobFailRetryTime;

    private static void initConfig() {
        scheduleStoreType = System.getProperty(KEY_SCHEDULE_STORE_TYPE, scheduleStoreType);
        if (ZkConfig.isSupportZk()) {
            String zkServer = ZkConfig.getZkServer();
            if (zkServer == null) {
                throw new KDException(BosErrorCode.configZookeepConfig, new Object[]{"schedule Schedule.zk.server not configured."});
            }
            ZkConfig.setHosts(ZKFactory.getZkAddress((String)zkServer));
            String zkPath = ZKFactory.getZkRootPath((String)zkServer);
            ZkConfig.setZkPath(zkPath);
        } else {
            zkPath = "/";
        }
        String scheduleRootPath = zkPath + "schedule/" + Instance.getClusterName().trim();
        boolean isDevMode = StringUtils.isNotBlank((CharSequence)System.getProperty(KEY_MQ_DEBUG_QUEUE_TAG));
        if (isDevMode) {
            runMode = AbstractService.RunMode.Dev;
            String ipAddress = ZkConfig.getHostIpAddress();
            scheduleRootPath = scheduleRootPath + "/" + ipAddress;
            ZkConfig.setRunMode(AbstractService.RunMode.Dev);
        }
        selfCheck = Integer.parseInt(System.getProperty(KEY_SCHEDULE_SELFCHECK_TIME, "300"));
        ZkConfig.scheduleRootPath = scheduleRootPath;
        masterServerPath = scheduleRootPath + "/masterServer";
        executorServerPath = scheduleRootPath + "/executorServer";
        jobMessagePath = scheduleRootPath + "/jobMessage";
        jobRootPath = scheduleRootPath + "/job";
        scheduleChangedMessagePath = scheduleRootPath + "/scheduleChangedMessage";
        jobChangedMessagePath = scheduleRootPath + "/jobChangedMessage";
        grayChangedMessagePath = scheduleRootPath + "/grayChangedMessage";
        grayInstanceChangingPath = scheduleRootPath + "/grayInstanceChanging";
        persisJobInfo = Boolean.parseBoolean(System.getProperty(KEY_SCHEDULE_PERSISJOBINFO, "false"));
        String accessMsgType = System.getProperty(KEY_SCHEDULE_MESSAGE_ACCESSTYPE, SerializationUtils.toJsonString(Arrays.asList(MessageType.BIZJOB, MessageType.WorkFlowJOB, MessageType.REALTIMEJOB)));
        ZkConfig.setAccessJobMsgType(accessMsgType);
        String executorName = System.getProperty(KEY_SCHEDULE_EXECUTOR_SERVERNAME);
        if (StringUtils.isBlank((CharSequence)executorName)) {
            try {
                executorName = ZkConfig.getHostIpAddress();
            }
            catch (Exception e) {
                executorName = "defaultExecutorName-" + new SecureRandom().nextInt(100);
            }
        }
        executorServerName = executorName;
        messageMode = System.getProperty(KEY_SCHEDULE_MESSAGE_MODE, "MQ");
        isStartAsynCallBackFlag = Boolean.parseBoolean(System.getProperty("Schedule.executor.isStartAsynCallBack", "false"));
        circle4JobCallBack = Integer.parseInt(System.getProperty(KEY_CIRCLE_JOB_CALL_BACK, "30"));
        numOfWorkThread = Integer.parseInt(System.getProperty(KEY_SCHEDULE_EXECUTOR_NUMOFWORKTHREAD, "5"));
        maxNumOfWorkThread = Integer.parseInt(System.getProperty(KEY_SCHEDULE_EXECUTOR_MAXNUMOFWORKTHREAD, "20"));
        mqConsumeConcurrency = Integer.parseInt(System.getProperty(KEY_SCHEDULE_MQ_CONCURRENCY, "1"));
        numOfAsynCallBackThread = Integer.parseInt(System.getProperty("Schedule.executor.numOfAsynCallBackThread", "2"));
        generateNextTime = Integer.parseInt(System.getProperty("Schedule.monitor.generateNextTime", "3"));
        interval4ScheduleGenerate = Integer.parseInt(System.getProperty("Schedule.monitor.interval4ScheduleGenerate", "60"));
        interval4DispatchJob = Integer.parseInt(System.getProperty("Schedule.monitor.interval4DispatchJob", "30"));
        jobFailRetryTime = Integer.parseInt(System.getProperty("Schedule.job.retryTimeWhenFail", "3"));
        delay4ScheduleGenerate = Integer.getInteger("schedule.monitor.delay4schedulegenerate", 1);
        String tempStorageTypeStr = System.getProperty(KEY_SCHEDULE_TEMPSTORAGEJOBTYPES, "");
        tempstoragejobtypes = tempStorageTypeStr.split(",");
        String deployModeStr = System.getProperty("Schedule.deployMode");
        if (StringUtils.isBlank((CharSequence)deployModeStr)) {
            deployMode = ScheduleDeployMode.NOLIMIT;
        } else if (ScheduleDeployMode.DISABLE.name().equalsIgnoreCase(deployModeStr)) {
            deployMode = ScheduleDeployMode.DISABLE;
        } else if (ScheduleDeployMode.EXECUTE_NODE.name().equalsIgnoreCase(deployModeStr)) {
            deployMode = ScheduleDeployMode.EXECUTE_NODE;
        } else if (ScheduleDeployMode.SCHEDULE_NODE.name().equalsIgnoreCase(deployModeStr)) {
            deployMode = ScheduleDeployMode.SCHEDULE_NODE;
        } else if (ScheduleDeployMode.NOLIMIT.name().equalsIgnoreCase(deployModeStr)) {
            deployMode = ScheduleDeployMode.NOLIMIT;
        } else {
            throw new KDException(BosErrorCode.configZookeepConfig, new Object[]{"deployMode not configured."});
        }
    }

    public static String getZkServer() {
        return System.getProperty(KEY_ZK_SERVER);
    }

    public static int getJobFailRetryTime() {
        return jobFailRetryTime;
    }

    public static int getSelfCheck() {
        return selfCheck;
    }

    public static void setSelfCheck(int selfCheck) {
        ZkConfig.selfCheck = selfCheck;
    }

    public static boolean isEmergentMode() {
        return Boolean.parseBoolean(System.getProperty("Schedule.executor.emergentMode", "false"));
    }

    public static int getNumOfAsynCallBackThread() {
        return numOfAsynCallBackThread;
    }

    public static boolean isStartAsynCallBack() {
        return isStartAsynCallBackFlag;
    }

    public static void setStartAsynCallBack(boolean isStart) {
        isStartAsynCallBackFlag = isStart;
    }

    public static int getGenerateNextTime() {
        generateNextTime = Integer.parseInt(System.getProperty("Schedule.monitor.generateNextTime", "6"));
        return generateNextTime;
    }

    public static int getInterval4ScheduleGenerate() {
        interval4ScheduleGenerate = Integer.parseInt(System.getProperty("Schedule.monitor.interval4ScheduleGenerate", "60"));
        return interval4ScheduleGenerate;
    }

    public static int getnterval4DispatchJob() {
        interval4DispatchJob = Integer.parseInt(System.getProperty("Schedule.monitor.interval4DispatchJob", "30"));
        return interval4DispatchJob;
    }

    public static String getZkPath() {
        return zkPath;
    }

    private static void setZkPath(String zkPath) {
        ZkConfig.zkPath = zkPath;
    }

    public static int getCircle4JobCallBack() {
        circle4JobCallBack = Integer.parseInt(System.getProperty(KEY_CIRCLE_JOB_CALL_BACK, "30"));
        return circle4JobCallBack;
    }

    private static void setRunMode(AbstractService.RunMode mode) {
        runMode = mode;
    }

    public static AbstractService.RunMode getRunMode() {
        return runMode;
    }

    public static String getHosts() {
        return hosts;
    }

    private static void setHosts(String hosts) {
        ZkConfig.hosts = hosts;
    }

    public static String getScheduleRootPath() {
        if (scheduleRootPath == null) {
            ErrorCode ec = new ErrorCode("SECHDULE_SERVICE_NOT_START", ResManager.loadKDString((String)"\u8c03\u5ea6\u670d\u52a1\u6ca1\u6709\u542f\u52a8\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u3002", (String)"ZkConfig_0", (String)"bos-schedule-message", (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        return scheduleRootPath;
    }

    private static void setScheduleRootPath(String scheduleRootPath) {
        ZkConfig.scheduleRootPath = scheduleRootPath;
    }

    public static String getExecutorServerPath() {
        if (executorServerPath == null) {
            ErrorCode ec = new ErrorCode("SECHDULE_SERVICE_NOT_START", ResManager.loadKDString((String)"\u8c03\u5ea6\u670d\u52a1\u6ca1\u6709\u542f\u52a8\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u3002", (String)"ZkConfig_0", (String)"bos-schedule-message", (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        return executorServerPath;
    }

    public static String getJobRootPath() {
        return jobRootPath;
    }

    public static String getTaskStatusRootPath() {
        return taskStatusRootPath;
    }

    public static String getTaskStatusPath(String taskId) {
        return ZkConfig.getTaskStatusRootPath() + "/" + taskId;
    }

    public static String getJobPath(MessageInfo message) {
        return ZkConfig.getJobRootPath() + "/" + message.getTarget() + "/" + message.getTaskId();
    }

    public static String getExecutorServerName() {
        return executorServerName;
    }

    public static int getNumOfWorkThread() {
        return numOfWorkThread;
    }

    public static int getMqConsumeConcurrency() {
        return mqConsumeConcurrency;
    }

    public static String getMessageMode() {
        return messageMode;
    }

    public static String getMasterServerPath() {
        if (masterServerPath == null) {
            ErrorCode ec = new ErrorCode("SECHDULE_SERVICE_NOT_START", ResManager.loadKDString((String)"\u8c03\u5ea6\u670d\u52a1\u6ca1\u6709\u542f\u52a8\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u3002", (String)"ZkConfig_0", (String)"bos-schedule-message", (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        return masterServerPath;
    }

    public static String getJobMessagePath() {
        if (jobMessagePath == null) {
            ErrorCode ec = new ErrorCode("SECHDULE_SERVICE_NOT_START", ResManager.loadKDString((String)"\u8c03\u5ea6\u670d\u52a1\u6ca1\u6709\u542f\u52a8\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u3002", (String)"ZkConfig_0", (String)"bos-schedule-message", (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        return jobMessagePath;
    }

    public static String getScheduleChangedMessagePath() {
        return scheduleChangedMessagePath;
    }

    public static String getJobChangedMessagePath() {
        return jobChangedMessagePath;
    }

    public static String getGrayChangedMessagePath() {
        return grayChangedMessagePath;
    }

    public static String getGrayInstanceChangingPath() {
        return grayInstanceChangingPath;
    }

    public static List<MessageType> getAccessJobMsgType() {
        return accessMessageType;
    }

    private static void setAccessJobMsgType(String messageType) {
        accessMessageType = SerializationUtils.fromJsonStringToList((String)messageType, MessageType.class);
    }

    public static boolean isPersisJobInfo() {
        return persisJobInfo;
    }

    public static boolean isPersisJobInfo(JobType jobType) {
        if (tempstoragejobtypes == null || jobType == null) {
            return true;
        }
        for (String str : tempstoragejobtypes) {
            if (!jobType.toString().equals(str)) continue;
            return false;
        }
        return true;
    }

    public static String getHostIpAddress() {
        return NetAddressUtils.getLocalIpAddress();
    }

    public static int getDelay4ScheduleGenerate() {
        return delay4ScheduleGenerate;
    }

    public static int getMaxNumOfWorkThread(MessageType type) {
        if (MessageType.WorkFlowJOB == type) {
            return maxNumOfWorkThread;
        }
        return numOfWorkThread;
    }

    public static ScheduleDeployMode getDeployMode() {
        return deployMode;
    }

    @Deprecated
    public static boolean isCheckServerStatus() {
        return Boolean.parseBoolean(System.getProperty(KEY_SCHEDULE_EXECUTOR_CHECKSERVERSTATUS, "true"));
    }

    public static String isCheckServerStatusStr() {
        return System.getProperty(KEY_SCHEDULE_EXECUTOR_CHECKSERVERSTATUS);
    }

    public static boolean isRouteToCustom() {
        return Boolean.parseBoolean(System.getProperty(KEY_SCHEDULE_EXECUTOR_ROUTETOCUSTOM, "false"));
    }

    public static int getReadyTasksSize() {
        return Integer.parseInt(System.getProperty(KEY_SCHEDULE_EXECUTOR_READYTASKSIZE, "50"));
    }

    public static boolean isMqAppSplit() {
        return Boolean.parseBoolean(System.getProperty(KEY_SCHEDULE_MQ_APPSPLIT, String.valueOf(Instance.isAppSplit())));
    }

    public static boolean isDispLookUpLocal() {
        return Boolean.parseBoolean(System.getProperty(KEY_SCHEDULE_DISPATCHER_LOOKUP_LOCAL, "true"));
    }

    public static boolean isSupportZk() {
        return "zk".equalsIgnoreCase(scheduleStoreType);
    }

    public static boolean isPigeon() {
        String mqType = QueueManager.getMQType((String)"demo");
        return mqType == null || mqType.equals("pigeon");
    }

    static {
        delay4ScheduleGenerate = 1;
        numOfAsynCallBackThread = 2;
        persisJobInfo = false;
        tempstoragejobtypes = null;
        deployMode = ScheduleDeployMode.NOLIMIT;
        scheduleStoreType = "zk";
        try {
            ZkConfig.initConfig();
        }
        catch (Throwable t) {
            logger.error(t);
        }
        jobFailRetryTime = 3;
    }
}

