/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.zk;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import kd.bos.schedule.zk.ZkStatus;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class ZkConnectionHelper {
    public static final int DEFAULT_SESSION_TIMEOUT = 5000;

    public ZooKeeper connect(String hosts, int sessionTimeout) throws IOException, InterruptedException {
        final CountDownLatch connectedSignal = new CountDownLatch(1);
        ZooKeeper zk = new ZooKeeper(hosts, sessionTimeout, new Watcher(){

            public void process(WatchedEvent event) {
                if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    ZkStatus.getInstance().set(ZkStatus.Status.Connected);
                    connectedSignal.countDown();
                }
                if (event.getState() == Watcher.Event.KeeperState.Disconnected) {
                    ZkStatus.getInstance().set(ZkStatus.Status.Disconnected);
                }
            }
        });
        connectedSignal.await();
        return zk;
    }

    public ZooKeeper connect(String hosts) throws IOException, InterruptedException {
        return this.connect(hosts, 5000);
    }
}

