/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.zk;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ExecutorServerInfo;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.zk.ZKFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class ZkStore
implements ActiveKeyValueStore {
    private static Log log = LogFactory.getLog((String)"kd.bos.schedule.zk.ActiveKeyValueStore");
    private ConcurrentHashMap<String, ConcurrentHashMap<ExecutorServerInfo, Integer>> appIdExeServerMap = new ConcurrentHashMap();
    private TreeMap<String, Integer> exeServerMap = new TreeMap();

    public static ZkStore create() {
        return new ZkStore();
    }

    @Override
    public CuratorFramework getCuratorFramework() {
        return ZKFactory.getZKClient((String)ZkConfig.getZkServer());
    }

    @Override
    public void ensureExisted(String path, String value) {
        log.info("ensureExisted " + ZkConfig.getHosts() + path);
        CuratorFramework cf = this.getCuratorFramework();
        try {
            Stat stat = (Stat)cf.checkExists().forPath(path);
            if (stat == null) {
                this.create(path, value, CreateMode.PERSISTENT);
            }
        }
        catch (KeeperException.NodeExistsException e1) {
            log.warn((Throwable)e1);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode("OPERATE_ZOOKEEPER_FAILED", "ensureExisted path:%s -value:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path, value});
        }
    }

    @Override
    public void setData(String path, String value) {
        try {
            this.getCuratorFramework().setData().forPath(path, value.getBytes(CHARSET));
        }
        catch (KeeperException.NodeExistsException e1) {
            log.warn((Throwable)e1);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode("OPERATE_ZOOKEEPER_FAILED", "setData path:%s -value:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path, value});
        }
    }

    @Override
    public void write(String path, String value) {
        Stat stat = this.exists(path);
        if (stat == null) {
            this.create(path, value, CreateMode.PERSISTENT);
        } else {
            this.setData(path, value);
        }
    }

    @Override
    public String create(String path, String value, Object createMode) {
        try {
            return (String)((ACLBackgroundPathAndBytesable)this.getCuratorFramework().create().creatingParentsIfNeeded().withMode((CreateMode)createMode)).forPath(path, value != null ? value.getBytes(CHARSET) : null);
        }
        catch (KeeperException.NodeExistsException e1) {
            log.warn((Throwable)e1);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode("OPERATE_ZOOKEEPER_FAILED", "create path:%s -value:%s -createMode:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path, value, ((CreateMode)createMode).name()});
        }
        return null;
    }

    @Override
    public String create(String path, Object createMode) {
        try {
            return (String)((ACLBackgroundPathAndBytesable)this.getCuratorFramework().create().creatingParentsIfNeeded().withMode((CreateMode)createMode)).forPath(path);
        }
        catch (KeeperException.NodeExistsException e1) {
            log.warn((Throwable)e1);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode("OPERATE_ZOOKEEPER_FAILED", "create path:%s -value:%s -createMode:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path, ((CreateMode)createMode).name()});
        }
        return null;
    }

    @Override
    public void write(String path, String value, Object createMode) {
        try {
            CuratorFramework cf = this.getCuratorFramework();
            Stat stat = (Stat)cf.checkExists().forPath(path);
            if (stat == null) {
                this.create(path, value, createMode);
            } else {
                this.setData(path, value);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode("OPERATE_ZOOKEEPER_FAILED", "write path:%s -value:%s -createMode:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path, value, ((CreateMode)createMode).name()});
        }
    }

    @Override
    public String read(String path, Object watcher) {
        byte[] data = this.readByte(path, watcher);
        if (data != null) {
            return new String(data, CHARSET);
        }
        return null;
    }

    @Override
    public byte[] readByte(String path, Object watcher) {
        try {
            CuratorFramework cf = this.getCuratorFramework();
            Stat stat = (Stat)cf.checkExists().forPath(path);
            if (stat == null) {
                return null;
            }
            return (byte[])((BackgroundPathable)cf.getData().usingWatcher((CuratorWatcher)watcher)).forPath(path);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode("OPERATE_ZOOKEEPER_FAILED", "readByte path:%s ");
            throw new KDException((Throwable)e, ec, new Object[]{path});
        }
    }

    @Override
    public void delete(String path) {
        try {
            CuratorFramework cf = this.getCuratorFramework();
            if (cf.checkExists().forPath(path) != null) {
                cf.delete().forPath(path);
            }
        }
        catch (KeeperException.NoNodeException e1) {
            log.warn((Throwable)e1);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode("OPERATE_ZOOKEEPER_FAILED", "delete path:%s ");
            throw new KDException((Throwable)e, ec, new Object[]{path});
        }
    }

    @Override
    public List<String> getChildren(String path) {
        return this.getChildren(path, null);
    }

    @Override
    public List<String> getChildren(String path, Object watcher) {
        try {
            return (List)((BackgroundPathable)this.getCuratorFramework().getChildren().usingWatcher((CuratorWatcher)watcher)).forPath(path);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode("OPERATE_ZOOKEEPER_FAILED", "getChildren path:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path});
        }
    }

    @Override
    public byte[] getData(String path, Object watcher, Object stat) {
        try {
            if (watcher != null) {
                return (byte[])((BackgroundPathable)this.getCuratorFramework().getData().usingWatcher((CuratorWatcher)watcher)).forPath(path);
            }
            return (byte[])this.getCuratorFramework().getData().forPath(path);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode("OPERATE_ZOOKEEPER_FAILED", "getData path:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path});
        }
    }

    public Stat exists(String path) {
        return this.exists(path, null);
    }

    public Stat exists(String path, Object watcher) {
        try {
            return (Stat)((BackgroundPathable)this.getCuratorFramework().checkExists().usingWatcher((CuratorWatcher)watcher)).forPath(path);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode("OPERATE_ZOOKEEPER_FAILED", "exists path:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path});
        }
    }

    @Override
    public void initAppIdExeServerMap() {
        List<ExecutorServerInfo> serverInfoList = this.queryExecutorServerStatus();
        if (CollectionUtils.isEmpty(serverInfoList)) {
            log.info("executorServer is empty");
            return;
        }
        for (ExecutorServerInfo executorServerInfo : serverInfoList) {
            Set appIds = executorServerInfo.getAppIds();
            for (String appId : appIds) {
                ConcurrentHashMap<Object, Object> executorServerIndex;
                if (this.appIdExeServerMap.containsKey(appId)) {
                    executorServerIndex = this.appIdExeServerMap.get(appId);
                    executorServerIndex.put(executorServerInfo, executorServerIndex.size() + 1);
                    continue;
                }
                executorServerIndex = new ConcurrentHashMap<ExecutorServerInfo, Integer>();
                executorServerIndex.put(executorServerInfo, 0);
                this.appIdExeServerMap.put(appId, executorServerIndex);
            }
        }
        log.info("appId and executorServer: " + JSON.toJSONString(this.appIdExeServerMap));
    }

    @Override
    public void initAppIdExeServerMap(String appId) {
        Stat stat;
        List<ExecutorServerInfo> serverInfoList = this.queryExecutorServerStatus();
        if (CollectionUtils.isEmpty(serverInfoList)) {
            log.info("executorServer is empty");
            return;
        }
        boolean isMasterHost = false;
        String masterHost = "";
        if ("MQ".equalsIgnoreCase(ZkConfig.getMessageMode()) && (stat = this.exists(ZkConfig.getMasterServerPath())) != null) {
            masterHost = this.read(ZkConfig.getMasterServerPath(), null);
        }
        int index = 0;
        if (serverInfoList != null) {
            for (int i = 0; i < serverInfoList.size(); ++i) {
                ExecutorServerInfo executorServerInfo = serverInfoList.get(i);
                Set appIds = executorServerInfo.getAppIds();
                boolean bl = isMasterHost = StringUtils.isBlank((CharSequence)masterHost) ? false : masterHost.equals(executorServerInfo.getName());
                if (!appIds.contains(appId) || isMasterHost) continue;
                this.exeServerMap.put(executorServerInfo.getName(), index);
                ++index;
            }
        }
        log.info("appId and executorServer: " + appId + "-" + JSON.toJSONString(this.exeServerMap));
    }

    public void executorServerStatusListener() {
        try {
            String path = ZkConfig.getExecutorServerPath();
            CuratorFramework client = this.getCuratorFramework();
            Stat stat = (Stat)client.checkExists().forPath(path);
            if (stat == null) {
                this.create(path, CreateMode.PERSISTENT);
            }
            PathChildrenCache pathChildrenCache = new PathChildrenCache(client, path, true);
            pathChildrenCache.start(PathChildrenCache.StartMode.BUILD_INITIAL_CACHE);
            pathChildrenCache.getListenable().addListener((cf, event) -> {
                PathChildrenCacheEvent.Type eventType = event.getType();
                switch (eventType) {
                    case CONNECTION_RECONNECTED: {
                        pathChildrenCache.rebuild();
                        this.appIdExeServerMap.clear();
                        this.initAppIdExeServerMap();
                        break;
                    }
                    case CONNECTION_SUSPENDED: {
                        this.appIdExeServerMap.clear();
                        break;
                    }
                    case CONNECTION_LOST: {
                        log.error("Zookeeper Connection lost");
                        this.appIdExeServerMap.clear();
                        break;
                    }
                    case CHILD_ADDED: {
                        this.appIdExeServerMap.clear();
                        this.initAppIdExeServerMap();
                        break;
                    }
                    case CHILD_UPDATED: {
                        break;
                    }
                    case CHILD_REMOVED: {
                        this.appIdExeServerMap.clear();
                        this.initAppIdExeServerMap();
                        break;
                    }
                }
            });
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    @Override
    public void publishBroadcastMsg(String path, String data) {
        this.write(path, data);
    }

    private List<ExecutorServerInfo> queryExecutorServerStatus() {
        List<String> exeServerList = this.getChildren(ZkConfig.getExecutorServerPath());
        if (exeServerList == null || exeServerList.isEmpty()) {
            return null;
        }
        ArrayList<ExecutorServerInfo> serverInfoList = new ArrayList<ExecutorServerInfo>();
        for (String exeServerNode : exeServerList) {
            String dataStr;
            ExecutorServerInfo serverInfo;
            byte[] data = this.readByte(ZkConfig.getExecutorServerPath() + "/" + exeServerNode, null);
            if (data == null || data[0] == 1 || (serverInfo = (ExecutorServerInfo)SerializationUtils.fromJsonString((String)(dataStr = new String(data, CHARSET)), ExecutorServerInfo.class)) == null) continue;
            serverInfoList.add(serverInfo);
        }
        return serverInfoList;
    }

    @Override
    public ConcurrentHashMap<String, ConcurrentHashMap<ExecutorServerInfo, Integer>> getAppIdExeServerMap() {
        return this.appIdExeServerMap;
    }

    @Override
    public TreeMap<String, Integer> getExeServerMap() {
        return this.exeServerMap;
    }

    @Override
    public void writeChildren(String path, String childKey, String value, Object createMode) {
        this.write(path + "/" + childKey, value, createMode);
    }

    @Override
    public Map<String, String> getChildrenData(String path, Object watcher) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteChildren(String path, String childKey) {
        throw new UnsupportedOperationException();
    }
}

