/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import kd.bos.context.OperationContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobDao;
import kd.bos.schedule.api.JobDispatchBatchResult;
import kd.bos.schedule.api.JobDispatcher;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.ObjectFactory;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RouteMode;
import kd.bos.schedule.api.ScheduleDao;
import kd.bos.schedule.api.ScheduleInfo;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskDao;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.api.TaskResult;
import kd.bos.schedule.dao.dbImpl.DbScheduleDAO;
import kd.bos.schedule.message.AbstractMessageSender;
import kd.bos.schedule.message.MessageCreator;
import kd.bos.schedule.server.ExecutorResourceManager;
import kd.bos.schedule.server.ExecutorServerStatistic;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.schedule.server.broadcast.BroadcastObjectFactory;
import kd.bos.schedule.server.realtime.RealtimeObjectFactory;
import kd.bos.schedule.server.schedulecreator.ScheduleCreator;
import kd.bos.schedule.server.schedulecreator.TimeUtils;
import kd.bos.schedule.utils.AppUtils;
import kd.bos.schedule.utils.ScheduleGrayGroup;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class JobDispatcherProxy
implements JobDispatcher {
    private static final Log logger = LogFactory.getLog(JobDispatcherProxy.class);
    private static final String BOS_SCHEDULE_CORE = "bos-schedule-core";
    private static final DBRoute Sch_Route = DBRoute.basedata;
    private static final String QUERY_SCHEDULE_SQL = "select t1.fid,t1.fstarttime,t1.fendtime,t1.fplan from t_sch_schedule t1 where t1.fid = ? ";

    private ObjectFactory getObjectFactory() {
        return ScheduleService.getInstance().getObjectFactory();
    }

    public void stopTask(String taskId) {
        this.getObjectFactory().getTaskDao().setStop(taskId);
    }

    public TaskInfo queryTask(String taskId) {
        ObjectFactory objectFactory = this.getObjectFactory();
        if (objectFactory == null) {
            ErrorCode ec = new ErrorCode("SCHEDULE_SERVER_START_FAIL", ResManager.loadKDString((String)"\u8c03\u5ea6\u670d\u52a1\u672a\u6b63\u5e38\u542f\u52a8\uff0cobjectFactory\u4e3a\u7a7a", (String)"JobDispatcherProxy_0", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        TaskDao taskDao = this.getObjectFactory().getTaskDao();
        return taskDao.get(taskId);
    }

    public String dispatch(JobInfo jobInfo) throws KDException {
        String taskId = this.genenateTaskId(jobInfo);
        logger.debug(String.format("Schedule***dispatcher job id : %s job name: %s", jobInfo.getId(), jobInfo.getlName()));
        OperationContext oc = new OperationContext();
        oc.setAppId(jobInfo.getAppId());
        oc.setFormId(jobInfo.getNumber());
        oc.setFormName(jobInfo.getTaskClassname());
        OperationContext.set((OperationContext)oc);
        this.checkServerSatus();
        String appId = jobInfo.getAppId();
        if (jobInfo.getJobType() == JobType.BIZ && jobInfo.isFromScheduler() && (StringUtils.equalsIgnoreCase((CharSequence)"bos", (CharSequence)appId) || AppUtils.isBOSApp((String)appId))) {
            jobInfo.setAppId("bos");
        }
        MessageInfo message = MessageCreator.createJobMessage((JobInfo)jobInfo);
        message.setTaskId(taskId);
        Object objectFactory = null;
        if (jobInfo.getRouteMode() == RouteMode.SHARDINGBROADCAST) {
            message.setMessageType(MessageType.BROADCASTJOB);
            objectFactory = new BroadcastObjectFactory();
            objectFactory.init();
            objectFactory.getMessageSender().send(message);
            return null;
        }
        if (message.getMessageType() == MessageType.REALTIMEJOB) {
            objectFactory = new RealtimeObjectFactory();
            objectFactory.init();
        } else {
            objectFactory = this.getObjectFactory();
        }
        try (TXHandle handle = TX.beginNew();){
            try {
                JobDao jobDao = objectFactory.getJobDao();
                if (!(JobType.WORKFLOW != jobInfo.getJobType() && JobType.REALTIME != jobInfo.getJobType() || ZkConfig.isPersisJobInfo((JobType)jobInfo.getJobType()))) {
                    logger.debug("Schedule***dispatch_sch_job :{}, taskId={}", (Object)jobInfo, (Object)jobInfo.getTaskId());
                } else if (!jobInfo.isFromScheduler() && !jobDao.isExist(jobInfo.getId())) {
                    jobDao.save(jobInfo);
                }
                TaskInfo taskInfo = this.createTaskInfo(taskId, jobInfo, message);
                objectFactory.getTaskDao().save(taskInfo);
                if (message.getMessageType() == MessageType.REALTIMEJOB && JobDispatcherProxy.lookupLocal(objectFactory, jobInfo)) {
                    objectFactory.getExecutor().processMessage(message, null);
                } else {
                    objectFactory.getMessageSender().send(message);
                }
            }
            catch (Exception e) {
                logger.warn("Schedule***master,taskId={},jobNumber={}:error", new Object[]{jobInfo.getTaskId(), jobInfo.getNumber(), e});
                handle.markRollback();
                throw new KDException(BosErrorCode.sQLTranslate, new Object[]{e});
            }
        }
        return taskId;
    }

    private static boolean lookupLocal(ObjectFactory objectFactory, JobInfo jobInfo) {
        if (!ZkConfig.isDispLookUpLocal()) {
            return false;
        }
        if (jobInfo.getJobType() != JobType.REALTIME) {
            return false;
        }
        if (!ScheduleGrayGroup.canRemoteDispatch((JobType)jobInfo.getJobType(), (String)jobInfo.getAppId())) {
            return true;
        }
        if (Instance.isAppSplit()) {
            String[] appIds = Instance.getAppIds();
            if (appIds == null) {
                return false;
            }
            for (String app : appIds) {
                if (!StringUtils.equals((CharSequence)jobInfo.getAppId(), (CharSequence)app)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public String dispatch(String jobId) throws KDException {
        ObjectFactory of = ScheduleService.getInstance().getObjectFactory();
        JobDao jobDao = of.getJobDao();
        JobInfo jobInfo = jobDao.get(jobId);
        if (jobInfo.getId() == null) {
            return null;
        }
        return this.dispatch(jobInfo);
    }

    public List<String> dispatchByPlanNumber(String planNumber) throws KDException {
        ObjectFactory of = ScheduleService.getInstance().getObjectFactory();
        ScheduleDao scheduleDao = of.getScheduleDao();
        if (!scheduleDao.existedByNumber(planNumber)) {
            return null;
        }
        String scheduleId = scheduleDao.getIdByNumber(planNumber);
        List jobIds = scheduleDao.getJobIdByScheduleId(scheduleId);
        ArrayList<String> taskIds = new ArrayList<String>(4);
        for (String jobId : jobIds) {
            String taskId = this.dispatch(jobId);
            if (!StringUtils.isNotBlank((CharSequence)taskId)) continue;
            taskIds.add(taskId);
        }
        return taskIds;
    }

    private TaskInfo createTaskInfo(String taskId, JobInfo jobInfo, MessageInfo message) {
        TaskInfo taskInfo = new TaskInfo();
        taskInfo.setId(taskId);
        taskInfo.setData(null);
        taskInfo.setDispachTime(System.currentTimeMillis());
        taskInfo.setEndTime(0L);
        taskInfo.setJobId(jobInfo.getId());
        taskInfo.setScheduleId(jobInfo.getScheduleId());
        taskInfo.setProgress(0);
        taskInfo.setRunAt(message.getTarget());
        taskInfo.setRunTime(0L);
        taskInfo.setStatus("SCHEDULED");
        taskInfo.setTimeOut(jobInfo.getTimeout());
        taskInfo.setRetryTime(jobInfo.getRetryTime());
        taskInfo.setGroupId(jobInfo.getGroupId());
        taskInfo.setExcuteTime(jobInfo.getExecuteTime());
        taskInfo.setRouteMode(String.valueOf(jobInfo.getRouteMode()));
        taskInfo.setRetryCode(jobInfo.getRetryCode());
        taskInfo.setCanStop(jobInfo.getCanStop());
        taskInfo.setInstanceId(message.getInstanceId());
        taskInfo.setAppid(jobInfo.getAppId());
        taskInfo.setJobType(jobInfo.getJobType());
        taskInfo.setMessageId(message.getId());
        taskInfo.setScheduleTime(jobInfo.getScheduleTime());
        return taskInfo;
    }

    private void checkServerSatus() {
        ScheduleService instance = ScheduleService.getInstance();
        if (instance == null || !instance.isStarted()) {
            ErrorCode ec = new ErrorCode("SCHEDULE_SERVER_STOPED", ResManager.loadKDString((String)"\u8c03\u5ea6\u670d\u52a1\u5df2\u505c\u6b62\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"JobDispatcherProxy_1", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
    }

    private ExecutorServerStatistic lookupExecutorTarget(MessageInfo message) {
        ExecutorServerStatistic target_executor = ExecutorResourceManager.getInstance().sheduleJob(message);
        return target_executor;
    }

    public String genenateTaskId(JobInfo jobInfo) {
        if (jobInfo.getTaskId() == null) {
            jobInfo.setTaskId(String.valueOf(DB.genLongId((String)"T_SCH_TASK")));
        }
        return jobInfo.getTaskId();
    }

    public int[] countNumOfExecute(String[] scheduleArray, Date endDate) {
        int[] counts = new int[scheduleArray.length];
        List<ZonedDateTime[]> scheduleTimeList = this.timelistOfExecute(scheduleArray, endDate);
        for (int i = 0; i < scheduleArray.length; ++i) {
            counts[i] = scheduleTimeList.get(i) == null ? 0 : scheduleTimeList.get(i).length;
        }
        return counts;
    }

    public List<ZonedDateTime[]> timelistOfExecute(String[] scheduleArray, Date endDate) {
        ZonedDateTime lastRuntime = ZonedDateTime.now();
        ZonedDateTime endTime = null;
        if (endDate == null) {
            Calendar n = Calendar.getInstance();
            n.set(13, 0);
            n.set(12, 1);
            n.set(11, 0);
            n.add(5, 1);
            endTime = TimeUtils.createDate(n.getTimeInMillis());
        } else {
            endTime = TimeUtils.createDate(endDate.getTime());
        }
        ArrayList<ZonedDateTime[]> scheduleTimeList = new ArrayList<ZonedDateTime[]>();
        int[] counts = new int[scheduleArray.length];
        ScheduleInfo info = null;
        int size = scheduleArray.length;
        for (int i = 0; i < size; ++i) {
            counts[i] = 0;
            info = this.getScheduleInfo(scheduleArray[i]);
            if (info != null) {
                ConcurrentLinkedQueue<ZonedDateTime> timeQ = TimeUtils.genSchedule(info, lastRuntime, endTime);
                if (timeQ != null) {
                    ZonedDateTime[] timeArray = timeQ.toArray(new ZonedDateTime[timeQ.size()]);
                    scheduleTimeList.add(timeArray);
                    continue;
                }
                scheduleTimeList.add(null);
                continue;
            }
            scheduleTimeList.add(null);
        }
        return scheduleTimeList;
    }

    private ScheduleInfo getScheduleInfo(String scheduleId) {
        Object[] params = new SqlParameter[]{new SqlParameter(":fid", 12, (Object)scheduleId)};
        return (ScheduleInfo)DB.query((DBRoute)Sch_Route, (String)QUERY_SCHEDULE_SQL, (Object[])params, rs -> {
            ScheduleInfo info1 = new ScheduleInfo();
            if (rs.next()) {
                info1.setId(rs.getString("fid"));
                info1.setStartTime(rs.getTimestamp("fstarttime").getTime());
                info1.setEndTime(rs.getTimestamp("fendtime").getTime());
                info1.setPlan(rs.getString("fplan"));
            }
            return info1;
        });
    }

    public ZonedDateTime[] nextExecuteTime(String[] scheduleArray) {
        ZonedDateTime[] nextTimes = new ZonedDateTime[scheduleArray.length];
        ScheduleInfo info = null;
        int size = scheduleArray.length;
        for (int i = 0; i < size; ++i) {
            info = this.getScheduleInfo(scheduleArray[i]);
            if (info == null) continue;
            nextTimes[i] = TimeUtils.genNextTime(info);
        }
        return nextTimes;
    }

    public String createJob(JobInfo jobInfo) {
        ObjectFactory of = ScheduleService.getInstance().getObjectFactory();
        JobDao jobDao = of.getJobDao();
        if (!jobDao.isExist(jobInfo.getId())) {
            jobDao.save(jobInfo);
        }
        return jobInfo.getId();
    }

    public String createPlan(PlanInfo planInfo) {
        ScheduleDao dao = this.getObjectFactory().getScheduleDao();
        if (planInfo.getNumber() != null && dao.existedByNumber(planInfo.getNumber())) {
            return dao.getIdByNumber(planInfo.getNumber());
        }
        ScheduleCreator creator = new ScheduleCreator();
        Map<String, Object> schMap = creator.create(planInfo);
        String idStr = (String)schMap.get("fid");
        dao.insert(schMap);
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"bos");
        service.invoke("kd.bos.service.ServiceFactory", ScheduleManager.class.getSimpleName(), "afterAddSchedule", new Object[]{idStr});
        return idStr;
    }

    public boolean deletePlan(String scheduleId) {
        ScheduleDao dao = this.getObjectFactory().getScheduleDao();
        boolean isSuccessDelete = dao.delete(scheduleId);
        if (isSuccessDelete) {
            DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"bos");
            service.invoke("kd.bos.service.ServiceFactory", ScheduleManager.class.getSimpleName(), "afterDeleteSchedule", new Object[]{scheduleId});
            TaskDao taskDao = this.getObjectFactory().getTaskDao();
            taskDao.asynDeleteTaskByScheduleId(scheduleId);
        }
        return isSuccessDelete;
    }

    public String updatePlan(PlanInfo planInfo) {
        String fid = planInfo.getId();
        DbScheduleDAO dao = new DbScheduleDAO();
        ScheduleCreator creator = new ScheduleCreator();
        planInfo.setId(fid);
        Map<String, Object> schMap = creator.create(planInfo);
        schMap.put("fid", fid);
        dao.update(schMap);
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"bos");
        service.invoke("kd.bos.service.ServiceFactory", ScheduleManager.class.getSimpleName(), "afterUpdateSchedule", new Object[]{fid});
        return fid;
    }

    public boolean deleteJob(String jobId) {
        boolean isDelete = this.getObjectFactory().getJobDao().delete(jobId);
        if (isDelete) {
            TaskDao taskDao = this.getObjectFactory().getTaskDao();
            taskDao.asynDeleteTaskByJobId(jobId);
        }
        return isDelete;
    }

    public List<TaskInfo> queryTask(List<String> taskIds) {
        ObjectFactory objectFactory = this.getObjectFactory();
        if (objectFactory == null) {
            ErrorCode ec = new ErrorCode("SCHEDULE_SERVER_START_FAIL", ResManager.loadKDString((String)"\u8c03\u5ea6\u670d\u52a1\u672a\u6b63\u5e38\u542f\u52a8\uff0cobjectFactory\u4e3a\u7a7a", (String)"JobDispatcherProxy_0", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        TaskDao taskDao = this.getObjectFactory().getTaskDao();
        return taskDao.get(taskIds);
    }

    public void reScheduledTask(String taskId) {
        Object objectFactory;
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            return;
        }
        TaskInfo taskInfo = this.queryTask(taskId);
        if (taskInfo == null || StringUtils.isEmpty((CharSequence)taskInfo.getJobId())) {
            return;
        }
        JobDao jobDao = this.getObjectFactory().getJobDao();
        JobInfo jobInfo = jobDao.get(taskInfo.getJobId());
        if (jobInfo == null) {
            return;
        }
        MessageInfo message = MessageCreator.createJobMessage((JobInfo)jobInfo);
        message.setTaskId(taskId);
        if (jobInfo.getRouteMode() == RouteMode.SHARDINGBROADCAST) {
            message.setMessageType(MessageType.BROADCASTJOB);
            objectFactory = new BroadcastObjectFactory();
            objectFactory.init();
        } else if (message.getMessageType() == MessageType.REALTIMEJOB) {
            objectFactory = new RealtimeObjectFactory();
            objectFactory.init();
        } else {
            objectFactory = this.getObjectFactory();
        }
        objectFactory.getMessageSender().send(message);
        logger.info("Schedule***task {} \u5df2\u91cd\u65b0\u53d1\u9001mq\u6d88\u606f\u91cd\u65b0\u8c03\u5ea6", (Object)taskId);
    }

    public void resetReadyTask(String taskId) {
        TaskDao taskDao = this.getObjectFactory().getTaskDao();
        boolean ret = taskDao.updateStatus(taskId, "SCHEDULED");
        if (ret) {
            this.reScheduledTask(taskId);
            logger.info("Schedule***task {} \u5df2\u91cd\u7f6e\u5c31\u7eea\u72b6\u6001", (Object)taskId);
        }
    }

    public void abortTask(String taskId) {
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            return;
        }
        TaskInfo taskInfo = this.queryTask(taskId);
        if (taskInfo == null || StringUtils.isEmpty((CharSequence)taskInfo.getJobId())) {
            return;
        }
        TaskDao taskDao = this.getObjectFactory().getTaskDao();
        boolean ret = taskDao.updateStatus(taskId, "ABORTED", "ABORTED_BY_REBOOT");
        if (ret) {
            JobDao jobDao = this.getObjectFactory().getJobDao();
            JobInfo jobInfo = jobDao.get(taskInfo.getJobId());
            if (jobInfo == null) {
                return;
            }
            logger.info("Schedule***{},taskId={},jobNumber={}", new Object[]{"task is aborted", taskId, jobInfo.getNumber()});
            jobInfo.setTaskId(taskId);
            if (StringUtils.isNotEmpty((CharSequence)taskInfo.getScheduleId())) {
                jobInfo.setScheduleMsgInfo(MessageCreator.buildScheduleMsgInfo((String)taskInfo.getScheduleId()));
                jobInfo.setScheduleId(taskInfo.getScheduleId());
            }
            MessageInfo message = MessageCreator.createJobMessage((JobInfo)jobInfo);
            message.setTaskId(taskId);
            message.setMessageType(MessageType.BIZ_TASK_FEEDBACK);
            TaskResult taskResult = new TaskResult();
            taskResult.setResultType(TaskResult.ResultTypeEnum.STATUS);
            taskResult.setStatus("ABORTED");
            taskResult.setStatusDesc("ABORTED_BY_REBOOT");
            message.setTaskResult(taskResult);
            if (this.getObjectFactory().getMessageSender() instanceof AbstractMessageSender) {
                AbstractMessageSender messageSender = (AbstractMessageSender)this.getObjectFactory().getMessageSender();
                messageSender.sendNotify(message);
            }
        }
    }

    public JobDispatchBatchResult dispatchBatch(JobInfo[] jobArray) {
        if (jobArray == null || jobArray.length == 0) {
            JobDispatchBatchResult result = new JobDispatchBatchResult(Collections.emptyList(), Collections.emptyList());
            return result;
        }
        this.checkServerSatus();
        for (JobInfo jobInfo : jobArray) {
            if (jobInfo.getJobType() == JobType.WORKFLOW) continue;
            ErrorCode ec = new ErrorCode(BosErrorCode.bOS.getCode(), "Batch interface only supports workflow job");
            throw new KDException(ec, new Object[0]);
        }
        ArrayList allTaskIds = new ArrayList(jobArray.length);
        ArrayList allFailTaskIndexs = new ArrayList(6);
        int batchSize = 500;
        ArrayList<JobInfo> batchJobs = new ArrayList<JobInfo>(batchSize);
        for (int i = 0; i < jobArray.length; ++i) {
            JobInfo jobInfo = jobArray[i];
            String appId = jobInfo.getAppId();
            if (jobInfo.getJobType() == JobType.BIZ && jobInfo.isFromScheduler() && (StringUtils.equalsIgnoreCase((CharSequence)"bos", (CharSequence)appId) || AppUtils.isBOSApp((String)appId))) {
                jobInfo.setAppId("bos");
            }
            batchJobs.add(jobInfo);
            if (batchJobs.size() < batchSize) continue;
            int startIndex = i + 1;
            Tuple<List<String>, List<Integer>> batchResult = this.batchDispatch(batchJobs, startIndex);
            allTaskIds.addAll((Collection)batchResult.item1);
            allFailTaskIndexs.addAll((Collection)batchResult.item2);
            batchJobs.clear();
        }
        if (!batchJobs.isEmpty()) {
            int startIndex = jobArray.length - batchJobs.size();
            Tuple<List<String>, List<Integer>> batchResult = this.batchDispatch(batchJobs, startIndex);
            allTaskIds.addAll((Collection)batchResult.item1);
            allFailTaskIndexs.addAll((Collection)batchResult.item2);
            batchJobs.clear();
        }
        JobDispatchBatchResult result = new JobDispatchBatchResult(allTaskIds, allFailTaskIndexs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tuple<List<String>, List<Integer>> batchDispatch(List<JobInfo> batchJobs, int startIndex) {
        ObjectFactory objectFactory = this.getObjectFactory();
        JobDao jobDao = objectFactory.getJobDao();
        TaskDao taskDao = objectFactory.getTaskDao();
        ArrayList<MessageInfo> batchMessages = new ArrayList<MessageInfo>(batchJobs.size());
        ArrayList<TaskInfo> batchTasks = new ArrayList<TaskInfo>(batchJobs.size());
        ArrayList<String> taskIds = new ArrayList<String>(batchJobs.size());
        ArrayList<Integer> failTaskIndexs = new ArrayList<Integer>(6);
        ArrayList<String> jobIds = new ArrayList<String>(batchJobs.size());
        for (JobInfo jobInfo : batchJobs) {
            MessageInfo message = MessageCreator.createJobMessage((JobInfo)jobInfo);
            String taskId = this.genenateTaskId(jobInfo);
            message.setTaskId(taskId);
            batchMessages.add(message);
            TaskInfo taskInfo = this.createTaskInfo(taskId, jobInfo, message);
            batchTasks.add(taskInfo);
            taskIds.add(taskId);
            jobIds.add(jobInfo.getId());
        }
        try (TXHandle handle = TX.beginNew();){
            OperationContext oriOc = OperationContext.get();
            try {
                if (!ZkConfig.isPersisJobInfo((JobType)JobType.WORKFLOW)) {
                    logger.info("Schedule***batchdispatch,taskId={}", Collections.singletonList(taskIds));
                } else {
                    Set existJobIds = jobDao.isExist(jobIds.toArray(new String[0]));
                    HashMap<String, JobInfo> saveJobs = new HashMap<String, JobInfo>(batchJobs.size());
                    for (JobInfo jobInfo : batchJobs) {
                        if (existJobIds.contains(jobInfo.getId())) continue;
                        saveJobs.put(jobInfo.getId(), jobInfo);
                    }
                    if (!saveJobs.isEmpty()) {
                        jobDao.save(saveJobs.values().toArray(new JobInfo[0]));
                    }
                }
                taskDao.save(batchTasks.toArray(new TaskInfo[0]));
                int[] ret = objectFactory.getMessageSender().send(batchMessages);
                for (int i = 0; i < ret.length; ++i) {
                    if (ret[i] != 0) continue;
                    failTaskIndexs.add(startIndex + i);
                }
            }
            catch (Exception e) {
                logger.error("Schedule***batchdispatch error,taskIds={}:", taskIds, (Object)e);
                for (int i = 0; i < taskIds.size(); ++i) {
                    failTaskIndexs.add(startIndex + i);
                }
            }
            finally {
                OperationContext.set((OperationContext)oriOc);
            }
        }
        logger.info("Schedule***:batchdispatch taskIds : {}", taskIds);
        return new Tuple(taskIds, failTaskIndexs);
    }
}

