/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server;

import com.alibaba.fastjson.JSON;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobDispatcher;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.RouteMode;
import kd.bos.schedule.api.ScheduleInfo;
import kd.bos.schedule.api.ShardingParam;
import kd.bos.schedule.next.observable.model.TimerPulse;
import kd.bos.schedule.next.observable.util.SchObservableCollectData;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.schedule.utils.RequestContextUtils;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.trace.util.TraceIdUtil;

public class ScheduleJobDispatchWorker
implements Runnable {
    private static final Log logger = LogFactory.getLog(ScheduleJobDispatchWorker.class);
    private LinkedBlockingQueue queue;
    private String name;
    private JobDispatcher jobDispatcher = new JobDispatcherProxy();
    private boolean isStop = false;
    private static boolean checkAccount = Boolean.parseBoolean(System.getProperty("Schedule.monitor.check.removedaccount", "true"));
    private static final String SCH_JOB = "sch_job";
    private static final String SHAREPARAMS = "SHAREPARAMS";
    private static final String SHAREPARAM = "SHAREPARAM";

    public ScheduleJobDispatchWorker(LinkedBlockingQueue queue, String name) {
        this.queue = queue;
        this.name = name;
    }

    @Override
    public void run() {
        try {
            this.isStop = false;
            this.execute();
        }
        catch (InterruptedException e) {
            logger.error("Error:Schedule***ScheduleJobDispatchWorker error: ", (Throwable)e);
        }
        finally {
            this.isStop = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws InterruptedException {
        logger.info("Schedule***dispatchJob send job. start:{}", (Object)this.name);
        String traceId = TraceIdUtil.getCurrentTraceIdString();
        while (!this.isStop) {
            try {
                ScheduleInfo info;
                TimerPulse timerPulse;
                block12: {
                    ThreadLifeCycleManager.start();
                    timerPulse = (TimerPulse)this.queue.take();
                    TraceIdUtil.setCurrentTraceId((String)traceId);
                    if (timerPulse.isStop()) {
                        this.stop();
                        break;
                    }
                    info = timerPulse.getInfo();
                    SchObservableCollectData.collectData((String)info.getTenantId(), (String)info.getAccountId(), (String)"Server", (String)"popLocalQueue", (Object)timerPulse);
                    RequestContextUtils.createRequestContext((String)info.getTenantId(), (String)info.getAccountId(), null);
                    JobInfo jobInfo = info.getJobInfo();
                    if (jobInfo.getRouteMode() == null || RouteMode.SHARDINGTASK != jobInfo.getRouteMode()) break block12;
                    this.dispatchShardeJob(timerPulse);
                }
                try {
                    this.dispatchJob(timerPulse);
                }
                catch (Throwable t) {
                    boolean isLog = this.isNeedLog(t);
                    if (!isLog) continue;
                    logger.error("Schedule***dispatchJob error.schedule={}", (Object)info, (Object)t);
                }
            }
            catch (Exception e) {
                logger.error("Schedule***ScheduleJobDispatchWorker execute error. ", (Throwable)e);
            }
            finally {
                ThreadLifeCycleManager.end();
            }
        }
    }

    private boolean isNeedLog(Throwable t) {
        try {
            KDException cause = null;
            if (t instanceof KDException && (cause = this.getCause((KDException)t)) != null) {
                cause = this.getCause(cause);
            }
            boolean isLog = true;
            if (cause != null && LoginErrorCode.loginMCServerFailed.equals((Object)cause.getErrorCode())) {
                Boolean loginMCServerFailed = (Boolean)this.getLocalCache().get("loginMCServerFailed");
                if (loginMCServerFailed == null) {
                    loginMCServerFailed = Boolean.FALSE;
                    this.getLocalCache().put("loginMCServerFailed", (Object)loginMCServerFailed);
                }
                isLog = loginMCServerFailed;
            }
            return isLog;
        }
        catch (Throwable throwable) {
            logger.debug(throwable.getMessage());
            return true;
        }
    }

    private KDException getCause(KDException t) {
        Object[] args = t.getArgs();
        if (args != null && args.length > 0 && args[0] instanceof KDException) {
            return (KDException)((Object)args[0]);
        }
        return null;
    }

    private void dispatchShardeJob(TimerPulse timerPulse) {
        ScheduleInfo info = timerPulse.getInfo();
        JobInfo jobInfo = info.getJobInfo();
        Map params = jobInfo.getParams();
        if (params != null && params.size() > 0) {
            Object shareParams = params.get(SHAREPARAMS);
            if (shareParams == null) {
                logger.info("Schedule***dispatchShardeJob shareparams is null");
                return;
            }
            List<ShardingParam> shareParamList = new ArrayList();
            try {
                shareParamList = JSON.parseArray((String)((String)shareParams), ShardingParam.class);
            }
            catch (Exception e) {
                HashMap shareParamMap = (HashMap)JSON.parseObject((String)((String)shareParams), HashMap.class);
                for (Map.Entry paramEntry : shareParamMap.entrySet()) {
                    shareParamList.add(new ShardingParam((String)paramEntry.getKey(), (String)paramEntry.getValue()));
                }
            }
            int index = 0;
            for (ShardingParam shardingParam : shareParamList) {
                jobInfo.setShardingParam(shardingParam);
                jobInfo.setShareIndex(++index);
                jobInfo.setExecuteTime(shareParamList.size());
                if (index > 1) {
                    timerPulse = new TimerPulse(this.generateTaskId(), timerPulse.getInfo());
                }
                this.dispatchJob(timerPulse);
            }
        }
    }

    private String generateTaskId() {
        return String.valueOf(DB.genLongId((String)"T_SCH_TASK"));
    }

    private void dispatchJob(TimerPulse timerPulse) {
        ZonedDateTime scheduleTime;
        ScheduleInfo info = timerPulse.getInfo();
        JobInfo jobInfo = info.getJobInfo();
        if (jobInfo.getJobType() != JobType.DETECT) {
            jobInfo.setTaskId(timerPulse.getTaskId());
        }
        if ((scheduleTime = timerPulse.getScheduleTime()) != null) {
            jobInfo.setScheduleTime(scheduleTime.toInstant().toEpochMilli());
        }
        this.jobDispatcher.dispatch(jobInfo);
        if (logger.isDebugEnabled()) {
            logger.debug("Schedule***dispatchJob send job. taskId={}, queueIndex={}, scheduleInfo={}, timePulse={}", new Object[]{jobInfo.getTaskId(), this.name, info, info.getLastExecuteTime()});
        }
        SchObservableCollectData.collectData((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)"Server", (String)"dispatchJobSuccess", (Object)timerPulse);
    }

    public synchronized boolean isStoped() {
        return this.isStop;
    }

    public synchronized void stop() {
        this.isStop = true;
        this.queue.clear();
        logger.info("Schedule***ScheduleJobDispatchWorker stop. traceid:{}", (Object)TraceIdUtil.getCurrentTraceIdString());
    }

    private LocalMemoryCache getLocalCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(600);
        info.setMaxItemSize(1000);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(RequestContext.getOrCreate().getAccountId(), "SCHEDULE_SERVICE_REGION", info);
    }
}

