/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.KDBizException;
import kd.bos.instance.AppGroup;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.support.ConfigForInitConsumer;
import kd.bos.schedule.api.ObjectFactory;
import kd.bos.schedule.api.ScheduleDeployMode;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.message.AbstractService;
import kd.bos.schedule.message.mq.MQObjectFactory;
import kd.bos.schedule.server.DBElectionHelper;
import kd.bos.schedule.server.ExecutorResourceManager;
import kd.bos.schedule.server.SchElectorWrapper;
import kd.bos.schedule.server.ScheduleServiceWrapper;
import kd.bos.schedule.server.Trigger;
import kd.bos.schedule.server.leader.LeaderElectionSupport;
import kd.bos.schedule.server.redis.RedisScheduleServiceWrapper;
import kd.bos.schedule.server.schedulecreator.SchVisitorStatus;
import kd.bos.schedule.server.zk.ZkScheduleServiceWrapper;
import kd.bos.schedule.utils.RequestContextUtils;
import kd.bos.schedule.utils.ScheduleAccountUtils;
import kd.bos.schedule.utils.ScheduleGrayGroup;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.tenant.listener.TenantListener;
import kd.bos.tenant.listener.TenantListenerInfo;
import kd.bos.tenant.listener.TenantListenerManager;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ScheduleService
extends AbstractService {
    private static Log log = LogFactory.getLog((String)"kd.bos.schedule.executor.ScheduleService");
    private static final String BOS_SCHEDULE_CORE = "bos-schedule-core";
    private static int recoveryDelayTime_ms = Integer.getInteger("Schedule.trigger.recover.delayms", 60000);
    private long masterStartTime = 0L;
    private static volatile ScheduleService instance = null;
    private ScheduleServiceWrapper serviceWrapper = null;
    private static AtomicBoolean isLeaderFlag = new AtomicBoolean(false);
    private static AtomicBoolean isElectStarted = new AtomicBoolean(false);
    private static volatile Status curStatus = Status.NotInitialed;
    ExecutorResourceManager executorResourceMrg = null;
    Trigger trigger = null;
    SchElectorWrapper selector = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduleService() {
        if (instance == null) {
            ScheduleService scheduleService = this;
            synchronized (scheduleService) {
                if (instance == null) {
                    instance = this;
                    this.serviceWrapper = ZkConfig.isSupportZk() ? new ZkScheduleServiceWrapper(this) : new RedisScheduleServiceWrapper(this);
                    log.info("Schedule***ScheduleService create ! classname : {}", (Object)this.serviceWrapper.getName());
                }
            }
        }
    }

    private void initDB() {
        List list = ScheduleAccountUtils.getAllAccountsOfCurrentEnv((boolean)false);
        for (Account account : list) {
            long startTime = System.currentTimeMillis();
            RequestContextUtils.createRequestContext((String)account.getTenantId(), (String)account.getAccountId(), (String)"0");
            this.initField("T_SCH_TASK", "FINSTANCEID", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_TASK' AND KSQL_COL_NAME ='FINSTANCEID') \nALTER TABLE T_SCH_TASK ADD FINSTANCEID VARCHAR(75)");
            this.initField("T_SCH_TASK", "FTRACEID", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_TASK' AND KSQL_COL_NAME ='FTRACEID') \nALTER TABLE T_SCH_TASK ADD FTRACEID VARCHAR(75)");
            this.initField("T_SCH_TASK", "FAPPID", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_TASK' AND KSQL_COL_NAME ='FAPPID') \nALTER TABLE T_SCH_TASK ADD FAPPID VARCHAR(50)");
            this.initField("T_SCH_TASK", "FJOBTYPE", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_TASK' AND KSQL_COL_NAME ='FJOBTYPE') \nALTER TABLE T_SCH_TASK ADD FJOBTYPE VARCHAR(50)");
            this.initField("T_SCH_TASK", "FSTATUSDESC", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_TASK' AND KSQL_COL_NAME ='FSTATUSDESC') \nALTER TABLE T_SCH_TASK ADD FSTATUSDESC VARCHAR(50)");
            this.initField("T_SCH_TASK", "FMESSAGEID", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_TASK' AND KSQL_COL_NAME ='FMESSAGEID') \nALTER TABLE T_SCH_TASK ADD FMESSAGEID VARCHAR(36) NULL");
            this.initField("T_SCH_TASK", "FCOSTTIME", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_TASK' AND KSQL_COL_NAME ='FCOSTTIME') \nALTER TABLE T_SCH_TASK ADD FCOSTTIME INT DEFAULT 0 NOT NULL");
            this.initField("T_SCH_TASKDEFENTRY", "FMUST", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_TASKDEFENTRY' AND KSQL_COL_NAME ='FMUST') \n ALTER TABLE T_SCH_TASKDEFENTRY ADD (FMUST CHAR(1) DEFAULT '1' NOT NULL )");
            this.initField("T_SCH_TASKDEFENTRY", "FPARAMVALUE", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_TASKDEFENTRY' AND KSQL_COL_NAME ='FPARAMVALUE') \n ALTER TABLE T_SCH_TASKDEFENTRY ADD (FPARAMVALUE NVARCHAR(512) )");
            this.initField("T_SCH_TASKDEFENTRY", "FBASEDATAINFO", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_TASKDEFENTRY' AND KSQL_COL_NAME ='FBASEDATAINFO') \n ALTER TABLE T_SCH_TASKDEFENTRY ADD (FBASEDATAINFO NVARCHAR(200) )");
            this.initField("T_SCH_TASKDEFENTRY", "FPARAMDESC", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_TASKDEFENTRY' AND KSQL_COL_NAME ='FPARAMDESC') \n ALTER TABLE T_SCH_TASKDEFENTRY ADD (FPARAMDESC NVARCHAR(512) )");
            this.initField("T_SCH_TASKDEFINE", "FRESCHEDULED", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_TASKDEFINE' AND KSQL_COL_NAME ='FRESCHEDULED') \n ALTER TABLE T_SCH_TASKDEFINE ADD (FRESCHEDULED CHAR(1) DEFAULT '0' NOT NULL )");
            this.initField("T_SCH_TASKDEFINE", "FCREATORID", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_TASKDEFINE' AND KSQL_COL_NAME ='FCREATORID') \n ALTER TABLE T_SCH_TASKDEFINE ADD (FCREATORID BIGINT DEFAULT 0 NOT NULL );");
            this.initField("T_SCH_TASKDEFINE", "FCREATETIME", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_TASKDEFINE' AND KSQL_COL_NAME ='FCREATETIME') \n ALTER TABLE T_SCH_TASKDEFINE ADD (FCREATETIME DATETIME );");
            this.initField("T_SCH_TASKDEFINE", "FMODIFIERID", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_TASKDEFINE' AND KSQL_COL_NAME ='FMODIFIERID') \n ALTER TABLE T_SCH_TASKDEFINE ADD (FMODIFIERID BIGINT DEFAULT 0 NOT NULL );");
            this.initField("T_SCH_TASKDEFINE", "FMODIFYTIME", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_TASKDEFINE' AND KSQL_COL_NAME ='FMODIFYTIME') \n ALTER TABLE T_SCH_TASKDEFINE ADD (FMODIFYTIME DATETIME );");
            this.initField("T_SCH_JOB", "FCREATORID", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_JOB' AND KSQL_COL_NAME ='FCREATORID') \n ALTER TABLE T_SCH_JOB ADD (FCREATORID BIGINT DEFAULT 0 NOT NULL );");
            this.initField("T_SCH_JOB", "FCREATETIME", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_JOB' AND KSQL_COL_NAME ='FCREATETIME') \n ALTER TABLE T_SCH_JOB ADD (FCREATETIME DATETIME );");
            this.initField("T_SCH_JOB", "FMODIFIERID", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_JOB' AND KSQL_COL_NAME ='FMODIFIERID') \n ALTER TABLE T_SCH_JOB ADD (FMODIFIERID BIGINT DEFAULT 0 NOT NULL );");
            this.initField("T_SCH_JOB", "FMODIFYTIME", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_JOB' AND KSQL_COL_NAME ='FMODIFYTIME') \n ALTER TABLE T_SCH_JOB ADD (FMODIFYTIME DATETIME );");
            this.initField("T_SCH_SCHEDULE", "FCREATORID", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_SCHEDULE' AND KSQL_COL_NAME ='FCREATORID') \n ALTER TABLE T_SCH_SCHEDULE ADD (FCREATORID BIGINT DEFAULT 0 NOT NULL );");
            this.initField("T_SCH_SCHEDULE", "FCREATETIME", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_SCHEDULE' AND KSQL_COL_NAME ='FCREATETIME') \n ALTER TABLE T_SCH_SCHEDULE ADD (FCREATETIME DATETIME );");
            this.initField("T_SCH_SCHEDULE", "FMODIFIERID", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_SCHEDULE' AND KSQL_COL_NAME ='FMODIFIERID') \n ALTER TABLE T_SCH_SCHEDULE ADD (FMODIFIERID BIGINT DEFAULT 0 NOT NULL );");
            this.initField("T_SCH_SCHEDULE", "FMODIFYTIME", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_SCHEDULE' AND KSQL_COL_NAME ='FMODIFYTIME') \n ALTER TABLE T_SCH_SCHEDULE ADD (FMODIFYTIME DATETIME );");
            this.initField("T_SCH_JOB", "FTASKTRACE", "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_SCH_JOB' AND KSQL_COL_NAME ='FTASKTRACE') \n ALTER TABLE T_SCH_JOB ADD (FTASKTRACE CHAR(1) DEFAULT '0' NOT NULL );");
            long costTime = System.currentTimeMillis() - startTime;
            log.info("Schedule***ScheduleService initDB costTime \uff1a {}", (Object)costTime);
        }
    }

    private void initField(String table, String field, String sql) {
        try {
            if (!ScheduleService.isExistField(table, field)) {
                DB.execute((DBRoute)DBRoute.base, (String)sql);
            }
        }
        catch (Exception e) {
            log.error("Schedule***ScheduleService init error", (Throwable)e);
        }
    }

    private static boolean isExistField(String tableName, String fieldName) {
        List fields = DB.getColumnNames((DBRoute)DBRoute.basedata, (String)tableName);
        if (fields == null || fields.isEmpty()) {
            return false;
        }
        for (String field : fields) {
            if (!field.equalsIgnoreCase(fieldName)) continue;
            return true;
        }
        return false;
    }

    public static ScheduleService getInstance() {
        if (instance == null) {
            log.error("Schedule***\u8c03\u5ea6\u670d\u52a1\u672a\u542f\u52a8\uff0c\u8be5\u670d\u52a1\u5668\u8282\u70b9bos.lifecycle.servicelist\u672a\u6ce8\u518cScheduleService\uff0c\u6216lifecyclemanager\u542f\u52a8\u5931\u8d25\u3002");
            return null;
        }
        if (Status.NotInitialed == curStatus) {
            RequestContext rc = RequestContext.get();
            try {
                instance.start();
            }
            finally {
                RequestContext.set((RequestContext)rc);
            }
        }
        return instance;
    }

    public boolean isLeader() {
        return isLeaderFlag.get();
    }

    public String getName() {
        return "Schedule Service";
    }

    public ScheduleManager getScheduleManager() {
        if (this.trigger == null) {
            return null;
        }
        return this.trigger.getScheduleManager();
    }

    public Status getCurStatus() {
        return curStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ScheduleService scheduleService = this;
        synchronized (scheduleService) {
            if (Status.NotInitialed != curStatus) {
                return;
            }
            curStatus = Status.Running;
        }
        this.isStart = true;
        try {
            super.start();
            OperationContext oc = new OperationContext();
            oc.setAppId("bos");
            OperationContext.set((OperationContext)oc);
            if (this.enableMasterElection()) {
                this.beginLeaderElection();
            }
            this.startDaemonThread();
        }
        catch (Throwable t) {
            log.error("Schedule****Error ", t);
            throw t;
        }
    }

    private boolean enableMasterElection() {
        if (ZkConfig.getDeployMode() == ScheduleDeployMode.DISABLE || ZkConfig.getDeployMode() == ScheduleDeployMode.EXECUTE_NODE) {
            log.info("Schedule***\u8be5\u8282\u70b9\u4e0d\u542f\u52a8scheduleservice\u670d\u52a1,\u8282\u70b9\u6a21\u5f0f\u4e3a:" + ZkConfig.getDeployMode());
            return false;
        }
        if (Boolean.getBoolean("Schedule.disableToWork")) {
            log.info("Schedule***ScheduleService\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u8be5\u8282\u70b9\u4e0d\u8fdb\u884c\u8c03\u5ea6\u9009\u4e3e");
            return false;
        }
        String[] appIds = Instance.getAppIds();
        Boolean qingNodeStart = Boolean.parseBoolean(System.getProperty("Schedule.executor.qingnode.defaultstart", "false"));
        if (!qingNodeStart.booleanValue() && appIds != null && appIds.length == 1 && "qing".equalsIgnoreCase(appIds[0])) {
            log.info("Schedule***\u8f7b\u5206\u6790\u8282\u70b9\u4e0d\u8fdb\u884c\u8c03\u5ea6\u9009\u4e3e");
            return false;
        }
        if (!ConfigForInitConsumer.isConsumerEnable()) {
            log.info("Schedule***\u672a\u5f00\u542fmq\u670d\u52a1,\u8be5\u8282\u70b9\u4e0d\u8fdb\u884c\u8c03\u5ea6\u9009\u4e3e");
            return false;
        }
        String curGrop = AppGroup.getCurAppGroup();
        if (StringUtils.isNotBlank((CharSequence)curGrop) && Instance.isAppSplit() && appIds != null && appIds.length > 0) {
            for (String appId : appIds) {
                if (!AppGroup.isCurrentGrayNode((String)appId)) continue;
                log.info("Schedule***\u5f53\u524d\u4e3a\u7070\u5ea6\u8282\u70b9\uff0c\u4e0d\u542f\u7528schedule-masterservice");
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public LeaderElectionSupport getLeaderElectionSupport() {
        return null;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public ExecutorResourceManager getExecutorResourceManager() {
        return this.executorResourceMrg;
    }

    private boolean pauseTriggerService() {
        return Boolean.getBoolean("Schedule.trigger.paused");
    }

    private synchronized void keepAlive() {
        if (this.trigger == null) {
            return;
        }
        if (this.trigger.getStatus() == SchVisitorStatus.Paused) {
            return;
        }
        this.trigger.reSetElectedAccount(this.getElectedAccount());
    }

    private void addAccountChangedListener() {
        TenantListenerManager.addTenantListener((TenantListener)new TenantListener(){

            public void onTenantAccountsAdded(TenantListenerInfo tenantListenerInfo) {
                block5: {
                    try {
                        String typeString = System.getProperty("mc.type");
                        if (!"ZK".equalsIgnoreCase(typeString) || !isLeaderFlag.get() || !ScheduleService.this.trigger.isRunning()) break block5;
                        ThreadLifeCycleManager.start();
                        for (Account account : tenantListenerInfo.getAccountList()) {
                            log.info("Schedule***\u589e\u52a0\u79df\u6237\uff1a" + account.getAccountId());
                            if (!ScheduleService.this.tryLock(account)) continue;
                            try {
                                Thread.sleep(recoveryDelayTime_ms);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            RequestContextUtils.createRequestContext((String)account.getTenantId(), (String)account.getAccountId(), (String)"0");
                            if (!DBElectionHelper.tryLock()) continue;
                            ScheduleService.this.trigger.addAccount(account);
                        }
                    }
                    catch (Exception e) {
                        log.error("Schedule***\u540e\u53f0\u4e8b\u52a1\u65b0\u589e\u79df\u6237\u5f02\u5e38\uff1a", (Throwable)e);
                    }
                }
            }

            public void onTenantAccountsRemoved(TenantListenerInfo tenantListenerInfo) {
                if (!isLeaderFlag.get() || !ScheduleService.this.trigger.isRunning()) {
                    return;
                }
                try {
                    ThreadLifeCycleManager.start();
                    for (Account account : tenantListenerInfo.getAccountList()) {
                        log.info("Schedule***\u79fb\u9664\u79df\u6237\uff1a" + account.getAccountId());
                        RequestContextUtils.createRequestContext((String)account.getTenantId(), (String)account.getAccountId(), (String)"0");
                        ScheduleService.this.trigger.deleteAccount(account);
                        DBElectionHelper.releaseLock();
                    }
                }
                catch (Exception e) {
                    log.error("Schedule***\u540e\u53f0\u4e8b\u52a1\u79fb\u9664\u79df\u6237\u5f02\u5e38\uff1a", (Throwable)e);
                }
            }
        });
    }

    private void beginLeaderElection() {
        if (this.selector != null) {
            try {
                this.selector.close();
            }
            catch (Exception e) {
                log.error("Schedule***close schedule selector error", (Throwable)e);
            }
        }
        this.selector = this.serviceWrapper.initElector();
        this.selector.start();
        isElectStarted.set(true);
    }

    public void stateChanged() {
        try {
            ThreadLifeCycleManager.start();
            TraceIdUtil.createTraceId();
            RequestContextUtils.createRequestContext(null, null, null);
            log.info("Schedule***\u8c03\u5ea6\u4e3b\u8282\u70b9\u53d1\u751f\u4e86stateChanged:" + isLeaderFlag.get());
            if (isLeaderFlag.get()) {
                this.stopLeader(true);
            }
        }
        catch (Throwable t) {
            log.error("Schedule***error", t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeLeadership() {
        long startTime = System.currentTimeMillis();
        try {
            ThreadLifeCycleManager.start();
            TraceIdUtil.createTraceId();
            RequestContextUtils.createRequestContext(null, null, null);
            log.info("Schedule***\u5f00\u59cb\u9009\u4e3e:");
            OperationContext oc = new OperationContext();
            oc.setAppId("bos");
            OperationContext.set((OperationContext)oc);
            this.innerBeginService(true);
            if (isLeaderFlag.get()) {
                this.zkStore.write(ZkConfig.getMasterServerPath(), ZkConfig.getHostIpAddress());
                this.setMasterStartTime(System.currentTimeMillis());
            }
        }
        catch (Throwable e) {
            log.error("Schedule***\u8c03\u5ea6\u670d\u52a1\u542f\u52a8\u5f02\u5e38:", e);
            this.stopLeader(false);
            try {
                Thread.sleep(ZkConfig.getSelfCheck() * 50);
            }
            catch (InterruptedException ex) {
                log.error(e);
            }
        }
        finally {
            log.info("Schedule***\u8c03\u5ea6\u670d\u52a1#takeLeadership costTime {}", (Object)(System.currentTimeMillis() - startTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keepHeartbeat() {
        long startTime = System.currentTimeMillis();
        try {
            while (isLeaderFlag.get()) {
                try {
                    Thread.sleep(ZkConfig.getSelfCheck() * 1000);
                    if (this.pauseTriggerService() && this.trigger != null) {
                        this.trigger.setStatus(SchVisitorStatus.Paused);
                    } else if (this.trigger != null) {
                        this.trigger.setStatus(SchVisitorStatus.Running);
                    }
                    this.keepAlive();
                    if (!this.trigger.isRunning()) break;
                    String masterIp = this.zkStore.read(ZkConfig.getMasterServerPath(), null);
                    String hostIpAddress = ZkConfig.getHostIpAddress();
                    if (!StringUtils.equals((CharSequence)hostIpAddress, (CharSequence)masterIp) || Instance.isPausedServiceByMonitor()) {
                        log.info("Schedule***\u5f53\u524dIP\u548cmasterIP\u4e0d\u4e00\u81f4\uff0c\u9700\u8981\u4e0b\u7ebf\u5904\u7406\u3002ZkConfig.getHostIpAddress\uff1a{} ,masterIp:{}", (Object)hostIpAddress, (Object)masterIp);
                        break;
                    }
                    if (!this.serviceWrapper.keepAlive()) break;
                    log.info("Schedule***\u9009\u4e3e\u76d1\u63a7\u7ebf\u7a0b\u5fc3\u8df3\u4e2d....");
                }
                catch (Exception e1) {
                    log.error("Schedule***\u8c03\u5ea6\u670d\u52a1\u76d1\u542c\u5f02\u5e38:", (Throwable)e1);
                    break;
                }
            }
            this.stopLeader(false);
        }
        catch (Exception e) {
            log.error("Schedule***\u8c03\u5ea6\u670d\u52a1\u542f\u52a8\u5f02\u5e38:", (Throwable)e);
            this.stopLeader(false);
            try {
                Thread.sleep(ZkConfig.getSelfCheck() * 50);
            }
            catch (InterruptedException ex) {
                log.error((Throwable)e);
            }
        }
        finally {
            log.info("Schedule***\u8c03\u5ea6\u670d\u52a1#keepHeartbeat costTime {}", (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private void startDaemonThread() {
        Thread loadThread = new Thread(ThreadLifeCycleManager.wrapRunnable(() -> {
            while (this.isStart) {
                long sleepTime = (long)ZkConfig.getSelfCheck() * 1000000000L;
                LockSupport.parkNanos(sleepTime);
                if (isElectStarted.get() || !this.enableMasterElection()) continue;
                this.beginLeaderElection();
            }
        }));
        loadThread.setDaemon(true);
        loadThread.setName("BOSSchedule-ServiceDaemo");
        loadThread.setUncaughtExceptionHandler((t, e) -> log.error("Schedule***scheduleservice.daemon thread error ", e));
        loadThread.start();
    }

    private boolean tryLock(Account account) {
        RequestContextUtils.createRequestContext((String)account.getTenantId(), (String)account.getAccountId(), (String)"0");
        return DBElectionHelper.tryLock();
    }

    private List<Account> getElectedAccount() {
        ArrayList<Account> eList = new ArrayList<Account>(16);
        List allAccounts = ScheduleAccountUtils.getAllAccountsOfCurrentEnv((boolean)false);
        for (Account account : allAccounts) {
            RequestContextUtils.createRequestContext((String)account.getTenantId(), (String)account.getAccountId(), (String)"0");
            try {
                if (ZkConfig.getRunMode() == AbstractService.RunMode.Dev || this.tryLock(account)) {
                    eList.add(account);
                    continue;
                }
                log.info("Schedule***\u8d26\u5957\u9009\u4e3e\u5931\u8d25,\u5df2\u5b58\u5728\u9501\uff0c\u5f53\u524daccountId=" + account.getAccountId() + ",accountName=" + account.getAccountName());
            }
            catch (Exception e) {
                log.info("Schedule***\u8d26\u5957\u9009\u4e3e\u5f02\u5e38,accountId=" + account.getAccountId() + ",accountName=" + account.getAccountName() + ",errMsg=" + e.getMessage());
            }
        }
        return eList;
    }

    public void beginService() {
        this.innerBeginService(false);
    }

    private void innerBeginService(boolean isThrowExp) {
        List<Account> eList = this.getElectedAccount();
        try {
            this.initDB();
            this.zkStore.ensureExisted(ZkConfig.getJobMessagePath(), String.valueOf(System.currentTimeMillis()));
            this.zkStore.ensureExisted(ZkConfig.getScheduleChangedMessagePath(), String.valueOf(System.currentTimeMillis()));
            this.zkStore.ensureExisted(ZkConfig.getJobChangedMessagePath(), String.valueOf(System.currentTimeMillis()));
            this.executorResourceMrg = this.serviceWrapper.initExecutorResourceMrg();
            this.executorResourceMrg.setObjectFactory(this.getObjectFactory());
            this.executorResourceMrg.setZooKeeper();
            ExecutorResourceManager.setInstance(this.executorResourceMrg);
            this.trigger = new Trigger(eList);
            this.executorResourceMrg.start();
            this.trigger.start();
            this.addAccountChangedListener();
            this.addTriggerServiceListener();
            ScheduleGrayGroup.startConfigListener();
            isLeaderFlag.set(true);
        }
        catch (Exception e) {
            log.error("Schedule***schedule\u670d\u52a1\u542f\u52a8\u5931\u8d25,\u5207\u6362\u8282\u70b9", (Throwable)e);
            if (isThrowExp) {
                throw e;
            }
            try {
                this.stopLeader(false);
                return;
            }
            catch (Exception e2) {
                log.error("Schedule***beginService stopLeader", (Throwable)e2);
            }
        }
        curStatus = Status.InService;
        log.info("Schedule***beginService execute complete");
    }

    private void addTriggerServiceListener() {
        ConfigurationUtil.observeChange((String)"Schedule.trigger.paused", (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                if (!"Schedule.trigger.paused".equals(key) || ScheduleService.this.trigger == null) {
                    return;
                }
                ThreadLifeCycleManager.start();
                if (Boolean.parseBoolean(String.valueOf(newValue))) {
                    ScheduleService.this.trigger.setStatus(SchVisitorStatus.Paused);
                    for (Account account : ScheduleService.this.trigger.getElectedAccountsOfCluster().values()) {
                        RequestContextUtils.createRequestContext((String)account.getTenantId(), (String)account.getAccountId(), (String)"0");
                        DBElectionHelper.releaseLock();
                    }
                } else {
                    ScheduleService.this.trigger.setStatus(SchVisitorStatus.Running);
                    ScheduleService.this.keepAlive();
                    try {
                        Thread.sleep(recoveryDelayTime_ms);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ScheduleService.this.trigger.resumeService();
                }
            }
        });
    }

    public void stop() {
        log.info("Schedule***Schedule Server begins to stop!");
        if (isLeaderFlag.get()) {
            this.stopLeader(false);
        }
        if (this.isStart) {
            if (this.selector != null) {
                this.selector.close();
            }
            if (this.serviceWrapper != null) {
                this.serviceWrapper.stop();
            }
            isElectStarted.set(false);
        }
        this.isStart = false;
        super.stop();
        log.info("Schedule***Schedule Server is stopped!");
    }

    private void stopLeader(boolean isFromStateChanged) {
        if (isLeaderFlag.get()) {
            isLeaderFlag.set(false);
            if (this.trigger != null) {
                this.executorResourceMrg.stop();
                this.trigger.stop();
            }
            if (this.serviceWrapper instanceof RedisScheduleServiceWrapper && !isFromStateChanged) {
                this.serviceWrapper.stop();
            }
            ScheduleGrayGroup.stopConfigListener();
            log.info("Schedule***\u8c03\u5ea6\u4e3b\u8282\u70b9\u89e6\u53d1\u4e86\u505c\u6b62\u4e3b\u8282\u70b9\u52a8\u4f5c");
        }
    }

    protected ObjectFactory createObjectFactory(String messageMode) {
        if (messageMode.equalsIgnoreCase("ZooKeeper")) {
            return new MQObjectFactory();
        }
        if (messageMode.equalsIgnoreCase("MQ")) {
            return new MQObjectFactory();
        }
        return null;
    }

    public static boolean isRunning() {
        return instance != null && instance.isStarted() && instance.isLeader() && instance.getTrigger() != null && instance.getTrigger().isRunning();
    }

    public static void scheduleProcessChanged(String message) {
        if (!ScheduleService.isRunning()) {
            return;
        }
        ScheduleService scheduleService = ScheduleService.getInstance();
        if (scheduleService == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u5ea6\u670d\u52a1\u672a\u542f\u52a8", (String)"ScheduleService_0", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        }
        ScheduleManager scheduleManager = scheduleService.getScheduleManager();
        if (scheduleManager != null) {
            scheduleManager.scheduleProcessChanged(message);
        }
    }

    public static void jobProcessChanged(String message) {
        if (!ScheduleService.isRunning()) {
            return;
        }
        ScheduleService scheduleService = ScheduleService.getInstance();
        if (scheduleService == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u5ea6\u670d\u52a1\u672a\u542f\u52a8", (String)"ScheduleService_0", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        }
        ScheduleManager scheduleManager = scheduleService.getScheduleManager();
        if (scheduleManager != null) {
            scheduleManager.jobProcessChanged(message);
        }
    }

    public static void grayChanged(String message) {
        ScheduleGrayGroup.updateGrayConfig((String)message);
    }

    public static void grayInstanceChanged(String message) {
        ScheduleGrayGroup.updateGrayInstance((String)message);
    }

    public ActiveKeyValueStore getZkStore() {
        return this.zkStore;
    }

    public static void masterChanged() {
        ScheduleService scheduleService = ScheduleService.getInstance();
        if (scheduleService == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u5ea6\u670d\u52a1\u672a\u542f\u52a8", (String)"ScheduleService_0", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        }
        scheduleService.stateChanged();
    }

    public long getMasterStartTime() {
        return this.masterStartTime;
    }

    public void setMasterStartTime(long masterStartTime) {
        this.masterStartTime = masterStartTime;
    }

    public static enum Status {
        NotInitialed,
        Running,
        READY,
        InService;

    }
}

