/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.dc.api.model.Account;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ScheduleInfo;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.next.observable.IObservableDataFilter;
import kd.bos.schedule.next.observable.ObservableLogHandler;
import kd.bos.schedule.server.DBElectionHelper;
import kd.bos.schedule.server.next.ScheduleJobNextDispatchManager;
import kd.bos.schedule.server.next.ScheduleNextMonitor;
import kd.bos.schedule.server.next.observable.filter.MasterServerStatusFilter;
import kd.bos.schedule.server.realtime.RetryRunnable;
import kd.bos.schedule.server.schedulecreator.SchVisitorStatus;
import kd.bos.schedule.server.schedulecreator.ScheduleVisitor;
import kd.bos.schedule.utils.RequestContextUtils;
import kd.bos.schedule.utils.ScheduleAccountUtils;
import kd.bos.threads.ThreadPools;

public class Trigger
implements ScheduleVisitor {
    private static final Log logger = LogFactory.getLog(Trigger.class);
    private static ConcurrentHashMap<String, Map<String, List<ScheduleInfo>>> scheduleMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, ConcurrentHashMap<ScheduleInfo, ConcurrentLinkedQueue<ZonedDateTime>>> scheduleDatas = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Account> electedAccounts = new ConcurrentHashMap();
    private static ScheduleNextMonitor scheduleMonitor = null;
    private static ScheduleJobNextDispatchManager manager = null;
    private static boolean bgModel = Boolean.parseBoolean(System.getProperty("Schedule.monitor.bgmodel.enable", "true"));
    private static SchVisitorStatus staus = SchVisitorStatus.Stopped;
    private static RetryRunnable retryService = null;
    private static List<LinkedBlockingQueue> queue = null;

    public Trigger() {
    }

    public Trigger(List<Account> accounts) {
        for (Account account : accounts) {
            electedAccounts.put(account.getAccountId(), account);
        }
    }

    private boolean enableLocalAccountListner() {
        String type = System.getProperty("schedule.trigger.accountlistener.type", "local");
        return "local".equals(type);
    }

    public void reSetElectedAccount(List<Account> accounts) {
        ConcurrentHashMap<String, Account> temp = new ConcurrentHashMap<String, Account>(electedAccounts.size());
        temp.putAll(electedAccounts);
        electedAccounts.clear();
        for (Account account : accounts) {
            electedAccounts.put(account.getAccountId(), account);
            if (!this.enableLocalAccountListner() || temp.containsKey(account.getAccountId())) continue;
            this.afterAddAccount(account);
        }
        temp.clear();
    }

    public void start() {
        logger.info("Schedule***trigger is starting...");
        try {
            List filtersByType = ObservableLogHandler.getFiltersByType((String)"master");
            for (IObservableDataFilter filter : filtersByType) {
                filter.init();
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        if (queue == null || queue.size() <= 0) {
            int queueSize = Integer.getInteger("schedule.server.queue.size", 1);
            queue = new ArrayList<LinkedBlockingQueue>();
            for (int i = 0; i < queueSize; ++i) {
                queue.add(new LinkedBlockingQueue());
            }
            logger.info("Schedule***queue is create " + queueSize);
        }
        if (scheduleMonitor == null) {
            scheduleMonitor = new ScheduleNextMonitor(this);
            scheduleMonitor.startToListenScheduleChange();
            ThreadPools.executeOnce((String)"BOSSchedule-ScheduleMonitor", (Runnable)scheduleMonitor, (String)"bos");
            logger.info("Schedule***scheduleMonitor is create!");
            try {
                ObservableLogHandler.addFilter((String)MasterServerStatusFilter.class.getName());
            }
            catch (Exception e) {
                logger.error("Schedule***\u521d\u59cb\u5316\u4e3b\u8282\u70b9\u8fc7\u6ee4\u5668\u5931\u8d25\uff0cclass={}", (Object)MasterServerStatusFilter.class.getName(), (Object)e);
            }
        }
        if (manager == null) {
            manager = new ScheduleJobNextDispatchManager(this);
            manager.start();
            logger.info("Schedule***manager is create!");
        }
        if (retryService == null) {
            retryService = new RetryRunnable(this);
            ThreadPools.executeOnce((String)"BOSSchedule-RetryService", (Runnable)retryService, (String)"bos");
            logger.info("Schedule***retryService is create!");
        }
        staus = SchVisitorStatus.Running;
    }

    public ScheduleManager getScheduleManager() {
        return scheduleMonitor;
    }

    public void stop() {
        IObservableDataFilter masterServerStatusFilter;
        if (scheduleMonitor != null) {
            scheduleMonitor.stop();
        }
        if (manager != null) {
            manager.stop();
        }
        if (retryService != null) {
            retryService.stop();
        }
        if ((masterServerStatusFilter = ObservableLogHandler.getFilters((String)"kd.bos.schedule.server.next.observable.filter.MasterServerStatusFilter")) != null) {
            masterServerStatusFilter.stop();
        }
        if (electedAccounts != null) {
            for (Map.Entry<String, Account> row : electedAccounts.entrySet()) {
                try {
                    RequestContextUtils.createRequestContext((String)row.getValue().getTenantId(), (String)row.getValue().getAccountId(), (String)"0");
                    DBElectionHelper.releaseLock();
                }
                catch (Throwable t) {
                    logger.error("Schedule***trigger.stop error", t);
                }
            }
            electedAccounts.clear();
        }
        staus = SchVisitorStatus.Stopped;
        logger.info("Schedule***trigger is stopped.");
        if (scheduleMap != null) {
            scheduleMap.clear();
        }
        if (scheduleDatas != null) {
            scheduleDatas.clear();
        }
        try {
            List filtersByType = ObservableLogHandler.getFiltersByType((String)"master");
            for (IObservableDataFilter filter : filtersByType) {
                filter.stop();
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        scheduleMonitor = null;
        manager = null;
        retryService = null;
        queue = null;
    }

    public boolean isRunning() {
        if (scheduleMonitor == null) {
            return false;
        }
        return !scheduleMonitor.isStoped();
    }

    @Override
    public ConcurrentHashMap<String, Map<String, List<ScheduleInfo>>> getSchedules() {
        return scheduleMap;
    }

    @Override
    public List<LinkedBlockingQueue> getServerQueues() {
        return queue;
    }

    @Override
    public ConcurrentMap<String, Account> getElectedAccountsOfCluster() {
        if (!bgModel) {
            List list = ScheduleAccountUtils.getAllAccountsOfCurrentEnv((boolean)false);
            ConcurrentHashMap<String, Account> map = new ConcurrentHashMap<String, Account>();
            for (Account account : list) {
                map.put(account.getAccountId(), account);
            }
            return map;
        }
        return electedAccounts;
    }

    @Override
    public void addAccount(Account account) {
        Account acc = electedAccounts.putIfAbsent(account.getAccountId(), account);
        if (acc == null) {
            this.afterAddAccount(account);
        }
    }

    private void afterAddAccount(Account account) {
        if (scheduleMonitor != null) {
            scheduleMonitor.scanPlan(account);
        }
    }

    @Override
    public void deleteAccount(Account account) {
        electedAccounts.remove(account.getAccountId());
        this.afterDeleteAccount(account);
    }

    private void afterDeleteAccount(Account account) {
        scheduleDatas.remove(account.getAccountId());
        if (scheduleMonitor != null) {
            scheduleMonitor.deletePlan(account);
        }
    }

    @Override
    public ConcurrentMap<ScheduleInfo, ConcurrentLinkedQueue<ZonedDateTime>> getSchedulesByAccountId(String accountId) {
        scheduleDatas.putIfAbsent(accountId, new ConcurrentHashMap());
        return scheduleDatas.get(accountId);
    }

    @Override
    public void setStatus(SchVisitorStatus status) {
        staus = status;
    }

    @Override
    public SchVisitorStatus getStatus() {
        return staus;
    }

    public void resumeService() {
        for (Account account : electedAccounts.values()) {
            this.afterAddAccount(account);
        }
    }
}

