/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.clearlogtask;

import java.lang.reflect.Method;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.Task;
import kd.bos.schedule.dao.dbImpl.TaskCache;
import kd.bos.schedule.message.AbstractService;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.schedule.zk.ZkConfig;

public class ClearUpTask
implements Task {
    private static final Log log = LogFactory.getLog(ClearUpTask.class);
    private static Method isInstanceAlive = null;
    private JobDispatcherProxy proxy = new JobDispatcherProxy();
    private int day = 3;

    public void setTaskId(String id) {
    }

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        if (isInstanceAlive == null) {
            log.warn("Schedule***ClearUpTask error. isInstanceAlive is null");
            return;
        }
        try {
            this.init(params);
            this.clearUp();
        }
        catch (Exception e) {
            log.error("Schedule***ClearUpTask error. ", (Throwable)e);
            throw new KDException(BosErrorCode.bOS, new Object[]{e});
        }
    }

    private void init(Map<String, Object> param) {
        if (param == null) {
            return;
        }
        if (StringUtils.isNotBlank((Object)param.get("day"))) {
            String dayStr = String.valueOf(param.get("day"));
            this.day = Integer.parseInt(dayStr);
        }
    }

    private void clearUp() throws Exception {
        Exception exp = null;
        try {
            this.clearUpBeginTask();
        }
        catch (Exception e) {
            log.error("Schedule***clearUp error", (Throwable)e);
            exp = e;
        }
        try {
            this.clearUpScheduleTask();
        }
        catch (Exception e) {
            log.error("Schedule***clearUp error", (Throwable)e);
            exp = e;
        }
        try {
            this.clearUpReadyTask();
        }
        catch (Exception e) {
            log.error("Schedule***clearUp error", (Throwable)e);
            exp = e;
        }
        if (exp != null) {
            throw exp;
        }
    }

    private void clearUpBeginTask() throws Exception {
        String sql = "select t1.fid, t1.fstatus, t1.fjobid, t1.fscheduleid, t2.fjobtype, t2.fstrategy,t2.fconcurrent,t1.finstanceid, t3.frescheduled  from t_sch_task t1 left join t_sch_job t2 on t1.fjobid = t2.fid left join t_sch_taskdefine t3 on t2.ftaskdefineid = t3.fid  where t1.fstatus in( ?,?) and fdispatchtime > ? ";
        LocalDate localDate = LocalDate.now().minusDays(this.day);
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDate.atStartOfDay().atZone(zone).toInstant();
        Date date = Date.from(instant);
        ArrayList<Object> param = new ArrayList<Object>(6);
        param.add("BEGIN");
        param.add("RUNNING");
        param.add(date);
        if (AbstractService.RunMode.Dev == ZkConfig.getRunMode()) {
            sql = sql + " and t1.frunat = ?";
            param.add(ZkConfig.getExecutorServerName());
        }
        ArrayList<String> abortTaskIds = new ArrayList<String>(6);
        ArrayList<String> reScheduleTaskIds = new ArrayList<String>(6);
        DataSet ds = DB.queryDataSet((String)"UpdateTaskRecordStatus", (DBRoute)DBRoute.base, (String)sql, (Object[])param.toArray());
        Object object = null;
        try {
            while (ds.hasNext()) {
                Row row = ds.next();
                String id = row.getString("fid");
                String instanceid = row.getString("finstanceid");
                String isReSchedule = row.getString("frescheduled");
                if (kd.bos.util.StringUtils.isEmpty((String)instanceid)) continue;
                boolean isAlive = (Boolean)isInstanceAlive.invoke(null, instanceid);
                if (isAlive) continue;
                if ("1".equals(isReSchedule)) {
                    reScheduleTaskIds.add(id);
                    continue;
                }
                abortTaskIds.add(id);
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    ds.close();
                }
            }
        }
        for (String taskId : abortTaskIds) {
            try {
                this.proxy.abortTask(taskId);
            }
            catch (Exception e) {
                log.error("Schedule**** abortTask error taskid:" + taskId, (Throwable)e);
            }
        }
        String updateStateSql = "update t_sch_task set fstatus = ? where fstatus = ? and  fid = ?";
        if (!reScheduleTaskIds.isEmpty()) {
            for (String taskId : reScheduleTaskIds) {
                TXHandle txh = TX.requiresNew();
                Throwable throwable = null;
                try {
                    try {
                        Object[] params2 = new Object[]{"RESCHEDULE", "BEGIN", taskId};
                        int ret = DB.update((DBRoute)DBRoute.base, (String)updateStateSql, (Object[])params2);
                        if (ret != 1) continue;
                        TaskCache.clearCache((String)taskId);
                        this.proxy.reScheduledTask(taskId);
                    }
                    catch (Throwable t) {
                        log.error(String.format("Schedule***task %s rescheduled error", taskId), t);
                        txh.markRollback();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (txh == null) continue;
                    if (throwable != null) {
                        try {
                            txh.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    txh.close();
                }
            }
        }
    }

    private void clearUpScheduleTask() throws Exception {
    }

    private void clearUpReadyTask() throws Exception {
        block16: {
            String sql = "select t1.fid, t1.fstatus, t1.fjobid, t1.fscheduleid, t2.fjobtype, t2.fstrategy,t2.fconcurrent,t1.finstanceid from t_sch_task t1 left join t_sch_job t2 on t1.fjobid = t2.fid where t1.fstatus = ? and fdispatchtime > ? ";
            ArrayList<Object> param = new ArrayList<Object>(6);
            param.add("READY");
            LocalDate localDate = LocalDate.now().minusDays(this.day);
            ZoneId zone = ZoneId.systemDefault();
            Instant instant = localDate.atStartOfDay().atZone(zone).toInstant();
            Date date = Date.from(instant);
            param.add(date);
            DataSet ds = DB.queryDataSet((String)"clearUpReadyTask", (DBRoute)DBRoute.base, (String)sql, (Object[])param.toArray());
            Throwable throwable = null;
            block11: while (true) {
                try {
                    while (ds.hasNext()) {
                        Row row = ds.next();
                        String id = row.getString("fid");
                        String instanceid = row.getString("finstanceid");
                        if (kd.bos.util.StringUtils.isEmpty((String)instanceid)) continue;
                        boolean isAlive = (Boolean)isInstanceAlive.invoke(null, instanceid);
                        if (isAlive) continue;
                        try {
                            this.proxy.resetReadyTask(id);
                            continue block11;
                        }
                        catch (Exception e) {
                            log.error(String.format("Schedule***clearUpReadyTask error, taskId %s", id), (Throwable)e);
                        }
                    }
                    break block16;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            finally {
                if (ds != null) {
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
    }

    public void stop() throws KDException {
    }

    static {
        try {
            Class<?> requestContextCls = Class.forName("kd.bos.monitor.service.LivingServiceUtils");
            isInstanceAlive = requestContextCls.getMethod("isInstanceAlive", String.class);
        }
        catch (Throwable e) {
            log.error("Schedule***ClearUpTask error", e);
        }
    }
}

