/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.next;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import java.sql.Timestamp;
import java.time.Clock;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.TimeZone;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ScheduleInfo;
import kd.bos.schedule.api.ScheduleTypeNextEnums;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.CoreBusinessDataServiceHelper;

public abstract class TimeNextUtils {
    static final TimeService svc = new TimeService();
    private static CronParser cronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
    private static final Log logger = LogFactory.getLog(TimeNextUtils.class);

    public static ZonedDateTime createDate(long times) {
        Timestamp ts = new Timestamp(times);
        return ts.toInstant().atZone(svc.getSysTimeZone().getTimeZone().toZoneId());
    }

    public static ZonedDateTime createDate(long times, ZoneId zoneId) {
        ZonedDateTime oriDT = TimeNextUtils.createDate(times);
        return oriDT.withZoneSameLocal(zoneId);
    }

    public static void genSchedule(ScheduleInfo info, ZonedDateTime lastRunTime, ZonedDateTime endTime) {
    }

    public static void genScheduleEx(ScheduleInfo info, ZonedDateTime lastRunTime, ZonedDateTime endTime) {
        TimeNextUtils.genScheduleEx(info, lastRunTime, endTime, 31);
    }

    public static void genScheduleEx(ScheduleInfo info, ZonedDateTime lastRunTime, ZonedDateTime endTime, int numTimes) {
        if (!TimeNextUtils.checkInfo(info) || lastRunTime == null) {
            return;
        }
        if (lastRunTime.isAfter(endTime)) {
            return;
        }
        ZoneId zoneId = TimeNextUtils.getZoneId(info.getTimeZoneId());
        ZonedDateTime scheduleStratTime = TimeNextUtils.createDate(info.getStartTime(), zoneId);
        ZonedDateTime scheduleEndTime = TimeNextUtils.createDate(info.getEndTime(), zoneId);
        scheduleStratTime = scheduleStratTime.truncatedTo(ChronoUnit.SECONDS);
        scheduleEndTime = scheduleEndTime.truncatedTo(ChronoUnit.SECONDS);
        lastRunTime = lastRunTime.truncatedTo(ChronoUnit.SECONDS);
        ExecutionTime executionTime = null;
        try {
            executionTime = ExecutionTime.forCron((Cron)cronParser.parse(info.getPlan()));
        }
        catch (Throwable t) {
            logger.warn("Schedule***genSchedule parse cron error, schedule={}", (Object)info);
            return;
        }
        if (info.getScheduleType() != ScheduleTypeNextEnums.NoRepeat && lastRunTime.isBefore(scheduleStratTime)) {
            lastRunTime = scheduleStratTime.minusSeconds(1L);
        }
        while (info.getPointOfTime().size() < numTimes) {
            ZonedDateTime nextTime = null;
            Optional opt = executionTime.nextExecution(lastRunTime);
            if (!opt.isPresent() || !(nextTime = (ZonedDateTime)opt.get()).isBefore(scheduleEndTime)) break;
            info.getPointOfTime().add(nextTime);
            lastRunTime = nextTime;
        }
        if (info.getScheduleType() == ScheduleTypeNextEnums.NoRepeat) {
            logger.info("scheduleinfo : {} , PointOfTime size : {} , PointOfTime : {}", new Object[]{info, info.getPointOfTime().size(), info.getPointOfTime()});
        }
    }

    public static ZoneId getZoneId(long timeZoneId) {
        ZoneId zoneId;
        if (timeZoneId != 0L) {
            DynamicObject dObj = CoreBusinessDataServiceHelper.loadSingleFromCache((Object)timeZoneId, (String)"inte_timezone", (String)"number");
            if (dObj == null || StringUtils.isEmpty((CharSequence)dObj.getString("number"))) {
                throw new RuntimeException(String.format("Get timeZoneand error, and timeZoneId is %d", timeZoneId));
            }
            zoneId = TimeZone.getTimeZone(dObj.getString("number")).toZoneId();
        } else {
            zoneId = Clock.systemDefaultZone().getZone();
        }
        return zoneId;
    }

    private static boolean checkInfo(ScheduleInfo info) {
        return info != null && info.getPlan() != null && info.getPlan().trim().length() != 0 && info.getStartTime() != 0L && info.getEndTime() != 0L;
    }

    public static ZonedDateTime genNextTime(ScheduleInfo info) {
        if (!TimeNextUtils.checkInfo(info)) {
            return null;
        }
        ZonedDateTime nextTime = null;
        ZonedDateTime now = ZonedDateTime.now().truncatedTo(ChronoUnit.MINUTES);
        ZonedDateTime scheduleStratTime = TimeNextUtils.createDate(info.getStartTime());
        ZonedDateTime lastRunTime = scheduleStratTime.isAfter(now) ? scheduleStratTime : now;
        ZonedDateTime scheduleEndTime = TimeNextUtils.createDate(info.getEndTime());
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)cronParser.parse(info.getPlan()));
        Optional opt = executionTime.nextExecution(lastRunTime);
        if (opt.isPresent() && (nextTime = (ZonedDateTime)opt.get()).isAfter(scheduleEndTime)) {
            nextTime = null;
        }
        return nextTime;
    }
}

