/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.next.observable.filter;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.expression.Always;
import com.cronutils.model.field.expression.Every;
import com.cronutils.parser.CronParser;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.RouteMode;
import kd.bos.schedule.api.ScheduleInfo;
import kd.bos.schedule.api.ServerManager;
import kd.bos.schedule.next.observable.IObservableDataFilter;
import kd.bos.schedule.next.observable.model.ObservableModel;
import kd.bos.schedule.next.observable.model.ObservableScheduleInfo;
import kd.bos.schedule.next.observable.model.TimerPulse;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.schedule.server.Trigger;
import kd.bos.schedule.utils.ScheduleSortUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.util.CollectionUtils;
import org.joda.time.DateTime;

public class MasterServerStatusFilter
implements IObservableDataFilter {
    @Deprecated
    public static Map<String, Object> localData = new HashMap<String, Object>();
    private static LocalQueueData localQueueData;
    private static final Log logger;
    private static final String BOS_SCHEDULE_CORE = "bos-schedule-core";
    private static final CronParser parser;
    private static final ServerManager sm;
    private DateTime hourDispatchJobStartTime;
    private DateTime minPushQueueStartTime;
    private DateTime minPopQueueStartTime;

    public void handle(ObservableModel model) {
        try {
            if (model.getData() instanceof TimerPulse) {
                TimerPulse timerPulse = (TimerPulse)model.getData();
                if (this.isBroadcast(timerPulse)) {
                    return;
                }
                switch (model.getClassfiy()) {
                    case "pushLocalQueue": {
                        this.countIncPushQueue();
                        break;
                    }
                    case "popLocalQueue": {
                        this.countIncPopQueue();
                        break;
                    }
                    case "dispatchJobSuccess": {
                        this.countIncDispatchCount();
                        break;
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.error("ERROR schedule***MasterServerStatusFilter error", t);
        }
    }

    public static Map<String, Map<String, Integer>> getScheduleCycleData() {
        Trigger trigger;
        ConcurrentHashMap<String, Map<String, List<ScheduleInfo>>> triggerScheduleInfo;
        HashMap<String, Map<String, Integer>> result = new HashMap<String, Map<String, Integer>>();
        if (ScheduleService.getInstance() != null && ScheduleService.getInstance().getTrigger() != null && (triggerScheduleInfo = (trigger = ScheduleService.getInstance().getTrigger()).getSchedules()) != null) {
            for (Map.Entry infoEntry : triggerScheduleInfo.entrySet()) {
                String repeatMode = (String)infoEntry.getKey();
                Map cronScheduleInfos = (Map)infoEntry.getValue();
                if (StringUtils.equalsIgnoreCase((CharSequence)repeatMode, (CharSequence)"NoRepeat")) continue;
                Map<String, Integer> cycleMap = MasterServerStatusFilter.getCycleMap(cronScheduleInfos, repeatMode);
                Map<String, Integer> cycleMapTop6 = MasterServerStatusFilter.sortCycleMap(cycleMap, repeatMode);
                result.put(repeatMode, cycleMapTop6);
            }
        }
        return result;
    }

    public static List<ObservableScheduleInfo> getScheduleDist(String repeatMode, String cron, String cyclePeriod) {
        if (ScheduleService.getInstance() != null && ScheduleService.getInstance().getTrigger() != null) {
            ConcurrentHashMap<String, Map<String, List<ScheduleInfo>>> triggerScheduleInfos = ScheduleService.getInstance().getTrigger().getSchedules();
            Map cronScheduleInfos = null;
            for (Map.Entry infoEntry : triggerScheduleInfos.entrySet()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)infoEntry.getKey()), (CharSequence)repeatMode)) continue;
                cronScheduleInfos = (Map)infoEntry.getValue();
                break;
            }
            List<Account> allAccounts = MasterServerStatusFilter.getAllAccountsOfCurrentEnv();
            HashMap<String, String> accountNamesMap = new HashMap<String, String>(allAccounts.size());
            for (Account account : allAccounts) {
                accountNamesMap.put(account.getAccountId(), account.getAccountName());
            }
            if (cronScheduleInfos != null) {
                if (StringUtils.equalsIgnoreCase((CharSequence)repeatMode, (CharSequence)"Other")) {
                    List scheduleInfos = (List)cronScheduleInfos.get(cron);
                    return MasterServerStatusFilter.convertToObservableScheduleInfo(scheduleInfos, accountNamesMap);
                }
                ArrayList<ObservableScheduleInfo> result = new ArrayList<ObservableScheduleInfo>(16);
                for (Map.Entry scheduleInfoEntry : cronScheduleInfos.entrySet()) {
                    String entryCron = (String)scheduleInfoEntry.getKey();
                    List scheduleInfos = (List)scheduleInfoEntry.getValue();
                    String entryPeriod = MasterServerStatusFilter.getCyclePeriodByCronAndRepeatMode(entryCron, repeatMode);
                    if (StringUtils.isBlank((CharSequence)entryPeriod) && CollectionUtils.isNotEmpty((Collection)scheduleInfos)) {
                        entryPeriod = String.valueOf(((ScheduleInfo)scheduleInfos.get(0)).getRepeatNum());
                    }
                    if (!StringUtils.equals((CharSequence)entryPeriod, (CharSequence)cyclePeriod)) continue;
                    result.addAll(MasterServerStatusFilter.convertToObservableScheduleInfo(scheduleInfos, accountNamesMap));
                }
                return result;
            }
        }
        return Collections.emptyList();
    }

    public static Map<String, Object> getMasterServerStatus() {
        HashMap<String, Object> result = new HashMap<String, Object>(7);
        Map<String, Object> localQueueDataMap = localQueueData.toMap();
        result.putAll(localQueueDataMap);
        int scheduleFrequency = 15;
        StringBuilder scheduleFrequencyStr = new StringBuilder(String.valueOf(scheduleFrequency));
        scheduleFrequencyStr.append(ResManager.loadKDString((String)"\u79d2", (String)"MasterServerStatusFilter_0", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        result.put("scheduleFrequency", scheduleFrequencyStr);
        Map masterServerInfo = sm.getMasterServerInfo();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (masterServerInfo.get("startTime") != null) {
            result.put("masterStartTime", sdf.format(masterServerInfo.get("startTime")));
        }
        result.put("masterServerIP", masterServerInfo.get("masterName"));
        result.put("masterIsStarted", "true".equals(masterServerInfo.get("isStarted").toString()) && sm.isScheduleServiceStarted());
        return result;
    }

    private boolean isBroadcast(TimerPulse timerPulse) {
        ScheduleInfo scheduleInfo = timerPulse.getInfo();
        if (scheduleInfo != null) {
            JobInfo jobInfo = scheduleInfo.getJobInfo();
            return jobInfo != null && jobInfo.getRouteMode() == RouteMode.SHARDINGBROADCAST;
        }
        return false;
    }

    private static List<Account> getAllAccountsOfCurrentEnv() {
        return AccountUtils.getAllAccountsOfCurrentEnv();
    }

    private void countIncPushQueue() {
        if (ScheduleSortUtils.isSameMinute((DateTime)this.minPushQueueStartTime)) {
            localQueueData.pushLocalQueueSuccess++;
        } else {
            localQueueData.pushLocalQueueSuccess = 1;
            this.minPushQueueStartTime = DateTime.now();
        }
    }

    private void countIncPopQueue() {
        if (ScheduleSortUtils.isSameMinute((DateTime)this.minPopQueueStartTime)) {
            localQueueData.popLocalQueueSuccess++;
        } else {
            localQueueData.popLocalQueueSuccess = 1;
            this.minPopQueueStartTime = DateTime.now();
        }
    }

    private void countIncDispatchCount() {
        if (ScheduleSortUtils.isSameHour((DateTime)this.hourDispatchJobStartTime)) {
            localQueueData.dispatchJobSuccess++;
        } else {
            localQueueData.dispatchJobSuccess = 1;
            this.hourDispatchJobStartTime = DateTime.now();
            logger.info("Schedule***master dispatchCount reset,time = {}", (Object)this.hourDispatchJobStartTime);
        }
    }

    public void handle(Object data) {
    }

    private static Map<String, Integer> getCycleMap(Map<String, List<ScheduleInfo>> cronScheduleInfos, String repeatMode) {
        HashMap<String, Integer> cycleMap = new HashMap<String, Integer>(8);
        for (Map.Entry<String, List<ScheduleInfo>> cronScheduleInfosEntry : cronScheduleInfos.entrySet()) {
            String cron = cronScheduleInfosEntry.getKey();
            List<ScheduleInfo> scheduleInfos = cronScheduleInfosEntry.getValue();
            if (!StringUtils.equalsIgnoreCase((CharSequence)repeatMode, (CharSequence)"Other") && CollectionUtils.isNotEmpty(scheduleInfos)) {
                String cyclePeriod = MasterServerStatusFilter.getCyclePeriodByCronAndRepeatMode(cron, repeatMode);
                if (StringUtils.isBlank((CharSequence)cyclePeriod)) {
                    cyclePeriod = String.valueOf(scheduleInfos.get(0).getRepeatNum());
                }
                Integer num = cycleMap.get(cyclePeriod) == null ? Integer.valueOf(0) : (Integer)cycleMap.get(cyclePeriod);
                cycleMap.put(cyclePeriod, num + scheduleInfos.size());
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)repeatMode, (CharSequence)"Other") || !CollectionUtils.isNotEmpty(scheduleInfos)) continue;
            cycleMap.put(cron, scheduleInfos.size());
        }
        return cycleMap;
    }

    private static Map<String, Integer> sortCycleMap(Map<String, Integer> cycleMap, String repeatMode) {
        Set<String> cycleMapKey = cycleMap.keySet();
        String[] cycleTop = cycleMapKey.toArray(new String[0]);
        ScheduleSortUtils.quickSort((String[])cycleTop, (int)0, (int)(cycleTop.length - 1), cycleMap);
        int cycleTop6Size = Math.min(cycleTop.length, 6);
        String[] cycleTop6 = new String[cycleTop6Size];
        System.arraycopy(cycleTop, 0, cycleTop6, 0, cycleTop6Size);
        if (!StringUtils.equalsIgnoreCase((CharSequence)repeatMode, (CharSequence)"Other")) {
            ScheduleSortUtils.quickSort((String[])cycleTop6, (int)0, (int)(cycleTop6.length - 1));
        }
        LinkedHashMap<String, Integer> cycleMapTop6 = new LinkedHashMap<String, Integer>(6);
        for (int i = 0; i < cycleTop6Size; ++i) {
            String cycle = cycleTop6[i];
            cycleMapTop6.put(cycle, cycleMap.get(cycle));
        }
        return cycleMapTop6;
    }

    private static String getCyclePeriodByCronAndRepeatMode(String cron, String repeatMode) {
        String cyclePeriod = "";
        try {
            CronField cronField;
            Cron parse = parser.parse(cron);
            Map items = parse.retrieveFieldsAsMap();
            CronFieldName cronFieldName = MasterServerStatusFilter.getCronFieldName(repeatMode);
            if (cronFieldName != null && (cronField = (CronField)items.get(cronFieldName)) != null) {
                if (cronField.getExpression() instanceof Every) {
                    Every every = (Every)cronField.getExpression();
                    Integer period = every.getPeriod().getValue();
                    cyclePeriod = String.valueOf(period);
                } else if (cronField.getExpression() instanceof Always) {
                    cyclePeriod = "1";
                }
            }
        }
        catch (Throwable t) {
            logger.error("Schedule***MasterServerStatusFilter getCycleData parse cron error,cron : {}", (Object)cron, (Object)t);
        }
        return cyclePeriod;
    }

    private static CronFieldName getCronFieldName(String repeatMode) {
        CronFieldName cronFieldName = null;
        switch (repeatMode) {
            case "Minutes": {
                cronFieldName = CronFieldName.MINUTE;
                break;
            }
            case "Hours": {
                cronFieldName = CronFieldName.HOUR;
                break;
            }
            case "Days": {
                cronFieldName = CronFieldName.DAY_OF_MONTH;
                break;
            }
            case "Weeks": {
                cronFieldName = CronFieldName.DAY_OF_WEEK;
                break;
            }
            case "Months": {
                cronFieldName = CronFieldName.MONTH;
                break;
            }
            case "Years": {
                cronFieldName = CronFieldName.YEAR;
                break;
            }
        }
        return cronFieldName;
    }

    private static List<ObservableScheduleInfo> convertToObservableScheduleInfo(List<ScheduleInfo> scheduleInfos, Map<String, String> accountNamesMap) {
        ArrayList<ObservableScheduleInfo> observableScheduleInfos = new ArrayList<ObservableScheduleInfo>(scheduleInfos.size());
        for (ScheduleInfo scheduleInfo : scheduleInfos) {
            ObservableScheduleInfo observableScheduleInfo = new ObservableScheduleInfo();
            observableScheduleInfo.setRepeatNum(String.valueOf(scheduleInfo.getRepeatNum()));
            observableScheduleInfo.setScheduleId(scheduleInfo.getId());
            observableScheduleInfo.setJobId(scheduleInfo.getJobId());
            observableScheduleInfo.setTenantId(scheduleInfo.getTenantId());
            observableScheduleInfo.setAccountId(scheduleInfo.getAccountId());
            observableScheduleInfo.setAccountName(accountNamesMap.get(scheduleInfo.getAccountId()));
            observableScheduleInfos.add(observableScheduleInfo);
        }
        return observableScheduleInfos;
    }

    private void checkLocalData() {
        if (!ScheduleSortUtils.isSameHour((DateTime)this.hourDispatchJobStartTime)) {
            localData.put("dispatchJobSuccess", 0);
            this.hourDispatchJobStartTime = DateTime.now();
        }
        if (!ScheduleSortUtils.isSameMinute((DateTime)this.minPopQueueStartTime)) {
            localData.put("popLocalQueue", 0);
            this.minPopQueueStartTime = DateTime.now();
        }
        if (!ScheduleSortUtils.isSameMinute((DateTime)this.minPushQueueStartTime)) {
            localData.put("pushLocalQueue", 0);
            this.minPushQueueStartTime = DateTime.now();
        }
    }

    public void init() {
        try {
            localQueueData = new LocalQueueData();
            this.hourDispatchJobStartTime = DateTime.now();
            this.minPushQueueStartTime = DateTime.now();
            this.minPopQueueStartTime = DateTime.now();
            logger.info("Schedule***MasterServerStatusFilter init success");
        }
        catch (Exception e) {
            logger.error("Schedule***MasterServerStatusFilter init error", (Throwable)e);
        }
    }

    public void stop() {
        logger.info("Schedule***MasterServerStatusFilter stop");
    }

    static {
        logger = LogFactory.getLog(MasterServerStatusFilter.class);
        parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
        sm = (ServerManager)ServiceFactory.getService(ServerManager.class);
    }

    static class LocalQueueData {
        private int pushLocalQueueSuccess;
        private int popLocalQueueSuccess;
        private int dispatchJobSuccess;

        LocalQueueData() {
        }

        Map<String, Object> toMap() {
            HashMap<String, Object> localQueueData = new HashMap<String, Object>(4);
            localQueueData.put("pushLocalQueue", this.pushLocalQueueSuccess);
            localQueueData.put("popLocalQueue", this.popLocalQueueSuccess);
            localQueueData.put("dispatchJobSuccess", this.dispatchJobSuccess);
            return localQueueData;
        }
    }
}

