/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.next.task;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.schedule.api.Task;
import kd.bos.schedule.api.TaskDao;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.util.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class SchTaskNumStatsTask
implements Task {
    private static final String TYPE_DAY = "DAY";
    private String taskId;

    public void setTaskId(String id) {
        this.taskId = id;
    }

    public void stop() throws KDException {
    }

    public void execute(RequestContext rc, Map<String, Object> param) throws KDException {
        String type = null;
        if (param.containsKey("type")) {
            type = (String)param.get("type");
        }
        if (StringUtils.isEmpty(type)) {
            type = TYPE_DAY;
        }
        Date dateTime = null;
        if (param.containsKey("time") && StringUtils.isNotEmpty((String)((String)param.get("time")))) {
            try {
                dateTime = DateUtils.parseDate((String)((String)param.get("time")), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
            }
            catch (ParseException e) {
                throw new KDException(BosErrorCode.bOS, "param time is illegal,time is " + param.get("time"), (Throwable)e);
            }
        }
        if (TYPE_DAY.equals(type)) {
            if (dateTime == null) {
                TaskDao taskDao = ScheduleService.getInstance().getObjectFactory().getTaskDao();
                TaskInfo taskInfo = taskDao.get(this.taskId);
                Date dispatchTime = new Date(taskInfo.getDispachTime());
                dateTime = DateUtils.addDays((Date)dispatchTime, (int)-1);
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dateTime);
            int value = calendar.get(5);
            Date startTime = DateUtils.truncate(dateTime, (int)5);
            Date endTime = DateUtils.addDays((Date)startTime, (int)1);
            String sql = "select fjobtype jobtype, count(1) count from t_sch_task where fdispatchtime > ? and fdispatchtime < ? group by fjobtype;";
            Object[] params = new SqlParameter[]{new SqlParameter(":fdispatchtime", 93, (Object)startTime), new SqlParameter(":fdispatchtime", 93, (Object)endTime)};
            Map res = (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, resultSet -> {
                ConcurrentHashMap<String, Integer> result = new ConcurrentHashMap<String, Integer>(16);
                while (resultSet.next()) {
                    String jobtype = resultSet.getString("jobtype");
                    if (StringUtils.isEmpty((String)jobtype)) continue;
                    int num = resultSet.getInt("count");
                    result.put(jobtype, num);
                }
                return result;
            });
            String deleteSql = "delete from T_SCH_TASKNUMSTATS where FTYPE = ? and FVALUE = ?;";
            params = new SqlParameter[]{new SqlParameter(":FTYPE", 12, (Object)type), new SqlParameter(":FVALUE", 4, (Object)value)};
            DB.execute((DBRoute)DBRoute.basedata, (String)deleteSql, (Object[])params);
            String insertSql = "insert into T_SCH_TASKNUMSTATS (FID,FTYPE,FVALUE,FCOUNT,FJOBTYPE,FTIME) values (?,?,?,?,?,?);";
            ArrayList<SqlParameter[]> paramss = new ArrayList<SqlParameter[]>(8);
            for (Map.Entry entry : res.entrySet()) {
                SqlParameter[] param2 = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)DB.genLongId((String)"T_SCH_TASKNUMSTATS")), new SqlParameter(":FTYPE", 12, (Object)type), new SqlParameter(":FVALUE", 4, (Object)value), new SqlParameter(":FCOUNT", 4, entry.getValue()), new SqlParameter(":FJOBTYPE", 12, entry.getKey()), new SqlParameter(":FTIME", 12, (Object)startTime)};
                paramss.add(param2);
            }
            if (!paramss.isEmpty()) {
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, paramss);
            }
        } else {
            if ("HOUR".equals(type)) {
                throw new KDBizException("NotSupported type:" + type);
            }
            throw new KDBizException("NotSupported type:" + type);
        }
        this.clearHistory(type, dateTime);
    }

    public void clearHistory(String type, Date dateTime) {
        dateTime = DateUtils.truncate((Date)dateTime, (int)2);
        dateTime = DateUtils.addMonths((Date)dateTime, (int)-3);
        String deleteSql = "delete from T_SCH_TASKNUMSTATS where FTIME < ? and FTYPE = ?;";
        Object[] params = new SqlParameter[]{new SqlParameter(":FTIME", 93, (Object)dateTime), new SqlParameter(":FTYPE", 12, (Object)type)};
        DB.execute((DBRoute)DBRoute.basedata, (String)deleteSql, (Object[])params);
    }
}

