/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.queueManager;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageType;

public class JobQueue
implements Comparator<JobQueue> {
    private List<String> executors;
    private List<MessageType> accessMsgType;
    private String name;
    private AtomicLong jobNum4Dispatch = new AtomicLong(0L);

    public JobQueue(String queueName, List<MessageType> accessTypes, List<String> executors) {
        this.name = queueName;
        this.executors = new CopyOnWriteArrayList<String>();
        this.executors.addAll(executors);
        this.accessMsgType = accessTypes;
    }

    public List<String> getExecutors() {
        return this.executors;
    }

    public List<MessageType> getAccessMsgType() {
        return this.accessMsgType;
    }

    public void addExecutor(String executor) {
        if (!this.executors.contains(executor)) {
            this.executors.add(executor);
        }
    }

    public void removeExecutor(String exectuor) {
        this.executors.remove(exectuor);
    }

    public String getName() {
        return this.name;
    }

    public boolean canWork() {
        return !this.executors.isEmpty();
    }

    public boolean canConsume(MessageInfo message) {
        return !this.executors.isEmpty() && this.accessMsgType.contains(message.getMessageType());
    }

    public void addOneJobNum() {
        this.jobNum4Dispatch.incrementAndGet();
    }

    public long getJobNum() {
        return this.jobNum4Dispatch.get();
    }

    @Override
    public int compare(JobQueue o1, JobQueue o2) {
        long jobNum2;
        long jobNum1 = o1.getJobNum();
        if (jobNum1 == (jobNum2 = o2.getJobNum())) {
            return 0;
        }
        return jobNum1 > jobNum2 ? 1 : -1;
    }
}

