/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.realtime;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.RouteMode;
import kd.bos.schedule.api.ShardingParam;
import kd.bos.schedule.dao.dbImpl.DbJobOperation;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.schedule.server.schedulecreator.SchVisitorStatus;
import kd.bos.schedule.server.schedulecreator.ScheduleVisitor;
import kd.bos.schedule.utils.RequestContextUtils;

public class RetryRunnable
implements Runnable {
    Log log = LogFactory.getLog((String)"kd.bos.schedule.server.realtime.RetryRunnable");
    private static final String SHAREPARAMS = "SHAREPARAMS";
    private static final String SHAREPARAM = "SHAREPARAM";
    private ScheduleVisitor visitor;
    private boolean runable = false;
    int timeCycle = 30000;

    public RetryRunnable(ScheduleVisitor visitor) {
        this.visitor = visitor;
    }

    @Override
    public void run() {
        this.runable = true;
        while (this.runable) {
            try {
                Thread.sleep(Integer.getInteger("schedule.retryTime", this.timeCycle).intValue());
            }
            catch (InterruptedException e) {
                this.log.error((Throwable)e);
            }
            if (this.visitor.getStatus() == SchVisitorStatus.Paused) {
                this.log.info("Schedule***SchVisitorStatus is Paused");
                continue;
            }
            for (Map.Entry row : this.visitor.getElectedAccountsOfCluster().entrySet()) {
                Account account = (Account)row.getValue();
                RequestContextUtils.createRequestContext((String)account.getTenantId(), (String)account.getAccountId(), null);
                try {
                    List jobInfos = DbJobOperation.RetrySelectJobInfo((int)this.timeCycle);
                    JobDispatcherProxy jobDispatcher = new JobDispatcherProxy();
                    for (int i = 0; i < jobInfos.size(); ++i) {
                        JobInfo jobInfo = (JobInfo)jobInfos.get(i);
                        jobInfo.setRetryCode(-1);
                        String scheduleId = jobInfo.getScheduleId();
                        String jobId = jobInfo.getId();
                        jobInfo.setExecuteTime(1);
                        long groupId = DbJobOperation.getGroupMax();
                        if (jobInfo.getRouteMode() != null && jobInfo.getRouteMode() == RouteMode.SHARDINGTASK) {
                            Map params = jobInfo.getParams();
                            if (params == null || params.size() <= 0) continue;
                            Object shareParams = params.get(SHAREPARAMS);
                            if (shareParams == null) {
                                return;
                            }
                            List<ShardingParam> shareParamList = new ArrayList();
                            try {
                                shareParamList = JSON.parseArray((String)((String)shareParams), ShardingParam.class);
                            }
                            catch (Exception e) {
                                HashMap shareParamMap = (HashMap)JSON.parseObject((String)((String)shareParams), HashMap.class);
                                for (Map.Entry paramEntry : shareParamMap.entrySet()) {
                                    shareParamList.add(new ShardingParam((String)paramEntry.getKey(), (String)paramEntry.getValue()));
                                }
                            }
                            int index = 0;
                            for (ShardingParam shardingParam : shareParamList) {
                                jobInfo.setShardingParam(shardingParam);
                                jobInfo.setTaskId(String.valueOf(DB.genLongId((String)"T_SCH_TASK")));
                                DbJobOperation.updateGroupId((String)scheduleId, (String)jobId, (long)groupId);
                                jobInfo.setGroupId(groupId);
                                jobInfo.setShareIndex(++index);
                                jobInfo.setExecuteTime(shareParamList.size());
                                jobDispatcher.dispatch(jobInfo);
                            }
                            continue;
                        }
                        DbJobOperation.updateGroupId((String)scheduleId, (String)jobId, (long)groupId);
                        jobInfo.setGroupId(groupId);
                        jobInfo.setTaskId(String.valueOf(DB.genLongId((String)"T_SCH_TASK")));
                        jobDispatcher.dispatch(jobInfo);
                    }
                }
                catch (KDException e) {
                    this.log.warn(String.format("Schedule***\u540e\u53f0\u4e8b\u52a1\u91cd\u8bd5\u5f02\u5e38\uff1a%s", e.getMessage()));
                }
            }
        }
    }

    public void stop() {
        this.runable = false;
    }
}

