/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.schedulecreator;

import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.IDService;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.schedule.message.AbstractService;
import kd.bos.schedule.server.schedulecreator.CronStruct;

public class ScheduleCreator {
    private static final String SCHEDULE_CREATOR_27 = "ScheduleCreator_27";
    private static final String SCH_001 = "SCH_001";
    private static final String SCHEDULE_CREATOR_33 = "ScheduleCreator_33";
    private static final String SCHEDULE_CREATOR_38 = "ScheduleCreator_38";
    private static final String FBYDAYORWEEK = "FBYDAYORWEEK";
    private static CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
    private static Map<String, String> weekMap = new HashMap<String, String>();
    private static Map<String, String> weekNameMap = new HashMap<String, String>();
    private static Map<String, String> dayOfMonthMap = new HashMap<String, String>();
    private static Map<String, String> monthsMap = new HashMap<String, String>();
    private static Map<String, String> monthsNameMap = new HashMap<String, String>();
    private static Map<String, String> noNameMap = new HashMap<String, String>();
    private static final String BOS_SCHEDULE_CORE = "bos-schedule-core";
    private static final String FREPEAT_MODE = "frepeatmode";
    private Map<String, Object> scheduleObj;

    public Map<String, Object> getScheduleObj() {
        if (this.scheduleObj == null) {
            this.scheduleObj = new HashMap<String, Object>();
        }
        return this.scheduleObj;
    }

    public void setScheduleObj(Map<String, Object> scheduleObj) {
        this.scheduleObj = scheduleObj;
    }

    public Map<String, Object> create(PlanInfo planInfo) {
        if (planInfo == null) {
            throw new IllegalArgumentException("planInfo is null");
        }
        if (planInfo.getStartTime() == null) {
            throw new IllegalArgumentException("planInfo.starttime is null");
        }
        if (planInfo.getEndTime() == null) {
            throw new IllegalArgumentException("planInfo.endtime is null");
        }
        String idStr = planInfo.getId();
        IDService idService = IDService.get();
        long id = idService.genLongId(RequestContext.get().getAccountId(), "T_SCH_SCHEDULE");
        idStr = String.valueOf(id);
        String host = null;
        host = planInfo.getHost() == null ? AbstractService.getHostIpAddress() : planInfo.getHost();
        Map<String, Object> scheduleObj = this.getScheduleObj();
        scheduleObj.put("fid", idStr);
        scheduleObj.put("FNumber", planInfo.getNumber());
        scheduleObj.put("fname", planInfo.getName());
        scheduleObj.put("flname", planInfo.getlName());
        scheduleObj.put("FJOBID", planInfo.getJobId());
        scheduleObj.put("FSTARTTIME", planInfo.getStartTime());
        scheduleObj.put("FENDTIME", planInfo.getEndTime());
        String status = planInfo.isEnable() ? "1" : "0";
        scheduleObj.put("FSTATUS", status);
        scheduleObj.put("FHost", host);
        scheduleObj.put("FTIMEZONEID", planInfo.getTimeZoneId());
        CronStruct cronStruct = new CronStruct();
        cronStruct.setSeconds("0");
        cronStruct.setMinutes(String.valueOf(planInfo.getStartTime().get(12)));
        cronStruct.setHours(String.valueOf(planInfo.getStartTime().get(11)));
        cronStruct.setDayOfMonth(String.valueOf(planInfo.getStartTime().get(5)));
        cronStruct.setMonth(String.valueOf(planInfo.getStartTime().get(2) + 1));
        cronStruct.setDayOfWeek("?");
        cronStruct.setYear(String.valueOf(planInfo.getStartTime().get(1)));
        cronStruct.getDescBuf().append(ResManager.loadKDString((String)"\u4e8b\u4ef6\u5c06", (String)"ScheduleCreator_25", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        int period = planInfo.getPeriod();
        scheduleObj.put("fcyclenum", period);
        if (planInfo.getRepeatMode() == RepeatModeEnum.NONE) {
            if (StringUtils.isNotBlank((CharSequence)planInfo.getCronExpression())) {
                scheduleObj.put(FREPEAT_MODE, "def");
                cronStruct.getDescBuf().setLength(0);
                cronStruct.getDescBuf().append(ResManager.loadKDString((String)"\u4e8b\u4ef6\u81ea\u5b9a\u4e49", (String)"ScheduleCreator_42", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
            } else {
                scheduleObj.put(FREPEAT_MODE, "n");
                cronStruct.getDescBuf().setLength(0);
                cronStruct.getDescBuf().append(ResManager.loadKDString((String)"\u4e8b\u4ef6\u4e0d\u91cd\u590d", (String)"ScheduleCreator_26", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
            }
        } else if (planInfo.getRepeatMode() == RepeatModeEnum.ByMinutes) {
            scheduleObj.put(FREPEAT_MODE, "mi");
            cronStruct.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)SCHEDULE_CREATOR_27, (String)BOS_SCHEDULE_CORE, (Object[])new Object[0])).append(period).append(ResManager.loadKDString((String)"\u5206\u949f\u91cd\u590d", (String)"ScheduleCreator_28", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
            if (period > 1) {
                cronStruct.setMinutes("0/" + period);
            } else {
                cronStruct.setMinutes("*");
            }
            cronStruct.setHours("*");
            cronStruct.setDayOfMonth("*");
            cronStruct.setMonth("*");
            cronStruct.setDayOfWeek("?");
            cronStruct.setYear(null);
        } else if (planInfo.getRepeatMode() == RepeatModeEnum.ByHours) {
            scheduleObj.put(FREPEAT_MODE, "h");
            cronStruct.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)SCHEDULE_CREATOR_27, (String)BOS_SCHEDULE_CORE, (Object[])new Object[0])).append(period).append(ResManager.loadKDString((String)"\u5c0f\u65f6\u91cd\u590d", (String)"ScheduleCreator_29", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
            if (period > 1) {
                cronStruct.setHours("0/" + period);
            } else {
                cronStruct.setHours("*");
            }
            cronStruct.setDayOfMonth("*");
            cronStruct.setMonth("*");
            cronStruct.setDayOfWeek("?");
            cronStruct.setYear(null);
        } else if (planInfo.getRepeatMode() == RepeatModeEnum.ByDays) {
            scheduleObj.put(FREPEAT_MODE, "d");
            cronStruct.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)SCHEDULE_CREATOR_27, (String)BOS_SCHEDULE_CORE, (Object[])new Object[0])).append(period).append(ResManager.loadKDString((String)"\u5929\u91cd\u590d", (String)"ScheduleCreator_30", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
            if (planInfo.getPeriod() > 1) {
                cronStruct.setDayOfMonth("1/" + planInfo.getPeriod());
            } else {
                cronStruct.setDayOfMonth("*");
            }
            cronStruct.setMonth("*");
            cronStruct.setDayOfWeek("?");
            cronStruct.setYear(null);
        } else if (planInfo.getRepeatMode() == RepeatModeEnum.ByWeeks) {
            scheduleObj.put(FREPEAT_MODE, "w");
            cronStruct.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf\u5468", (String)"ScheduleCreator_31", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
            cronStruct.setDayOfMonth("*");
            cronStruct.setMonth("*");
            cronStruct.setYear(null);
            if (this.isNoExp(planInfo.getWeekdaysExp())) {
                ErrorCode ec = new ErrorCode(SCH_001, ResManager.loadKDString((String)"\u6309\u5468\u91cd\u590d\uff0c\u4e0d\u652f\u6301\u7b2c\u51e0\u5468\u6a21\u5f0f\uff0c\u8bf7\u4f7f\u7528\u5468\u51e0\u6a21\u5f0f", (String)"ScheduleCreator_32", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
                throw new KDException(ec, new Object[0]);
            }
            cronStruct = this.repeatByWeek(cronStruct, scheduleObj, planInfo);
            cronStruct.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d", (String)SCHEDULE_CREATOR_33, (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        } else if (planInfo.getRepeatMode() == RepeatModeEnum.ByMonths) {
            scheduleObj.put(FREPEAT_MODE, "m");
            cronStruct.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)SCHEDULE_CREATOR_27, (String)BOS_SCHEDULE_CORE, (Object[])new Object[0])).append(period).append(ResManager.loadKDString((String)"\u6708", (String)"ScheduleCreator_34", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
            if (period > 1) {
                String month = String.valueOf(planInfo.getStartTime().get(2) + 1);
                cronStruct.setMonth(month + "/" + period);
            } else {
                cronStruct.setMonth("*");
            }
            cronStruct.setYear(null);
            if (planInfo.getWeekdaysExp() != null && planInfo.getDaysExp() != null) {
                ErrorCode ec = new ErrorCode(SCH_001, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u540c\u65f6\u8bbe\u7f6e\u5929\u548c\u5468\u6a21\u5f0f,\u8bf7\u4f7f\u7528\u4e00\u79cd\u6a21\u5f0f", (String)"ScheduleCreator_35", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
                throw new KDException(ec, new Object[0]);
            }
            cronStruct = planInfo.getWeekdaysExp() != null ? this.repeatByNoWeek(cronStruct, scheduleObj, planInfo.getWeekdaysExp()) : this.repeatByDayOfMonth(cronStruct, scheduleObj, planInfo);
            cronStruct.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d", (String)SCHEDULE_CREATOR_33, (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        } else if (planInfo.getRepeatMode() == RepeatModeEnum.ByYears) {
            scheduleObj.put(FREPEAT_MODE, "y");
            cronStruct.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf\u5e74", (String)"ScheduleCreator_36", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
            cronStruct.setYear(null);
            if (planInfo.getWeekdaysExp() != null && planInfo.getDaysExp() != null) {
                ErrorCode ec = new ErrorCode(SCH_001, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u540c\u65f6\u8bbe\u7f6e\u5929\u548c\u5468\u6a21\u5f0f,\u8bf7\u4f7f\u7528\u4e00\u79cd\u6a21\u5f0f", (String)"ScheduleCreator_35", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
                throw new KDException(ec, new Object[0]);
            }
            cronStruct = this.repeatByYear(cronStruct, scheduleObj, planInfo);
            cronStruct.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d", (String)SCHEDULE_CREATOR_33, (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        }
        try {
            String cronStr = StringUtils.isNotBlank((CharSequence)planInfo.getCronExpression()) ? planInfo.getCronExpression() : cronStruct.toString();
            parser.parse(cronStr);
            scheduleObj.put("fdesc", cronStruct.getDescBuf().toString());
            scheduleObj.put("fplan", cronStr);
        }
        catch (Exception e) {
            ErrorCode ec = new ErrorCode("SCH_004", ResManager.loadKDString((String)"\u8ba1\u5212\u65f6\u95f4\u8bbe\u7f6e\u9519\u8bef", (String)"ScheduleCreator_37", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        return scheduleObj;
    }

    private boolean isNoExp(String exp) {
        return exp != null && (exp.contains("#") || exp.endsWith("L"));
    }

    private CronStruct repeatByWeek(CronStruct cron, Map<String, Object> schduleObj, PlanInfo planInfo) {
        String weekDaysExp = planInfo.getWeekdaysExp();
        if (this.isNoExp(weekDaysExp)) {
            cron = this.repeatByNoWeek(cron, schduleObj, weekDaysExp);
        } else {
            cron.getDescBuf().append(ResManager.loadKDString((String)"\u7684", (String)SCHEDULE_CREATOR_38, (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
            if (weekDaysExp == null || weekDaysExp.trim().length() == 0) {
                weekDaysExp = String.valueOf(planInfo.getStartTime().get(7));
            }
            List<String> months = Arrays.asList(weekDaysExp.split(","));
            for (Map.Entry<String, String> week : weekMap.entrySet()) {
                String weekKey = week.getKey();
                if (months.contains(weekKey)) {
                    cron.getDescBuf().append(weekNameMap.get(weekKey)).append(",");
                    schduleObj.put(weekMap.get(weekKey), true);
                    continue;
                }
                schduleObj.put(weekMap.get(weekKey), false);
            }
            cron.getDescBuf().setLength(cron.getDescBuf().length() - 1);
            cron.setDayOfMonth("?");
            cron.setDayOfWeek(weekDaysExp);
        }
        return cron;
    }

    private CronStruct repeatByDayOfMonth(CronStruct cron, Map<String, Object> schduleObj, PlanInfo planInfo) {
        String daysExp = planInfo.getDaysExp();
        if (daysExp.endsWith("L")) {
            schduleObj.put(FBYDAYORWEEK, "w");
            schduleObj.put("fbyweek", true);
            schduleObj.put("fno", "L");
            schduleObj.put("fnoweek", 8);
            cron.getDescBuf().append(noNameMap.get("L")).append(ResManager.loadKDString((String)"\u81ea\u7136\u65e5", (String)"ScheduleCreator_39", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
            cron.setDayOfMonth(daysExp);
        } else {
            schduleObj.put(FBYDAYORWEEK, "d");
            cron.getDescBuf().append(ResManager.loadKDString((String)"\u7684", (String)SCHEDULE_CREATOR_38, (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
            if (daysExp == null || daysExp.length() == 0) {
                daysExp = String.valueOf(planInfo.getStartTime().get(5));
            }
            List<String> daysList = Arrays.asList(daysExp.split(","));
            for (Map.Entry<String, String> dayOfMonth : dayOfMonthMap.entrySet()) {
                String day = dayOfMonth.getKey();
                if (daysList.contains(day)) {
                    cron.getDescBuf().append(day).append(ResManager.loadKDString((String)"\u65e5", (String)"ScheduleCreator_40", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0])).append(",");
                    schduleObj.put(dayOfMonthMap.get(day), true);
                    continue;
                }
                schduleObj.put(dayOfMonthMap.get(day), false);
            }
            cron.getDescBuf().setLength(cron.getDescBuf().length() - 1);
            cron.setDayOfMonth(daysExp);
        }
        return cron;
    }

    private CronStruct repeatByYear(CronStruct cron, Map<String, Object> schduleObj, PlanInfo planInfo) {
        String monthsExp = planInfo.getMonthsExp();
        cron.getDescBuf().append(ResManager.loadKDString((String)"\u7684", (String)SCHEDULE_CREATOR_38, (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        if (monthsExp == null || monthsExp.trim().length() == 0) {
            monthsExp = String.valueOf(planInfo.getStartTime().get(2) + 1);
        }
        List<String> months = Arrays.asList(monthsExp.split(","));
        for (Map.Entry<String, String> month : monthsMap.entrySet()) {
            String monthKey = month.getKey();
            if (months.contains(monthKey)) {
                cron.getDescBuf().append(monthsNameMap.get(monthKey)).append(",");
                schduleObj.put(monthsMap.get(monthKey), true);
                continue;
            }
            schduleObj.put(monthsMap.get(monthKey), false);
        }
        cron.getDescBuf().setLength(cron.getDescBuf().length() - 1);
        cron.setMonth(monthsExp);
        if (this.isNoExp(planInfo.getWeekdaysExp())) {
            cron = this.repeatByNoWeek(cron, schduleObj, planInfo.getWeekdaysExp());
        }
        if (planInfo.getDaysExp() != null) {
            cron = this.repeatByDayOfMonth(cron, schduleObj, planInfo);
        }
        return cron;
    }

    private CronStruct repeatByNoWeek(CronStruct cron, Map<String, Object> schduleObj, String exp) {
        ErrorCode ec;
        String no = "";
        String noWeek = null;
        schduleObj.put(FBYDAYORWEEK, "w");
        schduleObj.put("fbyweek", true);
        if (exp.contains("#")) {
            String[] expArray = exp.split("#");
            noWeek = expArray[0];
            no = expArray[1];
        } else if (exp.endsWith("L")) {
            no = "L";
            noWeek = exp.substring(0, exp.length() - 1);
        }
        if (StringUtils.equals(noWeek, (CharSequence)"9")) {
            ec = new ErrorCode("SCH_005", ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8bbe\u7f6e\u5de5\u4f5c\u65e5\u3002", (String)"ScheduleCreator_43", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        if (StringUtils.equals((CharSequence)no, (CharSequence)"L") && StringUtils.equals((CharSequence)noWeek, (CharSequence)"8")) {
            ec = new ErrorCode("SCH_006", ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8bbe\u7f6e\u6700\u540e\u4e00\u4e2a\u81ea\u7136\u65e5\u3002", (String)"ScheduleCreator_44", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        cron.setDayOfWeek(exp);
        schduleObj.put("fno", no);
        schduleObj.put("fnoweek", noWeek);
        cron.getDescBuf().append(noNameMap.get(no));
        cron.getDescBuf().append(weekNameMap.get(noWeek));
        if (no.compareTo("1") >= 0 && no.compareTo("5") <= 0) {
            cron.setDayOfWeek(noWeek + "#" + no);
        } else if (no.compareTo("L") == 0) {
            cron.setDayOfWeek(noWeek + "L");
        }
        cron.setDayOfMonth("?");
        return cron;
    }

    static {
        weekMap.put("1", "fsun");
        weekMap.put("2", "fmon");
        weekMap.put("3", "ftues");
        weekMap.put("4", "fwed");
        weekMap.put("5", "fthur");
        weekMap.put("6", "ffri");
        weekMap.put("7", "fsat");
        weekNameMap.put("1", ResManager.loadKDString((String)"\u661f\u671f\u65e5", (String)"ScheduleCreator_0", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        weekNameMap.put("2", ResManager.loadKDString((String)"\u661f\u671f\u4e00", (String)"ScheduleCreator_1", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        weekNameMap.put("3", ResManager.loadKDString((String)"\u661f\u671f\u4e8c", (String)"ScheduleCreator_2", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        weekNameMap.put("4", ResManager.loadKDString((String)"\u661f\u671f\u4e09", (String)"ScheduleCreator_3", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        weekNameMap.put("5", ResManager.loadKDString((String)"\u661f\u671f\u56db", (String)"ScheduleCreator_4", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        weekNameMap.put("6", ResManager.loadKDString((String)"\u661f\u671f\u4e94", (String)"ScheduleCreator_5", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        weekNameMap.put("7", ResManager.loadKDString((String)"\u661f\u671f\u516d", (String)"ScheduleCreator_6", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        dayOfMonthMap.put("1", "fone");
        dayOfMonthMap.put("2", "ftwo");
        dayOfMonthMap.put("3", "fthree");
        dayOfMonthMap.put("4", "ffour");
        dayOfMonthMap.put("5", "ffive");
        dayOfMonthMap.put("6", "fsix");
        dayOfMonthMap.put("7", "fseven");
        dayOfMonthMap.put("8", "feight");
        dayOfMonthMap.put("9", "fnine");
        dayOfMonthMap.put("10", "ften");
        dayOfMonthMap.put("11", "feleven");
        dayOfMonthMap.put("12", "ftwelve");
        dayOfMonthMap.put("13", "fthirteen");
        dayOfMonthMap.put("14", "ffourteen");
        dayOfMonthMap.put("15", "ffifteen");
        dayOfMonthMap.put("16", "fsixteen");
        dayOfMonthMap.put("17", "fseventeen");
        dayOfMonthMap.put("18", "feighteen");
        dayOfMonthMap.put("19", "fnineteen");
        dayOfMonthMap.put("20", "ftwenty");
        dayOfMonthMap.put("21", "ftwentyone");
        dayOfMonthMap.put("22", "ftwentytwo");
        dayOfMonthMap.put("23", "ftwentythree");
        dayOfMonthMap.put("24", "ftwentyfour");
        dayOfMonthMap.put("25", "ftwentyfive");
        dayOfMonthMap.put("26", "ftwentysix");
        dayOfMonthMap.put("27", "ftwentyseven");
        dayOfMonthMap.put("28", "ftwentyeight");
        dayOfMonthMap.put("29", "ftwentynine");
        dayOfMonthMap.put("30", "fthirty");
        dayOfMonthMap.put("31", "fthirtyone");
        monthsMap.put("1", "fjan");
        monthsMap.put("2", "ffeb");
        monthsMap.put("3", "fmar");
        monthsMap.put("4", "fapr");
        monthsMap.put("5", "fmay");
        monthsMap.put("6", "fjun");
        monthsMap.put("7", "fjul");
        monthsMap.put("8", "faug");
        monthsMap.put("9", "fsep");
        monthsMap.put("10", "foct");
        monthsMap.put("11", "fnov");
        monthsMap.put("12", "fdec");
        monthsNameMap.put("1", ResManager.loadKDString((String)"\u4e00\u6708", (String)"ScheduleCreator_7", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        monthsNameMap.put("2", ResManager.loadKDString((String)"\u4e8c\u6708", (String)"ScheduleCreator_8", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        monthsNameMap.put("3", ResManager.loadKDString((String)"\u4e09\u6708", (String)"ScheduleCreator_9", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        monthsNameMap.put("4", ResManager.loadKDString((String)"\u56db\u6708", (String)"ScheduleCreator_10", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        monthsNameMap.put("5", ResManager.loadKDString((String)"\u4e94\u6708", (String)"ScheduleCreator_11", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        monthsNameMap.put("6", ResManager.loadKDString((String)"\u516d\u6708", (String)"ScheduleCreator_12", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        monthsNameMap.put("7", ResManager.loadKDString((String)"\u4e03\u6708", (String)"ScheduleCreator_13", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        monthsNameMap.put("8", ResManager.loadKDString((String)"\u516b\u6708", (String)"ScheduleCreator_14", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        monthsNameMap.put("9", ResManager.loadKDString((String)"\u4e5d\u6708", (String)"ScheduleCreator_15", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        monthsNameMap.put("10", ResManager.loadKDString((String)"\u5341\u6708", (String)"ScheduleCreator_16", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        monthsNameMap.put("11", ResManager.loadKDString((String)"\u5341\u4e00\u6708", (String)"ScheduleCreator_17", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        monthsNameMap.put("12", ResManager.loadKDString((String)"\u5341\u4e8c\u6708", (String)"ScheduleCreator_18", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        noNameMap.put("1", ResManager.loadKDString((String)"\u7b2c\u4e00\u4e2a", (String)"ScheduleCreator_19", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        noNameMap.put("2", ResManager.loadKDString((String)"\u7b2c\u4e8c\u4e2a", (String)"ScheduleCreator_20", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        noNameMap.put("3", ResManager.loadKDString((String)"\u7b2c\u4e09\u4e2a", (String)"ScheduleCreator_21", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        noNameMap.put("4", ResManager.loadKDString((String)"\u7b2c\u56db\u4e2a", (String)"ScheduleCreator_22", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        noNameMap.put("5", ResManager.loadKDString((String)"\u7b2c\u4e94\u4e2a", (String)"ScheduleCreator_23", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
        noNameMap.put("L", ResManager.loadKDString((String)"\u6700\u540e\u4e00\u4e2a", (String)"ScheduleCreator_24", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]));
    }
}

