/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.zk;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.message.AbstractService;
import kd.bos.schedule.server.ExecutorResourceManager;
import kd.bos.schedule.server.SchElectorWrapper;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.schedule.server.ScheduleServiceWrapper;
import kd.bos.schedule.server.zk.SchZKElectorWrapper;
import kd.bos.schedule.zk.ZkConfig;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.recipes.leader.CancelLeadershipException;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListenerAdapter;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.retry.RetryForever;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;

public class ZkScheduleServiceWrapper
implements ScheduleServiceWrapper {
    private static Log log = LogFactory.getLog(ZkScheduleServiceWrapper.class);
    private final ScheduleService scheduleService;
    LeaderSelector selector = null;
    CuratorFramework client = null;

    public ZkScheduleServiceWrapper(ScheduleService scheduleService) {
        this.scheduleService = scheduleService;
    }

    private CuratorFramework createNewZkClient(String urlConfig) {
        int propIndex = urlConfig.indexOf(63);
        String url = urlConfig;
        String user = null;
        String pass = null;
        String scheme = "digest";
        if (propIndex > 0) {
            String[] sl = urlConfig.split("\\?");
            url = sl[0];
            int urlIndex = url.indexOf(47);
            if (urlIndex > 0) {
                url = url.substring(0, urlIndex);
            }
            String strUrlParams = sl[1];
            String[] params = null;
            HashMap<String, String> config = new HashMap<String, String>(10);
            params = strUrlParams.contains("&") ? strUrlParams.split("&") : new String[]{strUrlParams};
            for (String p : params) {
                if (!p.contains("=")) continue;
                String[] param = p.split("=");
                if (param.length == 1) {
                    config.put(param[0], "");
                    continue;
                }
                String key = param[0];
                String value = param[1];
                config.put(key, value);
            }
            pass = (String)config.get("password");
            if (pass != null) {
                pass = Encrypters.decode((String)pass);
            }
            user = (String)config.get("user");
            if (config.get("scheme") != null) {
                scheme = (String)config.get("scheme");
            }
        }
        try {
            CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(url).sessionTimeoutMs(Integer.getInteger("curator-default-session-timeout", 60000).intValue()).connectionTimeoutMs(Integer.getInteger("curator-default-connection-timeout", 15000).intValue()).retryPolicy((RetryPolicy)new RetryForever(Integer.getInteger("zookeeper.client.retry.intervalMs", 1000).intValue()));
            if (user != null && pass != null) {
                final String auth = user + ":" + pass;
                ACLProvider aclProvider = new ACLProvider(){
                    private List<ACL> acl;

                    public List<ACL> getDefaultAcl() {
                        if (this.acl == null) {
                            ArrayList acl = ZooDefs.Ids.CREATOR_ALL_ACL;
                            acl.clear();
                            acl.add(new ACL(31, new Id("auth", auth)));
                            this.acl = acl;
                        }
                        return this.acl;
                    }

                    public List<ACL> getAclForPath(String path) {
                        return this.acl;
                    }
                };
                builder.authorization(scheme, auth.getBytes(StandardCharsets.UTF_8));
                builder.aclProvider(aclProvider);
            }
            CuratorFramework newClient = builder.build();
            newClient.start();
            return newClient;
        }
        catch (Exception e) {
            log.error("Schedule***createNewZkClient error", (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.configZookeepConfig, new Object[]{e.getMessage()});
        }
    }

    @Override
    public SchElectorWrapper initElector() {
        LeaderSelectorListenerAdapter listener = new LeaderSelectorListenerAdapter(){

            public void stateChanged(CuratorFramework client, ConnectionState newState) {
                if (client.getConnectionStateErrorPolicy().isErrorState(newState)) {
                    if (ZkConfig.getRunMode() == AbstractService.RunMode.Dev && (ConnectionState.SUSPENDED.equals((Object)newState) || ConnectionState.LOST.equals((Object)newState))) {
                        return;
                    }
                    ZkScheduleServiceWrapper.this.scheduleService.stateChanged();
                    throw new CancelLeadershipException();
                }
            }

            public void takeLeadership(CuratorFramework paramCuratorFramework) throws Exception {
                ZkScheduleServiceWrapper.this.scheduleService.takeLeadership();
                ZkScheduleServiceWrapper.this.scheduleService.keepHeartbeat();
            }
        };
        this.client = Boolean.getBoolean("Schedule.zk.client.alone") ? this.createNewZkClient(System.getProperty("Schedule.zk.server")) : this.scheduleService.getZkStore().getCuratorFramework();
        this.selector = new LeaderSelector(this.client, ZkConfig.getMasterServerPath(), (LeaderSelectorListener)listener);
        return new SchZKElectorWrapper(this.selector);
    }

    @Override
    public String getName() {
        return "ZK Schedule Service";
    }

    @Override
    public boolean keepAlive() throws Exception {
        return true;
    }

    @Override
    public ExecutorResourceManager initExecutorResourceMrg() {
        return new ExecutorResourceManager();
    }
}

