/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.form;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBackWraper;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.schedule.form.TaskProgressFormEdit;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BackgroundTaskSubscriber
implements Runnable {
    private Log log = LogFactory.getLog(BackgroundTaskSubscriber.class);
    private static final int DEFCIRCLEINTEVAL = 2;
    private RequestContext rc;
    private JobFormInfo jobFormInfo;
    private String taskId;
    private TaskInfo lastTaskInfo;
    private Date lastTime;

    public JobFormInfo getJobFormInfo() {
        return this.jobFormInfo;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public int getCircleInteval() {
        String circleInteval = System.getProperty("backgroundtask.querytask.inteval");
        if (StringUtils.isBlank((Object)circleInteval)) {
            return 2;
        }
        int inteval = Integer.parseInt(circleInteval.toString());
        if (inteval > 10 || inteval < 1) {
            return 2;
        }
        return inteval;
    }

    public BackgroundTaskSubscriber(RequestContext rc, JobFormInfo jobFormInfo, String taskId) {
        this.rc = rc;
        this.jobFormInfo = jobFormInfo;
        this.taskId = taskId;
    }

    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.rc);
        try {
            this.execute();
        }
        catch (Throwable exp) {
            this.log.error(exp);
            TaskInfo taskInfo = new TaskInfo();
            taskInfo.setId(this.getTaskId());
            taskInfo.setStatus("FAILED");
            taskInfo.setDesc(String.format(ResManager.loadKDString((String)"\u51fa\u9519\uff1a%s", (String)"BackgroundTaskSubscriber_1", (String)"bos-schedule-form", (Object[])new Object[0]), StringUtils.isBlank((CharSequence)exp.getMessage()) ? exp.getClass().getSimpleName() : exp.getMessage()));
            TaskClientProxy.feedbackProgress(this.getJobFormInfo(), taskInfo, null);
        }
    }

    public void execute() {
        block4: {
            TaskInfo taskInfo;
            long timeout_MS = 1000L * (long)this.getJobFormInfo().getTimeout();
            long circleInteval_MS = this.getCircleInteval() * 1000;
            long beginat_MS = System.currentTimeMillis();
            while (true) {
                this.sleep(circleInteval_MS, beginat_MS);
                beginat_MS = System.currentTimeMillis();
                taskInfo = ScheduleServiceHelper.queryTask((String)this.getTaskId());
                if (taskInfo == null) {
                    taskInfo = new TaskInfo();
                    taskInfo.setId(this.getTaskId());
                    taskInfo.setStatus("FAILED");
                    taskInfo.setDesc(ResManager.loadKDString((String)"\u5f02\u5e38\uff1a\u672a\u53d6\u5230\u4efb\u52a1\u72b6\u6001", (String)"BackgroundTaskSubscriber_2", (String)"bos-schedule-form", (Object[])new Object[0]));
                }
                if (taskInfo.isTaskEnd()) {
                    List<Map<String, Object>> formActions = this.closeCallBack(taskInfo);
                    TaskClientProxy.feedbackProgress(this.getJobFormInfo(), taskInfo, formActions);
                    break block4;
                }
                if (this.compareTaskInfo(taskInfo)) {
                    TaskClientProxy.feedbackProgress(this.getJobFormInfo(), taskInfo, null);
                    continue;
                }
                long offset_MS = System.currentTimeMillis() - this.lastTime.getTime();
                if (offset_MS > timeout_MS) break;
            }
            taskInfo = new TaskInfo();
            taskInfo.setId(this.getTaskId());
            taskInfo.setStatus("FAILED");
            taskInfo.setDesc(ResManager.loadKDString((String)"\u4efb\u52a1\u8fdb\u5ea6\u957f\u65f6\u95f4\u6ca1\u6709\u8fdb\u5c55\uff0c\u8bf7\u524d\u5f80\u8c03\u5ea6\u8fd0\u884c\u65e5\u5fd7\u67e5\u770b\u3002", (String)"BackgroundTaskSubscriber_3", (String)"bos-schedule-form", (Object[])new Object[0]));
            TaskClientProxy.feedbackProgress(this.getJobFormInfo(), taskInfo, null);
        }
    }

    private List<Map<String, Object>> closeCallBack(TaskInfo taskInfo) {
        IFormView progressView;
        if (!TaskClientProxy.isExistTask(this.getTaskId())) {
            return null;
        }
        String progressPageId = TaskClientProxy.getProgressPageId(this.getTaskId());
        if (StringUtils.isNotBlank((CharSequence)progressPageId) && (progressView = SessionManager.getCurrent().getViewNoPlugin(progressPageId)) != null) {
            return null;
        }
        if (this.getJobFormInfo().getCloseCallBack() == null) {
            return null;
        }
        Map<String, String> returnData = TaskProgressFormEdit.packageReturnResult(taskInfo);
        if (returnData == null) {
            return null;
        }
        FormShowParameter parentViewParameter = SessionManager.getCurrent().getFormShowParameter(this.getJobFormInfo().getParentPageId());
        if (parentViewParameter == null) {
            return null;
        }
        CloseCallBackWraper closeCallBackWraper = new CloseCallBackWraper(this.getJobFormInfo().getParentPageId(), this.getJobFormInfo().getCloseCallBack(), null, false);
        closeCallBackWraper.setReturnData(returnData);
        List acts = (List)DispatchServiceHelper.invokeBOSService((String)parentViewParameter.getServiceAppId(), (String)"FormService", (String)"closeCallBack", (Object[])new Object[]{closeCallBackWraper});
        if (acts == null) {
            return null;
        }
        HashMap<String, Object> arg = new HashMap<String, Object>();
        arg.put("pageId", this.getJobFormInfo().getParentPageId());
        arg.put("actions", acts);
        ArrayList<HashMap<String, Object>> paras = new ArrayList<HashMap<String, Object>>();
        paras.add(arg);
        HashMap<String, Object> sendParentViewAction = new HashMap<String, Object>();
        sendParentViewAction.put("a", "sendDynamicFormAction");
        sendParentViewAction.put("p", paras);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        list.add(sendParentViewAction);
        return list;
    }

    private boolean compareTaskInfo(TaskInfo taskInfo) {
        boolean equals;
        if (null == taskInfo && null == this.lastTaskInfo) {
            return false;
        }
        if (null == this.lastTaskInfo) {
            this.lastTaskInfo = taskInfo;
            this.lastTime = new Date();
            return true;
        }
        if (null == taskInfo) {
            this.lastTaskInfo = null;
            this.lastTime = new Date();
            return true;
        }
        boolean bl = equals = StringUtils.equals((CharSequence)taskInfo.getStatus(), (CharSequence)this.lastTaskInfo.getStatus()) && StringUtils.equals((CharSequence)taskInfo.getDesc(), (CharSequence)this.lastTaskInfo.getDesc()) && StringUtils.equals((CharSequence)taskInfo.getData(), (CharSequence)this.lastTaskInfo.getData()) && taskInfo.getProgress() == this.lastTaskInfo.getProgress();
        if (!equals) {
            this.lastTaskInfo = taskInfo;
            this.lastTime = new Date();
        }
        return !equals;
    }

    private void sleep(long circleInteval_MS, long beginat_MS) {
        long sleeptime = circleInteval_MS - (System.currentTimeMillis() - beginat_MS);
        if (sleeptime > 0L) {
            try {
                Thread.sleep(sleeptime);
            }
            catch (InterruptedException e) {
                this.log.error((Throwable)e);
            }
        }
    }
}

