/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.form;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.JobFromStatus;
import kd.bos.schedule.form.TaskClientCache;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class JobFormDao {
    private static final Log log = LogFactory.getLog(JobFormDao.class);

    public static void save(JobFormInfo jobFormInfo, TaskInfo taskInfo) {
        long id = DB.genLongId((String)"T_SCH_JOBFORM");
        String taskId = taskInfo.getId();
        long userId = jobFormInfo.getJobInfo().getRunByUserId();
        String data = SerializationUtils.toJsonString((Object)jobFormInfo);
        String sql = "INSERT INTO T_SCH_JOBFORM (FID,FCREATORID,FCREATETIME,FTASKID,FSTATUS,FDATA) VALUES (?,?,?,?,?,?)";
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)id), new SqlParameter(":FCREATORID", -5, (Object)userId), new SqlParameter(":FCREATETIME", 93, (Object)new Timestamp(System.currentTimeMillis())), new SqlParameter(":FTASKID", 12, (Object)taskId), new SqlParameter(":FSTATUS", 12, (Object)JobFromStatus.Create.getValue()), new SqlParameter(":FDATA", 12, (Object)data)};
        try (TXHandle handle = TX.requiresNew();){
            try {
                DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                handle.markRollback();
                throw new KDException(BosErrorCode.sQL, new Object[]{e});
            }
        }
    }

    public static boolean confirm(String taskId) {
        return JobFormDao.updateStatus(taskId, JobFromStatus.Confirm.getValue());
    }

    private static boolean updateStatus(String taskId, String status) {
        String sql = "UPDATE T_SCH_JOBFORM SET FSTATUS = ? , FMODIFYTIME = ? WHERE FTASKID = ? and FSTATUS <> ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":FSTATUS", 12, (Object)status), new SqlParameter(":FMODIFYTIME", 93, (Object)new Timestamp(System.currentTimeMillis())), new SqlParameter(":FTASKID", 12, (Object)taskId), new SqlParameter(":FSTATUS", 12, (Object)status)};
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            boolean bl = DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            return bl;
        }
        catch (Exception e) {
            try {
                log.error((Throwable)e);
                handle.markRollback();
                throw new KDException(BosErrorCode.sQL, new Object[]{e});
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static List<Map<String, Object>> getUnConfirmTasks() {
        List<Tuple<TaskInfo, JobFormInfo>> truples = JobFormDao.getUnConfirmTaskInfos();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(truples.size());
        String globalSessionId = RequestContext.get().getGlobalSessionId();
        for (Tuple<TaskInfo, JobFormInfo> truple : truples) {
            JobInfo jobInfo;
            TaskInfo taskInfo = (TaskInfo)truple.item1;
            JobFormInfo jobFormInfo = (JobFormInfo)truple.item2;
            HashMap<String, Object> paraMap = new HashMap<String, Object>();
            JobFormInfo jobFormInfoFormCache = TaskClientCache.getJobInfo(taskInfo.getId());
            if (jobFormInfoFormCache != null) {
                jobFormInfo = jobFormInfoFormCache;
            }
            if ((jobInfo = jobFormInfo.getJobInfo()) == null) continue;
            Set<String> sessinids = jobFormInfo.getSessionIds();
            if (sessinids.add(globalSessionId)) {
                TaskClientCache.putJobInfo(taskInfo.getId(), jobFormInfo);
            }
            paraMap.put("appid", jobInfo.getAppId());
            paraMap.put("taskid", taskInfo.getId());
            paraMap.put("title", jobInfo.getlName() == null ? "" : jobInfo.getlName().toString());
            paraMap.put("status", taskInfo.getStatus());
            paraMap.put("progress", taskInfo.getProgress());
            paraMap.put("desc", taskInfo.getDesc());
            if (StringUtils.isNotBlank((CharSequence)jobFormInfo.getTaskIcon())) {
                paraMap.put("icon", jobFormInfo.getTaskIcon());
            }
            result.add(paraMap);
        }
        return result;
    }

    static List<Tuple<TaskInfo, JobFormInfo>> getUnConfirmTaskInfos() {
        RequestContext rc = RequestContext.get();
        long userId = rc.getCurrUserId();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -3);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        calendar.set(14, 0);
        String strSQL = "SELECT A.FTASKID  FTASKID, A.FDATA FDATA FROM T_SCH_JOBFORM A WHERE A.FCREATORID = ? AND A.FSTATUS = ? and A.FCREATETIME >= ? ORDER BY A.FCREATETIME ASC";
        Object[] params = new SqlParameter[]{new SqlParameter(":FCREATORID", -5, (Object)userId), new SqlParameter(":FSTATUS", 12, (Object)JobFromStatus.Create.getValue()), new SqlParameter(":FCREATETIME", 93, (Object)calendar.getTime())};
        ArrayList taskIds = new ArrayList(6);
        Map jobFormInfos = (Map)DB.query((DBRoute)DBRoute.basedata, (String)strSQL, (Object[])params, rs -> {
            HashMap<String, JobFormInfo> result = new HashMap<String, JobFormInfo>(8);
            while (rs.next()) {
                String taskId = rs.getString("FTASKID");
                String data = rs.getString("FDATA");
                if (StringUtils.isEmpty((CharSequence)data)) continue;
                JobFormInfo jobFormInfo = (JobFormInfo)SerializationUtils.fromJsonString((String)data, JobFormInfo.class);
                result.put(taskId, jobFormInfo);
                taskIds.add(taskId);
            }
            return result;
        });
        List taskInfos = ScheduleServiceHelper.queryTask(taskIds);
        ArrayList<Tuple<TaskInfo, JobFormInfo>> truples = new ArrayList<Tuple<TaskInfo, JobFormInfo>>(taskInfos.size());
        for (TaskInfo taskInfo : taskInfos) {
            truples.add((Tuple<TaskInfo, JobFormInfo>)new Tuple((Object)taskInfo, jobFormInfos.get(taskInfo.getId())));
        }
        return truples;
    }

    static JobFormInfo getJobFormInfo(String taskid) {
        String strSQL = "SELECT TOP 1 A.FTASKID  FTASKID, A.FDATA FDATA FROM T_SCH_JOBFORM A WHERE A.FTASKID = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":FTASKID", 12, (Object)taskid)};
        JobFormInfo jobFormInfo = (JobFormInfo)DB.query((DBRoute)DBRoute.basedata, (String)strSQL, (Object[])params, rs -> {
            String data;
            JobFormInfo info = null;
            if (rs.next() && StringUtils.isNotEmpty((CharSequence)(data = rs.getString("FDATA")))) {
                info = (JobFormInfo)SerializationUtils.fromJsonString((String)data, JobFormInfo.class);
            }
            return info;
        });
        return jobFormInfo;
    }
}

