/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.form;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormDao;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClick;
import kd.bos.schedule.form.TaskClientCache;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.schedule.form.event.ClickEventArgs;
import kd.bos.schedule.form.event.ItemClickEventArgs;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TaskClickProxy {
    private static Log log = LogFactory.getLog(TaskClickProxy.class);
    private IFormView mainView;
    private String taskId;
    private JobFormInfo jobFormInfo;

    public TaskClickProxy(IFormView mainView, String taskId) {
        this.mainView = mainView;
        this.taskId = taskId;
        this.jobFormInfo = TaskClientCache.getJobInfo(taskId);
    }

    public void click(String itemKey) {
        Object args;
        String rootPageId;
        TaskClick taskClick = this.createPlugin();
        if (taskClick == null) {
            return;
        }
        if (!(this.mainView == null || this.jobFormInfo == null || this.jobFormInfo.getSessionIds().isEmpty() || StringUtils.isEmpty((CharSequence)(rootPageId = this.mainView.getPageId())) || rootPageId.equals(this.jobFormInfo.getRootPageId()))) {
            this.jobFormInfo.setRootPageId(rootPageId);
            this.jobFormInfo.setParentPageId(rootPageId);
        }
        if (StringUtils.isBlank((CharSequence)itemKey)) {
            args = new ClickEventArgs();
            taskClick.click((ClickEventArgs)args);
            if (((ClickEventArgs)args).isClearTask()) {
                TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
                if (this.mainView != null && taskInfo != null && "FAILED".equals(taskInfo.getStatus())) {
                    String errMsg = ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u51fa\u9519\uff0c\u8be6\u60c5\u8bf7\u67e5\u9605\u8c03\u5ea6\u8fd0\u884c\u65e5\u5fd7\uff0c\u4efb\u52a1ID:%s\u3002", (String)"TaskProgressFormEdit_2", (String)"bos-schedule-form", (Object[])new Object[0]);
                    this.mainView.showErrorNotification(String.format(errMsg, this.taskId));
                }
                TaskClientProxy.delTask(this.mainView, this.taskId);
            }
        } else {
            args = new ItemClickEventArgs(itemKey);
            taskClick.itemClick((ItemClickEventArgs)args);
        }
    }

    public void release() {
        TaskClick taskClick = null;
        try {
            taskClick = this.createPlugin();
        }
        catch (KDException e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                log.warn("task release error and cause is ClassNotFoundException, it can be skip. taskId : {}", (Object)this.taskId, (Object)e);
            }
            log.error("task release error. taskId : {}", (Object)this.taskId, (Object)e);
            throw e;
        }
        boolean success = true;
        if (taskClick != null) {
            success = taskClick.release();
        }
        if (success) {
            TaskClientProxy.delTask(this.mainView, this.taskId);
        }
    }

    private TaskClick createPlugin() {
        if (this.jobFormInfo == null) {
            this.jobFormInfo = JobFormDao.getJobFormInfo(this.taskId);
            if (this.jobFormInfo != null) {
                TaskClientCache.putJobInfo(this.taskId, this.jobFormInfo);
            } else {
                log.info("jobFormInfo is null");
                return null;
            }
        }
        if (StringUtils.isBlank((CharSequence)this.jobFormInfo.getClickClassName())) {
            return null;
        }
        Class<?> taskClass = null;
        try {
            taskClass = Class.forName(this.jobFormInfo.getClickClassName());
        }
        catch (ClassNotFoundException e) {
            ErrorCode ec = new ErrorCode("TASK_NAME_EMPTY", this.jobFormInfo.getClickClassName());
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
        TaskClick taskClick = null;
        try {
            taskClick = (TaskClick)taskClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            ErrorCode ec = new ErrorCode("TASK_CLASS_INIT_FAILED", this.jobFormInfo.getClickClassName());
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
        taskClick.setContext(this.mainView, this.jobFormInfo, this.taskId);
        return taskClick;
    }
}

