/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.form;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.schedule.form.JobFormInfo;

class TaskClientCache {
    private static final String CACHE_DISTRIBUTESESSION = "bos_schedule_form";
    private static final String CACHE_TYPE = "tasknotice";
    private static final String JOB_FORM_INFO = "jobforminfo";
    private static final String LAST_TIME = "lasttime";
    private static final String PROGRESS_PAGEID = "progresspageid";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("bos_schedule_form", new DistributeCacheHAPolicy(true, true));

    TaskClientCache() {
    }

    private static String buildCacheType() {
        return String.format("%s.%s.%s", CACHE_TYPE, RequestContext.get().getAccountId(), RequestContext.get().getCurrUserId());
    }

    private static String buildCacheKey(String taskId, String key) {
        return String.format("%s.%s", taskId, key);
    }

    public static void clearSessionCache() {
        String type = TaskClientCache.buildCacheType();
        cache.remove(type);
    }

    public static void removeTask(String taskId) {
        String type = TaskClientCache.buildCacheType();
        String[] keys = new String[]{TaskClientCache.buildCacheKey(taskId, JOB_FORM_INFO), TaskClientCache.buildCacheKey(taskId, LAST_TIME), TaskClientCache.buildCacheKey(taskId, PROGRESS_PAGEID)};
        cache.remove(type, keys);
    }

    public static void putJobInfo(String taskId, JobFormInfo jobFormInfo) {
        String type = TaskClientCache.buildCacheType();
        String key = TaskClientCache.buildCacheKey(taskId, JOB_FORM_INFO);
        String jobInfoStr = SerializationUtils.toJsonString((Object)jobFormInfo);
        cache.put(type, key, (Object)jobInfoStr);
    }

    public static JobFormInfo getJobInfo(String taskId) {
        String key;
        String type = TaskClientCache.buildCacheType();
        String jobInfoStr = (String)cache.get(type, key = TaskClientCache.buildCacheKey(taskId, JOB_FORM_INFO));
        if (StringUtils.isBlank((CharSequence)jobInfoStr)) {
            return null;
        }
        return (JobFormInfo)SerializationUtils.fromJsonString((String)jobInfoStr, JobFormInfo.class);
    }

    public static void putLastTime(String taskId, long lastTime) {
        String type = TaskClientCache.buildCacheType();
        String key = TaskClientCache.buildCacheKey(taskId, LAST_TIME);
        cache.put(type, key, (Object)String.valueOf(lastTime));
    }

    public static long getLastTime(String taskId) {
        String key;
        String type = TaskClientCache.buildCacheType();
        String lastTimeStr = (String)cache.get(type, key = TaskClientCache.buildCacheKey(taskId, LAST_TIME));
        if (StringUtils.isBlank((CharSequence)lastTimeStr)) {
            return 0L;
        }
        return Long.parseLong(lastTimeStr);
    }

    public static void putProgressPageId(String taskId, String pageId) {
        String type = TaskClientCache.buildCacheType();
        String key = TaskClientCache.buildCacheKey(taskId, PROGRESS_PAGEID);
        cache.put(type, key, (Object)pageId);
    }

    public static String getProgressPageId(String taskId) {
        String type = TaskClientCache.buildCacheType();
        String key = TaskClientCache.buildCacheKey(taskId, PROGRESS_PAGEID);
        String pageId = (String)cache.get(type, key);
        return pageId;
    }
}

