/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.form;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormDao;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientCache;
import kd.bos.schedule.form.TaskNoticeAction;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TaskClientProxy {
    public static boolean isExistTask(String taskId) {
        JobFormInfo jobFormInfo = TaskClientCache.getJobInfo(taskId);
        return jobFormInfo != null;
    }

    public static void addTask(JobFormInfo jobFormInfo, TaskInfo taskInfo, List<Map<String, Object>> formActions) {
        if (TaskClientProxy.isExistTask(taskInfo.getId())) {
            TaskClientProxy.feedbackProgress(jobFormInfo, taskInfo, formActions);
        } else {
            JobFormDao.save(jobFormInfo, taskInfo);
            TaskClientCache.putJobInfo(taskInfo.getId(), jobFormInfo);
            TaskNoticeAction.addTask(jobFormInfo, taskInfo, formActions);
        }
    }

    public static void addTask(IFormView view, JobFormInfo jobFormInfo, TaskInfo taskInfo) {
        if (view == null) {
            TaskClientProxy.addTask(jobFormInfo, taskInfo, null);
            return;
        }
        if (TaskClientProxy.isExistTask(taskInfo.getId())) {
            TaskClientProxy.feedbackProgress(view, jobFormInfo, taskInfo);
        } else {
            JobFormDao.save(jobFormInfo, taskInfo);
            TaskClientCache.putJobInfo(taskInfo.getId(), jobFormInfo);
            TaskNoticeAction.addTask(view, jobFormInfo, taskInfo);
        }
    }

    public static void feedbackProgress(JobFormInfo jobFormInfo, TaskInfo taskInfo, List<Map<String, Object>> formActions) {
        TaskClientCache.putLastTime(taskInfo.getId(), TimeServiceHelper.getTimeStamp());
        TaskNoticeAction.feedbackProgress(jobFormInfo, taskInfo, formActions);
    }

    public static void feedbackProgress(IFormView view, JobFormInfo jobFormInfo, TaskInfo taskInfo) {
        TaskClientCache.putLastTime(taskInfo.getId(), TimeServiceHelper.getTimeStamp());
        TaskNoticeAction.feedbackProgress(view, jobFormInfo, taskInfo);
    }

    public static void delTask(JobFormInfo jobFormInfo, String taskId, List<Map<String, Object>> formActions) {
        JobFormDao.confirm(taskId);
        TaskNoticeAction.delTask(jobFormInfo, taskId, formActions);
        TaskClientCache.removeTask(taskId);
    }

    public static void delTask(IFormView mainView, String taskId) {
        JobFormInfo jobFormInfo = TaskClientCache.getJobInfo(taskId);
        if (mainView == null || jobFormInfo != null && !jobFormInfo.getSessionIds().isEmpty()) {
            TaskClientProxy.delTask(jobFormInfo, taskId, null);
            return;
        }
        JobFormDao.confirm(taskId);
        TaskNoticeAction.delTask(mainView, taskId);
        TaskClientCache.removeTask(taskId);
    }

    public static String getProgressPageId(String taskId) {
        return TaskClientCache.getProgressPageId(taskId);
    }

    public static void setProgressPageId(String taskId, String pageId) {
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            TaskClientCache.putProgressPageId(taskId, pageId);
        }
    }

    public static void sessionEnd() {
        TaskClientCache.clearSessionCache();
    }

    public static void suspend(JobFormInfo jobFormInfo, String taskId) {
        JobFormDao.confirm(taskId);
    }

    public static void confirm(String taskId) {
        JobFormDao.confirm(taskId);
    }
}

