/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.form;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;

public class TaskProgressFormEdit
extends AbstractFormPlugin
implements ProgresssListener {
    public static final String FORMID_TASKPROGRESS = "sch_taskprogress";
    public static final String CUSTPARAM_CLIENTJOBINFO = "sch_clientjobinfo";
    public static final String CUSTPARAM_TASKID = "sch_taskid";
    private static final String CACHEKEY_ISSTART = "isstart";
    private static final String CACHEKEY_ISFINISHED = "isfinished";
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String KEY_LBLPROGRESS = "lblprogress";
    private static final String KEY_STOP = "btnstop";
    private static final String KEY_MIN = "btnmin";
    private static final String CONFIRMACTIONID_STOP = "continue_stop";
    private static final String CONFIRMACTIONID_BACKGROUND = "continue_background";
    private static final String TASKCOMPLETE = "TASKCOMPLETE";
    private static final String SHOWEXP = "showexp";
    private boolean canClose = false;
    private JobFormInfo jobFormInfo;

    private JobInfo getJobInfo() {
        if (this.jobFormInfo == null) {
            this.jobFormInfo = this.getJobFormInfo();
        }
        if (this.jobFormInfo == null) {
            return null;
        }
        return this.jobFormInfo.getJobInfo();
    }

    private JobFormInfo getJobFormInfo() {
        if (this.jobFormInfo == null) {
            String str = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_CLIENTJOBINFO);
            if (StringUtils.isBlank((CharSequence)str)) {
                return null;
            }
            this.jobFormInfo = (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
        }
        return this.jobFormInfo;
    }

    private String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey(CUSTPARAM_TASKID)) {
            return (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_TASKID);
        }
        return this.getPageCache().get(CUSTPARAM_TASKID);
    }

    private void setTaskId(String taskId) {
        this.getPageCache().put(CUSTPARAM_TASKID, taskId);
    }

    private boolean isStart() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey(CUSTPARAM_TASKID)) {
            return true;
        }
        String start = this.getPageCache().get(CACHEKEY_ISSTART);
        if (StringUtils.isBlank((CharSequence)start)) {
            return false;
        }
        return Boolean.parseBoolean(start);
    }

    private void setStart(boolean start) {
        this.getPageCache().put(CACHEKEY_ISSTART, String.valueOf(start));
    }

    private boolean isFinished() {
        String finished = this.getPageCache().get(CACHEKEY_ISFINISHED);
        if (StringUtils.isBlank((CharSequence)finished)) {
            return false;
        }
        return Boolean.parseBoolean(finished);
    }

    private void setFinished(boolean finished) {
        this.getPageCache().put(CACHEKEY_ISFINISHED, String.valueOf(finished));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{KEY_STOP, KEY_MIN, SHOWEXP});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.startBar();
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_STOP, KEY_MIN});
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            this.setProgressDesc(ResManager.loadKDString((String)"\u7b49\u5f85\u4efb\u52a1\u6267\u884c", (String)"TaskProgressFormEdit_1", (String)"bos-schedule-form", (Object[])new Object[0]));
        } else {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
            bar.setPercent(progress);
            this.setProgressDesc(taskInfo.getDesc());
            JobFormInfo jobFormInfo = this.getJobFormInfo();
            if (jobFormInfo != null) {
                this.setButtonVisible(jobFormInfo);
            }
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{SHOWEXP});
    }

    public void click(EventObject e) {
        Control source = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_STOP)) {
            this.stop();
        } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_MIN)) {
            this.tranBackground();
        } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)SHOWEXP)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCustomParam("taskId", (Object)this.getTaskId());
            parameter.setCustomParam("ishideschedule", (Object)true);
            JobInfo jobInfo = this.getJobInfo();
            if (jobInfo != null) {
                parameter.setCustomParam("jobnumber", (Object)jobInfo.getNumber());
                parameter.setCustomParam("jobname", (Object)(jobInfo.getlName() == null ? "" : jobInfo.getlName().toString()));
            }
            parameter.setCaption(ResManager.loadKDString((String)"\u5f02\u5e38\u65e5\u5fd7\u8be6\u60c5", (String)"TaskProgressFormEdit_11", (String)"bos-schedule-form", (Object[])new Object[0]));
            parameter.setShowTitle(true);
            parameter.setFormId("sch_errorjob_details");
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(parameter);
        }
    }

    public void onProgress(ProgressEvent e) {
        String taskId = this.getTaskId();
        boolean start = this.isStart();
        this.setStart(true);
        if (!start && StringUtils.isBlank((CharSequence)taskId)) {
            this.dispatchTask();
            return;
        }
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (taskInfo.isTaskEnd()) {
            this.complete(taskInfo, e);
        } else {
            int progress = taskInfo.getProgress();
            String desc = taskInfo.getDesc();
            e.setProgress(progress);
            this.getPageCache().put("progress", String.valueOf(progress));
            if (StringUtils.isNotBlank((CharSequence)desc)) {
                this.setProgressDesc(desc);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (!this.isStart()) {
            e.setCancel(true);
            return;
        }
        if (this.canClose || this.isFinished()) {
            return;
        }
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        if (jobFormInfo == null) {
            return;
        }
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        if (jobFormInfo.isCanStop()) {
            this.stop();
            e.setCancel(true);
        } else if (jobFormInfo.isCanBackground()) {
            this.tranBackground();
            e.setCancel(true);
        } else {
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (evt.getResult() != MessageBoxResult.Yes) {
            this.startBar();
        } else if (StringUtils.equals((CharSequence)evt.getCallBackId(), (CharSequence)CONFIRMACTIONID_BACKGROUND)) {
            this.doTranBackground();
        } else {
            this.doStop();
        }
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.start();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.stop();
    }

    private void closeForm() {
        this.canClose = true;
        TaskClientProxy.setProgressPageId(this.getTaskId(), "");
        this.getView().close();
    }

    private void dispatchTask() {
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        if (jobFormInfo == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)jobFormInfo.getJobInfo().getAppId())) {
            jobFormInfo.getJobInfo().setAppId(this.getView().getFormShowParameter().getServiceAppId());
        }
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        this.setTaskId(taskId);
        this.setButtonVisible(jobFormInfo);
    }

    private void complete(TaskInfo taskInfo, ProgressEvent e) {
        this.setFinished(true);
        if (StringUtils.equalsIgnoreCase((CharSequence)"FAILED", (CharSequence)taskInfo.getStatus())) {
            if (TaskProgressFormEdit.isShowStackTrace()) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{SHOWEXP});
            }
            String errMsg = ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u51fa\u9519\uff0c\u8be6\u60c5\u8bf7\u67e5\u9605\u8c03\u5ea6\u8fd0\u884c\u65e5\u5fd7\uff0c\u4efb\u52a1ID:%s\u3002", (String)"TaskProgressFormEdit_2", (String)"bos-schedule-form", (Object[])new Object[0]);
            this.getView().showErrorNotification(String.format(errMsg, taskInfo.getId()));
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_STOP, KEY_MIN});
            this.stopBar();
            String str_progress = this.getPageCache().get("progress");
            if (StringUtils.isNotEmpty((CharSequence)str_progress)) {
                e.setProgress(Integer.parseInt(str_progress));
            }
            return;
        }
        String msg = StringUtils.equalsIgnoreCase((CharSequence)"ABORTED", (CharSequence)taskInfo.getStatus()) ? ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u7ec8\u6b62", (String)"TaskProgressFormEdit_10", (String)"bos-schedule-form", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5", (String)"TaskProgressFormEdit_3", (String)"bos-schedule-form", (Object[])new Object[0]);
        this.setProgressDesc(msg);
        e.setProgress(100);
        this.getView().addClientCallBack(TASKCOMPLETE, Integer.valueOf(1500));
        this.stopBar();
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if (TASKCOMPLETE.equals(e.getName())) {
            String taskId = this.getTaskId();
            if (StringUtils.isBlank((CharSequence)taskId)) {
                return;
            }
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            this.returnResult(null);
            if (StringUtils.equalsIgnoreCase((CharSequence)"COMPLETED", (CharSequence)taskInfo.getStatus())) {
                this.returnResult(taskInfo);
            }
            this.closeForm();
        }
    }

    private void stop() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRMACTIONID_STOP, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed\u6267\u884c", (String)"TaskProgressFormEdit_4", (String)"bos-schedule-form", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ec8\u6b62\u6267\u884c", (String)"TaskProgressFormEdit_5", (String)"bos-schedule-form", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u4efb\u52a1\u8fd8\u6ca1\u6709\u6267\u884c\u5b8c\u6bd5\uff0c\u60a8\u662f\u5426\u786e\u8ba4\u8981\u7ec8\u6b62\u6267\u884c\uff1f", (String)"TaskProgressFormEdit_6", (String)"bos-schedule-form", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        this.stopBar();
    }

    private void doStop() {
        this.startBar();
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        ScheduleServiceHelper.stopTask((String)taskId);
        TaskClientProxy.suspend(this.jobFormInfo, taskId);
    }

    private void tranBackground() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRMACTIONID_BACKGROUND, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TaskProgressFormEdit_7", (String)"bos-schedule-form", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u540e\u53f0\u6267\u884c", (String)"TaskProgressFormEdit_8", (String)"bos-schedule-form", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u4efb\u52a1\u8fd8\u6ca1\u6709\u6267\u884c\u5b8c\u6bd5\uff0c\u60a8\u662f\u5426\u786e\u8ba4\u8981\u8f6c\u5165\u540e\u53f0\u6267\u884c\uff1f", (String)"TaskProgressFormEdit_9", (String)"bos-schedule-form", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        this.stopBar();
    }

    private void doTranBackground() {
        this.closeForm();
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (!TaskClientProxy.isExistTask(taskId)) {
            TaskClientProxy.addTask(this.getView(), this.getJobFormInfo(), taskInfo);
            BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), this.getJobFormInfo(), taskId);
            ThreadPools.executeOnce((String)"BOSSchedule-task-background-monitor", (Runnable)subscriber);
        }
    }

    private void setProgressDesc(String desc) {
        Label lblDesc = (Label)this.getControl(KEY_LBLPROGRESS);
        lblDesc.setText(desc);
    }

    private void setButtonVisible(JobFormInfo jobFormInfo) {
        if (jobFormInfo.isCanStop()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_STOP});
        }
        if (jobFormInfo.isCanBackground()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_MIN});
        }
    }

    private void returnResult(TaskInfo taskInfo) {
        Map<String, String> result = TaskProgressFormEdit.packageReturnResult(taskInfo);
        if (result == null) {
            return;
        }
        this.getView().returnDataToParent(result);
    }

    public static Map<String, String> packageReturnResult(TaskInfo taskInfo) {
        if (taskInfo == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (taskInfo != null) {
            String taskInfoStr = SerializationUtils.toJsonString((Object)taskInfo);
            result.put("taskinfo", taskInfoStr);
            result.put("taskend", String.valueOf(taskInfo.isTaskEnd()));
        }
        return result;
    }

    private static boolean isShowStackTrace() {
        Object isShowStackTrace;
        String showStackTrace = System.getProperty("exception_showstacktrace");
        if (showStackTrace != null && "true".equals(showStackTrace)) {
            return true;
        }
        Map cache = SystemParamServiceHelper.loadPublicParametersFromCache();
        if (cache != null && cache.size() > 0 && (isShowStackTrace = cache.get("showstacktrace")) != null) {
            return (Boolean)isShowStackTrace;
        }
        return false;
    }
}

