/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.form.sample;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class JobDispatchSample {
    public void dispatchByJobClient() {
        JobInfo createJob = this.createRuntimeJob();
        String taskId = JobClient.dispatch((JobInfo)createJob);
        try {
            for (int i = 0; i < 50; ++i) {
                Object object;
                Thread.sleep(200L);
                TaskInfo taskInfo = JobClient.queryTask((String)taskId);
                if (taskInfo == null) continue;
                int progress = taskInfo.getProgress();
                String desc = taskInfo.getDesc();
                String data = taskInfo.getData();
                if (StringUtils.isNotBlank((CharSequence)data)) {
                    object = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                }
                if (!taskInfo.isTaskEnd()) continue;
                if (!StringUtils.equalsIgnoreCase((CharSequence)taskInfo.getStatus(), (CharSequence)"COMPLETED")) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)taskInfo.getStatus(), (CharSequence)"FAILED")) {
                        object = taskInfo.getFailureReason();
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)taskInfo.getStatus(), (CharSequence)"ABORTED")) {
                        // empty if block
                    }
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void dispatchByMService() {
        JobInfo createJob = this.createRuntimeJob();
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)createJob);
        try {
            for (int i = 0; i < 50; ++i) {
                Object object;
                Thread.sleep(200L);
                TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
                if (taskInfo == null) continue;
                int progress = taskInfo.getProgress();
                String desc = taskInfo.getDesc();
                String data = taskInfo.getData();
                if (StringUtils.isNotBlank((CharSequence)data)) {
                    object = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                }
                if (!taskInfo.isTaskEnd()) continue;
                if (!StringUtils.equalsIgnoreCase((CharSequence)taskInfo.getStatus(), (CharSequence)"COMPLETED")) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)taskInfo.getStatus(), (CharSequence)"FAILED")) {
                        object = taskInfo.getFailureReason();
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)taskInfo.getStatus(), (CharSequence)"ABORTED")) {
                        // empty if block
                    }
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private JobInfo createRuntimeJob() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("bos");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setName("test job");
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.bos.schedule.sample.MyTask");
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("time", 10);
        jobInfo.setParams(params);
        return jobInfo;
    }
}

