/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.form.task;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.Task;

public class ClearUpJobFormTask
implements Task {
    private static final Log log = LogFactory.getLog(ClearUpJobFormTask.class);

    public void setTaskId(String id) {
    }

    public void stop() throws KDException {
    }

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        String day = (String)params.get("day");
        if (day == null) {
            day = "7";
        }
        this.clearUpHistory(Integer.parseInt(day));
    }

    private void clearUpHistory(int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -day);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        calendar.set(14, 0);
        String sql = "select fid from T_SCH_JOBFORM where FCREATETIME < ?";
        ArrayList<Date> param = new ArrayList<Date>(6);
        param.add(calendar.getTime());
        try (DataSet ds = (DataSet)DB.queryAlone(() -> DB.queryDataSet((String)"ClearHistorySchRecordTask", (DBRoute)DBRoute.basedata, (String)sql, (Object[])param.toArray()));){
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(6);
            while (ds.hasNext()) {
                Row row = ds.next();
                paramsList.add(new Object[]{row.getLong("fid")});
                if (paramsList.size() != 1000) continue;
                this.clearUpHistory(paramsList);
                paramsList.clear();
            }
            if (!paramsList.isEmpty()) {
                this.clearUpHistory(paramsList);
            }
        }
    }

    private void clearUpHistory(List<Object[]> ids) {
        try (TXHandle handle = TX.requiresNew();){
            try {
                String sql = "DELETE FROM T_SCH_JOBFORM WHERE FID = ?";
                DB.executeBatch((DBRoute)DBRoute.base, (String)sql, ids);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                handle.markRollback();
                throw new KDException(BosErrorCode.sQL, new Object[]{e});
            }
        }
    }
}

