/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mutex.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.id.IDService;
import kd.bos.instance.Instance;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.IntentLockInfo;
import kd.bos.mutex.impl.Mutex;
import kd.bos.mutex.impl.MutexBaseInfo;
import kd.bos.mutex.impl.MutexLockDataInfo;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.mutex.lock.LockListener;
import kd.bos.mutex.lock.WriteLock_Redis;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;

class DataMutexImpl_Redis
extends Mutex
implements DataMutex {
    DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("dataMutex-pagecache", new DistributeCacheHAPolicy(true, true));
    static final int CACHE_KEEP_TIME_S = Integer.parseInt(System.getProperty("mutex.cachetimeout_h", "24")) * 60 * 60;
    private static final long LOCK_KEEP_TIME_MS = Long.parseLong(System.getProperty("mutex.maxkeeptime_h", "8")) * 60L * 60L * 1000L;
    private static final String SPAN_TYPE_MUTEX = "Mutex";
    private static final String KEY_AUTOCLEARLOSTLOCK = "autoclearlostlock";
    private static final String KEY_MAXLOCKTIME = "maxlocktime_s";
    private static final String KEY_INSTANCEID = "instanceId";
    private static final String OPTYPE_MODIFY = "modify";
    private List<Map<String, Object>> mutexRequires;
    private List<Object[]> insertDBLockParams = new ArrayList<Object[]>();
    private List<Object[]> dirtyLockClearParams = new ArrayList<Object[]>();
    protected String entityKey;
    protected String groupId;
    private List<String> batchConcurrencyData = new ArrayList<String>();
    static final String KEY_CONCURRENCYBATCH = "_batch";
    private static final String HMUTEX = "IMUTEX:";
    private static final String YX = "_YX";
    private Map<String, Boolean> mutexResults = new HashMap<String, Boolean>();
    private Map<String, Boolean> releaseResults = new HashMap<String, Boolean>();
    private int lockInfoSize = 2000;
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"DataMutexImpl_Redis", (int)10);

    @Override
    protected String getLockType() {
        return "data";
    }

    @Override
    protected void prepared() {
    }

    @Override
    @Deprecated
    public boolean require(String dataObjId, String groupId, String entityKey, String operationKey) {
        return this.require(dataObjId, groupId, entityKey, operationKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean require(MutexLockInfo mutexLockInfo) {
        try (EntityTraceSpan span = null;){
            if (EntityTracer.isRealtime()) {
                span = EntityTracer.create((String)SPAN_TYPE_MUTEX, (String)"", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());
                span.addLocaleTag("mutexLockInfo", (Object)mutexLockInfo);
            }
            boolean bl = this.requireMutex(mutexLockInfo);
            return bl;
        }
    }

    @Override
    @Deprecated
    public boolean require(String dataObjId, String groupId, String entityKey, String operationKey, boolean isStrict) {
        MutexLockInfo lockInfo = new MutexLockInfo(dataObjId, null, groupId, entityKey, operationKey, isStrict, null);
        return this.requireMutex(lockInfo);
    }

    private boolean requireMutex(MutexLockInfo mutexLockInfo) {
        this.prepared();
        this.mutexResults = new HashMap<String, Boolean>();
        this.mutexRequires = new ArrayList<Map<String, Object>>();
        this.insertDBLockParams = new ArrayList<Object[]>();
        this.dirtyLockClearParams = new ArrayList<Object[]>(1);
        this.entityKey = mutexLockInfo.getEntityNumber();
        this.groupId = mutexLockInfo.getGroupId();
        String dataObjId = mutexLockInfo.getDataObjId();
        HashMap<String, Object> mutexRequire = new HashMap<String, Object>();
        mutexRequire.put("dataObjId", dataObjId);
        mutexRequire.put("dataObjNumber", mutexLockInfo.getDataObjNumber());
        mutexRequire.put("groupId", this.groupId);
        mutexRequire.put("entityKey", this.entityKey);
        mutexRequire.put("operationKey", mutexLockInfo.getOperationKey());
        mutexRequire.put("isStrict", mutexLockInfo.isStrict());
        mutexRequire.put("callSource", mutexLockInfo.getCallSource());
        mutexRequire.put(KEY_AUTOCLEARLOSTLOCK, mutexLockInfo.isAutoClearLostLock());
        mutexRequire.put(KEY_MAXLOCKTIME, mutexLockInfo.getMaxLockTime());
        this.mutexRequires.add(mutexRequire);
        this.lockObjKey = this.processSpecialString(this.entityKey + "_" + this.groupId);
        this.lockPath = this.getBasePath() + "/" + this.lockObjKey;
        this.data = "NODATA".getBytes(UTF_8);
        if (!this.tryRequire(this.entityKey, dataObjId, this.groupId, false, null)) {
            return false;
        }
        this.batchClearDirtyLock(this.dirtyLockClearParams);
        this.batchWriteDb(this.insertDBLockParams);
        this.insertDBLockParams.clear();
        Boolean mutexResult = this.mutexResults.get(dataObjId);
        if (mutexResult != null) {
            return mutexResult;
        }
        return false;
    }

    @Override
    public Map<String, String> getLockInfo() {
        if (this.mutexRequires == null || this.mutexRequires.isEmpty()) {
            return null;
        }
        String dataObjId = (String)this.mutexRequires.get(0).get("dataObjId");
        String group = (String)this.mutexRequires.get(0).get("groupId");
        String entity = (String)this.mutexRequires.get(0).get("entityKey");
        return this.getLockInfo(dataObjId, group, entity);
    }

    @Override
    public Map<String, String> getLockInfo(String dataObjId, String groupId, String entityKey) {
        String type = this.buildLockCacheTypeName(entityKey, groupId);
        String value = (String)this.cache.get(type, dataObjId);
        if (value == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            return new HashMap<String, String>();
        }
        return (Map)JSON.parseObject((String)value, Map.class);
    }

    @Override
    public List<MutexLockDataInfo> getLockInfo(List<MutexBaseInfo> lockInfo) {
        String entityKey;
        if (CollectionUtils.isEmpty(lockInfo)) {
            return new ArrayList<MutexLockDataInfo>(0);
        }
        if (lockInfo.size() > 10000) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u7f51\u63a7\u9501\u4fe1\u606f\u4e0d\u80fd\u8d85\u8fc7\u4e00\u4e07\u6761\u3002", (String)"DataMutexImpl_Redis_0", (String)"bos-mutex", (Object[])new Object[0]));
        }
        HashMap group = new HashMap();
        for (MutexBaseInfo mutexBaseInfo : lockInfo) {
            String string = mutexBaseInfo.getDataObjId();
            entityKey = mutexBaseInfo.getEntityNumber();
            String netGroupId = mutexBaseInfo.getGroupId();
            if (!group.containsKey(entityKey)) {
                group.put(entityKey, new HashMap());
            }
            if (!((Map)group.get(entityKey)).containsKey(netGroupId)) {
                ((Map)group.get(entityKey)).put(netGroupId, new ArrayList());
            }
            ((List)((Map)group.get(entityKey)).get(netGroupId)).add(string);
        }
        ArrayList lockInfoValue = new ArrayList(lockInfo.size());
        for (Map.Entry entry : group.entrySet()) {
            entityKey = (String)entry.getKey();
            Map groupMap = (Map)entry.getValue();
            for (Map.Entry groupEntry : groupMap.entrySet()) {
                String groupId = (String)groupEntry.getKey();
                String lockCacheType = this.buildLockCacheTypeName(entityKey, groupId);
                List cacheData = this.cache.get(lockCacheType, ((List)groupEntry.getValue()).toArray(new String[0]));
                if (!CollectionUtils.isNotEmpty((Collection)cacheData)) continue;
                lockInfoValue.addAll(cacheData);
            }
        }
        ArrayList<MutexLockDataInfo> arrayList = new ArrayList<MutexLockDataInfo>(lockInfoValue.size());
        for (String value : lockInfoValue) {
            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
            arrayList.add((MutexLockDataInfo)JSON.parseObject((String)value, MutexLockDataInfo.class));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean release(String dataObjId, String entityKey, String operationKey) {
        try (EntityTraceSpan span = null;){
            if (EntityTracer.isRealtime()) {
                span = EntityTracer.create((String)SPAN_TYPE_MUTEX, (String)"DataMutexImpl.release", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());
                span.addLocaleTag("entityKey", (Object)entityKey);
                span.addLocaleTag("operationKey", (Object)operationKey);
                span.addLocaleTag("dataObjId", (Object)dataObjId);
            }
            if (dataObjId == null) {
                boolean bl = false;
                return bl;
            }
            this.releaseResults = new HashMap<String, Boolean>();
            this.doRelease(entityKey, operationKey, new String[]{dataObjId}, "", false);
            Boolean releaseResult = this.releaseResults.get(dataObjId);
            if (releaseResult != null) {
                boolean bl = releaseResult;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean forcerelease(String dataObjId, String entityKey, String operationKey) {
        try (EntityTraceSpan span = null;){
            if (EntityTracer.isRealtime()) {
                span = EntityTracer.create((String)SPAN_TYPE_MUTEX, (String)"DataMutexImpl.forcerelease", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());
                span.addLocaleTag("entityKey", (Object)entityKey);
                span.addLocaleTag("operationKey", (Object)operationKey);
                span.addLocaleTag("dataObjId", (Object)dataObjId);
            }
            if (dataObjId == null) {
                boolean bl = false;
                return bl;
            }
            this.releaseResults = new HashMap<String, Boolean>();
            this.doRelease(entityKey, operationKey, new String[]{dataObjId}, "", true);
            Boolean releaseResult = this.releaseResults.get(dataObjId);
            if (releaseResult != null) {
                boolean bl = releaseResult;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public void releaseTimeoutLock() {
        String querySQL = "select top 1000000 FID, FEntityKey, FGroupID, FOperationKey, FObjectID from t_mutex_datalock ";
        List lockList = (List)DB.query((DBRoute)DBRoute.basedata, (String)querySQL, null, (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

            public List<Object[]> handle(ResultSet rs) throws Exception {
                ArrayList<Object[]> records = new ArrayList<Object[]>();
                while (rs.next()) {
                    Long recId = rs.getLong(1);
                    String entityKey = rs.getString(2);
                    String groupId = rs.getString(3);
                    String operationKey = rs.getString(4);
                    String dataObjId = rs.getString(5);
                    String data = (String)DataMutexImpl_Redis.this.cache.get(DataMutexImpl_Redis.this.buildLockCacheTypeName(entityKey, groupId), dataObjId);
                    if (StringUtils.isBlank((CharSequence)data)) {
                        SqlParameter[] sqlParams = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)recId)};
                        records.add(sqlParams);
                        continue;
                    }
                    Map lockInfo = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                    String lockTime = (String)lockInfo.get("lockedTime");
                    if (System.currentTimeMillis() - Long.parseLong(lockTime) <= LOCK_KEEP_TIME_MS) continue;
                    SqlParameter[] sqlParams = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)recId)};
                    records.add(sqlParams);
                    DataMutexImpl_Redis.this.cache.remove(DataMutexImpl_Redis.this.buildLockCacheTypeName(entityKey, groupId), dataObjId);
                }
                return records;
            }
        });
        this.batchDeleteRecord(lockList, true);
        this.refreshLocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshLocks() {
        try (EntityTraceSpan span = null;){
            if (EntityTracer.isRealtime()) {
                span = EntityTracer.create((String)SPAN_TYPE_MUTEX, (String)"DataMutexImpl.refreshLocks", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());
            }
            Map<String, Map<String, Map<String, List<Map<String, Object>>>>> dbRecords = this.readAllDBLock();
            Map<String, Map<String, Map<String, String>>> netGroups = this.readAllCacheNetGroups();
            for (Map.Entry<String, Map<String, Map<String, String>>> entity : netGroups.entrySet()) {
                HashMap<String, String> removeGroups = new HashMap<String, String>(entity.getValue().size());
                for (Map.Entry<String, Map<String, Object>> entry : entity.getValue().entrySet()) {
                    String groupId = entry.getKey();
                    String cacheType = this.buildLockCacheTypeName(entity.getKey(), groupId);
                    Map cacheValues = this.cache.getAll(cacheType);
                    HashSet<String> delDataObjIds = new HashSet<String>();
                    for (Map.Entry data : cacheValues.entrySet()) {
                        String dataObjId = (String)data.getKey();
                        if (dbRecords.containsKey(entity.getKey()) && dbRecords.get(entity.getKey()).containsKey(groupId) && dbRecords.get(entity.getKey()).get(groupId).containsKey(dataObjId)) continue;
                        delDataObjIds.add(dataObjId);
                    }
                    if (!delDataObjIds.isEmpty()) {
                        this.cache.remove(cacheType, delDataObjIds.toArray(new String[delDataObjIds.size()]));
                    }
                    if (cacheValues != null && !cacheValues.isEmpty()) continue;
                    removeGroups.putAll(entry.getValue());
                }
                if (removeGroups.isEmpty()) continue;
                this.removeNetGroupCache(entity.getKey(), removeGroups);
            }
            ArrayList<Object[]> delRecordIds = new ArrayList<Object[]>();
            for (Map.Entry<String, Map<String, Map<String, List<Map<String, Object>>>>> entity : dbRecords.entrySet()) {
                for (Map.Entry<String, Map<String, Object>> entry : entity.getValue().entrySet()) {
                    String cacheType = this.buildLockCacheTypeName(entity.getKey(), entry.getKey());
                    Map cacheValues = this.cache.getAll(cacheType);
                    for (Map.Entry<String, Object> data : entry.getValue().entrySet()) {
                        String dataObjId = data.getKey();
                        if (cacheValues.containsKey(dataObjId)) continue;
                        for (Map record : (List)data.getValue()) {
                            SqlParameter[] sqlParams = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)((Long)record.get("recordId")))};
                            delRecordIds.add(sqlParams);
                        }
                    }
                }
            }
            this.batchDeleteRecord(delRecordIds, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Boolean> batchrequire(List<Map<String, Object>> data) {
        try (EntityTraceSpan span = null;){
            if (EntityTracer.isRealtime()) {
                span = EntityTracer.create((String)SPAN_TYPE_MUTEX, (String)"DataMutexImpl.batchrequire", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());
                span.addLocaleTag("data", data);
            }
            this.prepared();
            this.insertDBLockParams = new ArrayList<Object[]>(10);
            this.dirtyLockClearParams = new ArrayList<Object[]>(10);
            this.mutexResults = new HashMap<String, Boolean>(16);
            HashMap group = new HashMap();
            for (Map<String, Object> map : data) {
                String dataObjId = (String)map.get("dataObjId");
                this.mutexResults.put(dataObjId, Boolean.FALSE);
                String entityKey = (String)map.get("entityKey");
                String netGroupId = (String)map.get("groupId");
                if (!group.containsKey(entityKey)) {
                    group.put(entityKey, new HashMap());
                }
                if (!((Map)group.get(entityKey)).containsKey(netGroupId)) {
                    ((Map)group.get(entityKey)).put(netGroupId, new ArrayList());
                }
                ((List)((Map)group.get(entityKey)).get(netGroupId)).add(map);
            }
            for (Map.Entry entry : group.entrySet()) {
                this.entityKey = (String)entry.getKey();
                for (Map.Entry group2 : ((Map)entry.getValue()).entrySet()) {
                    this.groupId = (String)group2.getKey();
                    this.mutexRequires = new ArrayList<Map<String, Object>>();
                    this.mutexRequires.addAll((Collection)group2.getValue());
                    this.lockObjKey = this.processSpecialString(this.entityKey + "_" + this.groupId);
                    this.lockPath = this.getBasePath() + "/" + this.lockObjKey;
                    this.data = "NODATA".getBytes(UTF_8);
                    for (Map map : (List)group2.getValue()) {
                        String objectId = map.get("dataObjId").toString();
                        this.batchConcurrencyData.add(objectId);
                    }
                    if (((List)group2.getValue()).size() > 1) {
                        this.tryRequire(this.entityKey, KEY_CONCURRENCYBATCH, this.groupId, true, this.batchConcurrencyData);
                        continue;
                    }
                    this.tryRequire(this.entityKey, this.batchConcurrencyData.get(0), this.groupId, false, null);
                }
            }
            this.batchClearDirtyLock(this.dirtyLockClearParams);
            this.batchWriteDb(this.insertDBLockParams);
            this.insertDBLockParams.clear();
            Map<String, Boolean> map = this.mutexResults;
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Boolean> batchRelease(List<Map<String, Object>> data) {
        try (EntityTraceSpan span = null;){
            if (EntityTracer.isRealtime()) {
                span = EntityTracer.create((String)SPAN_TYPE_MUTEX, (String)"DataMutexImpl.batchRelease", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());
                span.addLocaleTag("data", data);
            }
            this.releaseResults = new HashMap<String, Boolean>(16);
            HashMap dataGroup = new HashMap();
            for (Map<String, Object> map : data) {
                String dataObjId = (String)map.get("dataObjId");
                String entityKey = (String)map.get("entityKey");
                String operationKey = (String)map.get("operationKey");
                String groupId = (String)map.getOrDefault("groupId", "");
                this.releaseResults.put(dataObjId, Boolean.FALSE);
                if (dataObjId == null) continue;
                if (!dataGroup.containsKey(entityKey)) {
                    dataGroup.put(entityKey, new HashMap());
                }
                if (!((Map)dataGroup.get(entityKey)).containsKey(groupId)) {
                    ((Map)dataGroup.get(entityKey)).put(groupId, new HashMap());
                }
                if (!((Map)((Map)dataGroup.get(entityKey)).get(groupId)).containsKey(operationKey)) {
                    ((Map)((Map)dataGroup.get(entityKey)).get(groupId)).put(operationKey, new ArrayList());
                }
                ((List)((Map)((Map)dataGroup.get(entityKey)).get(groupId)).get(operationKey)).add(dataObjId);
            }
            for (Map.Entry entry : dataGroup.entrySet()) {
                for (Map.Entry group2 : ((Map)entry.getValue()).entrySet()) {
                    for (Map.Entry group3 : ((Map)group2.getValue()).entrySet()) {
                        String entityKey = (String)entry.getKey();
                        String groupKey = (String)group2.getKey();
                        String operationKey = (String)group3.getKey();
                        List dataObjIds = (List)group3.getValue();
                        this.doRelease(entityKey, operationKey, dataObjIds.toArray(new String[dataObjIds.size()]), groupKey, false);
                    }
                }
            }
            Map<String, Boolean> map = this.releaseResults;
            return map;
        }
    }

    @Override
    public boolean releaseByReLogin() {
        RequestContext requestContext = RequestContext.get();
        if (this.getIsTerminalLimit(requestContext.getTenantId())) {
            return true;
        }
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_MUTEX, (String)"DataMutexImpl.releaseByReLogin", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            String loginUserId = requestContext.getUserId();
            String loginClient = requestContext.getClient();
            String loginSessionId = requestContext.getGlobalSessionId();
            log.info(String.format("releaseMutexByReLogin, loginClient=%s", loginClient));
            Object[] params = new SqlParameter[]{new SqlParameter(":FUSERID", -5, (Object)Long.parseLong(loginUserId)), new SqlParameter(":FGROUPID", 12, (Object)"default_netctrl"), new SqlParameter(":FOPERATIONKEY", 12, (Object)OPTYPE_MODIFY)};
            String sql = "SELECT  FID,  FUSERID,  FSESSIONID,  FOPERATIONKEY, FENTITYKEY,  FGROUPID,  FOBJECTID,  FCREATETIME FROM t_mutex_datalock WHERE  FUSERID = ? AND FGROUPID = ? AND FOPERATIONKEY = ?";
            List lockList = new ArrayList();
            try {
                lockList = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, rs -> {
                    ArrayList list = new ArrayList();
                    try {
                        while (rs.next()) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("recordId", rs.getString(1));
                            map.put("userid", rs.getString(2));
                            map.put("GLOBALSESSION", rs.getString(3));
                            map.put("operationKey", rs.getString(4));
                            map.put("entityKey", rs.getString(5));
                            map.put("groupId", rs.getString(6));
                            map.put("dataObjId", rs.getString(7));
                            list.add(map);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                    }
                    return list;
                });
            }
            catch (Exception e) {
                String msg = String.format("release by login error:%s;  sql:%s", e.getMessage(), sql);
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
            }
            ArrayList<Object[]> deleteRecord = new ArrayList<Object[]>();
            if (lockList != null && lockList.size() > 0) {
                for (Map lock : lockList) {
                    String dataObjId = lock.get("dataObjId").toString();
                    String groupId = lock.get("groupId").toString();
                    String entityKey = lock.get("entityKey").toString();
                    String operationKey = lock.get("operationKey").toString();
                    String lockCacheType = this.buildLockCacheTypeName(entityKey, groupId);
                    String value = (String)this.cache.get(lockCacheType, dataObjId);
                    Map lockInfo = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
                    String userId = (String)lockInfo.get("userid");
                    String client = (String)lockInfo.get("client");
                    String sessionId = (String)lockInfo.get("GLOBALSESSION");
                    if (!loginUserId.equals(userId) || !loginClient.equalsIgnoreCase(client) || client.equalsIgnoreCase("batch") || client.equals("MQ") || loginSessionId.equals(sessionId)) continue;
                    this.doRelease4Login(entityKey, dataObjId, groupId, operationKey, Long.parseLong(lock.get("recordId").toString()), deleteRecord);
                }
            }
            if (deleteRecord.size() > 0) {
                this.batchDeleteRecord(deleteRecord, true);
            }
        }
        return true;
    }

    private boolean tryRequire(String entityKey, String dataObjId, String groupId, boolean isBatch, List<String> data) {
        this.batchConcurrencyData = data != null ? data : new ArrayList();
        String lockObjKey = this.processSpecialString(entityKey + "_" + dataObjId + "_" + groupId);
        if (isBatch) {
            lockObjKey = this.processSpecialString(entityKey + "_" + KEY_CONCURRENCYBATCH + "_" + groupId);
        }
        return this.require(lockObjKey, isBatch);
    }

    @Deprecated
    private boolean tryRequire(String lockObjKey, int tryCount) {
        if (tryCount > 25) {
            return false;
        }
        if (!this.require(lockObjKey)) {
            this.retryDelay(4);
            return this.tryRequire(lockObjKey, ++tryCount);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean require(String lockObjKey, final boolean isBatch) {
        if (lockObjKey == null) {
            return false;
        }
        try (WriteLock_Redis redisWriteLock = new WriteLock_Redis(lockObjKey, this.batchConcurrencyData, new LockListener(){

            @Override
            public void lockAcquired(boolean isSuccess) {
                DataMutexImpl_Redis.this.afterLocked(isSuccess, isBatch);
            }

            @Override
            public void lockReleased() {
                DataMutexImpl_Redis.this.afterRelease();
            }
        }, isBatch);){
            boolean bl = redisWriteLock.write();
            return bl;
        }
        catch (KDException kde) {
            throw new KDException((Throwable)kde, kde.getErrorCode(), new Object[]{kde.getMessage()});
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{e.getMessage()});
        }
    }

    private void retryDelay(int millis) {
        if (millis > 0) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void afterLocked(boolean isSuccess, boolean isBatch) {
        if (!isSuccess) {
            return;
        }
        if (isBatch) {
            this.retryDelay(10);
        }
        HashMap<String, String> cacheLockInfos = new HashMap<String, String>();
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>();
        Date lockTime = new Date();
        String lockCacheType = this.buildLockCacheTypeName(this.entityKey, this.groupId);
        Map<String, String> oldCacheLockInfos = this.getOldCacheLockInfos(lockCacheType, this.mutexRequires);
        HashSet<String> opKeys = new HashSet<String>(16);
        ArrayList<String> dirtyLockObjIds = new ArrayList<String>(10);
        boolean isClearlostlock = Boolean.parseBoolean(System.getProperty("mutex.clearlostlock.enable", "true"));
        for (Map<String, Object> mutexRequire : this.mutexRequires) {
            List lockList;
            String lockStr;
            String dataObjId = (String)mutexRequire.get("dataObjId");
            if (!isBatch && StringUtils.isNotBlank((CharSequence)(lockStr = WriteLock_Redis.getBatchLockedData(this.processSpecialString(RequestContext.get().getAccountId() + "_" + this.entityKey + "_" + KEY_CONCURRENCYBATCH + "_" + this.groupId)))) && (lockList = SerializationUtils.fromJsonStringToList((String)lockStr, List.class)) != null && lockList.contains(dataObjId)) {
                return;
            }
            String operationKey = (String)mutexRequire.get("operationKey");
            opKeys.add(operationKey);
            boolean requireResult = this.buildLockInfo(mutexRequire, lockTime, oldCacheLockInfos.get(dataObjId), cacheLockInfos, sqlParams, isClearlostlock, dirtyLockObjIds);
            this.mutexResults.put(dataObjId, requireResult);
        }
        if (this.mutexResults != null) {
            int rsSize = this.mutexResults.size();
            String rsLog = "DataMutex.afterLocked,size:" + rsSize;
            if (rsSize <= 50) {
                rsLog = rsLog + ",rs:" + SerializationUtils.toJsonString(this.mutexResults);
            }
            log.info(rsLog + ",entityKey:" + this.entityKey + ",groupId:" + this.groupId);
        }
        if (!cacheLockInfos.isEmpty()) {
            this.cache.put(lockCacheType, cacheLockInfos, CACHE_KEEP_TIME_S);
            this.updateNetGroupCache(this.entityKey, this.groupId, opKeys);
        }
        if (!dirtyLockObjIds.isEmpty()) {
            for (String dirtyObjId : dirtyLockObjIds) {
                SqlParameter[] params = new SqlParameter[]{new SqlParameter(":FENTITYKEY", 12, (Object)this.entityKey), new SqlParameter(":FGROUPID", 12, (Object)this.groupId), new SqlParameter(":FOBJECTID", 12, (Object)dirtyObjId)};
                this.dirtyLockClearParams.add(params);
            }
        }
        this.insertDBLockParams.addAll(sqlParams);
    }

    private Map<String, String> getOldCacheLockInfos(String lockCacheType, List<Map<String, Object>> infos) {
        if (infos.size() > this.lockInfoSize) {
            return this.cache.getAll(lockCacheType);
        }
        HashSet<String> ids = new HashSet<String>(infos.size());
        for (Map<String, Object> info : infos) {
            Object id = info.get("dataObjId");
            if (id == null) continue;
            ids.add((String)id);
        }
        return this.getOldCacheLockInfos(lockCacheType, ids.toArray(new String[ids.size()]));
    }

    private Map<String, String> getOldCacheLockInfos(String lockCacheType, String[] dataObjIdArr) {
        if (dataObjIdArr == null || dataObjIdArr.length == 0) {
            return Collections.emptyMap();
        }
        if (dataObjIdArr.length > this.lockInfoSize) {
            return this.cache.getAll(lockCacheType);
        }
        List lockInfos = this.cache.get(lockCacheType, dataObjIdArr);
        HashMap<String, String> oldCacheLockInfos = new HashMap<String, String>(lockInfos.size());
        for (int i = 0; i < dataObjIdArr.length; ++i) {
            oldCacheLockInfos.put(dataObjIdArr[i], (String)lockInfos.get(i));
        }
        return oldCacheLockInfos;
    }

    @Override
    protected void afterRelease() {
        this.batchConcurrencyData.clear();
    }

    private boolean buildLockInfo(Map<String, Object> mutexRequire, Date lockTime, String oldCacheValue, Map<String, String> cacheLockInfos, List<Object[]> sqlParams, boolean isClearLostLock, List<String> dirtyLock) {
        Set<Object> opSet;
        MutexLockDataInfo lockInfo = null;
        boolean isReentry = false;
        boolean isNodeLiving = true;
        boolean clearDirtyLock = false;
        String operationKey = (String)mutexRequire.get("operationKey");
        String dataObjId = (String)mutexRequire.get("dataObjId");
        RequestContext rc = RequestContext.get();
        if (oldCacheValue != null) {
            lockInfo = (MutexLockDataInfo)SerializationUtils.fromJsonString((String)oldCacheValue, MutexLockDataInfo.class);
            boolean isStrict = StringUtils.isBlank((Object)mutexRequire.get("isStrict")) ? false : (Boolean)mutexRequire.get("isStrict");
            boolean enableClearLostLock = Boolean.parseBoolean(lockInfo.getAutoClearLostLock());
            String lockedTime = lockInfo.getLockedTime();
            long lockTime_ms = Long.parseLong(StringUtils.isBlank((CharSequence)lockedTime) ? String.valueOf(System.currentTimeMillis()) : lockedTime);
            String maxLockTime = lockInfo.getMaxLockTime();
            long maxLockKeep_s = Long.parseLong(StringUtils.isBlank((CharSequence)maxLockTime) ? "-1" : maxLockTime);
            if (isClearLostLock && enableClearLostLock) {
                isNodeLiving = this.isLivingNode(lockInfo);
            }
            if (!isNodeLiving && maxLockKeep_s > 0L && System.currentTimeMillis() - lockTime_ms > maxLockKeep_s * 1000L) {
                clearDirtyLock = true;
            } else if (!(this.isIgnoreModifyLock(lockInfo, mutexRequire) || !isStrict && this.enableReentrant(rc, lockInfo))) {
                return false;
            }
        }
        if (clearDirtyLock) {
            dirtyLock.add(dataObjId);
            String oldOpKey = lockInfo.getOperationKey();
            lockInfo = null;
            log.info("instance not alive \u7f51\u7edc\u4e92\u65a5\u9501\u5f02\u5e38\u9501\u6e05\u7406\uff1a group={} , opkey={} , entitykey={} , dataid={} ", new Object[]{this.groupId, oldOpKey, this.entityKey, dataObjId});
        }
        if (lockInfo == null) {
            opSet = new HashSet<String>();
            opSet.add(operationKey);
            lockInfo = new MutexLockDataInfo(dataObjId, this.entityKey, this.groupId, StringUtils.join((Object[])opSet.toArray(), (String)","));
            lockInfo.setUserId(rc.getUserId());
            lockInfo.setLockedTime(String.valueOf(System.currentTimeMillis()));
            lockInfo.setClient(rc.getClient());
            lockInfo.setGlobalSession(rc.getGlobalSessionId());
            lockInfo.setInstanceId(Instance.getInstanceId());
            boolean autoClearDirtyLock = (Boolean)mutexRequire.getOrDefault(KEY_AUTOCLEARLOSTLOCK, Boolean.FALSE);
            long maxLostLockTime = (Long)mutexRequire.getOrDefault(KEY_MAXLOCKTIME, -1L);
            if (autoClearDirtyLock && maxLostLockTime > 0L) {
                lockInfo.setMaxLockTime(Long.toString(maxLostLockTime));
                lockInfo.setAutoClearLostLock("true");
            }
        } else {
            opSet = this.parseOpSet(lockInfo.getOperationKey());
            if (opSet.contains(operationKey)) {
                isReentry = true;
            }
            opSet.add(operationKey);
            lockInfo.setClient(rc.getClient());
            lockInfo.setLockedTime(String.valueOf(System.currentTimeMillis()));
            lockInfo.setOperationKey(StringUtils.join((Object[])opSet.toArray(), (String)","));
        }
        String lockInfoStr = SerializationUtils.toJsonString((Object)lockInfo);
        cacheLockInfos.put(dataObjId, lockInfoStr);
        if (!isReentry) {
            sqlParams.add(this.buildSQLParameter(dataObjId, (String)mutexRequire.get("dataObjNumber"), this.groupId, this.entityKey, operationKey, (String)mutexRequire.get("callSource"), lockTime));
        }
        return true;
    }

    private boolean isLivingNode(MutexLockDataInfo lockInfo) {
        if (!Boolean.parseBoolean(lockInfo.getAutoClearLostLock())) {
            return true;
        }
        String instanceId = lockInfo.getInstanceId();
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            return true;
        }
        try {
            return DLock.isInstanceAlive((String)instanceId);
        }
        catch (Exception e) {
            log.error("Mutex\u83b7\u53d6instance\u72b6\u6001\u4fe1\u606f\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            return true;
        }
    }

    private boolean isIgnoreModifyLock(MutexLockDataInfo lockInfo, Map<String, Object> mutexRequire) {
        Object ignoreModify = mutexRequire.get("ignoreModify");
        if (StringUtils.isBlank((Object)ignoreModify) || !((Boolean)ignoreModify).booleanValue()) {
            return false;
        }
        String groupId = (String)mutexRequire.get("groupId");
        if (!StringUtils.equalsIgnoreCase((CharSequence)groupId, (CharSequence)"default_netctrl")) {
            return false;
        }
        String operationKey = (String)mutexRequire.get("operationKey");
        if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)OPTYPE_MODIFY)) {
            return false;
        }
        Set<String> opSet = this.parseOpSet(lockInfo.getOperationKey());
        if (opSet.size() > 1) {
            return false;
        }
        return opSet.contains(OPTYPE_MODIFY);
    }

    private boolean enableReentrant(RequestContext rc, MutexLockDataInfo lockInfo) {
        if (StringUtils.equalsIgnoreCase((CharSequence)rc.getGlobalSessionId(), (CharSequence)lockInfo.getGlobalSession())) {
            return true;
        }
        if ("mobile".equalsIgnoreCase(rc.getClient()) && StringUtils.equalsIgnoreCase((CharSequence)rc.getClient(), (CharSequence)lockInfo.getClient()) && StringUtils.equalsIgnoreCase((CharSequence)rc.getUserId(), (CharSequence)lockInfo.getUserId())) {
            return true;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)rc.getUserId(), (CharSequence)lockInfo.getUserId()) && "web".equalsIgnoreCase(rc.getClient());
    }

    private void doRelease(String entityKey, String operationKey, String[] dataObjIds, String oriGroupId, boolean isForce) {
        if (dataObjIds == null) {
            return;
        }
        Map<String, String> cacheLocks = null;
        HashMap<String, String> upCacheLocks = new HashMap<String, String>();
        HashSet<String> removeCacheLocks = new HashSet<String>();
        String lockCacheType = "";
        String releaseGroupId = oriGroupId;
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(10);
        List<Map<String, Object>> dbRecords = this.readDBLock(entityKey, operationKey, releaseGroupId, dataObjIds);
        HashSet<String> noRecordObjIds = new HashSet<String>();
        noRecordObjIds.addAll(Arrays.asList(dataObjIds));
        for (Map<String, Object> dbRecord : dbRecords) {
            if (cacheLocks == null) {
                if (StringUtils.isBlank((CharSequence)releaseGroupId)) {
                    releaseGroupId = (String)dbRecord.get("groupId");
                }
                lockCacheType = this.buildLockCacheTypeName(entityKey, releaseGroupId);
                cacheLocks = this.getOldCacheLockInfos(lockCacheType, dataObjIds);
            }
            String dataObjId = (String)dbRecord.get("dataObjId");
            noRecordObjIds.remove(dataObjId);
            this.removeCacheMutex(dataObjId, operationKey, cacheLocks.get(dataObjId), upCacheLocks, removeCacheLocks);
            SqlParameter[] delParams = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)((Long)dbRecord.get("recordId")))};
            sqlParams.add(delParams);
        }
        if (!noRecordObjIds.isEmpty()) {
            if (cacheLocks == null) {
                if (StringUtils.isBlank((CharSequence)releaseGroupId)) {
                    releaseGroupId = this.getCacheNetGroupId(entityKey, operationKey);
                }
                if (StringUtils.isNotBlank((CharSequence)releaseGroupId)) {
                    lockCacheType = this.buildLockCacheTypeName(entityKey, releaseGroupId);
                    cacheLocks = this.getOldCacheLockInfos(lockCacheType, noRecordObjIds.toArray(new String[noRecordObjIds.size()]));
                }
            }
            if (cacheLocks != null) {
                for (String dataObjId : noRecordObjIds) {
                    this.removeCacheMutex(dataObjId, operationKey, cacheLocks.get(dataObjId), upCacheLocks, removeCacheLocks);
                }
            }
        }
        if (!upCacheLocks.isEmpty()) {
            this.cache.put(lockCacheType, upCacheLocks);
        }
        if (!removeCacheLocks.isEmpty()) {
            this.cache.remove(lockCacheType, removeCacheLocks.toArray(new String[removeCacheLocks.size()]));
        }
        this.batchDeleteRecord(sqlParams, isForce);
        if (dataObjIds.length <= 50) {
            log.info("DataMutex.doRelease,dataObjId:{}, entityKey:{}, oriGroupId:{}, releaseGroupId:{}, opKey:{}, isForce:{}", new Object[]{Arrays.toString(dataObjIds), entityKey, oriGroupId, releaseGroupId, operationKey, isForce});
        } else {
            log.info("DataMutex.doRelease, dataObjIdLength:{}, entityKey:{}, oriGroupId:{}, releaseGroupId:{}, opKey:{}, isForce:{}", new Object[]{dataObjIds.length, entityKey, oriGroupId, releaseGroupId, operationKey, isForce});
        }
    }

    private void doRelease4Login(String entityKey, String dataObjId, String groupId, String operationKey, Long fid, List<Object[]> sqlParams) {
        if (dataObjId == null) {
            return;
        }
        HashMap<String, String> upCacheLocks = new HashMap<String, String>();
        HashSet<String> removeCacheLocks = new HashSet<String>();
        String lockCacheType = this.buildLockCacheTypeName(entityKey, groupId);
        String cacheLock = (String)this.cache.get(lockCacheType, dataObjId);
        this.removeCacheMutex(dataObjId, operationKey, cacheLock, upCacheLocks, removeCacheLocks);
        SqlParameter[] delParams = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)fid)};
        sqlParams.add(delParams);
        if (!upCacheLocks.isEmpty()) {
            this.cache.put(lockCacheType, upCacheLocks);
        }
        if (!removeCacheLocks.isEmpty()) {
            this.cache.remove(lockCacheType, removeCacheLocks.toArray(new String[removeCacheLocks.size()]));
        }
    }

    private void removeCacheMutex(String dataObjId, String operationKey, String oldCacheValue, Map<String, String> upCacheLocks, Set<String> removeCacheLocks) {
        String cacheValue = oldCacheValue;
        String upCacheLock = upCacheLocks.get(dataObjId);
        if (upCacheLock != null) {
            cacheValue = upCacheLock;
        }
        if (StringUtils.isBlank((CharSequence)cacheValue)) {
            return;
        }
        Map lockInfo = (Map)JSON.parseObject((String)cacheValue, Map.class);
        Set<String> opSet = this.parseOpSet((String)lockInfo.get("opkey"));
        opSet.remove(operationKey);
        if (opSet.isEmpty()) {
            upCacheLocks.remove(dataObjId);
            removeCacheLocks.add(dataObjId);
        } else {
            lockInfo.put("opkey", StringUtils.join((Object[])opSet.toArray(), (String)","));
            upCacheLocks.put(dataObjId, JSON.toJSONString((Object)lockInfo));
        }
        this.releaseResults.put(dataObjId, Boolean.TRUE);
    }

    private Set<String> parseOpSet(String opKeyStr) {
        String[] opKeyArr = StringUtils.split((String)opKeyStr, (String)",");
        HashSet<String> opSet = new HashSet<String>(16);
        for (String opKey : opKeyArr) {
            opSet.add(opKey);
        }
        return opSet;
    }

    private void updateNetGroupCache(String entityKey, String groupId, Set<String> opKeys) {
        String netGroupCacheType = this.buildNetGroupCacheTypeName();
        String oldNetGroupCache = (String)this.cache.get(netGroupCacheType, entityKey);
        Map cacheGroupIds = new HashMap(16);
        cacheGroupIds = StringUtils.isBlank((CharSequence)oldNetGroupCache) ? new HashMap(16) : (Map)JSON.parseObject((String)oldNetGroupCache, Map.class);
        for (String opKey : opKeys) {
            cacheGroupIds.put(opKey, groupId);
        }
        this.cache.put(netGroupCacheType, entityKey, JSON.toJSONString(cacheGroupIds), CACHE_KEEP_TIME_S);
    }

    private void removeNetGroupCache(String entityKey, Map<String, String> removeNetGroups) {
        if (StringUtils.isBlank((CharSequence)entityKey) || removeNetGroups == null || removeNetGroups.isEmpty()) {
            return;
        }
        String netGroupCacheType = this.buildNetGroupCacheTypeName();
        String oldNetGroupCache = (String)this.cache.get(netGroupCacheType, entityKey);
        if (StringUtils.isNotBlank((CharSequence)oldNetGroupCache)) {
            Map cacheGroupIds = (Map)JSON.parseObject((String)oldNetGroupCache, Map.class);
            for (Map.Entry<String, String> netGroup : removeNetGroups.entrySet()) {
                if (!StringUtils.equals((CharSequence)((CharSequence)cacheGroupIds.get(netGroup.getKey())), (CharSequence)netGroup.getValue())) continue;
                cacheGroupIds.remove(netGroup.getKey());
            }
            if (cacheGroupIds.isEmpty()) {
                this.cache.remove(netGroupCacheType, entityKey);
            } else {
                this.cache.put(netGroupCacheType, entityKey, JSON.toJSONString((Object)cacheGroupIds), CACHE_KEEP_TIME_S);
            }
        }
    }

    private String getCacheNetGroupId(String entityKey, String operationKey) {
        String netGroupCacheType = this.buildNetGroupCacheTypeName();
        String oldNetGroupCache = (String)this.cache.get(netGroupCacheType, entityKey);
        Map cacheGroupIds = new HashMap();
        cacheGroupIds = StringUtils.isBlank((CharSequence)oldNetGroupCache) ? new HashMap() : (Map)JSON.parseObject((String)oldNetGroupCache, Map.class);
        return (String)cacheGroupIds.get(operationKey);
    }

    private Map<String, Map<String, Map<String, String>>> readAllCacheNetGroups() {
        HashMap<String, Map<String, Map<String, String>>> netGroups = new HashMap<String, Map<String, Map<String, String>>>();
        String cacheType = this.buildNetGroupCacheTypeName();
        Map cacheValues = this.cache.getAll(cacheType);
        for (Map.Entry entry : cacheValues.entrySet()) {
            if (StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
            String entityKey = (String)entry.getKey();
            Map ops = (Map)JSON.parseObject((String)((String)entry.getValue()), Map.class);
            for (Map.Entry op : ops.entrySet()) {
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)op.getValue()))) continue;
                if (!netGroups.containsKey(entityKey)) {
                    netGroups.put(entityKey, new HashMap(10));
                }
                if (!((Map)netGroups.get(entityKey)).containsKey(op.getValue())) {
                    ((Map)netGroups.get(entityKey)).put(op.getValue(), new HashMap(10));
                }
                ((Map)((Map)netGroups.get(entityKey)).get(op.getValue())).put(op.getKey(), op.getValue());
            }
        }
        return netGroups;
    }

    private Object[] buildSQLParameter(String dataObjId, String dataObjNumber, String groupId, String entityKey, String operationKey, String callSource, Date lockTime) {
        Object[] params = new SqlParameter[12];
        if (lockTime == null) {
            lockTime = new Date();
        }
        RequestContext rc = RequestContext.get();
        long id = IDService.get().genLongId(rc.getAccountId(), "t_mutex_datalock");
        String globalSessionId = rc.getGlobalSessionId();
        params[0] = new SqlParameter(":FID", -5, (Object)id);
        params[1] = new SqlParameter(":FUserID", -5, (Object)rc.getUserId());
        params[2] = new SqlParameter(":FSessionID", 12, (Object)(StringUtils.isBlank((CharSequence)globalSessionId) ? "" : globalSessionId));
        params[3] = new SqlParameter(":FEntityKey", 12, (Object)entityKey);
        params[4] = new SqlParameter(":FOperationKey", 12, (Object)operationKey);
        params[5] = new SqlParameter(":FGroupID", 12, (Object)groupId);
        params[6] = new SqlParameter(":FObjectID", 12, (Object)(dataObjId == null ? " " : dataObjId));
        params[7] = new SqlParameter(":fobjectnumber", 12, (Object)(dataObjNumber == null ? " " : dataObjNumber));
        params[8] = new SqlParameter(":fclienttype", 12, (Object)rc.getClient());
        params[9] = new SqlParameter(":ftraceid", 12, (Object)rc.getTraceId());
        params[10] = new SqlParameter(":fcallsource", 12, (Object)callSource);
        params[11] = new SqlParameter(":FCreateTime", 93, (Object)lockTime);
        return params;
    }

    private void batchClearDirtyLock(List<Object[]> dirtyParams) {
        if (dirtyParams.isEmpty()) {
            return;
        }
        String deleteSql = "DELETE FROM T_MUTEX_DATALOCK WHERE FENTITYKEY=? AND FGROUPID=? AND FOBJECTID=? ";
        try (TXHandle handle = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)deleteSql, dirtyParams);
            }
            catch (Exception e) {
                handle.markRollback();
            }
        }
    }

    private void batchWriteDb(List<Object[]> sqlParams) {
        if (sqlParams.isEmpty()) {
            return;
        }
        String strInsertSQL = "INSERT INTO t_mutex_datalock (FID,FUserID,FSessionID,FEntityKey,FOperationKey,FGroupID,FObjectID,fobjectnumber,fclienttype,ftraceid,fcallsource,FCreateTime)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?) ";
        try (TXHandle handle = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)strInsertSQL, sqlParams);
            }
            catch (Exception e) {
                handle.markRollback();
            }
        }
    }

    private void batchDeleteRecord(final List<Object[]> recordIdParams, final boolean isForce) {
        if (recordIdParams.size() == 0) {
            return;
        }
        final RequestContext rc = RequestContext.get();
        threadPool.execute(new Runnable(){

            @Override
            public void run() {
                String deleteSql = "delete from t_mutex_datalock where fid = ?";
                try (TXHandle handle = TX.requiresNew();){
                    try {
                        if (isForce) {
                            String logSQL = "INSERT INTO t_mutex_cleardatalock  (FID,FUserID,FSessionID,FEntityKey,FOperationKey,FGroupID,FObjectID,FCreateTime,FClearTime,FClearedBy)  select FID,FUserID,FSessionID,FEntityKey,FOperationKey,FGroupID,FObjectID,FCreateTime,now(), " + rc.getUserId() + " from t_mutex_datalock  where FID = ? ";
                            DB.executeBatch((DBRoute)DBRoute.basedata, (String)logSQL, (List)recordIdParams);
                        }
                        DB.executeBatch((DBRoute)DBRoute.basedata, (String)deleteSql, (List)recordIdParams);
                    }
                    catch (Exception e) {
                        handle.markRollback();
                    }
                }
            }
        }, RequestContext.get());
    }

    private void writeForceLog(Long recId) {
        RequestContext rc = RequestContext.get();
        String strInsertSQL = "INSERT INTO t_mutex_cleardatalock  (FID,FUserID,FSessionID,FEntityKey,FOperationKey,FGroupID,FObjectID,FCreateTime,FClearTime,FClearedBy)  select FID,FUserID,FSessionID,FEntityKey,FOperationKey,FGroupID,FObjectID,FCreateTime,now(), " + rc.getUserId() + " from t_mutex_datalock  where FID = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)recId)};
        try (TXHandle handle = TX.requiresNew();){
            try {
                DB.execute((DBRoute)DBRoute.basedata, (String)strInsertSQL, (Object[])params);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                handle.markRollback();
            }
        }
    }

    private List<Map<String, Object>> readDBLock(final String entityKey, final String operationKey, String groupId, String[] dataObjIds) {
        if (dataObjIds == null || dataObjIds.length == 0) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        params.add(new SqlParameter(":FEntityKey", 12, (Object)entityKey));
        params.add(new SqlParameter(":FOperationKey", 12, (Object)operationKey));
        SqlBuilder sbBuilder = new SqlBuilder();
        sbBuilder.append("select FID,FGroupID,FObjectID from t_mutex_datalock where FEntityKey = ? and FOperationKey = ? and ", params.toArray(new Object[params.size()]));
        if (StringUtils.isNotBlank((CharSequence)groupId)) {
            sbBuilder.append(" FGroupId = ? and ", (Object[])new SqlParameter[]{new SqlParameter(":FGroupId", 12, (Object)groupId)});
        }
        sbBuilder.appendIn("FObjectID", (Object[])dataObjIds);
        List lockList = (List)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sbBuilder, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
                while (rs.next()) {
                    HashMap<String, Object> record = new HashMap<String, Object>();
                    record.put("recordId", rs.getLong("FID"));
                    record.put("entityKey", entityKey);
                    record.put("groupId", rs.getString("FGroupID"));
                    record.put("dataObjId", rs.getString("FObjectID"));
                    record.put("operationKey", operationKey);
                    list.add(record);
                }
                return list;
            }
        });
        return lockList;
    }

    private Map<String, Map<String, Map<String, List<Map<String, Object>>>>> readAllDBLock() {
        String querySQL = "select top 100000 FID, FEntityKey, FGroupID, FOperationKey, FObjectID from t_mutex_datalock ";
        Map lockList = (Map)DB.query((DBRoute)DBRoute.basedata, (String)querySQL, null, (ResultSetHandler)new ResultSetHandler<Map<String, Map<String, Map<String, List<Map<String, Object>>>>>>(){

            public Map<String, Map<String, Map<String, List<Map<String, Object>>>>> handle(ResultSet rs) throws Exception {
                HashMap<String, Map<String, Map<String, List<Map<String, Object>>>>> records = new HashMap<String, Map<String, Map<String, List<Map<String, Object>>>>>();
                while (rs.next()) {
                    HashMap<String, Object> record = new HashMap<String, Object>();
                    Long recId = rs.getLong(1);
                    String entityKey = rs.getString(2);
                    String groupId = rs.getString(3);
                    String operationKey = rs.getString(4);
                    String dataObjId = rs.getString(5);
                    record.put("recordId", recId);
                    record.put("entityKey", entityKey);
                    record.put("groupId", groupId);
                    record.put("dataObjId", dataObjId);
                    record.put("operationKey", operationKey);
                    if (!records.containsKey(entityKey)) {
                        records.put(entityKey, new HashMap());
                    }
                    if (!((Map)records.get(entityKey)).containsKey(groupId)) {
                        ((Map)records.get(entityKey)).put(groupId, new HashMap());
                    }
                    if (!((Map)((Map)records.get(entityKey)).get(groupId)).containsKey(dataObjId)) {
                        ((Map)((Map)records.get(entityKey)).get(groupId)).put(dataObjId, new ArrayList());
                    }
                    ((List)((Map)((Map)records.get(entityKey)).get(groupId)).get(dataObjId)).add(record);
                }
                return records;
            }
        });
        return lockList;
    }

    private String buildLockCacheTypeName(String entityKey, String groupId) {
        String accountId = RequestContext.get().getAccountId();
        String type = accountId + "_datalock_" + entityKey + "_" + groupId;
        return type;
    }

    private String buildNetGroupCacheTypeName() {
        return this.buildLockCacheTypeName("all", "netgroup");
    }

    private void forceReleaseAllLockForUnitTest() {
        Map<String, Map<String, Map<String, String>>> netGroups = this.readAllCacheNetGroups();
        for (Map.Entry<String, Map<String, Map<String, String>>> entity : netGroups.entrySet()) {
            for (Map.Entry entry : entity.getValue().entrySet()) {
                String cacheType = this.buildLockCacheTypeName(entity.getKey(), (String)entry.getKey());
                Map cacheValues = this.cache.getAll(cacheType);
                HashSet delDataObjIds = new HashSet(16);
                for (Map.Entry data : cacheValues.entrySet()) {
                    delDataObjIds.add(data.getKey());
                }
                if (delDataObjIds.isEmpty()) continue;
                this.cache.remove(cacheType, delDataObjIds.toArray(new String[delDataObjIds.size()]));
            }
        }
        String sql = "DELETE FROM t_mutex_datalock ";
        TXHandle handle = TX.requiresNew();
        Object object = null;
        try {
            try {
                DB.execute((DBRoute)DBRoute.basedata, (String)sql);
            }
            catch (Exception exception) {
                handle.markRollback();
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (handle != null) {
                if (object != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    handle.close();
                }
            }
        }
    }

    @Override
    public IntentLockInfo requireIntent(String dataObjId, String entityKey, String timestamp, String intentKey) {
        if (StringUtils.isNotBlank((CharSequence)entityKey) && StringUtils.isNotBlank((CharSequence)dataObjId) && StringUtils.isNotBlank((CharSequence)intentKey)) {
            try {
                HashMap<String, String> dataObjIdMap = new HashMap<String, String>(16);
                RequestContext rc = RequestContext.get();
                IntentLockInfo lockInfo = new IntentLockInfo(entityKey, dataObjId, timestamp, rc.getUserId());
                dataObjIdMap.put(intentKey, JSONObject.toJSONString((Object)lockInfo));
                log.info("requireIntent:" + this.buildIntentKey(entityKey, dataObjId) + " " + intentKey);
                this.cache.addToSet(this.buildBatchIntentKey(entityKey), new String[]{dataObjId}, this.getDefaultTimeout());
                this.cache.put(this.buildIntentKey(entityKey, dataObjId), dataObjIdMap);
                return lockInfo;
            }
            catch (Exception e) {
                log.error("Fail to requireIntent: " + e.getMessage());
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean batchReleaseIntent(List<Map<String, Set<String>>> data) {
        try (EntityTraceSpan span = null;){
            if (EntityTracer.isRealtime()) {
                span = EntityTracer.create((String)SPAN_TYPE_MUTEX, (String)"DataMutexImpl.batchReleaseIntent", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());
                span.addLocaleTag("data", data);
            }
            for (Map<String, Set<String>> datum : data) {
                for (Map.Entry<String, Set<String>> entry : datum.entrySet()) {
                    String entityKey = entry.getKey();
                    HashSet<String> dataObjIds = new HashSet<String>(16);
                    Set<String> dataObjIdSet = entry.getValue();
                    List<String> dataObjIdList = Arrays.asList(this.cache.getSetValues(this.buildBatchIntentKey(entityKey)));
                    for (String dataObjId : dataObjIdSet) {
                        if (!dataObjIdList.contains(dataObjId)) continue;
                        this.cache.remove(this.buildIntentKey(entityKey, dataObjId));
                        dataObjIds.add(dataObjId);
                    }
                    log.info("batchReleaseIntentLocks:" + entityKey + ":" + StringUtils.join((Object[])dataObjIds.toArray(), (String)","));
                    if (dataObjIds.size() <= 0) continue;
                    String[] dataObjIdArray = dataObjIds.toArray(new String[dataObjIds.size()]);
                    this.cache.removeSetValues(this.buildBatchIntentKey(entityKey), dataObjIdArray);
                }
            }
        }
        return true;
    }

    @Override
    public boolean releaseIntent(String entityKey, String dataObjId) {
        try {
            log.info("releaseIntent: " + this.buildIntentKey(entityKey, dataObjId));
            if (StringUtils.isNotBlank((CharSequence)dataObjId)) {
                this.cache.removeSetValues(this.buildBatchIntentKey(entityKey), new String[]{dataObjId});
            }
            this.cache.remove(this.buildIntentKey(entityKey, dataObjId));
        }
        catch (Exception e) {
            log.error("releaseIntent failed: " + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean releaseIntent(String entityKey, String dataObjId, String intentKey) {
        try {
            log.info("releaseIntentByKey:" + this.buildIntentKey(entityKey, dataObjId) + " " + intentKey);
            this.cache.remove(this.buildIntentKey(entityKey, dataObjId), intentKey);
            Map map = this.cache.getAll(this.buildIntentKey(entityKey, dataObjId));
            if (map.size() == 0) {
                this.cache.removeSetValues(this.buildBatchIntentKey(entityKey), new String[]{dataObjId});
            }
        }
        catch (Exception e) {
            log.error("releaseIntent failed: " + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean checkIntentExist(String entityKey, String dataObjId, String intentKey) {
        String value = (String)this.cache.get(this.buildIntentKey(entityKey, dataObjId), intentKey);
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_MUTEX, (String)"DataMutexImpl.checkIntentExist", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
                span.addLocaleTag("entityKey", (Object)entityKey);
                span.addLocaleTag("dataObjId", (Object)dataObjId);
                span.addLocaleTag("intentKey", (Object)intentKey);
                span.addLocaleTag("cacheValue", (Object)value);
            }
        }
        return value != null;
    }

    private String buildIntentKey(String entityKey, String dataObjId) {
        RequestContext rc = RequestContext.get();
        StringBuilder intentKey = new StringBuilder();
        intentKey.append(HMUTEX).append(rc.getAccountId()).append(':').append(entityKey).append(YX).append(':').append(dataObjId);
        return intentKey.toString();
    }

    private String buildBatchIntentKey(String entityKey) {
        RequestContext rc = RequestContext.get();
        StringBuilder batchIntentKey = new StringBuilder();
        batchIntentKey.append(HMUTEX).append(rc.getAccountId()).append(':').append(entityKey);
        return batchIntentKey.toString();
    }

    private int getDefaultTimeout() {
        String s = System.getProperty("redis.defaulttimeout");
        if (s != null) {
            try {
                return Integer.parseInt(s.trim());
            }
            catch (Exception var3) {
                log.error("redis.defaulttimeout is not legal integer: " + s);
            }
        }
        return 3600;
    }

    private boolean getIsTerminalLimit(String tenantId) {
        String needString = System.getProperty(tenantId + "_login.session.terminalLimit");
        if (StringUtils.isBlank((CharSequence)needString)) {
            needString = System.getProperty("login.session.terminalLimit");
        }
        return "true".equals(needString) || "1".equals(needString);
    }
}

