/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mutex.impl;

import com.alibaba.fastjson.JSON;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.IDService;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.Mutex;
import kd.bos.mutex.impl.MutexBaseInfo;
import kd.bos.mutex.impl.MutexLockDataInfo;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.mutex.lock.ZkStore;

class DataMutexImpl_ZK
extends Mutex
implements DataMutex {
    public static final String MUTEX_ERROR_CODE = "MUTEX_ERROR_CODE";
    private static final long LOCK_KEEP_TIME_MS = Long.parseLong(System.getProperty("mutex.maxkeeptime_h", "8")) * 60L * 60L * 1000L;
    protected String dataObjId;
    protected String dataObjNumber;
    protected String groupId;
    protected String entityKey;
    protected String operationKey;
    private static final String CLIENT = "client";
    private static final String USERID = "userid";
    private static final String FENTITYKEY = ":FEntityKey";
    private static final String FOPERATIONKEY = ":FOperationKey";
    private static final String FGROUPID = ":FGroupID";
    private static final String FOBJECTID = ":FObjectID";

    DataMutexImpl_ZK() {
    }

    @Override
    protected String getLockType() {
        return "data";
    }

    @Override
    public boolean require(String dataObjId, String groupId, String entityKey, String operationKey) {
        return this.require(dataObjId, groupId, entityKey, operationKey, false);
    }

    @Override
    public boolean require(String dataObjId, String groupId, String entityKey, String operationKey, boolean isStrict) {
        MutexLockInfo lockInfo = new MutexLockInfo(dataObjId, null, groupId, entityKey, operationKey, isStrict, null);
        return this.require(lockInfo);
    }

    @Override
    public boolean require(MutexLockInfo mutexLockInfo) {
        this.prepared();
        this.dataObjId = mutexLockInfo.getDataObjId();
        this.dataObjNumber = mutexLockInfo.getDataObjNumber();
        this.groupId = mutexLockInfo.getGroupId();
        this.entityKey = mutexLockInfo.getEntityNumber();
        this.operationKey = mutexLockInfo.getOperationKey();
        this.lockObjKey = this.processSpecialString(this.dataObjId + "_" + this.entityKey + "_" + this.groupId);
        this.lockPath = this.getBasePath() + "/" + this.lockObjKey;
        this.data = this.operationKey.getBytes(UTF_8);
        RequestContext rc = RequestContext.get();
        String globalSessionid = rc.getGlobalSessionId();
        String userId = rc.getUserId();
        String client = rc.getClient();
        if (this.hasLocked(this.lockPath)) {
            if (mutexLockInfo.isStrict() || !this.isSameUserLocked(this.lockPath, userId, client)) {
                return false;
            }
            this.afterLocked(true);
        } else {
            this.writeLock = null;
            if (!this.require(this.lockObjKey)) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void afterLocked(boolean isSuccess) {
        String child_path;
        int ret;
        super.afterLocked(isSuccess);
        if (isSuccess && (ret = ZkStore.write(child_path = this.lockPath + "/" + this.operationKey, String.valueOf(System.currentTimeMillis()))) == 0) {
            try {
                RequestContext rc = RequestContext.get();
                long runUserId = Long.parseLong(rc.getUserId());
                String gSessionId = rc.getGlobalSessionId();
                this.writeDb(this.dataObjId, this.groupId, this.entityKey, this.operationKey, runUserId, gSessionId, null);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                ZkStore.delete(child_path);
                this.deleteEmpNode();
                List<String> children = ZkStore.getChildren(this.lockPath);
                if (children.isEmpty()) {
                    ZkStore.delete(this.lockPath);
                }
                ErrorCode ec = new ErrorCode(MUTEX_ERROR_CODE, ResManager.loadKDString((String)"\u5199DB\u5931\u8d25\uff0c\u5bfc\u81f4\u7533\u8bf7\u4e92\u65a5\u9501\u5931\u8d25.", (String)"DataMutexImpl_ZK_0", (String)"bos-mutex", (Object[])new Object[0]));
                throw new KDException(ec, new Object[0]);
            }
        }
    }

    @Override
    protected int batchAfterLocked(boolean isSuccess, String lockObjKey, String lockPath, String operationKey) {
        super.batchAfterLocked(isSuccess, lockObjKey, lockPath, operationKey);
        if (isSuccess) {
            String child_path = lockPath + "/" + operationKey;
            int ret = ZkStore.write(child_path, String.valueOf(System.currentTimeMillis()));
            return ret;
        }
        return 1;
    }

    @Override
    protected void afterRelease() {
        if (log.isInfoEnabled()) {
            log.info(Thread.currentThread().getName() + " data mutex close.");
        }
    }

    protected boolean hasLocked(String path) {
        return ZkStore.existed(path) && !ZkStore.getChildren(path).isEmpty();
    }

    @Override
    public Map<String, String> getLockInfo(String dataObjId, String groupId, String entityKey) {
        this.prepared();
        String lockObjKey = this.processSpecialString(dataObjId + "_" + entityKey + "_" + groupId);
        String lockPath = this.getBasePath() + "/" + lockObjKey;
        String lockData = ZkStore.read(lockPath, null);
        if (lockData != null) {
            Map lockDataMap = (Map)JSON.parseObject((String)lockData, Map.class);
            return lockDataMap;
        }
        return null;
    }

    @Override
    public List<MutexLockDataInfo> getLockInfo(List<MutexBaseInfo> lockInfo) {
        return null;
    }

    protected boolean isSameSessionLocked(String path, String globalSessionId) {
        String lockData = ZkStore.read(path, null);
        if (lockData != null) {
            Map lockDataMap = (Map)JSON.parseObject((String)lockData, Map.class);
            return globalSessionId.equals(lockDataMap.get("GLOBALSESSION"));
        }
        ErrorCode ec = new ErrorCode("MUTEX_0001", ResManager.loadKDString((String)"\u9501\u8282\u70b9\u7684\u6570\u636e\u9519\u8bef\uff0c\u4e0d\u80fd\u4e3a\u7a7a", (String)"DataMutexImpl_ZK_1", (String)"bos-mutex", (Object[])new Object[0]));
        throw new KDException(ec, new Object[0]);
    }

    protected boolean isSameUserLocked(String path, String userId, String client) {
        String lockData = ZkStore.read(path, null);
        if (lockData != null) {
            Map lockDataMap = (Map)JSON.parseObject((String)lockData, Map.class);
            return userId.equals(lockDataMap.get(USERID)) && client.equals(lockDataMap.get(CLIENT));
        }
        ErrorCode ec = new ErrorCode("MUTEX_0001", ResManager.loadKDString((String)"\u9501\u8282\u70b9\u7684\u6570\u636e\u9519\u8bef\uff0c\u4e0d\u80fd\u4e3a\u7a7a", (String)"DataMutexImpl_ZK_1", (String)"bos-mutex", (Object[])new Object[0]));
        throw new KDException(ec, new Object[0]);
    }

    private void writeDb(String dataObjId, String groupId, String entityKey, String operationKey, long userId, String gSessionId, Date lockTime) {
        String strInsertSQL = "INSERT INTO t_mutex_datalock (FID,FUserID,FSessionID,FEntityKey,FOperationKey,FGroupID,FObjectID,FCreateTime)  VALUES (?, ?, ?, ?, ?, ?, ?, ?) ";
        Object[] params = new SqlParameter[8];
        if (lockTime == null) {
            lockTime = new Date();
        }
        RequestContext rc = RequestContext.get();
        long id = IDService.get().genLongId(rc.getAccountId(), "t_mutex_datalock");
        params[0] = new SqlParameter(":FID", -5, (Object)id);
        params[1] = new SqlParameter(":FUserID", -5, (Object)userId);
        params[2] = new SqlParameter(":FSessionID", 12, (Object)gSessionId);
        params[3] = new SqlParameter(FENTITYKEY, 12, (Object)entityKey);
        params[4] = new SqlParameter(FOPERATIONKEY, 12, (Object)operationKey);
        params[5] = new SqlParameter(FGROUPID, 12, (Object)groupId);
        params[6] = new SqlParameter(FOBJECTID, 12, (Object)dataObjId);
        params[7] = new SqlParameter(":FCreateTime", 93, (Object)lockTime);
        try (TXHandle handle = TX.beginNew();){
            try {
                DB.execute((DBRoute)DBRoute.basedata, (String)strInsertSQL, (Object[])params);
            }
            catch (Exception e) {
                handle.markRollback();
            }
        }
    }

    private SqlParameter[] generateInsertSqlParameter(String dataObjId, String groupId, String entityKey, String operationKey, long userId, String gSessionId, Date lockTime) {
        SqlParameter[] params = new SqlParameter[8];
        if (lockTime == null) {
            lockTime = new Date();
        }
        RequestContext rc = RequestContext.get();
        long id = IDService.get().genLongId(rc.getAccountId(), "t_mutex_datalock");
        params[0] = new SqlParameter(":FID", -5, (Object)id);
        params[1] = new SqlParameter(":FUserID", -5, (Object)userId);
        params[2] = new SqlParameter(":FSessionID", 12, (Object)gSessionId);
        params[3] = new SqlParameter(FENTITYKEY, 12, (Object)entityKey);
        params[4] = new SqlParameter(FOPERATIONKEY, 12, (Object)operationKey);
        params[5] = new SqlParameter(FGROUPID, 12, (Object)groupId);
        params[6] = new SqlParameter(FOBJECTID, 12, (Object)dataObjId);
        params[7] = new SqlParameter(":FCreateTime", 93, (Object)lockTime);
        return params;
    }

    private SqlParameter[] generatedeleteSqlParameter(String dataObjId, String groupId, String entityKey, String operationKey) {
        SqlParameter[] params = new SqlParameter[]{new SqlParameter(FENTITYKEY, 12, (Object)entityKey), new SqlParameter(FOPERATIONKEY, 12, (Object)operationKey), new SqlParameter(FOBJECTID, 12, (Object)dataObjId), new SqlParameter(FGROUPID, 12, (Object)groupId)};
        return params;
    }

    private void batchDeleteRecord(List<Object[]> list) {
        if (list.size() == 0) {
            return;
        }
        String deleteSql = "delete from t_mutex_datalock where FEntityKey = ? and FOperationKey = ? and FObjectID = ? and FgroupID = ?";
        try (TXHandle handle = TX.beginNew();){
            try {
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)deleteSql, list);
            }
            catch (Exception e) {
                handle.markRollback();
            }
        }
    }

    private void batchWriteDb(List<Object[]> list) {
        if (list.size() == 0) {
            return;
        }
        String strInsertSQL = "INSERT INTO t_mutex_datalock (FID,FUserID,FSessionID,FEntityKey,FOperationKey,FGroupID,FObjectID,FCreateTime)  VALUES (?, ?, ?, ?, ?, ?, ?, ?) ";
        try (TXHandle handle = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)strInsertSQL, list);
            }
            catch (Exception e) {
                handle.markRollback();
            }
        }
    }

    @Override
    public boolean release(String dataObjId, String entityKey, String operationKey) {
        return this.release(dataObjId, entityKey, operationKey, false);
    }

    @Override
    public boolean forcerelease(String dataObjId, String entityKey, String operationKey) {
        return this.release(dataObjId, entityKey, operationKey, true);
    }

    private boolean release(String dataObjId, String entityKey, String operationKey, boolean isForce) {
        this.prepared();
        String querySQL = "select FID,FGroupID from t_mutex_datalock where FEntityKey = ? and FOperationKey = ? and FObjectID = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(FENTITYKEY, 12, (Object)entityKey), new SqlParameter(FOPERATIONKEY, 12, (Object)operationKey), new SqlParameter(FOBJECTID, 12, (Object)dataObjId)};
        String deleteSql = "delete from t_mutex_datalock where fid = ? ";
        boolean result = false;
        try (TXHandle handle = TX.beginNew();){
            try {
                result = (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)querySQL, (Object[])params, rs -> {
                    boolean found = false;
                    while (rs.next()) {
                        String groupId = rs.getString("FGroupID");
                        Long recId = rs.getLong("FID");
                        String lockObjKey = this.processSpecialString(dataObjId + "_" + entityKey + "_" + groupId);
                        String path = this.getBasePath() + "/" + lockObjKey;
                        String child_path = path + "/" + operationKey;
                        ZkStore.delete(child_path);
                        List<String> children = ZkStore.getChildren(path);
                        if (children.isEmpty()) {
                            ZkStore.delete(path);
                        } else {
                            log.error(String.format("\u9501[%s]\u88ab\u591a\u4e2a\u64cd\u4f5c\u9501\u4f4f\uff0c\u6ca1\u6709\u6e05\u9664\uff0c\u8fd8\u6709%s\u4e2a\u64cd\u4f5c", lockObjKey, children.size()));
                        }
                        if (isForce) {
                            this.writeForceLog(recId);
                        }
                        Object[] delParams = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)recId)};
                        DB.execute((DBRoute)DBRoute.basedata, (String)deleteSql, (Object[])delParams);
                        found = true;
                    }
                    return found;
                });
            }
            catch (Exception e) {
                log.error(String.format("\u9501\u6e05\u9664\u5931\u8d25 %s-%s-%s", entityKey, dataObjId, operationKey), (Throwable)e);
                handle.markRollback();
            }
        }
        if (!result) {
            String lockObjKeyPrex = this.processSpecialString(dataObjId + "_" + entityKey + "_");
            List<String> childrenKeys = ZkStore.getChildren(this.getBasePath());
            for (String lockObjKey : childrenKeys) {
                if (!lockObjKey.startsWith(lockObjKeyPrex)) continue;
                String lock_path = this.getBasePath() + "/" + lockObjKey;
                String child_path = lock_path + "/" + operationKey;
                ZkStore.delete(child_path);
                List<String> children = ZkStore.getChildren(lock_path);
                if (!children.isEmpty()) continue;
                ZkStore.delete(lock_path);
            }
        }
        return true;
    }

    private void writeForceLog(Long recId) {
        RequestContext rc = RequestContext.get();
        String strInsertSQL = "INSERT INTO t_mutex_cleardatalock  (FID,FUserID,FSessionID,FEntityKey,FOperationKey,FGroupID,FObjectID,FCreateTime,FClearTime,FClearedBy)  select FID,FUserID,FSessionID,FEntityKey,FOperationKey,FGroupID,FObjectID,FCreateTime,now(), " + rc.getUserId() + " from t_mutex_datalock  where FID = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)recId)};
        try (TXHandle handle = TX.beginNew();){
            try {
                DB.execute((DBRoute)DBRoute.basedata, (String)strInsertSQL, (Object[])params);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                handle.markRollback();
            }
        }
    }

    @Override
    public void releaseTimeoutLock() {
        this.prepared();
        List<String> childrenKeys = ZkStore.getChildren(this.getBasePath());
        ArrayList<SqlParameter[]> sqlParams = new ArrayList<SqlParameter[]>();
        for (String childrenKey : childrenKeys) {
            long keepLockTime;
            Map lockInfo;
            String lockedTimeStr;
            String lockPath = this.getBasePath() + "/" + childrenKey;
            String data = ZkStore.read(lockPath, null);
            if (!StringUtils.isNotBlank((CharSequence)data) || !StringUtils.isNotBlank((CharSequence)(lockedTimeStr = (String)(lockInfo = (Map)JSON.parseObject((String)data, Map.class)).get("lockedTime"))) || !((double)(keepLockTime = System.currentTimeMillis() - Long.parseLong(lockedTimeStr)) > 1.5 * (double)LOCK_KEEP_TIME_MS)) continue;
            ZkStore.deleteAll(lockPath);
            String lockObjKey = String.valueOf(lockInfo.get("lockObjKey"));
            int fIndex = lockObjKey.indexOf(95);
            if (fIndex < 0) continue;
            int lIndex = lockObjKey.indexOf("_default_netctrl");
            if (lIndex < 0) {
                lIndex = lockObjKey.lastIndexOf(95);
            }
            String objId = lockObjKey.substring(0, fIndex);
            String entityKey = lockObjKey.substring(fIndex + 1, lIndex);
            SqlParameter[] parameters = new SqlParameter[]{new SqlParameter(FENTITYKEY, 12, (Object)entityKey), new SqlParameter(FOBJECTID, 12, (Object)objId)};
            sqlParams.add(parameters);
        }
        if (!sqlParams.isEmpty()) {
            String sql = "DELETE FROM T_MUTEX_DATALOCK WHERE FENTITYKEY = ? AND FOBJECTID = ?";
            try (TXHandle handle = TX.requiresNew();){
                try {
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, sqlParams);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    handle.markRollback();
                }
            }
        }
    }

    @Override
    public void refreshLocks() {
        this.prepared();
        String querySQL = "select FID from t_mutex_datalock where FEntityKey = ? and FOperationKey = ? and FObjectID = ? and FGroupID = ?";
        List<String> childrenKeys = ZkStore.getChildren(this.getBasePath());
        for (String lockObjKey : childrenKeys) {
            int fIndex = lockObjKey.indexOf(95);
            if (fIndex < 0) continue;
            int lIndex = lockObjKey.indexOf("_default_netctrl");
            if (lIndex < 0) {
                lIndex = lockObjKey.lastIndexOf(95);
            }
            String t_ObjId = lockObjKey.substring(0, fIndex);
            String t_EntityKey = lockObjKey.substring(fIndex + 1, lIndex);
            String t_GroupId = lockObjKey.substring(lIndex + 1);
            String childPath = this.getBasePath() + "/" + this.processSpecialString(lockObjKey);
            List<String> childrenOpers = ZkStore.getChildren(childPath);
            for (String operkey : childrenOpers) {
                Object[] params = new SqlParameter[]{new SqlParameter(FENTITYKEY, 12, (Object)t_EntityKey), new SqlParameter(FOPERATIONKEY, 12, (Object)operkey), new SqlParameter(FOBJECTID, 12, (Object)t_ObjId), new SqlParameter(FGROUPID, 12, (Object)t_GroupId)};
                boolean found = (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)querySQL, (Object[])params, rs -> rs.next());
                if (found) continue;
                List<String> children = ZkStore.getChildren(childPath);
                for (String child : children) {
                    ZkStore.delete(childPath + "/" + child);
                }
                ZkStore.delete(childPath);
            }
            if (!childrenOpers.isEmpty()) continue;
            ZkStore.delete(childPath);
        }
    }

    @Override
    public Map<String, Boolean> batchRelease(List<Map<String, Object>> data) {
        log.info("\u6279\u91cf\u5220\u9664\u542f\u52a8\u65f6\u95f4-" + new Date());
        this.prepared();
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        ArrayList<Object[]> sqlList = new ArrayList<Object[]>();
        for (Map<String, Object> info : data) {
            String dataObjId = (String)info.get("dataObjId");
            String groupId = (String)info.get("groupId");
            String entityKey = (String)info.get("entityKey");
            String operationKey = (String)info.get("operationKey");
            String lockObjKey = this.processSpecialString(dataObjId + "_" + entityKey + "_" + groupId);
            if (this.batchRelease(dataObjId, entityKey, groupId, operationKey)) {
                result.put(dataObjId, Boolean.TRUE);
                sqlList.add(this.generatedeleteSqlParameter(dataObjId, groupId, entityKey, operationKey));
                continue;
            }
            result.put(dataObjId, Boolean.FALSE);
        }
        log.info("\u6279\u91cf\u5220\u9664zk\u5b8c\u6210\u65f6\u95f4-" + new Date());
        this.batchDeleteRecord(sqlList);
        log.info("\u6279\u91cf\u5220\u9664\u5b8c\u6210\u65f6\u95f4-" + new Date());
        return result;
    }

    private boolean batchRelease(String dataObjId, String entityKey, String groupId, String operationKey) {
        this.prepared();
        String lockObjKey = this.processSpecialString(dataObjId + "_" + entityKey + "_" + groupId);
        String path = this.getBasePath() + "/" + lockObjKey;
        String child_path = path + "/" + operationKey;
        try {
            ZkStore.delete(child_path);
            List<String> children = ZkStore.getChildren(path);
            if (children.isEmpty()) {
                ZkStore.delete(path);
            } else {
                log.error(String.format("\u9501[%s]\u88ab\u591a\u4e2a\u64cd\u4f5c\u9501\u4f4f\uff0c\u6ca1\u6709\u6e05\u9664\uff0c\u8fd8\u6709%s\u4e2a\u64cd\u4f5c", lockObjKey, children.size()));
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Boolean> batchrequire(List<Map<String, Object>> data) {
        log.info("\u6279\u91cf\u7533\u8bf7\u542f\u52a8\u65f6\u95f4-" + new Date());
        this.prepared();
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        RequestContext rc = RequestContext.get();
        for (Map<String, Object> info : data) {
            String dataObjId = (String)info.get("dataObjId");
            String groupId = (String)info.get("groupId");
            String entityKey = (String)info.get("entityKey");
            String operationKey = (String)info.get("operationKey");
            boolean isStrict = StringUtils.isBlank((Object)info.get("isStrict")) ? true : (Boolean)info.get("isStrict");
            String lockObjKey = this.processSpecialString(dataObjId + "_" + entityKey + "_" + groupId);
            String lockPath = this.getBasePath() + "/" + lockObjKey;
            byte[] datas = operationKey.getBytes(UTF_8);
            String globalSessionid = rc.getGlobalSessionId();
            String userId = rc.getUserId();
            String client = rc.getClient();
            if (this.hasLocked(lockPath)) {
                if (isStrict || !this.isSameUserLocked(lockPath, userId, client)) {
                    result.put(dataObjId, Boolean.FALSE);
                    continue;
                }
                if (this.batchAfterLocked(true, lockObjKey, lockPath, operationKey) == 1) {
                    list.add(this.generateInsertSqlParameter(dataObjId, groupId, entityKey, operationKey, Long.parseLong(userId), globalSessionid, null));
                }
                result.put(dataObjId, Boolean.TRUE);
                continue;
            }
            this.writeLocks.put(lockPath, null);
            if (!this.batchRequire(lockObjKey, operationKey)) {
                result.put(dataObjId, Boolean.FALSE);
            } else {
                result.put(dataObjId, Boolean.TRUE);
            }
            list.add(this.generateInsertSqlParameter(dataObjId, groupId, entityKey, operationKey, Long.parseLong(userId), globalSessionid, null));
        }
        log.info("\u6279\u91cf\u7533\u8bf7zk\u7ed3\u675f\u65f6\u95f4-" + new Date());
        this.batchWriteDb(list);
        log.info("\u6279\u91cf\u7533\u8bf7db\u7ed3\u675f\u65f6\u95f4-" + new Date());
        return result;
    }

    @Override
    public boolean releaseByReLogin() {
        RequestContext requestContext = RequestContext.get();
        long userId = requestContext.getCurrUserId();
        String client = requestContext.getClient();
        String nowSessionId = requestContext.getGlobalSessionId();
        String mutexRootPath = String.format("%s/%s", Mutex.MUTEX_LOCK_PATH, RequestContext.get().getAccountId());
        String dataLockRootPath = String.format("%s/%s", mutexRootPath, this.getLockType());
        Object[] params = new SqlParameter[]{new SqlParameter(":FUSERID", -5, (Object)userId)};
        String sql = "SELECT  FID,  FUSERID,  FSESSIONID,  FOPERATIONKEY, FENTITYKEY,  FGROUPID,  FOBJECTID,  FCREATETIME FROM t_mutex_datalock WHERE  FUSERID = ?";
        List lockList = new ArrayList();
        try {
            lockList = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, rs -> {
                ArrayList list = new ArrayList();
                try {
                    while (rs.next()) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("id", rs.getString(1));
                        map.put(USERID, rs.getString(2));
                        map.put("sessionid", rs.getString(3));
                        map.put("operationkey", rs.getString(4));
                        map.put("entitykey", rs.getString(5));
                        map.put("groupid", rs.getString(6));
                        map.put("objectid", rs.getString(7));
                        list.add(map);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                }
                return list;
            });
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        ArrayList<String> deleteRecord = new ArrayList<String>();
        if (lockList != null && lockList.size() > 0) {
            for (Map lock : lockList) {
                String entityKey = lock.get("entitykey").toString();
                String groupId = lock.get("groupid").toString();
                String objectId = lock.get("objectid").toString();
                String lockObjKey = this.processSpecialString(objectId + "_" + (String)entityKey + "_" + groupId);
                String path = dataLockRootPath + "/" + lockObjKey;
                try {
                    if (ZkStore.existed(path)) {
                        String data = ZkStore.read(path, null);
                        Map zkLockInfo = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                        if (!StringUtils.isNotBlank(zkLockInfo.get(CLIENT)) || !StringUtils.isNotBlank(zkLockInfo.get(USERID)) || !StringUtils.isNotBlank(zkLockInfo.get("GLOBALSESSION")) || !zkLockInfo.get(CLIENT).toString().equals(client) || !zkLockInfo.get(USERID).toString().equals(String.valueOf(userId)) || zkLockInfo.get("GLOBALSESSION").toString().equals(nowSessionId)) continue;
                        ZkStore.deleteAll(path);
                        deleteRecord.add(lock.get("id").toString());
                        continue;
                    }
                    deleteRecord.add(lock.get("id").toString());
                }
                catch (Exception e) {
                    log.error("\u767b\u5f55\u6e05\u9664\u9501\u5931\u8d25:" + e.getMessage());
                }
            }
            if (deleteRecord.size() > 0) {
                String deleteSql = "delete from t_mutex_datalock where fid = ? ";
                ArrayList<SqlParameter[]> deleteList = new ArrayList<SqlParameter[]>(10);
                for (String id : deleteRecord) {
                    SqlParameter[] delParams = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)Long.parseLong(id))};
                    deleteList.add(delParams);
                }
                try (TXHandle handle = TX.beginNew();){
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)deleteSql, deleteList);
                }
                catch (Exception e) {
                    log.error(String.format("\u9501\u6e05\u9664\u5931\u8d25   %s", userId), (Throwable)e);
                }
            }
        }
        return true;
    }
}

