/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mutex.impl;

import kd.bos.mutex.DataMutex;
import kd.bos.mutex.FunctionMutex;
import kd.bos.mutex.LockType;
import kd.bos.mutex.ShareLock;
import kd.bos.mutex.impl.DataMutexImpl;
import kd.bos.mutex.impl.FunctionMutexImpl;
import kd.bos.mutex.impl.FunctionMutexImpl_DB;
import kd.bos.mutex.impl.ShareLockImpl;
import kd.bos.mutex.impl.ShareLockImpl_DB;

public class MutexFactory {
    public static DataMutex createDataMutex() {
        return new DataMutexImpl();
    }

    @Deprecated
    public static FunctionMutex createFunctionMutex() {
        return new FunctionMutexImpl();
    }

    public static FunctionMutex createFunctionMutex(LockType lockType) {
        FunctionMutexImpl functionMutex = null;
        switch (lockType) {
            case DB: {
                functionMutex = new FunctionMutexImpl_DB();
                break;
            }
            default: {
                functionMutex = new FunctionMutexImpl();
            }
        }
        return functionMutex;
    }

    public static ShareLock createSharkLock(LockType lockType) {
        ShareLockImpl shareLock = null;
        switch (lockType) {
            case DB: {
                shareLock = new ShareLockImpl_DB();
                break;
            }
            default: {
                shareLock = new ShareLockImpl();
            }
        }
        return shareLock;
    }
}

