/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mutex.impl;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.ShareLock;
import kd.bos.mutex.impl.Mutex;

public class ShareLockImpl
extends Mutex
implements ShareLock {
    private static final Log log = LogFactory.getLog(ShareLockImpl.class);
    private static final String DATA_KEEPTIME = "keeptime";
    private static final String DATA_LOCKEDTIME = "lockedTime";
    private String flag = null;
    private boolean isShareLock = true;

    @Override
    public boolean requireLock(String key, boolean shared) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        this.prepared();
        this.flag = UUID.randomUUID().toString();
        this.data = String.valueOf(shared).getBytes(UTF_8);
        this.lockObjKey = this.processSpecialString(key);
        this.isShareLock = shared;
        this.lockPath = this.getBasePath() + "/" + this.lockObjKey;
        return this.requireLockInner(0);
    }

    private boolean requireLockInner(int tryCount) {
        if (tryCount > 3) {
            return false;
        }
        if (this.hasLocked(this.lockPath)) {
            String lockType;
            String data = null;
            try {
                data = this.getDataStore().read(this.lockPath);
            }
            catch (KDException e) {
                log.info("Share lock deleteed,read lock error!", (Object)e);
                return this.requireNewLock(++tryCount);
            }
            if (data == null || data.trim().length() == 0) {
                return this.requireLockInner(++tryCount);
            }
            Map mapData = (Map)JSON.parseObject((String)data, Map.class);
            if (mapData.containsKey(DATA_KEEPTIME)) {
                long timeout = Long.parseLong((String)mapData.get(DATA_KEEPTIME));
                long lockTime = Long.parseLong((String)mapData.get(DATA_LOCKEDTIME));
                long currTime = System.currentTimeMillis();
                if (currTime - lockTime > timeout * 1000L) {
                    this.getDataStore().deleteAll(this.lockPath);
                    return this.requireLockInner(++tryCount);
                }
            }
            if ("true".equalsIgnoreCase(lockType = (String)mapData.get("data"))) {
                if (this.isShareLock) {
                    try {
                        this.succ();
                        mapData.put(DATA_LOCKEDTIME, String.valueOf(System.currentTimeMillis()));
                        this.getDataStore().write(this.lockPath, JSON.toJSONString((Object)mapData));
                    }
                    catch (KDException e) {
                        log.info("Share lock deleteed,read lock error!", (Object)e);
                        return this.requireNewLock(++tryCount);
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        return this.requireNewLock(tryCount);
    }

    private boolean requireNewLock(int tryCount) {
        this.resetWLock();
        if (!this.require(this.lockObjKey)) {
            if (this.isShareLock) {
                return this.requireLockInner(++tryCount);
            }
            return false;
        }
        this.succ();
        return true;
    }

    private void succ() {
        String childrenPath = this.lockPath + "/" + this.flag;
        this.getDataStore().write(childrenPath, String.valueOf(this.isShareLock));
    }

    @Override
    protected void afterRelease() {
        List<String> children;
        if (log.isInfoEnabled()) {
            log.info(Thread.currentThread().getName() + " share lock close.");
        }
        String childrenPath = this.lockPath + "/" + this.flag;
        boolean isSuccessLock = this.getDataStore().existed(childrenPath);
        if (isSuccessLock) {
            this.getDataStore().delete(childrenPath);
        }
        if (this.getDataStore().existed(this.lockPath) && isSuccessLock && (children = this.getDataStore().getChildren(this.lockPath)).isEmpty()) {
            this.getDataStore().delete(this.lockPath);
        }
    }

    protected boolean hasLocked(String path) {
        return this.getDataStore().existed(path);
    }

    @Override
    public void release() {
        super.release();
        this.afterRelease();
    }

    @Override
    public void forceRelease(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        this.prepared();
        String lockObjKey = this.processSpecialString(key);
        String lockPath = this.getBasePath() + "/" + lockObjKey;
        if (this.hasLocked(lockPath)) {
            this.getDataStore().deleteAll(lockPath);
        }
    }

    @Override
    public void setTimeout(long keeptime_s) {
        if (keeptime_s > 0L) {
            this.keeptime = keeptime_s;
        }
    }

    @Override
    public boolean setTimeout(String key, long keeptime_s, boolean refreshLock) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        this.prepared();
        String lockObjKey = this.processSpecialString(key);
        String lockPath = this.getBasePath() + "/" + lockObjKey;
        if (this.hasLocked(lockPath)) {
            String data = this.getDataStore().read(lockPath);
            Map mapData = (Map)JSON.parseObject((String)data, Map.class);
            mapData.put(DATA_KEEPTIME, String.valueOf(keeptime_s));
            if (refreshLock) {
                mapData.put(DATA_LOCKEDTIME, String.valueOf(System.currentTimeMillis()));
            }
            this.getDataStore().write(lockPath, JSON.toJSONString((Object)mapData));
            return true;
        }
        return false;
    }

    @Override
    public boolean refreshLock(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        this.prepared();
        String lockObjKey = this.processSpecialString(key);
        String lockPath = this.getBasePath() + "/" + lockObjKey;
        if (this.hasLocked(lockPath)) {
            String data = this.getDataStore().read(lockPath);
            Map mapData = (Map)JSON.parseObject((String)data, Map.class);
            mapData.put(DATA_LOCKEDTIME, String.valueOf(System.currentTimeMillis()));
            this.getDataStore().write(lockPath, JSON.toJSONString((Object)mapData));
            return true;
        }
        return false;
    }
}

