/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mutex.lock;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class DbStore {
    private static final Log log = LogFactory.getLog(DbStore.class);
    private static final String FIELD_PATH = "FPath";
    private static final String FIELD_USERID = "FUserId";
    private static final String FIELD_CREATE = "FCreateTime";
    private static final String FIELD_OVER = "FOverTime";
    private static final String FIELD_DATA = "FData";
    private static final String FIELD_MAXSEQ = "FMaxSeq";
    private static final String SQL_INSERT = "INSERT INTO t_mutex_lock (FPath, FUserId, FCreateTime, FOverTime, FData, FMaxSeq) values (?,?,?,?,?,?)";
    private static final String SQL_UPDATE_DATA = "UPDATE t_mutex_lock set FData = ? WHERE FPath = ? ";
    private static final String SQL_ADD_SEQ = "UPDATE t_mutex_lock set FMaxSeq = FMaxSeq + 1 WHERE FPath = ? ";
    private static final String SQL_DELETE = "DELETE FROM t_mutex_lock WHERE FPath = ?";
    private static final String SQL_DELETE_CHILD = "DELETE FROM t_mutex_lock WHERE FPath like ?";
    private static final String SQL_READ_DATA = "SELECT FPath, FData FROM t_mutex_lock WHERE FPath = ? ";
    private static final String SQL_READ_CHILD = "SELECT FPath FROM t_mutex_lock WHERE FPath like ? ";
    private static final String SQL_READ_OVERTIME = "SELECT FPath, FOverTime FROM t_mutex_lock WHERE FPath like ? ORDER BY FPath desc ";
    private static final String SQL_READ_MAXSEQ = "SELECT FPath, FMaxSeq FROM t_mutex_lock WHERE FPath = ? ";
    private static final String SQL_EXISTS_PATH = "SELECT top 1 FPath FROM t_mutex_lock WHERE FPath = ? ";
    private static final String SQL_EXISTS_CHILD = "SELECT top 1 FPath FROM t_mutex_lock WHERE FPath like ? ";
    private static final String SQL_LOCK_RECORD = "UPDATE t_mutex_lock set FMaxSeq = FMaxSeq WHERE FPath = ? ";
    private static final int MAX_CLEAR_ROWS = 5000;

    private static DBRoute getDBRoute() {
        return DBRoute.base;
    }

    private static long getLockKeepTime_ms() {
        return Long.parseLong(System.getProperty("mutex.maxkeeptime_h", "8")) * 60L * 60L * 1000L;
    }

    private DbStore() {
    }

    public static String read(String path) {
        Object[] params = new Object[]{new SqlParameter(FIELD_PATH, 12, (Object)path)};
        Tuple result = (Tuple)DB.query((DBRoute)DbStore.getDBRoute(), (String)SQL_READ_DATA, (Object[])params, (ResultSetHandler)new ResultSetHandler<Tuple<String, Boolean>>(){

            public Tuple<String, Boolean> handle(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    return new Tuple((Object)resultSet.getString(DbStore.FIELD_DATA), (Object)true);
                }
                return null;
            }
        });
        if (result != null) {
            return (String)result.item1;
        }
        throw new KDException(new ErrorCode("kd.bos.mutex.lock.DbStore#notexist", ""), new Object[]{"path don't exist: " + path});
    }

    public static List<String> getChildren(String path) {
        Object[] params = new Object[]{new SqlParameter(FIELD_PATH, 12, (Object)(path + "/%"))};
        List childPaths = (List)DB.query((DBRoute)DbStore.getDBRoute(), (String)SQL_READ_CHILD, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet resultSet) throws Exception {
                ArrayList<String> list = new ArrayList<String>(8);
                while (resultSet.next()) {
                    list.add(resultSet.getString(DbStore.FIELD_PATH));
                }
                return list;
            }
        });
        if (childPaths.isEmpty()) {
            return childPaths;
        }
        ArrayList<String> result = new ArrayList<String>(childPaths.size());
        int beginIndex = path.length() + 1;
        for (String childPath : childPaths) {
            String temp = childPath.substring(beginIndex, childPath.length());
            if (temp.indexOf(47) >= 0) continue;
            result.add(temp);
        }
        return result;
    }

    public static boolean existed(String path) {
        Object[] params = new Object[]{new SqlParameter(FIELD_PATH, 12, (Object)path)};
        return (Boolean)DB.query((DBRoute)DbStore.getDBRoute(), (String)SQL_EXISTS_PATH, (Object[])params, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet resultSet) throws Exception {
                return resultSet.next();
            }
        });
    }

    private static boolean existedChildren(String path) {
        Object[] params = new Object[]{new SqlParameter(FIELD_PATH, 12, (Object)(path + "/%"))};
        return (Boolean)DB.query((DBRoute)DbStore.getDBRoute(), (String)SQL_EXISTS_CHILD, (Object[])params, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet resultSet) throws Exception {
                return resultSet.next();
            }
        });
    }

    public static void ensureExisted(String path, String data) {
        if (!DbStore.existed(path)) {
            DbStore.createIgnoreExist(path, data);
        }
    }

    public static String create(String path, String data) {
        Date createTime = new Date();
        Date overTime = new Date(createTime.getTime() + DbStore.getLockKeepTime_ms());
        Object[] params = new Object[]{new SqlParameter(FIELD_PATH, 12, (Object)path), new SqlParameter(FIELD_USERID, -5, (Object)RequestContext.get().getCurrUserId()), new SqlParameter(FIELD_CREATE, 91, (Object)createTime), new SqlParameter(FIELD_OVER, 91, (Object)overTime), new SqlParameter(FIELD_DATA, 2011, (Object)data), new SqlParameter(FIELD_MAXSEQ, 4, (Object)0)};
        try (TXHandle tx = TX.requiresNew();){
            DB.execute((DBRoute)DbStore.getDBRoute(), (String)SQL_INSERT, (Object[])params);
        }
        return path;
    }

    public static String createSeqNode(String path, String prefix, String data) {
        int count = 0;
        int tryCount = 3;
        while (true) {
            try {
                return DbStore.tryCreateSeqNode(path, prefix, data);
            }
            catch (KDException exp) {
                if (exp.getErrorCode() != null && StringUtils.equals((CharSequence)exp.getErrorCode().getCode(), (CharSequence)BosErrorCode.sQLDuplicateKey.getCode())) continue;
                throw exp;
                if (++count < tryCount) continue;
                return null;
            }
            break;
        }
    }

    private static String tryCreateSeqNode(String path, String prefix, String data) {
        Date createTime = new Date();
        Date overTime = new Date(createTime.getTime() + DbStore.getLockKeepTime_ms());
        SqlParameter pathParam = new SqlParameter(FIELD_PATH, 12, (Object)path);
        SqlParameter userParam = new SqlParameter(FIELD_USERID, -5, (Object)RequestContext.get().getCurrUserId());
        SqlParameter createTimeParam = new SqlParameter(FIELD_CREATE, 91, (Object)createTime);
        SqlParameter overTimeParam = new SqlParameter(FIELD_OVER, 91, (Object)overTime);
        SqlParameter dataParam = new SqlParameter(FIELD_DATA, 2011, (Object)data);
        SqlParameter seqParam_0 = new SqlParameter(FIELD_MAXSEQ, 4, (Object)0);
        SqlParameter seqParam_1 = new SqlParameter(FIELD_MAXSEQ, 4, (Object)1);
        String seqPath = null;
        try (TXHandle tx = TX.requiresNew();){
            try {
                DB.execute((DBRoute)DbStore.getDBRoute(), (String)SQL_ADD_SEQ, (Object[])new Object[]{pathParam});
                Integer maxSeq = (Integer)DB.query((DBRoute)DbStore.getDBRoute(), (String)SQL_READ_MAXSEQ, (Object[])new Object[]{pathParam}, (ResultSetHandler)new ResultSetHandler<Integer>(){

                    public Integer handle(ResultSet resultSet) throws Exception {
                        if (resultSet.next()) {
                            return resultSet.getInt(DbStore.FIELD_MAXSEQ);
                        }
                        return null;
                    }
                });
                if (maxSeq == null) {
                    DB.execute((DBRoute)DbStore.getDBRoute(), (String)SQL_INSERT, (Object[])new Object[]{pathParam, userParam, createTimeParam, overTimeParam, dataParam, seqParam_1});
                    maxSeq = 1;
                }
                String seqStr = String.valueOf(100000000 + maxSeq).substring(1);
                seqPath = path + "/" + prefix + seqStr;
                SqlParameter seqPathParam = new SqlParameter(FIELD_PATH, 12, (Object)seqPath);
                DB.execute((DBRoute)DbStore.getDBRoute(), (String)SQL_INSERT, (Object[])new Object[]{seqPathParam, userParam, createTimeParam, overTimeParam, dataParam, seqParam_0});
            }
            catch (RuntimeException exp) {
                tx.markRollback();
                throw exp;
            }
        }
        return seqPath;
    }

    public static String createIgnoreExist(String path, String data) {
        try {
            return DbStore.create(path, data);
        }
        catch (KDException exp) {
            if (exp.getErrorCode() != null && StringUtils.equals((CharSequence)exp.getErrorCode().getCode(), (CharSequence)BosErrorCode.sQLDuplicateKey.getCode())) {
                return path;
            }
            throw exp;
        }
    }

    public static int write(String path, String data) {
        try {
            boolean existed = DbStore.existed(path);
            String sql = null;
            Object[] params = null;
            int result = 0;
            if (!existed) {
                DbStore.create(path, data);
            } else {
                sql = SQL_UPDATE_DATA;
                params = new Object[]{new SqlParameter(FIELD_DATA, 2011, (Object)data), new SqlParameter(FIELD_PATH, 12, (Object)path)};
                try (TXHandle tx = TX.requiresNew();){
                    DB.execute((DBRoute)DbStore.getDBRoute(), (String)sql, (Object[])params);
                }
                result = 1;
            }
            return result;
        }
        catch (Exception exp) {
            log.error((Throwable)exp);
            throw exp;
        }
    }

    public static void delete(String path) {
        SqlParameter paramPath = new SqlParameter(FIELD_PATH, 12, (Object)path);
        try (TXHandle tx = TX.requiresNew();){
            DB.execute((DBRoute)DbStore.getDBRoute(), (String)SQL_LOCK_RECORD, (Object[])new Object[]{paramPath});
            if (!DbStore.existedChildren(path)) {
                DB.execute((DBRoute)DbStore.getDBRoute(), (String)SQL_DELETE, (Object[])new Object[]{paramPath});
            }
        }
    }

    public static void deleteAll(String path) {
        Object[] delParams = new Object[]{new SqlParameter(FIELD_PATH, 12, (Object)path)};
        Object[] delChildParams = new Object[]{new SqlParameter(FIELD_PATH, 12, (Object)(path + "/%"))};
        try (TXHandle tx = TX.requiresNew();){
            try {
                DB.execute((DBRoute)DbStore.getDBRoute(), (String)SQL_DELETE_CHILD, (Object[])delChildParams);
                DB.execute((DBRoute)DBRoute.base, (String)SQL_DELETE, (Object[])delParams);
            }
            catch (RuntimeException exp) {
                tx.markRollback();
                throw exp;
            }
        }
    }

    public static void clearOvertimePath(final String path, int top) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return;
        }
        final int delTopRows = top < 0 || top > 5000 ? 5000 : top;
        final HashSet excludePaths = new HashSet(16);
        Object[] params = new Object[]{new SqlParameter(FIELD_PATH, 12, (Object)(path + "/%"))};
        final long currTime = System.currentTimeMillis();
        List delParams = (List)DB.query((DBRoute)DbStore.getDBRoute(), (String)SQL_READ_OVERTIME, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

            public List<Object[]> handle(ResultSet resultSet) throws Exception {
                int rowCount = 0;
                ArrayList<Object[]> list = new ArrayList<Object[]>(8);
                while (list.size() < delTopRows && resultSet.next()) {
                    ++rowCount;
                    String tempPath = resultSet.getString(DbStore.FIELD_PATH);
                    Timestamp overTime = resultSet.getTimestamp(DbStore.FIELD_OVER);
                    if (Long.compare(overTime.getTime(), currTime) <= 0) {
                        if (excludePaths.contains(tempPath)) continue;
                        list.add(new Object[]{new SqlParameter(DbStore.FIELD_PATH, 12, (Object)tempPath)});
                        continue;
                    }
                    DbStore.splitParentPath(path, tempPath, excludePaths);
                }
                return list;
            }
        });
        if (delParams.isEmpty()) {
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)DbStore.getDBRoute(), (String)SQL_DELETE, (List)delParams);
            }
            catch (RuntimeException exp) {
                tx.markRollback();
                throw exp;
            }
        }
    }

    private static void splitParentPath(String root, String path, Set<String> parentPaths) {
        int index;
        String temp = path;
        while ((index = temp.lastIndexOf(47)) > 0) {
            temp = temp.substring(0, index);
            parentPaths.add(temp);
            if (StringUtils.equals((CharSequence)temp, (CharSequence)root)) continue;
        }
    }
}

