/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mutex.lock;

import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.AutoReleaseLock;
import kd.bos.mutex.LockType;
import kd.bos.mutex.lock.LockListener;
import kd.bos.mutex.lock.ProtocolSupport;
import kd.bos.mutex.lock.WriteLock;
import kd.bos.mutex.lock.WriteLockAdapter;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;

class WriteLockAdapter_ZK
implements WriteLockAdapter {
    private static Log log = LogFactory.getLog(WriteLockAdapter_ZK.class);
    private AutoReleaseLock autoReleaseLock = null;
    private WriteLock writeLock = null;
    private ProtocolSupport support = null;

    public WriteLockAdapter_ZK() {
    }

    public WriteLockAdapter_ZK(String dir, List<ACL> acl) {
        if (dir != null) {
            this.writeLock = new WriteLock(dir, acl);
        }
    }

    public WriteLockAdapter_ZK(String dir, List<ACL> acl, LockListener callback) {
        if (dir != null) {
            this.writeLock = new WriteLock(dir, acl, callback);
        }
    }

    @Override
    public void setData(byte[] data) {
        if (this.writeLock != null) {
            this.writeLock.setData(data);
        }
    }

    @Override
    public void ensurePathExists(String path) {
        if (this.writeLock != null) {
            this.writeLock.ensurePathExists(path);
        } else if (this.support != null) {
            this.support.ensurePathExists(path);
        } else {
            this.support = new ProtocolSupport();
            this.support.ensurePathExists(path);
        }
    }

    @Override
    public boolean lock() {
        boolean locked = false;
        try {
            if (this.writeLock != null) {
                locked = this.writeLock.lock();
                this.autoReleaseResigter(this.writeLock.getDir());
            }
        }
        catch (InterruptedException | KeeperException e) {
            log.error(e);
            locked = false;
        }
        return locked;
    }

    @Override
    public void unlock() {
        if (this.writeLock != null) {
            this.writeLock.unlock();
            this.autoReleaseUnresigter(this.writeLock.getDir());
        }
    }

    @Override
    public void deleteEmpNode() {
        if (this.writeLock != null) {
            this.writeLock.deleteEmpNode();
        }
    }

    @Override
    public void close() {
        if (this.writeLock != null) {
            this.writeLock.close();
        }
    }

    @Override
    public WriteLock getWriteLock() {
        return this.writeLock;
    }

    private void autoReleaseResigter(String path) {
        if (this.autoReleaseLock == null) {
            this.autoReleaseLock = AutoReleaseLock.create();
        }
        this.autoReleaseLock.registerFuncMutex(LockType.ZK, path);
    }

    private void autoReleaseUnresigter(String path) {
        if (this.autoReleaseLock == null) {
            this.autoReleaseLock = AutoReleaseLock.create();
        }
        this.autoReleaseLock.unRegisterFuncMutex(LockType.ZK, path);
    }
}

