/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mutex.lock;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

public class ZkStore {
    private static Log log = LogFactory.getLog((String)"kd.bos.mutex.lock.ZkStore");
    public static final String OPERATE_ZOOKEEPER_FAILED = "OPERATE_ZOOKEEPER_FAILED";
    public static final Charset CHARSET = Charset.forName("UTF-8");
    public static final String ZK_ADDRESS = System.getProperty("mutex.zk.url", System.getProperty("configUrl"));
    private static final List<ACL> DEFAULT_ACL = ZooDefs.Ids.OPEN_ACL_UNSAFE;
    private static final String OPERATE_ZOOKEEPER_DELETE_FAILED = "OPERATE_ZOOKEEPER_DELETE_FAILED";

    public static boolean existed(String path) {
        return ZkStore.existed(ZkStore.getCuratorFramework(), path);
    }

    public static String read(String path, Watcher watcher) {
        return ZkStore.read(ZkStore.getCuratorFramework(), path, watcher);
    }

    public static void delete(String path, int value) {
        ZkStore.delete(ZkStore.getCuratorFramework(), path, value);
    }

    public static void delete(String path) {
        ZkStore.delete(ZkStore.getCuratorFramework(), path, -1);
    }

    public static int write(String path, String value, CreateMode createMode) {
        return ZkStore.write(ZkStore.getCuratorFramework(), path, value, createMode);
    }

    public static int write(String path, String value) {
        return ZkStore.write(ZkStore.getCuratorFramework(), path, value);
    }

    public static List<String> getChildren(String path) {
        return ZkStore.getChildren(ZkStore.getCuratorFramework(), path);
    }

    public static String create(String path, String value, CreateMode createMode) {
        return ZkStore.create(path, value, DEFAULT_ACL, createMode);
    }

    public static void ensureExisted(String path, byte[] data, List<ACL> acl, CreateMode flags) {
        try {
            if (!ZkStore.existed(path)) {
                ZkStore.createIgnoreExist(path, data, acl, flags);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode(OPERATE_ZOOKEEPER_FAILED, "existed path:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path});
        }
    }

    public static void ensureExisted(String path, String value, List<ACL> acl, CreateMode flags) {
        ZkStore.ensureExisted(path, value.getBytes(CHARSET), acl, flags);
    }

    public static String create(String path, String value, List<ACL> acl, CreateMode createMode) {
        return ZkStore.create(path, value.getBytes(CHARSET), acl, createMode);
    }

    public static String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) {
        try {
            return (String)((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)ZkStore.getCuratorFramework().create().creatingParentsIfNeeded().withMode(createMode)).withACL(acl)).forPath(path, data);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode(OPERATE_ZOOKEEPER_FAILED, "create path:%s -data:%s -createMode:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path, new String(data, Charset.forName("utf-8")), createMode.name()});
        }
    }

    public static String createIgnoreExist(String path, String data, CreateMode createMode) {
        return ZkStore.createIgnoreExist(path, data.getBytes(CHARSET), DEFAULT_ACL, createMode);
    }

    public static String createIgnoreExist(String path, byte[] data, List<ACL> acl, CreateMode createMode) {
        try {
            return (String)((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)ZkStore.getCuratorFramework().create().creatingParentsIfNeeded().withMode(createMode)).withACL(acl)).forPath(path, data);
        }
        catch (KeeperException.NodeExistsException e) {
            return path;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode(OPERATE_ZOOKEEPER_FAILED, "createIgnoreExist path:%s -data:%s -createMode:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path, data == null ? "null" : new String(data, Charset.forName("utf-8")), createMode.name()});
        }
    }

    public static void deleteAll(String path) {
        try {
            ZkStore.getCuratorFramework().delete().deletingChildrenIfNeeded().forPath(path);
        }
        catch (KeeperException.NoNodeException | KeeperException.NotEmptyException e) {
            ErrorCode ec = new ErrorCode(OPERATE_ZOOKEEPER_DELETE_FAILED, "delete path\uff1a%s");
            log.warn((Throwable)new KDException(e, ec, new Object[]{path}));
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode(OPERATE_ZOOKEEPER_FAILED, "deleteAll path:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path});
        }
    }

    private static boolean existed(CuratorFramework client, String path) {
        try {
            return client.checkExists().forPath(path) != null;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode(OPERATE_ZOOKEEPER_FAILED, "existed path:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path});
        }
    }

    private static String read(CuratorFramework client, String path, Watcher watcher) {
        try {
            byte[] data = (byte[])((BackgroundPathable)client.getData().usingWatcher(watcher)).forPath(path);
            if (data != null) {
                return new String(data, CHARSET);
            }
            return null;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode(OPERATE_ZOOKEEPER_FAILED, "read path:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path});
        }
    }

    private static void delete(CuratorFramework client, String path, int value) {
        try {
            ((BackgroundPathable)client.delete().withVersion(value)).forPath(path);
        }
        catch (KeeperException.NoNodeException | KeeperException.NotEmptyException e) {
            ErrorCode ec = new ErrorCode(OPERATE_ZOOKEEPER_DELETE_FAILED, "delete path\uff1a%s");
            log.warn((Throwable)new KDException(e, ec, new Object[]{path}));
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode(OPERATE_ZOOKEEPER_DELETE_FAILED, "delete path\uff1a%s - value:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path, value});
        }
    }

    private static List<String> getChildren(CuratorFramework client, String path) {
        try {
            return (List)client.getChildren().forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            return new ArrayList<String>();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode(OPERATE_ZOOKEEPER_FAILED, "get children path:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path});
        }
    }

    private static int write(CuratorFramework client, String path, String value) {
        return ZkStore.write(client, path, value, CreateMode.PERSISTENT);
    }

    private static int write(CuratorFramework client, String path, String value, CreateMode createMode) {
        try {
            boolean existed = ZkStore.existed(client, path);
            if (!existed) {
                ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)client.create().withMode(createMode)).withACL((List)ZooDefs.Ids.OPEN_ACL_UNSAFE)).forPath(path, value.getBytes(CHARSET));
                return 0;
            }
            ((BackgroundPathAndBytesable)client.setData().withVersion(-1)).forPath(path, value.getBytes(CHARSET));
            return 1;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode ec = new ErrorCode(OPERATE_ZOOKEEPER_FAILED, "write path:%s -value:value -createMode:%s");
            throw new KDException((Throwable)e, ec, new Object[]{path, value, createMode.name()});
        }
    }

    private static CuratorFramework getCuratorFramework() {
        return ZKFactory.getZKClient((String)ZK_ADDRESS);
    }
}

