/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.executor;

import java.util.Map;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.ObjectFactory;
import kd.bos.schedule.api.Task;
import kd.bos.schedule.executor.TaskHelper;
import kd.bos.schedule.message.MessageCreator;
import kd.bos.schedule.server.ScheduleService;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class AbstractTask
implements Task {
    private static Log log = LogFactory.getLog(AbstractTask.class);
    protected String taskId = null;
    private MessageHandler messageHandler;
    @SdkInternal
    protected static final String SHAREPARAM = "SHAREPARAM";

    public void setTaskId(String id) {
        this.taskId = id;
    }

    @SdkInternal
    public void setMessageHandle(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    @SdkInternal
    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    private ObjectFactory getObjectFactory() {
        ObjectFactory objectFactory = this.getMessageHandler().getObjFactory();
        if (objectFactory == null) {
            objectFactory = ScheduleService.getInstance().getObjectFactory();
        }
        return objectFactory;
    }

    protected void feedbackProgress(int progress) {
        MessageInfo message = MessageCreator.createProgressMessage((String)this.taskId, (int)progress);
        this.getObjectFactory().getMessageSender().send(message);
    }

    protected void feedbackProgress(int progress, String desc, Map<String, Object> customData) {
        MessageInfo message = MessageCreator.createProgressMessage((String)this.taskId, (int)progress, (String)desc, customData);
        this.getObjectFactory().getMessageSender().send(message);
    }

    protected void feedbackCustomdata(Map<String, Object> customData) {
        MessageInfo message = MessageCreator.createCustomdataMessage((String)this.taskId, customData);
        this.getObjectFactory().getMessageSender().send(message);
    }

    public void stop() throws KDException {
        TaskHelper.stop(this.taskId);
    }

    protected boolean isStop() {
        return TaskHelper.isStop(this.taskId);
    }

    protected void checkIsStop() {
        if (this.isStop()) {
            log.info(String.format("Schedule***task is terminated, taskId:%s", this.taskId));
            this.stop();
        }
    }
}

