/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.executor;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.healthmanage.cluster.ClusterHealth;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.MessageWatcher;
import kd.bos.schedule.executor.ExecutorService;
import kd.bos.schedule.message.RunningTasks;
import kd.bos.schedule.zk.ZkConfig;

@Deprecated
public class ExecutorMessageCustomer
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(ExecutorMessageCustomer.class);
    private static AtomicReference<MessageWatcher> customer = new AtomicReference<Object>(null);
    private static String waitTime = System.getProperty("schedule.executor.initwaittime", "5000");
    private static long retryTime = 600000L;
    private static long interval = 100L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        if (this.ensureReadyToCustom()) {
            MessageInfo message;
            block21: {
                try {
                    message = (MessageInfo)JSON.parseObject((String)((String)body), MessageInfo.class);
                    if (this.checkServerStatus()) break block21;
                    log.error("Schedule***\u5f53\u524d\u8282\u70b9\u4e0d\u5065\u5eb7\uff0c\u8c03\u5ea6\u670d\u52a1\u6682\u4e0d\u6d88\u8d39\u6d88\u606f\uff0c\u4f11\u77203\u5206\u949f\u540e\u518d\u5c1d\u8bd5\u6d88\u8d39\uff0c\u6d88\u606f\uff1a{}", (Object)message);
                    try {
                        Thread.sleep(180000L);
                    }
                    catch (InterruptedException e) {
                        log.error((Throwable)e);
                    }
                    acker.deny(messageId);
                    return;
                }
                catch (Exception e) {
                    log.error("Schedule***\u5904\u7406MQ\u6d88\u606f\uff1a\u5e8f\u5217\u5316\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
                    acker.ack(messageId);
                    return;
                }
            }
            try {
                int retryCnt = 0;
                long totalRetryCnt = retryTime / interval;
                long awaitStartTime = System.currentTimeMillis();
                JobInfo jobInfo = message.fetchJobInfo();
                while (true) {
                    boolean isCanRun;
                    if (isCanRun = this.isCanRun(message.getMessageType())) {
                        MessageType messageType = message.getMessageType();
                        synchronized (messageType) {
                            isCanRun = this.isCanRun(message.getMessageType());
                            if (isCanRun) {
                                long awaitCostTime = System.currentTimeMillis() - awaitStartTime;
                                if (awaitCostTime > retryTime) {
                                    log.info("Schedule***\u4efb\u52a1\u5728\u672c\u5730\u8282\u70b9\u7b49\u5f85\u65f6\u95f4\u8d85\u65f6\uff0c\u8fd4\u56deMQ\u3002message\uff1a{},awaitCostTime:{}", (Object)message, (Object)awaitCostTime);
                                    acker.deny(messageId);
                                }
                                try {
                                    acker.ack(messageId);
                                    log.info("Schedule***\u4eceMQ\u4e2d\u63a5\u6536\u5230\u6d88\u606f\uff1a{}", (Object)message);
                                    message.setMessageMQId(messageId);
                                    customer.get().dispatch(message, acker);
                                }
                                catch (Throwable e) {
                                    log.error("Schedule***\u5904\u7406MQ\u6d88\u606f, \u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)message, (Object)e);
                                }
                            }
                        }
                    }
                    if (!isCanRun) {
                        if ((long)retryCnt <= totalRetryCnt) {
                            Thread.sleep(interval);
                            if (retryCnt == 0) {
                                log.info("Schedule***\u5f53\u524d\u6ca1\u6709\u7a7a\u95f2\u7684MQ\u7ebf\u7a0b\u6d88\u8d39\u6d88\u606f\uff0c\u5c06\u5728\u5f53\u524d\u8282\u70b9\u5c1d\u8bd5\uff0cretryTime:{},interval\uff1a{},message\uff1a{}", new Object[]{retryTime, interval, message});
                            }
                        } else {
                            log.info("Schedule***\u5f53\u524d\u6ca1\u6709\u7a7a\u95f2\u7684MQ\u7ebf\u7a0b\u6d88\u8d39\u6d88\u606f\uff0c\u8fd4\u56deMQ\u3002message\uff1a{}", (Object)message);
                            acker.deny(messageId);
                        }
                    }
                    ++retryCnt;
                }
            }
            catch (Exception e) {
                log.error("Schedule***\u5904\u7406MQ\u6d88\u606f, \u51fa\u73b0\u5f02\u5e38\uff1a" + message, (Throwable)e);
                acker.deny(messageId);
            }
        } else {
            acker.deny(messageId);
        }
    }

    private boolean ensureReadyToCustom() {
        boolean result;
        if (customer.get() == null && ExecutorService.getInstance() != null && ExecutorService.getInstance().isStarted()) {
            customer.compareAndSet(null, ExecutorService.getInstance().getObjectFactory().getMessageWatcher());
        }
        boolean bl = result = customer.get() != null;
        if (!result) {
            try {
                Thread.sleep(Integer.parseInt(waitTime));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return result;
    }

    private boolean isCanRun(MessageType messageType) {
        int maxNumOfWorkThread = ZkConfig.getMaxNumOfWorkThread((MessageType)messageType);
        int runningSize = RunningTasks.getInstance((MessageType)messageType).size();
        return runningSize < maxNumOfWorkThread;
    }

    private boolean checkServerStatus() {
        if (!Instance.isAppSplit()) {
            if ("true".equalsIgnoreCase(ZkConfig.isCheckServerStatusStr())) {
                return this.innerCheckHealth();
            }
            return true;
        }
        if ("false".equalsIgnoreCase(ZkConfig.isCheckServerStatusStr())) {
            return true;
        }
        return this.innerCheckHealth();
    }

    private boolean innerCheckHealth() {
        try {
            boolean isCanRun = true;
            if (!this.isHealth(ClusterHealth.getHealth((String)Instance.getInstanceId()))) {
                isCanRun = false;
            }
            if (!isCanRun) {
                boolean hasOtherHealthIns = false;
                Map appMap = (Map)ClusterHealth.getClusterApplicationHealth().get(Instance.getAppName());
                if (appMap != null && !appMap.isEmpty()) {
                    for (Map.Entry entry : appMap.entrySet()) {
                        if (!this.isHealth((Integer)entry.getKey()) || ((AtomicInteger)entry.getValue()).get() <= 0) continue;
                        hasOtherHealthIns = true;
                        break;
                    }
                }
                if (!hasOtherHealthIns) {
                    log.warn("Schedule***\u5f53\u524d\u8282\u70b9\u4e0d\u5065\u5eb7\uff0c\u4f46\u5f53\u524d\u5e94\u7528\u8282\u70b9\u6ca1\u6709\u5176\u4ed6\u5065\u5eb7\u7684\u8282\u70b9\uff0c\u5f53\u524d\u8282\u70b9\u8c03\u5ea6\u670d\u52a1\u4ecd\u7136\u5904\u7406\u6d88\u606f\u3002");
                    isCanRun = true;
                }
            }
            return isCanRun;
        }
        catch (Exception e) {
            log.error("Schedule***checkhealth error", (Throwable)e);
            return true;
        }
    }

    private boolean isHealth(int level) {
        return HealthLevel.ERROR.getLevel() != level && HealthLevel.OVERLOAD.getLevel() != level;
    }
}

