/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.executor;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.context.RequestContext;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.healthmanage.cluster.ClusterHealth;
import kd.bos.resource.balancer.Configs;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.MessageWatcher;
import kd.bos.schedule.api.ScheduleInfo;
import kd.bos.schedule.api.ScheduleTypeNextEnums;
import kd.bos.schedule.executor.ExecutorService;
import kd.bos.schedule.executor.SchPigeonExecutorMessageCustomer;
import kd.bos.schedule.executor.SchWorkflowExecutorMessageCustomer;
import kd.bos.schedule.message.ReadyTasks;
import kd.bos.schedule.message.RunningTasks;
import kd.bos.schedule.next.observable.util.SchObservableCollectData;
import kd.bos.schedule.utils.RequestContextUtils;
import kd.bos.schedule.utils.ScheduleSortUtils;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.threads.ThreadPools;
import org.joda.time.DateTime;

public class SchExecutorMessageCustomer
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(SchExecutorMessageCustomer.class);
    private static AtomicReference<MessageWatcher> customer = new AtomicReference<Object>(null);
    private static String waitTime = System.getProperty("schedule.executor.initwaittime", "5000");
    private static long retryTime = 600000L;
    private static final Map<MessageType, MessageType> workInitMap = new ConcurrentHashMap<MessageType, MessageType>(8);
    private static final int checkServerTimeInterval = 30;
    private DateTime checkServerTime = DateTime.now();
    private boolean isHealth = true;

    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        block18: {
            if (ZkConfig.isPigeon()) {
                SchPigeonExecutorMessageCustomer customer = new SchPigeonExecutorMessageCustomer();
                customer.onMessage(body, messageId, resend, acker);
                return;
            }
            long beginReceiveMessageTime = System.currentTimeMillis();
            if (this.ensureReadyToCustom()) {
                MessageInfo message;
                try {
                    message = (MessageInfo)JSON.parseObject((String)((String)body), MessageInfo.class);
                    if (MessageType.WorkFlowJOB == message.getMessageType() && Configs.isWorkFlowResourceBalanceEnable()) {
                        SchWorkflowExecutorMessageCustomer customer = new SchWorkflowExecutorMessageCustomer();
                        customer.onMessage(body, messageId, resend, acker);
                        return;
                    }
                    this.reSetServerStatus();
                    if (!this.isHealth) {
                        log.error("Schedule***\u5f53\u524d\u8282\u70b9\u4e0d\u5065\u5eb7\uff0c\u8c03\u5ea6\u670d\u52a1\u6682\u4e0d\u6d88\u8d39\u6d88\u606f\uff0c\u4f11\u77203\u5206\u949f\u540e\u518d\u5c1d\u8bd5\u6d88\u8d39\uff0c\u6d88\u606f\uff1a{}", (Object)message);
                        try {
                            Thread.sleep(180000L);
                        }
                        catch (InterruptedException e) {
                            log.error((Throwable)e);
                        }
                        acker.deny(messageId);
                        return;
                    }
                    message.setMessageMQId(messageId);
                    RequestContextUtils.fillContext((MessageInfo)message, (RequestContext)RequestContext.get());
                }
                catch (Exception e) {
                    log.error("Schedule***\u5904\u7406MQ\u6d88\u606f\uff1a\u5e8f\u5217\u5316\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
                    acker.ack(messageId);
                    long endReceiveMessage = System.currentTimeMillis();
                    long receiveMessageTime = endReceiveMessage - beginReceiveMessageTime;
                    HashMap<String, Long> observableModelData = new HashMap<String, Long>(2);
                    observableModelData.put("receiveMessageTime", receiveMessageTime);
                    SchObservableCollectData.collectData((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getTenantId(), (String)"Client", (String)"receiveMessageError", observableModelData);
                    return;
                }
                JobInfo jobInfo = message.fetchJobInfo();
                try {
                    this.initWork(message.getMessageType());
                    if (this.isCanRun(message)) {
                        try {
                            acker.ack(messageId);
                            if (jobInfo != null && jobInfo.isTaskTrace()) {
                                log.info("Schedule***\u4eceMQ\u4e2d\u63a5\u6536\u5230\u6d88\u606f\uff1a{},resend\uff1a{}", (Object)message, (Object)resend);
                            } else if (log.isDebugEnabled()) {
                                log.debug("Schedule***\u4eceMQ\u4e2d\u63a5\u6536\u5230\u6d88\u606f\uff1a{},resend\uff1a{}", (Object)message, (Object)resend);
                            }
                            long endReceiveMessage = System.currentTimeMillis();
                            long receiveMessageTime = endReceiveMessage - beginReceiveMessageTime;
                            HashMap<String, Long> observableModelData = new HashMap<String, Long>(2);
                            observableModelData.put("receiveMessageTime", receiveMessageTime);
                            observableModelData.put("receiveMessageInfo", (Long)message);
                            SchObservableCollectData.collectData((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)"Client", (String)"receiveMessage", observableModelData);
                            if (jobInfo.getJobType() == JobType.DETECT) {
                                ScheduleInfo scheduleInfo = new ScheduleInfo();
                                scheduleInfo.setTenantId(message.getTenantId());
                                scheduleInfo.setAccountId(message.getAccountId());
                                scheduleInfo.setScheduleType(ScheduleTypeNextEnums.Detect);
                                scheduleInfo.setJobInfo(jobInfo);
                                SchObservableCollectData.collectData((String)message.getTenantId(), (String)message.getAccountId(), (String)"Client", (String)"receiveTaskSuccess", (Object)scheduleInfo);
                            }
                            break block18;
                        }
                        catch (Throwable e) {
                            log.error("Schedule***\u5904\u7406MQ\u6d88\u606f, \u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)message, (Object)e);
                        }
                        break block18;
                    }
                    log.info("Schedule***\u5f53\u524d\u5c31\u7eea\u961f\u5217\u5df2\u6ee1\uff0c\u4e14\u5df2\u5728\u5f53\u524d\u8282\u70b9\u5c1d\u8bd5{}\u5206\u949f\u65e0\u6cd5\u52a0\u5165\u961f\u5217\uff0c\u6d88\u606f\u8fd4\u56deMQ\u3002message\uff1a{}", (Object)(retryTime / 60L / 1000L), (Object)message);
                    acker.deny(messageId);
                }
                catch (Exception e) {
                    log.error("Schedule***\u5904\u7406MQ\u6d88\u606f, \u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)message, (Object)e);
                    acker.deny(messageId);
                }
            } else {
                acker.deny(messageId);
            }
        }
    }

    private boolean ensureReadyToCustom() {
        boolean result;
        if (customer.get() == null && ExecutorService.getInstance() != null && ExecutorService.getInstance().isStarted()) {
            customer.compareAndSet(null, ExecutorService.getInstance().getObjectFactory().getMessageWatcher());
        }
        boolean bl = result = customer.get() != null;
        if (!result) {
            try {
                Thread.sleep(Integer.parseInt(waitTime));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return result;
    }

    private boolean isCanRun(MessageInfo message) {
        ReadyTasks readyTasks = ReadyTasks.getInstance((MessageType)message.getMessageType());
        return readyTasks.in(message, retryTime);
    }

    private boolean checkServerStatus() {
        if (!Instance.isAppSplit()) {
            if ("true".equalsIgnoreCase(ZkConfig.isCheckServerStatusStr())) {
                return this.innerCheckHealth();
            }
            return true;
        }
        if ("false".equalsIgnoreCase(ZkConfig.isCheckServerStatusStr())) {
            return true;
        }
        return this.innerCheckHealth();
    }

    private void reSetServerStatus() {
        boolean afterThirtyMinutes = ScheduleSortUtils.isAfterSomeMinutes((int)30, (DateTime)this.checkServerTime);
        if (afterThirtyMinutes || !this.isHealth) {
            this.isHealth = this.checkServerStatus();
            this.checkServerTime = DateTime.now();
        }
    }

    private boolean innerCheckHealth() {
        try {
            boolean isCanRun = true;
            if (!this.isHealth(ClusterHealth.getHealth((String)Instance.getInstanceId()))) {
                isCanRun = false;
            }
            if (!isCanRun) {
                boolean hasOtherHealthIns = false;
                Map appMap = (Map)ClusterHealth.getClusterApplicationHealth().get(Instance.getAppName());
                if (appMap != null && !appMap.isEmpty()) {
                    for (Map.Entry entry : appMap.entrySet()) {
                        if (!this.isHealth((Integer)entry.getKey()) || ((AtomicInteger)entry.getValue()).get() <= 0) continue;
                        hasOtherHealthIns = true;
                        break;
                    }
                }
                if (!hasOtherHealthIns) {
                    log.warn("Schedule***\u5f53\u524d\u8282\u70b9\u4e0d\u5065\u5eb7\uff0c\u4f46\u5f53\u524d\u5e94\u7528\u8282\u70b9\u6ca1\u6709\u5176\u4ed6\u5065\u5eb7\u7684\u8282\u70b9\uff0c\u5f53\u524d\u8282\u70b9\u8c03\u5ea6\u670d\u52a1\u4ecd\u7136\u5904\u7406\u6d88\u606f\u3002");
                    isCanRun = true;
                }
            }
            return isCanRun;
        }
        catch (Exception e) {
            log.error("Schedule***checkhealth error", (Throwable)e);
            return true;
        }
    }

    private boolean isHealth(int level) {
        return HealthLevel.ERROR.getLevel() != level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWork(MessageType messageType) {
        if (!workInitMap.containsKey(messageType)) {
            Map<MessageType, MessageType> map = workInitMap;
            synchronized (map) {
                if (!workInitMap.containsKey(messageType)) {
                    String name = "BOSSchedule-Executor-Worker-" + messageType;
                    ThreadPools.executeOnce((String)name, (Runnable)new Work(messageType));
                    workInitMap.put(messageType, messageType);
                    log.info("Schedule*** initworker threadpool" + name);
                }
            }
        }
    }

    static class Work
    extends Thread {
        private final MessageType messageType;

        Work(MessageType messageType) {
            this.messageType = messageType;
        }

        @Override
        public void run() {
            try {
                MessageInfo messageInfo;
                log.info("Schedule***messageType:{},Work Thread begin to run", (Object)this.messageType);
                ReadyTasks readyTasks = ReadyTasks.getInstance((MessageType)this.messageType);
                block6: while ((messageInfo = readyTasks.take()) != null) {
                    try {
                        long interval = 100L;
                        int maxRejectTimes = 100;
                        int i = 0;
                        while (true) {
                            if (this.beginRun()) {
                                this.doExecute(messageInfo);
                                continue block6;
                            }
                            try {
                                Thread.sleep((long)i * interval);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (i >= maxRejectTimes) continue;
                            ++i;
                        }
                    }
                    catch (Throwable t) {
                        log.error("Schedule***messageType:{},Work Thread take message error", (Object)this.messageType, (Object)t);
                    }
                }
            }
            catch (Throwable tt) {
                log.error("Schedule***messageType:{},Work Thread error", (Object)this.messageType, (Object)tt);
            }
        }

        private boolean beginRun() {
            int maxNumOfWorkThread = ZkConfig.getMaxNumOfWorkThread((MessageType)this.messageType);
            int runningSize = RunningTasks.getInstance((MessageType)this.messageType).size();
            return runningSize < maxNumOfWorkThread;
        }

        private void doExecute(MessageInfo messageInfo) {
            try {
                ((MessageWatcher)customer.get()).dispatch(messageInfo, null);
            }
            catch (Throwable t) {
                log.error("Schedule*** messageInfo doExecute fail. messageinfo:{}", (Object)messageInfo, (Object)t);
            }
        }
    }
}

