/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.executor;

import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.executor.ExecutorService;
import kd.bos.schedule.message.MessageCreator;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public abstract class TaskHelper {
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));

    public static void feedbackProgress(String taskId, int progress) {
        MessageInfo message = MessageCreator.createProgressMessage((String)taskId, (int)progress);
        ExecutorService.getInstance().getObjectFactory().getMessageSender().send(message);
    }

    public static void feedbackCustomdata(String taskId, Map<String, Object> customData) {
        MessageInfo message = MessageCreator.createCustomdataMessage((String)taskId, customData);
        ExecutorService.getInstance().getObjectFactory().getMessageSender().send(message);
    }

    public static void stop(String taskId) throws KDException {
        ErrorCode ec = new ErrorCode("TASK_STOPED_BY_USER", taskId);
        throw new KDException(ec, new Object[0]);
    }

    public static boolean isStop(String taskId) {
        String type = "TASK";
        String key = RequestContext.get().getAccountId() + "_STOP_" + taskId;
        String stopVal = (String)cache.get(type, key);
        if (stopVal != null && stopVal.length() > 0) {
            return "stop".equalsIgnoreCase(stopVal);
        }
        return ExecutorService.getInstance().getObjectFactory().getTaskDao().isStop(taskId);
    }
}

