/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.executor.zk;

import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ExecutorServerInfo;
import kd.bos.schedule.executor.ExecutorService;
import kd.bos.schedule.executor.ExecutorServiceWrapper;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.schedule.zk.ZkConfig;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;

public class ZkExecutorServiceWrapper
implements ExecutorServiceWrapper {
    private static Log log = LogFactory.getLog(ZkExecutorServiceWrapper.class);
    private final ExecutorService service;

    public ZkExecutorServiceWrapper(ExecutorService service) {
        this.service = service;
    }

    @Override
    public String getName() {
        return "zk executor service";
    }

    @Override
    public void register(ExecutorServerInfo executorServerInfo) {
        String serverName = ZkConfig.getExecutorServerName();
        String path = ZkConfig.getExecutorServerPath() + "/" + serverName;
        Stat stat = (Stat)this.getZkStore().exists(path);
        if (stat != null) {
            this.getZkStore().delete(path);
            log.info("Schedule***Executor Server\u542f\u52a8\u65f6\uff0c\u524d\u9762\u7684session\u6ca1\u6709\u6765\u7684\u53ca\u91ca\u653e\uff0c\u81ea\u52a8\u5220\u9664\u3002");
        }
        this.getZkStore().create(path, SerializationUtils.toJsonString((Object)executorServerInfo), (Object)CreateMode.EPHEMERAL);
    }

    private ActiveKeyValueStore getZkStore() {
        return this.service.getStore();
    }
}

