/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.next.observable.filter;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ScheduleInfo;
import kd.bos.schedule.next.observable.IObservableDataFilter;
import kd.bos.schedule.next.observable.model.ObservableModel;

public class TraceLogFilter
implements IObservableDataFilter {
    private static final String CACHE_KEY = "observable-tracelog";
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("observable-tracelog", new DistributeCacheHAPolicy(true, true));
    Log logger = LogFactory.getLog(TraceLogFilter.class);

    @Override
    public void handle(ObservableModel model) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ScheduleInfo info = null;
            if (!(model.getData() instanceof ScheduleInfo)) {
                return;
            }
            info = (ScheduleInfo)model.getData();
            if (!this.allowTrace(info.getTenantId(), info.getAccountId(), info.getId())) {
                return;
            }
            String dateFormat = sdf.format(new Date());
            Object var5_6 = null;
        }
        catch (Exception e) {
            this.logger.error("Error:Schedule***TraceLogFilter", (Throwable)e);
        }
    }

    private boolean allowTrace(String tenantId, String accountId, String scheduleId) {
        byte[] arg = cache.hget(tenantId + "$" + accountId + "$" + scheduleId, "ENABLE_TRACE".getBytes());
        if (arg == null) {
            return false;
        }
        String open = new String(arg);
        return open.equalsIgnoreCase("OPEN");
    }

    @Override
    public void handle(Object data) {
    }

    @Override
    public void init() {
    }
}

