/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.service;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.dataentity.AbstractDeployEntity;
import kd.bos.schedule.dataentity.DeployScheduleEntity;
import kd.bos.schedule.dataentity.DeployScriptEntity;
import kd.bos.schedule.dataentity.JobMainEntity;
import kd.bos.schedule.dataentity.JobMainEntityL;
import kd.bos.schedule.dataentity.ScheduleDeployInfo;
import kd.bos.schedule.dataentity.ScheduleMainEntity;
import kd.bos.schedule.dataentity.ScheduleMainEntityL;
import kd.bos.schedule.dataentity.TaskDefineMainEntity;
import kd.bos.schedule.dataentity.TaskDefineMainEntityL;
import kd.bos.schedule.dataentity.dao.ScheduleEntityReader;
import kd.bos.schedule.dataentity.dao.ScheduleEntityWriter;
import kd.bos.schedule.dataentity.dao.ScheduleModelBinder;
import kd.bos.schedule.deploy.IScheduleDeployService;
import kd.bos.service.ServiceFactory;
import kd.bos.util.ExceptionUtils;

public class ScheduleDeployServiceImpl
implements IScheduleDeployService {
    private static final Log log = LogFactory.getLog(ScheduleDeployServiceImpl.class);
    public static final String SUCCESS = "success";
    public static final String MSG = "msg";
    private static final String TASK_DEFINE_MAIN_ENTITYL_REPEAT_INDEX_MSG = "taskDefineMainEntityLRepeatIndexMsg";
    private static final String JOB_MAIN_ENTITYL_REPEAT_INDEX_MSG = "jobMainEntityLRepeatIndexMsg";
    private static final String SCHEDULE_MAIN_ENTITYL_REPEAT_INDEX_MSG = "scheduleMainEntityLRepeatIndexMsg";
    private static final String MSERVICE_SCHEDULE = "mservice-schedule";

    private static Map<String, Object> deployData(Map<String, Object> params, String content) {
        HashMap<String, Object> result = new HashMap<String, Object>(10);
        ScheduleModelBinder binder = new ScheduleModelBinder();
        DcxmlSerializer dcxmlSerializer = new DcxmlSerializer((DcBinder)binder);
        dcxmlSerializer.setNewlines(true);
        dcxmlSerializer.setIndent(true);
        Object data = dcxmlSerializer.deserializeFromString(content, null);
        if (data instanceof DeployScheduleEntity) {
            ScheduleMainEntity scheduleMainEntity;
            Map<String, Object> deployResult = ScheduleDeployServiceImpl.deployNew((DeployScheduleEntity)data, params);
            Object modeObj = params.get("deployMode");
            if (!"upgrade".equals(modeObj) && (scheduleMainEntity = ((DeployScheduleEntity)data).getScheduleMainEntity()) != null) {
                ScheduleDeployServiceImpl.afterUpdateSchedules(deployResult, Collections.singletonList(scheduleMainEntity.getId()));
            }
            return deployResult;
        }
        result.put(SUCCESS, true);
        return result;
    }

    private static Map<String, Object> batchDeploy(List<DeployScheduleEntity> datas, List<DeployScriptEntity> deployScriptEntities) {
        SqlBuilder sqlBuilder;
        HashMap<String, Object> result = new HashMap<String, Object>(10);
        if (datas.isEmpty()) {
            result.put(SUCCESS, false);
            String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u8c03\u5ea6\u6587\u4ef6\u53ef\u4ee5\u5bfc\u5165\u3002", (String)"ScheduleDeployServiceImpl_1", (String)MSERVICE_SCHEDULE, (Object[])new Object[0]);
            result.put(MSG, msg);
            log.info(msg);
            return result;
        }
        HashMap<String, Object> overrideSchList = new HashMap<String, Object>(10);
        HashMap overridejobList = new HashMap(10);
        HashMap overrideTaskDefineList = new HashMap(10);
        HashMap<String, ScheduleMainEntity> partOverrideSchList = new HashMap<String, ScheduleMainEntity>(10);
        HashMap<String, JobMainEntity> partOverridejobList = new HashMap<String, JobMainEntity>(10);
        HashMap<String, TaskDefineMainEntity> partOverrideTaskDefineList = new HashMap<String, TaskDefineMainEntity>(10);
        for (DeployScheduleEntity data : datas) {
            if (data.isOverride()) {
                overrideSchList.put(data.getScheduleMainEntity().getId(), data.getScheduleMainEntity());
                data.getJobMainEntityList().forEach(it -> overridejobList.put(it.getId(), it));
                data.getJobTaskMainEntityList().forEach(it -> overrideTaskDefineList.put(it.getId(), it));
                continue;
            }
            partOverrideSchList.put(data.getScheduleMainEntity().getId(), data.getScheduleMainEntity());
            for (JobMainEntity job : data.getJobMainEntityList()) {
                partOverridejobList.put(job.getId(), job);
            }
            for (TaskDefineMainEntity taskdefine : data.getJobTaskMainEntityList()) {
                partOverrideTaskDefineList.put(taskdefine.getId(), taskdefine);
            }
        }
        if (!partOverrideSchList.isEmpty()) {
            sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid,fstatus,fplan,fstarttime,fendtime,frepeatmode from t_sch_schedule where ", new Object[0]).appendIn("fid", partOverrideSchList.keySet().toArray());
            DB.query((DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sqlBuilder, rs -> {
                int size = 0;
                while (rs.next()) {
                    String id = rs.getString("fid");
                    boolean enable = StringUtils.equals((CharSequence)"1", (CharSequence)rs.getString("fstatus"));
                    String cron = rs.getString("fplan");
                    Timestamp start = rs.getTimestamp("fstarttime");
                    Timestamp end = rs.getTimestamp("fendtime");
                    ScheduleMainEntity obj = (ScheduleMainEntity)partOverrideSchList.get(id);
                    if (obj != null) {
                        obj.setEnable(enable);
                        obj.setStartTime((Date)start);
                        obj.setEndTime((Date)end);
                        obj.setCron(cron);
                        obj.setRepeatMode(rs.getString("frepeatmode"));
                    }
                    ++size;
                }
                return size;
            });
        }
        if (!partOverridejobList.isEmpty()) {
            sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid,fstatus from t_sch_job where ", new Object[0]).appendIn("fid", partOverridejobList.keySet().toArray());
            DB.query((DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sqlBuilder, rs -> {
                int size = 0;
                while (rs.next()) {
                    String id = rs.getString("fid");
                    boolean enable = StringUtils.equals((CharSequence)"1", (CharSequence)rs.getString("fstatus"));
                    JobMainEntity obj = (JobMainEntity)partOverridejobList.get(id);
                    if (obj != null) {
                        obj.setEnable(enable);
                    }
                    ++size;
                }
                return size;
            });
        }
        overrideSchList.putAll(partOverrideSchList);
        overridejobList.putAll(partOverridejobList);
        overrideTaskDefineList.putAll(partOverrideTaskDefineList);
        result.put(TASK_DEFINE_MAIN_ENTITYL_REPEAT_INDEX_MSG, ScheduleDeployServiceImpl.checkTaskDefineMainEntityLRepeatIndexs(new ArrayList<TaskDefineMainEntity>(overrideTaskDefineList.values())));
        result.put(JOB_MAIN_ENTITYL_REPEAT_INDEX_MSG, ScheduleDeployServiceImpl.checkJobMainEntityLRepeatIndexs(new ArrayList<JobMainEntity>(overridejobList.values())));
        result.put(SCHEDULE_MAIN_ENTITYL_REPEAT_INDEX_MSG, ScheduleDeployServiceImpl.checkScheduleMainEntityLRepeatIndex(new ArrayList<ScheduleMainEntity>(overrideSchList.values())));
        try (TXHandle tx = TX.requiresNew();){
            try {
                ScheduleEntityWriter.saveTaskDefine(new ArrayList(overrideTaskDefineList.values()));
                ScheduleEntityWriter.saveJob(new ArrayList(overridejobList.values()));
                ScheduleEntityWriter.saveSchedule(new ArrayList(overrideSchList.values()));
                result.put(SUCCESS, true);
            }
            catch (Exception e) {
                tx.markRollback();
                result.put(SUCCESS, false);
                result.put(MSG, e.getMessage());
            }
            boolean success = (Boolean)result.get(SUCCESS);
            if (success) {
                try (TXHandle scriptTx = TX.requiresNew();){
                    ScheduleEntityWriter.saveScript(deployScriptEntities);
                }
            }
            ScheduleDeployServiceImpl.buildLogInfo("sch_schedule", "sch_import");
            ScheduleDeployServiceImpl.buildLogInfo("sch_job", "job_import");
            ScheduleDeployServiceImpl.buildLogInfo("sch_taskdefine", "task_import");
        }
        return result;
    }

    private static List<String> checkTaskDefineMainEntityLRepeatIndexs(List<TaskDefineMainEntity> taskDefineMainEntityList) {
        ArrayList<String> taskDefineMainEntityLRepeatIndexs = new ArrayList<String>(8);
        for (TaskDefineMainEntity taskDefineMainEntity : taskDefineMainEntityList) {
            List localeCollection = taskDefineMainEntity.getLocaleCollection();
            HashSet<String> uniqueIndex = new HashSet<String>(localeCollection.size());
            Iterator iterator = localeCollection.iterator();
            while (iterator.hasNext()) {
                TaskDefineMainEntityL next = (TaskDefineMainEntityL)iterator.next();
                String localeIdFIdIndex = next.getId() + next.getLocaleId();
                if (uniqueIndex.add(localeIdFIdIndex)) continue;
                StringBuilder repeatIndexMsg = new StringBuilder();
                repeatIndexMsg.append("pkId=").append(next.getPkId()).append("Id=").append(next.getId()).append("localeId=").append(next.getLocaleId()).append("name=").append(next.getName());
                taskDefineMainEntityLRepeatIndexs.add(repeatIndexMsg.toString());
                iterator.remove();
            }
        }
        return taskDefineMainEntityLRepeatIndexs;
    }

    private static List<String> checkJobMainEntityLRepeatIndexs(List<JobMainEntity> jobMainEntityList) {
        ArrayList<String> repeatIndexs = new ArrayList<String>(8);
        for (JobMainEntity jobMainEntity : jobMainEntityList) {
            List localeCollection = jobMainEntity.getLocaleCollection();
            HashSet<String> uniqueIndex = new HashSet<String>(localeCollection.size());
            Iterator iterator = localeCollection.iterator();
            while (iterator.hasNext()) {
                JobMainEntityL next = (JobMainEntityL)iterator.next();
                String localeIdFIdIndex = next.getId() + next.getLocaleId();
                if (uniqueIndex.add(localeIdFIdIndex)) continue;
                StringBuilder repeatIndexMsg = new StringBuilder();
                repeatIndexMsg.append("pkId=").append(next.getPkId()).append(",").append("Id=").append(next.getId()).append(",").append("localeId=").append(next.getLocaleId()).append(",").append("name=").append(next.getName());
                repeatIndexs.add(repeatIndexMsg.toString());
                iterator.remove();
            }
        }
        return repeatIndexs;
    }

    private static List<String> checkScheduleMainEntityLRepeatIndex(List<ScheduleMainEntity> scheduleMainEntityList) {
        ArrayList<String> repeatIndexs = new ArrayList<String>(8);
        for (ScheduleMainEntity scheduleMainEntity : scheduleMainEntityList) {
            List localeCollection = scheduleMainEntity.getLocaleCollection();
            HashSet<String> uniqueIndex = new HashSet<String>(localeCollection.size());
            Iterator iterator = localeCollection.iterator();
            while (iterator.hasNext()) {
                ScheduleMainEntityL next = (ScheduleMainEntityL)iterator.next();
                String localeIdFIdIndex = next.getId() + next.getLocaleId();
                if (uniqueIndex.add(localeIdFIdIndex)) continue;
                StringBuilder repeatIndexMsg = new StringBuilder();
                repeatIndexMsg.append("pkId=").append(next.getPkId()).append(",").append("Id=").append(next.getId()).append(",").append("localeId").append(next.getLocaleId()).append(",").append("name").append(next.getName());
                repeatIndexs.add(repeatIndexMsg.toString());
                iterator.remove();
            }
        }
        return repeatIndexs;
    }

    private static void buildLogInfo(String formId, String opNumber) {
        ILogService logService = (ILogService)ServiceFactory.getService((String)"ILogService");
        AppLogInfo logInfo = ScheduleDeployServiceImpl.doBuildLogInfo(formId, opNumber);
        logService.addLog(logInfo);
    }

    private static AppLogInfo doBuildLogInfo(String formId, String opNumber) {
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        logInfo.setBizAppID("18XSXYEL8//U");
        logInfo.setBizObjID(formId);
        logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        logInfo.setOpTime(new Date());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u8c03\u5ea6\u6570\u636e\u5bfc\u5165", "ScheduleDeployServiceImpl_3", MSERVICE_SCHEDULE);
        logInfo.setOpName(opNumber, opNameBridge);
        String opDescBridge = ResManager.loadKDString((String)"\u8c03\u5ea6\u6570\u636e\u5bfc\u5165\u6210\u529f\u3002", (String)"ScheduleDeployServiceImpl_2", (String)MSERVICE_SCHEDULE, (Object[])new Object[0]);
        logInfo.setOpDescription(opDescBridge);
        return logInfo;
    }

    private static Map<String, Object> deploy(DeployScheduleEntity data) {
        ArrayList<DeployScheduleEntity> list = new ArrayList<DeployScheduleEntity>(3);
        list.add(data);
        return ScheduleDeployServiceImpl.batchDeploy(list, new ArrayList<DeployScriptEntity>());
    }

    public Map<String, Object> deployXml(Map<String, Object> params, String content) {
        return ScheduleDeployServiceImpl.deployData(params, content);
    }

    private static Map<String, Object> deployNew(DeployScheduleEntity data, Map<String, Object> params) {
        Object modeObj = params.get("deployMode");
        if (!ScheduleDeployServiceImpl.isExistSchDeployInfoTable() || modeObj == null || !StringUtils.equals((CharSequence)String.valueOf(modeObj), (CharSequence)"upgrade")) {
            return ScheduleDeployServiceImpl.deploy(data);
        }
        String dataVersion = data.getVersion();
        String filename = String.valueOf(params.get("filename"));
        String path = String.valueOf(params.get("path"));
        if (StringUtils.equals((CharSequence)"2.0", (CharSequence)dataVersion)) {
            return ScheduleDeployServiceImpl.deployNewVerData(data, filename, path);
        }
        return ScheduleDeployServiceImpl.deployOldVerData(data, filename, path);
    }

    public Map<String, Object> deploy(List<AbstractDeployEntity> datas) {
        ArrayList<DeployScheduleEntity> deployDatas = new ArrayList<DeployScheduleEntity>(datas.size());
        ArrayList<DeployScriptEntity> deployScriptEntities = new ArrayList<DeployScriptEntity>(8);
        ArrayList<String> scheduleIds = new ArrayList<String>(datas.size());
        for (AbstractDeployEntity data : datas) {
            if (data instanceof DeployScheduleEntity) {
                deployDatas.add((DeployScheduleEntity)data);
                ScheduleMainEntity scheduleMainEntity = ((DeployScheduleEntity)data).getScheduleMainEntity();
                if (scheduleMainEntity == null) continue;
                scheduleIds.add(scheduleMainEntity.getId());
                continue;
            }
            if (!(data instanceof DeployScriptEntity)) continue;
            deployScriptEntities.add((DeployScriptEntity)data);
        }
        Map<String, Object> result = ScheduleDeployServiceImpl.batchDeploy(deployDatas, deployScriptEntities);
        ScheduleDeployServiceImpl.afterUpdateSchedules(result, scheduleIds);
        return result;
    }

    public DynamicObjectCollection querySchedules(String appNum) {
        QFilter taskFilter = new QFilter("appid", "=", (Object)appNum);
        DynamicObjectCollection taskColl = ORM.create().query("sch_taskdefine", "id", taskFilter.toArray());
        ArrayList<Object> taskIdList = new ArrayList<Object>();
        for (DynamicObject tempTask : taskColl) {
            taskIdList.add(tempTask.getPkValue());
        }
        QFilter scheduleFilter = new QFilter("job.taskclassname.id", "in", taskIdList);
        return ORM.create().query("sch_schedule", scheduleFilter.toArray());
    }

    public Map<String, Object> expScheduleDeployDatas(List<String> scheduleIds, String exportPath, boolean isOverride) {
        return this.saveTmpScheduleDeployDatas(this.getScheduleDeployDatas(scheduleIds, isOverride), exportPath);
    }

    private List<DeployScheduleEntity> getScheduleDeployDatas(List<String> scheduleIds, boolean isOverride) {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>(1);
        params.put("override", isOverride);
        return ScheduleEntityReader.getDeployDatasByScheduleId(scheduleIds, params);
    }

    private Map<String, Object> saveTmpScheduleDeployDatas(List<DeployScheduleEntity> datas, String exportPath) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put(SUCCESS, true);
        ScheduleModelBinder binder = new ScheduleModelBinder();
        DcxmlSerializer dcxmlSerializer = new DcxmlSerializer((DcBinder)binder);
        dcxmlSerializer.setNewlines(true);
        dcxmlSerializer.setIndent(true);
        dcxmlSerializer.setNeedDBIgnore(true);
        for (DeployScheduleEntity data : datas) {
            String fileName = String.format("schedule_%1$s_%2$s.schdata", data.getScheduleMainEntity().getNumber(), System.currentTimeMillis());
            String fullPath = String.format("%1$s%2$s%3$s", exportPath, File.separator, fileName);
            Path customZipPath = Paths.get(fullPath.replace("../", "#"), new String[0]);
            try {
                OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(customZipPath, new OpenOption[0]), StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    writer.write(dcxmlSerializer.serializeToString((Object)data, null));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (IOException e) {
                String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                resultMap.put(SUCCESS, true);
                resultMap.put("message", errMsg);
            }
        }
        return resultMap;
    }

    private static Map<String, Object> deployNewVerData(DeployScheduleEntity data, String filename, String path) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        ScheduleDeployInfo scheduleDeployInfo = ScheduleDeployServiceImpl.queryDeployInfoByFileName(filename);
        String deployingSchId = data.getScheduleMainEntity().getId();
        if (scheduleDeployInfo == null) {
            ScheduleDeployInfo lastNewVerDeployInfo = ScheduleDeployServiceImpl.queryLastNewVerDeployInfoBySchId(data.getScheduleMainEntity().getId());
            if (lastNewVerDeployInfo == null || data.getExportTime() > lastNewVerDeployInfo.getExportTime().getTime()) {
                return ScheduleDeployServiceImpl.deployAndSaveDeployInfo(data, filename, path, scheduleDeployInfo);
            }
            result.put(SUCCESS, false);
            String msg = String.format(ResManager.loadKDString((String)"\u8be5\u8c03\u5ea6\u8ba1\u5212\u6570\u636e\u5305\uff1a%1$s\uff0c\u4e3a2.0\u7248\u672c\u6570\u636e\u5305\uff0c\u5df2\u6709\u66f4\u65b0\u6587\u4ef6\u90e8\u7f72\u8fc7\uff1a%2$s\uff0c\u8df3\u8fc7\u90e8\u7f72\u3002", (String)"ScheduleDeployServiceImpl_6", (String)MSERVICE_SCHEDULE, (Object[])new Object[0]), filename, lastNewVerDeployInfo.getFileName());
            result.put(MSG, msg);
            log.info("\u8be5\u8c03\u5ea6\u8ba1\u5212\u6570\u636e\u5305\uff1a{}\uff0c\u4e3a2.0\u7248\u672c\u6570\u636e\u5305\uff0c\u5df2\u6709\u66f4\u65b0\u6587\u4ef6\u90e8\u7f72\u8fc7\uff1a{}\uff0c\u8df3\u8fc7\u90e8\u7f72\u3002", (Object)filename, (Object)lastNewVerDeployInfo.getFileName());
            return result;
        }
        if (!StringUtils.equals((CharSequence)scheduleDeployInfo.getSchId(), (CharSequence)deployingSchId) || data.getExportTime() > scheduleDeployInfo.getExportTime().getTime()) {
            return ScheduleDeployServiceImpl.deployAndSaveDeployInfo(data, filename, path, scheduleDeployInfo);
        }
        result.put(SUCCESS, false);
        String msg = String.format(ResManager.loadKDString((String)"\u8be5\u8c03\u5ea6\u8ba1\u5212\u6570\u636e\u5305\uff1a%s\uff0c\u4e3a2.0\u7248\u672c\u6570\u636e\u5305\uff0c\u5df2\u90e8\u7f72\u8fc7\uff0c\u8df3\u8fc7\u90e8\u7f72\u3002", (String)"ScheduleDeployServiceImpl_7", (String)MSERVICE_SCHEDULE, (Object[])new Object[0]), filename);
        result.put(MSG, msg);
        log.info("\u8be5\u8c03\u5ea6\u8ba1\u5212\u6570\u636e\u5305\uff1a{}\uff0c\u4e3a2.0\u7248\u672c\u6570\u636e\u5305\uff0c\u5df2\u90e8\u7f72\u8fc7\uff0c\u8df3\u8fc7\u90e8\u7f72\u3002", (Object)filename);
        return result;
    }

    private static Map<String, Object> deployOldVerData(DeployScheduleEntity data, String filename, String path) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (ScheduleDeployServiceImpl.deployedNewVersionData(data.getScheduleMainEntity().getId()).booleanValue()) {
            result.put(SUCCESS, false);
            String msg = String.format(ResManager.loadKDString((String)"\u8be5\u8c03\u5ea6\u8ba1\u5212\u6570\u636e\u5305\uff1a%s\uff0c\u4e3a1.0\u7248\u672c\u6570\u636e\u5305\uff0c\u5df2\u5b58\u57282.0\u7248\u672c\u6570\u636e\u5305\u90e8\u7f72\u8bb0\u5f55\uff0c\u8df3\u8fc7\u90e8\u7f72\u3002", (String)"ScheduleDeployServiceImpl_4", (String)MSERVICE_SCHEDULE, (Object[])new Object[0]), filename);
            result.put(MSG, msg);
            log.info(msg);
            return result;
        }
        ScheduleDeployInfo scheduleDeployInfo = ScheduleDeployServiceImpl.queryDeployInfoByFileName(filename);
        if (scheduleDeployInfo != null) {
            result.put(SUCCESS, false);
            String msg = String.format(ResManager.loadKDString((String)"\u8be5\u8c03\u5ea6\u8ba1\u5212\u6570\u636e\u5305\uff1a%s\uff0c\u4e3a1.0\u7248\u672c\u6570\u636e\u5305\uff0c\u5df2\u90e8\u7f72\u8fc7\uff0c\u8df3\u8fc7\u90e8\u7f72\u3002", (String)"ScheduleDeployServiceImpl_5", (String)MSERVICE_SCHEDULE, (Object[])new Object[0]), filename);
            result.put(MSG, msg);
            log.info(msg);
            return result;
        }
        return ScheduleDeployServiceImpl.deployAndSaveDeployInfo(data, filename, path, null);
    }

    private static ScheduleDeployInfo queryDeployInfoByFileName(String filename) {
        String querySql = "SELECT FID,FEXECTIME,FSCHID,FVERSION,FPATH,FEXPORTTIME FROM T_SCH_DEPLOYINFO WHERE FFILENAME = ?";
        return (ScheduleDeployInfo)DB.query((DBRoute)DBRoute.basedata, (String)querySql, (Object[])new Object[]{filename}, rs -> {
            ScheduleDeployInfo scheduleDeployInfo = null;
            if (rs.next()) {
                scheduleDeployInfo = new ScheduleDeployInfo();
                scheduleDeployInfo.setFileName(filename);
                scheduleDeployInfo.setId(rs.getLong("FID"));
                scheduleDeployInfo.setExecTime((Date)rs.getTimestamp("FEXECTIME"));
                scheduleDeployInfo.setSchId(rs.getString("FSCHID"));
                scheduleDeployInfo.setVersion(rs.getString("FVERSION"));
                scheduleDeployInfo.setPath(rs.getString("FPATH"));
                scheduleDeployInfo.setExportTime((Date)rs.getTimestamp("FEXPORTTIME"));
                return scheduleDeployInfo;
            }
            return null;
        });
    }

    private static ScheduleDeployInfo queryLastNewVerDeployInfoBySchId(String schId) {
        String querySql = "SELECT FID,FFILENAME,FEXECTIME,FPATH,FEXPORTTIME FROM T_SCH_DEPLOYINFO WHERE FSCHID = ? AND FVERSION = ?";
        Object[] params = new Object[]{schId, "2.0"};
        List scheduleDeployInfos = (List)DB.query((DBRoute)DBRoute.basedata, (String)querySql, (Object[])params, rs -> {
            ArrayList<ScheduleDeployInfo> temp = new ArrayList<ScheduleDeployInfo>(8);
            while (rs.next()) {
                ScheduleDeployInfo scheduleDeployInfo = new ScheduleDeployInfo();
                scheduleDeployInfo.setSchId(schId);
                scheduleDeployInfo.setVersion("2.0");
                scheduleDeployInfo.setPath(rs.getString("FPATH"));
                scheduleDeployInfo.setFileName(rs.getString("FFILENAME"));
                scheduleDeployInfo.setExportTime((Date)rs.getTimestamp("FEXPORTTIME"));
                scheduleDeployInfo.setExecTime((Date)rs.getTimestamp("FEXECTIME"));
                scheduleDeployInfo.setId(rs.getLong("FID"));
                temp.add(scheduleDeployInfo);
            }
            return temp;
        });
        if (scheduleDeployInfos.isEmpty()) {
            return null;
        }
        long lastTime = 0L;
        int i = -1;
        for (ScheduleDeployInfo scheduleDeployInfo : scheduleDeployInfos) {
            if (scheduleDeployInfo.getExportTime().getTime() <= lastTime) continue;
            ++i;
            lastTime = scheduleDeployInfo.getExportTime().getTime();
        }
        if (i != -1) {
            return (ScheduleDeployInfo)scheduleDeployInfos.get(i);
        }
        return null;
    }

    private static Boolean deployedNewVersionData(String schId) {
        String existSql = "SELECT COUNT(*) FROM T_SCH_DEPLOYINFO WHERE FSCHID = ? AND FVERSION = ?";
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(schId);
        params.add("2.0");
        return (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)existSql, (Object[])params.toArray(), rs -> {
            if (rs.next()) {
                return rs.getLong(1) > 0L;
            }
            return false;
        });
    }

    private static Map<String, Object> deployAndSaveDeployInfo(DeployScheduleEntity data, String filename, String path, ScheduleDeployInfo scheduleDeployInfo) {
        ArrayList<DeployScheduleEntity> datas = new ArrayList<DeployScheduleEntity>();
        datas.add(data);
        Map<String, Object> result = ScheduleDeployServiceImpl.batchDeploy(datas, new ArrayList<DeployScriptEntity>());
        Boolean success = (Boolean)result.get(SUCCESS);
        if (success.booleanValue()) {
            boolean isSave = false;
            if (scheduleDeployInfo == null) {
                scheduleDeployInfo = new ScheduleDeployInfo();
                scheduleDeployInfo.setId(ID.genLongId());
                isSave = true;
            }
            scheduleDeployInfo.setSchId(data.getScheduleMainEntity().getId());
            scheduleDeployInfo.setFileName(filename);
            scheduleDeployInfo.setExecTime(new Date());
            scheduleDeployInfo.setVersion(data.getVersion());
            scheduleDeployInfo.setPath(path);
            scheduleDeployInfo.setExportTime(data.getExportTime() == 0L ? new Date() : new Date(data.getExportTime()));
            if (isSave) {
                ScheduleDeployServiceImpl.saveDeployInfo(scheduleDeployInfo);
            } else {
                ScheduleDeployServiceImpl.updateDeployInfo(scheduleDeployInfo);
            }
        }
        return result;
    }

    private static void saveDeployInfo(ScheduleDeployInfo scheduleDeployInfo) {
        String insertSql = "INSERT INTO T_SCH_DEPLOYINFO (FID,FFILENAME,FEXECTIME,FSCHID,FVERSION,FEXPORTTIME,FPATH) VALUES(?,?,?,?,?,?,?)";
        ArrayList<Object> params = new ArrayList<Object>(8);
        params.add(scheduleDeployInfo.getId());
        params.add(scheduleDeployInfo.getFileName());
        params.add(scheduleDeployInfo.getExecTime());
        params.add(scheduleDeployInfo.getSchId());
        params.add(scheduleDeployInfo.getVersion());
        params.add(scheduleDeployInfo.getExportTime());
        params.add(scheduleDeployInfo.getPath());
        try {
            DB.execute((DBRoute)DBRoute.basedata, (String)insertSql, (Object[])params.toArray(new Object[params.size()]));
        }
        catch (Exception e) {
            log.error("\u8c03\u5ea6\u8ba1\u5212\u6587\u4ef6\uff1a%s\uff0c\u63d2\u5165\u90e8\u7f72\u8bb0\u5f55\u5931\u8d25\u3002", (Object)scheduleDeployInfo.getFileName());
            throw e;
        }
    }

    private static void updateDeployInfo(ScheduleDeployInfo scheduleDeployInfo) {
        String updateSql = "UPDATE T_SCH_DEPLOYINFO SET FFILENAME = ?,FEXECTIME=?,FSCHID=?,FVERSION=?,FEXPORTTIME=?,FPATH=? WHERE FID=?";
        ArrayList<Object> params = new ArrayList<Object>(8);
        params.add(scheduleDeployInfo.getFileName());
        params.add(scheduleDeployInfo.getExecTime());
        params.add(scheduleDeployInfo.getSchId());
        params.add(scheduleDeployInfo.getVersion());
        params.add(scheduleDeployInfo.getExportTime());
        params.add(scheduleDeployInfo.getPath());
        params.add(scheduleDeployInfo.getId());
        try {
            DB.execute((DBRoute)DBRoute.basedata, (String)updateSql, (Object[])params.toArray(new Object[params.size()]));
        }
        catch (Exception e) {
            log.error("\u8c03\u5ea6\u8ba1\u5212\u6587\u4ef6\uff1a%s\uff0c\u66f4\u65b0\u90e8\u7f72\u8bb0\u5f55\u5931\u8d25\u3002", (Throwable)e);
            throw e;
        }
    }

    private static boolean isExistSchDeployInfoTable() {
        LocalMemoryCache cache = ScheduleDeployServiceImpl.getCache(RequestContext.get().getAccountId());
        Object obj = cache.get("EXIST_DEPLOY_INFO_TABLE");
        if (obj != null) {
            return (Boolean)obj;
        }
        boolean exitsDeployInfoTable = DB.exitsTable((DBRoute)DBRoute.basedata, (String)"T_SCH_DEPLOYINFO");
        cache.put("EXIST_DEPLOY_INFO_TABLE", (Object)exitsDeployInfoTable);
        return exitsDeployInfoTable;
    }

    private static LocalMemoryCache getCache(String accountId) {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(1800);
        info.setMaxItemSize(1000);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("SCHEDULE_SERVICE_REGION", accountId, info);
    }

    private static void afterUpdateSchedules(Map<String, Object> result, List<String> scheduleIds) {
        try {
            if (((Boolean)result.get(SUCCESS)).booleanValue()) {
                ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
                for (String scheduleId : scheduleIds) {
                    scheduleManager.afterUpdateSchedule(scheduleId);
                }
            }
        }
        catch (Exception e) {
            log.error("Schedule***\u66f4\u65b0\u65f6\u95f4\u8f6e\u8c03\u5ea6\u8ba1\u5212\u5931\u8d25", (Throwable)e);
        }
    }
}

