/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.analyse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.TimeLineStyle;
import kd.bos.form.control.TimelineOption;
import kd.bos.form.control.TimelineText;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.analyse.AbstractTaskAnalyse;
import kd.bos.schedule.api.ExecutorServerInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.ScheduleDeployMode;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.message.rpc.ExecutorServerData;
import kd.bos.schedule.message.rpc.RPCHelper;
import kd.bos.schedule.next.ClientObservableUtils;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class ScheduleTaskAnalyse
extends AbstractTaskAnalyse {
    private static final Log log = LogFactory.getLog(ScheduleTaskAnalyse.class);
    private static final String ANALYSE_RESULT_FLEX = "analyseresultflex";
    private static final String ANALYSE_RESULT = "analyseresult";

    public ScheduleTaskAnalyse(IFormView view) {
        this.view = view;
    }

    @Override
    void nextAnalyse() {
        String analyseStep = this.getTaskAnalyseCache("analyseStep");
        if (StringUtils.isBlank((CharSequence)analyseStep)) {
            this.stopProgressBar();
        } else {
            String taskId = (String)this.view.getFormShowParameter().getCustomParam("taskId");
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            switch (analyseStep) {
                case "beginAnalyse": {
                    this.beginAnalyse();
                    break;
                }
                case "appSplitGetMservice": 
                case "appNotSplitGetMservice": {
                    boolean isStopProgressBar = this.showAllServiceNode(taskInfo, analyseStep);
                    if (!isStopProgressBar) break;
                    this.stopProgressBar();
                    break;
                }
                case "analyseMservice": {
                    String mserviceNodeStr = this.getTaskAnalyseCache("mserviceNode");
                    if (mserviceNodeStr != null) {
                        this.analyseMserviceNode(mserviceNodeStr, taskInfo);
                        break;
                    }
                    this.stopProgressBar();
                    break;
                }
                case "showResult": {
                    Map<String, List<String>> serviceNodeAnalyseResult = this.getServiceNodeAnalyseResult();
                    this.view.setVisible(Boolean.TRUE, new String[]{ANALYSE_RESULT_FLEX});
                    this.showResult(serviceNodeAnalyseResult);
                    this.stopProgressBar();
                    break;
                }
                default: {
                    this.stopProgressBar();
                }
            }
        }
    }

    private void showResult(Map<String, List<String>> serviceNodeAnalyseResult) {
        StringBuilder resultBuilder = new StringBuilder();
        List<String> paramsErrorNode = serviceNodeAnalyseResult.get("paramsErrorNode");
        List<String> threadErrorNode = serviceNodeAnalyseResult.get("threadErrorNode");
        List<String> busyNode = serviceNodeAnalyseResult.get("busyNode");
        if (!CollectionUtils.isEmpty(paramsErrorNode) && CollectionUtils.isEmpty(threadErrorNode) && CollectionUtils.isEmpty(busyNode)) {
            resultBuilder.append(ResManager.loadKDString((String)"\u96c6\u7fa4\u4e2d\u6240\u6709\u6267\u884c\u673a\u8282\u70b9\u914d\u7f6e\u7684\u8c03\u5ea6\u53c2\u6570\u5f02\u5e38\uff0c\u65e0\u6cd5\u6267\u884c\u4efb\u52a1\u3002", (String)"ScheduleTaskAnalyse_31", (String)"bos-schedule-formplugin", (Object[])new Object[0]));
            this.view.getModel().setValue(ANALYSE_RESULT, (Object)resultBuilder.toString());
            return;
        }
        if (!CollectionUtils.isEmpty(threadErrorNode) && CollectionUtils.isEmpty(paramsErrorNode) && CollectionUtils.isEmpty(busyNode)) {
            resultBuilder.append(ResManager.loadKDString((String)"\u96c6\u7fa4\u4e2d\u6240\u6709\u6267\u884c\u673a\u8282\u70b9\u7ebf\u7a0b\u8d44\u6e90\u8c03\u5ea6\u60c5\u51b5\u5f02\u5e38\uff0c\u65e0\u6cd5\u6267\u884c\u4efb\u52a1\u3002", (String)"ScheduleTaskAnalyse_32", (String)"bos-schedule-formplugin", (Object[])new Object[0]));
            this.view.getModel().setValue(ANALYSE_RESULT, (Object)resultBuilder.toString());
            return;
        }
        if (!CollectionUtils.isEmpty(busyNode) && CollectionUtils.isEmpty(paramsErrorNode) && CollectionUtils.isEmpty(threadErrorNode)) {
            resultBuilder.append(ResManager.loadKDString((String)"\u96c6\u7fa4\u4e2d\u6ca1\u6709\u7a7a\u95f2\u8282\u70b9\uff0c\u4efb\u52a1\u6392\u961f\u7b49\u5f85\u6267\u884c\u3002", (String)"ScheduleTaskAnalyse_33", (String)"bos-schedule-formplugin", (Object[])new Object[0]));
            this.view.getModel().setValue(ANALYSE_RESULT, (Object)resultBuilder.toString());
            return;
        }
        if (!CollectionUtils.isEmpty(paramsErrorNode)) {
            resultBuilder.append(String.format(ResManager.loadKDString((String)"\u96c6\u7fa4\u4e2d\u8c03\u5ea6\u53c2\u6570\u5f02\u5e38\u7684\u8282\u70b9\uff08%s\uff09\uff0c\u65e0\u6cd5\u6267\u884c\u4efb\u52a1\u3002", (String)"ScheduleTaskAnalyse_34", (String)"bos-schedule-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", paramsErrorNode))).append("\r\n");
        }
        if (!CollectionUtils.isEmpty(threadErrorNode)) {
            resultBuilder.append(String.format(ResManager.loadKDString((String)"\u96c6\u7fa4\u4e2d\u7ebf\u7a0b\u8d44\u6e90\u8c03\u5ea6\u60c5\u51b5\u5f02\u5e38\u7684\u8282\u70b9\uff08%s\uff09\uff0c\u65e0\u6cd5\u6267\u884c\u4efb\u52a1\u3002", (String)"ScheduleTaskAnalyse_35", (String)"bos-schedule-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", threadErrorNode))).append("\r\n");
        }
        if (!CollectionUtils.isEmpty(busyNode)) {
            resultBuilder.append(String.format(ResManager.loadKDString((String)"\u96c6\u7fa4\u4e2d\u65e0\u7a7a\u95f2\u7ebf\u7a0b\u8d44\u6e90\u7684\u8282\u70b9\uff08%s\uff09\uff0c\u7b49\u5f85\u8d44\u6e90\u91ca\u653e\u6267\u884c\u4efb\u52a1\u3002", (String)"ScheduleTaskAnalyse_36", (String)"bos-schedule-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", busyNode))).append("\r\n");
        }
        if (resultBuilder.length() != 0) {
            resultBuilder.delete(resultBuilder.lastIndexOf("\r\n"), resultBuilder.length());
            this.view.getModel().setValue(ANALYSE_RESULT, (Object)resultBuilder.toString());
        }
    }

    private boolean showAllServiceNode(TaskInfo taskInfo, String analyseStep) {
        List<TimelineOption> preAnalyseResult = this.getPreAnalyseResult();
        List<ExecutorServerData> executorServerDatas = this.getServiceNode(taskInfo);
        ArrayList<TimelineText> serviceNodeContentValues = new ArrayList<TimelineText>(16);
        String serviceNodeTitle = ResManager.loadKDString((String)"\u83b7\u53d6\u96c6\u7fa4\u4e2d\u53ef\u4ee5\u6267\u884c\u5f53\u524d\u4efb\u52a1\u7684\u8282\u70b9", (String)"ScheduleTaskAnalyse_3", (String)"bos-schedule-formplugin", (Object[])new Object[0]);
        if (executorServerDatas.isEmpty()) {
            String emptyText = ResManager.loadKDString((String)"\u96c6\u7fa4\u4e2d\u6ca1\u6709\u53ef\u4ee5\u6267\u884c\u5f53\u524d\u4efb\u52a1\u7684\u8282\u70b9", (String)"ScheduleTaskAnalyse_4", (String)"bos-schedule-formplugin", (Object[])new Object[0]);
            if (StringUtils.equals((CharSequence)analyseStep, (CharSequence)"appSplitGetMservice")) {
                emptyText = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u5f53\u524d\u4efb\u52a1appId\u4e3a\uff1a%2$s\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u68c0\u67e5\u96c6\u7fa4\u4e2d\u662f\u5426\u6709\u90e8\u7f72\u5f53\u524d\u5e94\u7528", (String)"ScheduleTaskAnalyse_5", (String)"bos-schedule-formplugin", (Object[])new Object[0]), emptyText, taskInfo.getAppid());
            }
            TimelineText emptyNodeText = new TimelineText(new LocaleString(emptyText), this.createErrorStyle());
            serviceNodeContentValues.add(emptyNodeText);
            preAnalyseResult.add(this.createTimelineOption(serviceNodeTitle, null, serviceNodeContentValues));
            this.updateTimeline(preAnalyseResult);
            return true;
        }
        for (ExecutorServerData executorServerData : executorServerDatas) {
            TimelineText timelineText = null;
            String nodeData = "";
            if (executorServerData.isSuccess()) {
                nodeData = String.format(ResManager.loadKDString((String)"ip\uff1a%1$s\uff0c\u5b9e\u4f8b\u540d\u79f0\uff1a%2$s", (String)"ScheduleTaskAnalyse_6", (String)"bos-schedule-formplugin", (Object[])new Object[0]), executorServerData.getIp(), executorServerData.getInstanceId());
                timelineText = new TimelineText(new LocaleString(nodeData), null);
            } else {
                nodeData = String.format(ResManager.loadKDString((String)"ip\uff1a%s\uff0c\u8fdc\u7a0b\u8bbf\u95ee\u5931\u8d25", (String)"ScheduleTaskAnalyse_7", (String)"bos-schedule-formplugin", (Object[])new Object[0]), executorServerData.getIp());
                timelineText = new TimelineText(new LocaleString(nodeData), this.createErrorStyle());
            }
            serviceNodeContentValues.add(timelineText);
        }
        this.putTaskAnalyseCache("mserviceNode", SerializationUtils.toJsonString(executorServerDatas));
        this.putTaskAnalyseCache("analyseStep", "analyseMservice");
        preAnalyseResult.add(this.createTimelineOption(serviceNodeTitle, null, serviceNodeContentValues));
        this.updateTimeline(preAnalyseResult);
        return false;
    }

    private void beginAnalyse() {
        List<TimelineOption> preAnalyseResult = this.getPreAnalyseResult();
        String contentTitle = ResManager.loadKDString((String)"\u8c03\u5ea6\u5206\u5e94\u7528\u90e8\u7f72\u72b6\u6001", (String)"ScheduleTaskAnalyse_0", (String)"bos-schedule-formplugin", (Object[])new Object[0]);
        String contentValue = "";
        String nextAnalyse = "";
        boolean mqAppSplit = ZkConfig.isMqAppSplit();
        if (mqAppSplit) {
            contentValue = ResManager.loadKDString((String)"\u8c03\u5ea6\u5df2\u5f00\u542f\u5206\u5e94\u7528\uff0c\u5c06\u83b7\u53d6\u90e8\u7f72\u4e86\u4efb\u52a1\u6240\u5c5e\u5e94\u7528\u7684\u6267\u884c\u8282\u70b9\u8fdb\u884c\u4e0b\u4e00\u6b65\u5206\u6790", (String)"ScheduleTaskAnalyse_1", (String)"bos-schedule-formplugin", (Object[])new Object[0]);
            nextAnalyse = "appSplitGetMservice";
        } else {
            contentValue = ResManager.loadKDString((String)"\u8c03\u5ea6\u672a\u5f00\u542f\u5206\u5e94\u7528\uff0c\u5c06\u83b7\u53d6\u96c6\u7fa4\u6240\u6709\u6267\u884c\u8282\u70b9\u8fdb\u884c\u4e0b\u4e00\u6b65\u5206\u6790", (String)"ScheduleTaskAnalyse_2", (String)"bos-schedule-formplugin", (Object[])new Object[0]);
            nextAnalyse = "appNotSplitGetMservice";
        }
        TimelineOption mqAppSplitOption = this.createTimelineOption(contentTitle, null, contentValue, null);
        preAnalyseResult.add(mqAppSplitOption);
        this.updateTimeline(preAnalyseResult);
        this.putTaskAnalyseCache("analyseStep", nextAnalyse);
    }

    private List<ExecutorServerData> getServiceNode(TaskInfo taskInfo) {
        boolean mqAppSplit = ZkConfig.isMqAppSplit();
        ArrayList<ExecutorServerData> executorServerDatas = new ArrayList<ExecutorServerData>();
        List executorServerInfos = null;
        if (mqAppSplit) {
            String appId = taskInfo.getAppid();
            executorServerInfos = ClientObservableUtils.queryExecutorServerStatus((String)appId);
        } else {
            executorServerInfos = ClientObservableUtils.queryExecutorServerStatus();
        }
        if (CollectionUtils.isEmpty((Collection)executorServerInfos)) {
            return executorServerDatas;
        }
        JobType jobType = taskInfo.getJobType();
        MessageType messageType = ClientObservableUtils.convertType((JobType)jobType);
        for (ExecutorServerInfo executorServerInfo : executorServerInfos) {
            String instanceIp = (String)executorServerInfo.getDetail().get("host");
            try {
                ExecutorServerData executorServerData = (ExecutorServerData)RPCHelper.remoteGetExecutorServerData((String)instanceIp, (MessageType)messageType);
                executorServerDatas.add(executorServerData);
            }
            catch (Exception e) {
                log.error("Schedule***\u4efb\u52a1\u8bca\u65ad\u5f02\u5e38\uff0ctaskId = {}\uff0cRPC Request error", (Object)taskInfo.getId(), (Object)e);
                ExecutorServerData executorServerData = new ExecutorServerData();
                executorServerData.setSuccess(false);
                executorServerData.setIp(instanceIp);
                executorServerDatas.add(executorServerData);
            }
        }
        return executorServerDatas;
    }

    private void analyseMserviceNode(String mserviceNodeStr, TaskInfo taskInfo) {
        List executorServerDatas = SerializationUtils.fromJsonStringToList((String)mserviceNodeStr, ExecutorServerData.class);
        String serviceNodeIndexStr = this.getTaskAnalyseCache("mserviceNodeIndex");
        int serviceNodeIndex = 0;
        if (StringUtils.isNotBlank((CharSequence)serviceNodeIndexStr)) {
            serviceNodeIndex = Integer.parseInt(serviceNodeIndexStr);
        }
        if (serviceNodeIndex < executorServerDatas.size()) {
            ExecutorServerData executorServerData = (ExecutorServerData)executorServerDatas.get(serviceNodeIndex);
            TimelineOption analyseNodeResult = this.analyseServiceNode(executorServerData, taskInfo);
            List<TimelineOption> preAnalyseResult = this.getPreAnalyseResult();
            preAnalyseResult.add(analyseNodeResult);
            this.updateTimeline(preAnalyseResult);
            if (++serviceNodeIndex == executorServerDatas.size()) {
                this.putTaskAnalyseCache("analyseStep", "showResult");
            } else {
                this.putTaskAnalyseCache("mserviceNodeIndex", String.valueOf(serviceNodeIndex));
            }
        } else {
            this.stopProgressBar();
        }
    }

    private TimelineOption analyseServiceNode(ExecutorServerData executorServerData, TaskInfo taskInfo) {
        ArrayList<TimelineText> serviceNodeContentValues = new ArrayList<TimelineText>(8);
        TimelineOption analyseNodeOption = this.createTimelineOption(String.format(ResManager.loadKDString((String)"\u68c0\u6d4bmservice\u8282\u70b9\uff08%s\uff09\u8c03\u5ea6\u53c2\u6570", (String)"ScheduleTaskAnalyse_8", (String)"bos-schedule-formplugin", (Object[])new Object[0]), executorServerData.getIp()), null, serviceNodeContentValues);
        if (executorServerData.isSuccess()) {
            boolean serviceStarted = this.analyseNodeAnalyseTitle(executorServerData, serviceNodeContentValues);
            boolean serviceEnableWork = this.analyseNodeDisableToWork(executorServerData, serviceNodeContentValues);
            boolean serviceEnableExecutor = this.analyseNodeDeployMode(executorServerData, serviceNodeContentValues);
            this.analyseNodeIsDev(executorServerData, serviceNodeContentValues);
            boolean serviceEnableThisMessageType = this.analyseNodeAccessMessageType(executorServerData, taskInfo, serviceNodeContentValues);
            if (serviceStarted && serviceEnableWork && serviceEnableExecutor && serviceEnableThisMessageType) {
                TimelineText canExecuteTheTask = new TimelineText(new LocaleString(ResManager.loadKDString((String)"\u8282\u70b9\u53c2\u6570\u5141\u8bb8\u6267\u884c\u8be5\u4efb\u52a1\uff0c\u68c0\u67e5\u8282\u70b9\u8d44\u6e90\u8c03\u5ea6\u60c5\u51b5", (String)"ScheduleTaskAnalyse_26", (String)"bos-schedule-formplugin", (Object[])new Object[0])), this.createSuccessStyle());
                serviceNodeContentValues.add(canExecuteTheTask);
                this.analyseThread(executorServerData, analyseNodeOption);
            } else {
                TimelineText canNotExecuteTheTask = new TimelineText(new LocaleString(ResManager.loadKDString((String)"\u8282\u70b9\u53c2\u6570\u90e8\u7f72\u5f02\u5e38\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u8be5\u4efb\u52a1", (String)"ScheduleTaskAnalyse_27", (String)"bos-schedule-formplugin", (Object[])new Object[0])), this.createErrorStyle());
                serviceNodeContentValues.add(canNotExecuteTheTask);
                this.putNodeIpInPageCache("paramsErrorNode", executorServerData.getIp());
            }
        } else {
            TimelineText nodeTitleLineText = new TimelineText(new LocaleString(String.format(ResManager.loadKDString((String)"ip\uff1a%s\uff0c\u8fdc\u7a0b\u8bbf\u95ee\u5931\u8d25", (String)"ScheduleTaskAnalyse_7", (String)"bos-schedule-formplugin", (Object[])new Object[0]), executorServerData.getIp())), this.createErrorStyle());
            serviceNodeContentValues.add(nodeTitleLineText);
        }
        return analyseNodeOption;
    }

    private void putNodeIpInPageCache(String nodeType, String nodeIp) {
        Map<String, List<String>> serviceNodeAnalyseResult = this.getServiceNodeAnalyseResult();
        List paramsErrorNode = serviceNodeAnalyseResult.computeIfAbsent(nodeType, k -> new ArrayList(8));
        paramsErrorNode.add(nodeIp);
        this.cacheServiceNodeAnalyseResult(serviceNodeAnalyseResult);
    }

    @Override
    void analyseThread(ExecutorServerData executorServerData, TimelineOption analyseNodeOption) {
        int readyTaskSize = executorServerData.getReadyTaskSize() + 1;
        int maxReadyTaskSize = executorServerData.getMaxReadyTaskSize();
        int runningTaskSize = executorServerData.getRunningTaskSize();
        int maxNumOfWorkThread = executorServerData.getMaxNumOfWorkThread();
        TimelineText desc = null;
        if (readyTaskSize < maxReadyTaskSize) {
            desc = new TimelineText(new LocaleString(String.format(ResManager.loadKDString((String)"\u8282\u70b9\u8d44\u6e90\u8c03\u5ea6\u60c5\u51b5\uff1a\u5f02\u5e38\uff0c\u5f53\u524d\u8282\u70b9\u5c31\u7eea\u4efb\u52a1\u6570\u91cf\u4e3a %1$s\uff0c\u5c0f\u4e8e\u5141\u8bb8\u5904\u7406\u7684\u5c31\u7eea\u4efb\u52a1\u6700\u5927\u6570\u91cf %2$s\uff0c\u8fd0\u884c\u4e2d\u4efb\u52a1\u6570\u91cf\u4e3a %3$s\uff0c\u5f53\u524d\u8282\u70b9\u5141\u8bb8\u5904\u7406\u7684\u6700\u5927\u4efb\u52a1\u6570\u91cf\u4e3a %4$s\uff0c\u539f\u56e0\u53ef\u80fd\u662f\u6267\u884c\u673a\u8ba2\u9605\u6d88\u606f\u961f\u5217\u5f02\u5e38\uff0c\u6216\u8005\u6267\u884c\u673a\u5c31\u7eea\u4efb\u52a1\u5904\u7406\u5f02\u5e38\uff0c\u6216\u8005\u53d7\u8282\u70b9\u5065\u5eb7\u5ea6\u5f71\u54cd\uff0c\u5efa\u8bae\u8054\u7cfb\u7ba1\u7406\u5458", (String)"ScheduleTaskAnalyse_28", (String)"bos-schedule-formplugin", (Object[])new Object[0]), readyTaskSize, maxReadyTaskSize, runningTaskSize, maxNumOfWorkThread)), this.createErrorStyle());
            this.putNodeIpInPageCache("threadErrorNode", executorServerData.getIp());
        } else if (readyTaskSize == maxReadyTaskSize && runningTaskSize < maxNumOfWorkThread) {
            desc = new TimelineText(new LocaleString(String.format(ResManager.loadKDString((String)"\u8282\u70b9\u8d44\u6e90\u8c03\u5ea6\u60c5\u51b5\uff1a\u5f02\u5e38\uff0c\u5f53\u524d\u8282\u70b9\u5141\u8bb8\u5904\u7406\u7684\u5c31\u7eea\u4efb\u52a1\u6700\u5927\u6570\u91cf\u4e3a %1$s\uff0c\u8fd0\u884c\u4e2d\u4efb\u52a1\u6570\u91cf\u4e3a %2$s\uff0c\u5141\u8bb8\u5904\u7406\u7684\u6700\u5927\u4efb\u52a1\u6570\u91cf\u4e3a %3$s\uff0c\u65e0\u6cd5\u5904\u7406\u5f53\u524d\u8282\u70b9\u7684\u5c31\u7eea\u4efb\u52a1\uff0c\u5efa\u8bae\u8054\u7cfb\u7ba1\u7406\u5458", (String)"ScheduleTaskAnalyse_29", (String)"bos-schedule-formplugin", (Object[])new Object[0]), maxReadyTaskSize, runningTaskSize, maxNumOfWorkThread)), this.createErrorStyle());
            this.putNodeIpInPageCache("threadErrorNode", executorServerData.getIp());
        } else if (readyTaskSize == maxReadyTaskSize && runningTaskSize == maxNumOfWorkThread) {
            desc = new TimelineText(new LocaleString(String.format(ResManager.loadKDString((String)"\u8282\u70b9\u8d44\u6e90\u8c03\u5ea6\u60c5\u51b5\uff1a\u8282\u70b9\u6ca1\u6709\u7a7a\u95f2\u7ebf\u7a0b\uff0c\u4efb\u52a1\u6392\u961f\u7b49\u5f85\u6267\u884c\u3002\uff08\u5f53\u524d\u8282\u70b9\u5c31\u7eea\u4efb\u52a1\u6570\u91cf\u7b49\u4e8e\u5141\u8bb8\u5904\u7406\u7684\u5c31\u7eea\u4efb\u52a1\u6700\u5927\u6570\u91cf %1$s\uff0c\u8fd0\u884c\u4e2d\u7684\u4efb\u52a1\u6570\u91cf\u7b49\u4e8e\u5141\u8bb8\u5904\u7406\u7684\u6700\u5927\u4efb\u52a1\u6570\u91cf %2$s\uff09", (String)"ScheduleTaskAnalyse_30", (String)"bos-schedule-formplugin", (Object[])new Object[0]), maxReadyTaskSize, maxNumOfWorkThread)), this.createWarnStyle());
            analyseNodeOption.setOptionKeys(this.createViewThreadDumpOption(executorServerData.getIp()));
            this.putNodeIpInPageCache("busyNode", executorServerData.getIp());
        }
        if (desc != null) {
            analyseNodeOption.getContent().getDescriptions().add(desc);
        }
    }

    private boolean analyseNodeAccessMessageType(ExecutorServerData executorServerData, TaskInfo taskInfo, List<TimelineText> serviceNodeContentValues) {
        JobType jobType = taskInfo.getJobType();
        MessageType taskMessageType = ClientObservableUtils.convertType((JobType)jobType);
        List messageAccessType = executorServerData.getMessageAccessType();
        StringBuilder accessTypeBuilder = new StringBuilder();
        boolean canExecuteTheTask = false;
        if (CollectionUtils.isEmpty((Collection)messageAccessType)) {
            accessTypeBuilder.append(ResManager.loadKDString((String)"\u4e0d\u5904\u7406\u4efb\u4f55\u7c7b\u578b\u7684\u4efb\u52a1", (String)"ScheduleTaskAnalyse_21", (String)"bos-schedule-formplugin", (Object[])new Object[0]));
        } else {
            ArrayList<String> accessTaskType = new ArrayList<String>(messageAccessType.size());
            for (MessageType messageType : messageAccessType) {
                switch (messageType) {
                    case BIZJOB: {
                        accessTaskType.add(ResManager.loadKDString((String)"\u5b9a\u65f6\u4efb\u52a1", (String)"ScheduleTaskAnalyse_22", (String)"bos-schedule-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    case REALTIMEJOB: {
                        accessTaskType.add(ResManager.loadKDString((String)"\u5b9e\u65f6\u4efb\u52a1", (String)"ScheduleTaskAnalyse_23", (String)"bos-schedule-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    case WorkFlowJOB: {
                        accessTaskType.add(ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u4efb\u52a1", (String)"ScheduleTaskAnalyse_24", (String)"bos-schedule-formplugin", (Object[])new Object[0]));
                        break;
                    }
                }
                if (taskMessageType != messageType) continue;
                canExecuteTheTask = true;
            }
            accessTypeBuilder.append(String.join((CharSequence)"\u3001", accessTaskType));
        }
        String accessMessage = String.format(ResManager.loadKDString((String)"\u8282\u70b9\u5141\u8bb8\u5904\u7406\u7684\u4efb\u52a1\u7c7b\u578b\uff08Schedule.Message.AccessType\uff09\uff1a%s", (String)"ScheduleTaskAnalyse_25", (String)"bos-schedule-formplugin", (Object[])new Object[0]), accessTypeBuilder);
        serviceNodeContentValues.add(new TimelineText(new LocaleString(accessMessage), null));
        return canExecuteTheTask;
    }

    private void analyseNodeIsDev(ExecutorServerData executorServerData, List<TimelineText> serviceNodeContentValues) {
        String isDevStr = executorServerData.isDevMode() ? ResManager.loadKDString((String)"\u662f", (String)"ScheduleTaskAnalyse_12", (String)"bos-schedule-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ScheduleTaskAnalyse_13", (String)"bos-schedule-formplugin", (Object[])new Object[0]);
        String isDev = String.format(ResManager.loadKDString((String)"\u8282\u70b9\u662f\u5426\u662f\u5f00\u53d1\u6a21\u5f0f\uff08mq.debug.queue.tag\uff09\uff1a%s", (String)"ScheduleTaskAnalyse_20", (String)"bos-schedule-formplugin", (Object[])new Object[0]), isDevStr);
        serviceNodeContentValues.add(new TimelineText(new LocaleString(isDev), null));
    }

    private boolean analyseNodeDeployMode(ExecutorServerData executorServerData, List<TimelineText> serviceNodeContentValues) {
        ScheduleDeployMode deployMode = executorServerData.getDeployMode();
        boolean canExecuteTheTask = true;
        String deployModeDesc = "";
        TimeLineStyle style = null;
        if (deployMode != null) {
            switch (deployMode) {
                case DISABLE: {
                    deployModeDesc = ResManager.loadKDString((String)"\u8be5\u8282\u70b9\u4e0d\u542f\u7528\u3010\u8c03\u5ea6\u670d\u52a1\u3011\u548c\u3010\u6267\u884c\u670d\u52a1\u3011", (String)"ScheduleTaskAnalyse_14", (String)"bos-schedule-formplugin", (Object[])new Object[0]);
                    canExecuteTheTask = false;
                    style = this.createErrorStyle();
                    break;
                }
                case SCHEDULE_NODE: {
                    deployModeDesc = ResManager.loadKDString((String)"\u8be5\u8282\u70b9\u53ea\u542f\u7528\u3010\u8c03\u5ea6\u670d\u52a1\u3011\uff0c\u4e0d\u53c2\u6570\u6267\u884c\u4efb\u52a1", (String)"ScheduleTaskAnalyse_15", (String)"bos-schedule-formplugin", (Object[])new Object[0]);
                    canExecuteTheTask = false;
                    style = this.createErrorStyle();
                    break;
                }
                case EXECUTE_NODE: {
                    deployModeDesc = ResManager.loadKDString((String)"\u8be5\u8282\u70b9\u53ea\u542f\u7528\u3010\u6267\u884c\u670d\u52a1\u3011\uff0c\u4e0d\u53c2\u4e0e\u8c03\u5ea6\u4e3b\u8282\u70b9\u9009\u4e3e", (String)"ScheduleTaskAnalyse_16", (String)"bos-schedule-formplugin", (Object[])new Object[0]);
                    style = this.createWarnStyle();
                    break;
                }
                case NOLIMIT: {
                    deployModeDesc = ResManager.loadKDString((String)"\u8be5\u8282\u70b9\u3010\u8c03\u5ea6\u670d\u52a1\u3011\u548c\u3010\u6267\u884c\u670d\u52a1\u3011\u90fd\u542f\u52a8", (String)"ScheduleTaskAnalyse_17", (String)"bos-schedule-formplugin", (Object[])new Object[0]);
                    break;
                }
            }
        } else {
            deployModeDesc = ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u90e8\u7f72\u6a21\u5f0f\uff08Schedule.deployMode\uff09\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"ScheduleTaskAnalyse_18", (String)"bos-schedule-formplugin", (Object[])new Object[0]);
            style = this.createErrorStyle();
        }
        deployModeDesc = String.format(ResManager.loadKDString((String)"\u8282\u70b9\u7684\u90e8\u7f72\u6a21\u5f0f\uff1a%s", (String)"ScheduleTaskAnalyse_19", (String)"bos-schedule-formplugin", (Object[])new Object[0]), deployModeDesc);
        serviceNodeContentValues.add(new TimelineText(new LocaleString(deployModeDesc), style));
        return canExecuteTheTask;
    }

    private boolean analyseNodeAnalyseTitle(ExecutorServerData executorServerData, List<TimelineText> serviceNodeContentValues) {
        TimelineText timelineText = null;
        if (executorServerData.isStarted()) {
            String nodeTitle = String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff08%1$s\uff09\u8c03\u5ea6\u6267\u884c\u670d\u52a1\u5df2\u542f\u52a8\uff0c\u5b9e\u4f8b\u540d\uff1a%2$s", (String)"ScheduleTaskAnalyse_9", (String)"bos-schedule-formplugin", (Object[])new Object[0]), executorServerData.getIp(), executorServerData.getInstanceId());
            timelineText = new TimelineText(new LocaleString(nodeTitle), null);
        } else {
            String nodeTitle = String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff08%1$s\uff09\u8c03\u5ea6\u6267\u884c\u670d\u52a1\u542f\u52a8\u5931\u8d25\uff0c\u5b9e\u4f8b\u540d\uff1a%2$s", (String)"ScheduleTaskAnalyse_10", (String)"bos-schedule-formplugin", (Object[])new Object[0]), executorServerData.getIp(), executorServerData.getInstanceId());
            timelineText = new TimelineText(new LocaleString(nodeTitle), this.createErrorStyle());
        }
        serviceNodeContentValues.add(timelineText);
        return executorServerData.isStarted();
    }

    private boolean analyseNodeDisableToWork(ExecutorServerData executorServerData, List<TimelineText> serviceNodeContentValues) {
        boolean canExecuteTheTask = true;
        boolean isDisableToWork = executorServerData.isDisableToWork();
        if (isDisableToWork) {
            canExecuteTheTask = false;
        }
        String isEnable = isDisableToWork ? ResManager.loadKDString((String)"\u5426", (String)"ScheduleTaskAnalyse_13", (String)"bos-schedule-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u662f", (String)"ScheduleTaskAnalyse_12", (String)"bos-schedule-formplugin", (Object[])new Object[0]);
        String disableToWork = String.format(ResManager.loadKDString((String)"\u8282\u70b9\u662f\u5426\u542f\u7528\u8c03\u5ea6\u670d\u52a1\uff08Schedule.disableToWork\uff09\uff1a%s", (String)"ScheduleTaskAnalyse_11", (String)"bos-schedule-formplugin", (Object[])new Object[0]), isEnable);
        serviceNodeContentValues.add(new TimelineText(new LocaleString(disableToWork), isDisableToWork ? this.createErrorStyle() : null));
        return canExecuteTheTask;
    }
}

