/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.formplugin;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class JobPkRepairToolPlugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener {
    private static final Log logger = LogFactory.getLog(JobPkRepairToolPlugin.class);
    private static final String FID = "fid";
    private static final String KEY_APP_TREE = "treeview";
    private static final String BTNOK = "btnok";
    private static final String ROOT = "root";
    private static final String ENTRYENTITY = "entryentity";
    private static final String JOBDATAS = "jobdatas";
    private static final String PKREPAIR = "pkrepair";
    private static final String BOS_SCHEDULE_FORMPLUGIN = "bos-schedule-formplugin";

    public void initialize() {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_APP_TREE);
        if (null != treeView) {
            treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTree();
    }

    private void initTree() {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_APP_TREE);
        TreeNode root = this.buildRootNode();
        treeView.addNode(root);
        treeView.setRootVisible(true);
        treeView.expand(ROOT);
    }

    private TreeNode buildRootNode() {
        TreeNode root = new TreeNode();
        root.setText(FID);
        root.setId(ROOT);
        List<String> ids = this.getRepeatIds();
        if (ids.isEmpty()) {
            return root;
        }
        for (String id : ids) {
            TreeNode node = new TreeNode();
            node.setText(id);
            node.setId(id);
            root.addChild(node);
        }
        return root;
    }

    private List<String> getRepeatIds() {
        String sql = "select fid,count(fid) from t_sch_job group by fid having(count(fid) > 1);";
        List ids = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, resultSet -> {
            ArrayList<String> ret = new ArrayList<String>(6);
            while (resultSet.next()) {
                ret.add(resultSet.getString(FID));
            }
            return ret;
        });
        return ids;
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTNOK.equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows == null || selectRows.length < 1) {
                List<String> ids = this.getRepeatIds();
                if (ids.isEmpty()) {
                    this.buildPk();
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"JobPkRepairToolPlugin_0", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
            }
            String nodeID = null;
            List selList = ((TreeView)this.getControl(KEY_APP_TREE)).getTreeState().getSelectedNodeId();
            if (selList != null && !selList.isEmpty()) {
                nodeID = (String)selList.get(0);
            }
            if (nodeID == null) {
                logger.error("select nodeid is null");
                return;
            }
            List<Map<String, Object>> repeatDatas = this.getRepeatData(nodeID);
            if (repeatDatas.size() <= 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4fee\u590d\u3002", (String)"JobPkRepairToolPlugin_1", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u52fe\u9009\u7684\u6570\u636e\"fid\"\u4fdd\u6301\u4e0d\u53d8\uff0c\u5269\u4f59\u6570\u636e\u5c06\u91cd\u65b0\u751f\u6210\"fid\"\uff0c\u786e\u8ba4\u4fee\u590d\uff1f", (String)"JobPkRepairToolPlugin_2", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(PKREPAIR));
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (!(e.getNodeId() instanceof String)) {
            return;
        }
        this.getModel().deleteEntryData(ENTRYENTITY);
        String nodeId = (String)e.getNodeId();
        if (ROOT.equals(nodeId)) {
            return;
        }
        List<Map<String, Object>> list = this.getRepeatData(nodeId);
        this.getPageCache().put(JOBDATAS, SerializationUtils.toJsonString(list));
        if (list.isEmpty()) {
            return;
        }
        this.refreshEntry(list);
    }

    private List<Map<String, Object>> getRepeatData(String nodeId) {
        List columns = DB.getColumnNames((DBRoute)DBRoute.basedata, (String)"t_sch_job");
        String selectColoum = StringUtils.join((Iterable)columns, (String)",");
        StringBuilder sb = new StringBuilder("select ").append(selectColoum).append(" from t_sch_job where fid = ? ");
        List list = (List)DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])new Object[]{nodeId}, resultSet -> {
            ArrayList list1 = new ArrayList(6);
            while (resultSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                for (String column : columns) {
                    Object val = resultSet.getObject(column);
                    if (("fcreatetime".equalsIgnoreCase(column) || "fmodifytime".equalsIgnoreCase(column)) && val instanceof Timestamp) {
                        val = ((Timestamp)val).getTime();
                    }
                    map.put(column.toLowerCase(Locale.ENGLISH), val);
                }
                list1.add(map);
            }
            return list1;
        });
        return list;
    }

    private void refreshEntry(List<Map<String, Object>> list) {
        this.getModel().deleteEntryData(ENTRYENTITY);
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, list.size());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        for (int i = 0; i < list.size(); ++i) {
            DynamicObject target = (DynamicObject)entryEntity.get(i);
            Map<String, Object> data = list.get(i);
            target.set(FID, data.get(FID));
            target.set("number", data.get("fnumber"));
            target.set("taskclassname", data.get("ftaskdefineid"));
            target.set("classname", data.get("ftaskclassname"));
            target.set("runbyorg", data.get("frunbyorgid"));
        }
        this.getView().updateView(ENTRYENTITY);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (PKREPAIR.equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            if (!(this.getPageCache().get(JOBDATAS) instanceof String)) {
                return;
            }
            List list = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(JOBDATAS), Map.class);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
            int selectRow = entryGrid.getSelectRows()[0];
            if (selectRow > list.size()) {
                logger.error(String.format("selectRow > list.size(). selectRow : %d, list.size() : %d", selectRow, list.size()));
                return;
            }
            Map data = (Map)list.get(selectRow);
            List<Object[]> paramss = this.getParamss(list, selectRow);
            String insertSql = this.getInsertSQL(data);
            try (TXHandle tx = TX.requiresNew();){
                try {
                    DB.execute((DBRoute)DBRoute.basedata, (String)("delete from t_sch_job where fid = '" + data.get(FID) + "'"));
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, paramss);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    tx.markRollback();
                    throw e;
                }
            }
            this.refreshEntry(list);
            List<String> ids = this.getRepeatIds();
            if (ids.isEmpty()) {
                this.buildPk();
            }
        }
    }

    private void buildPk() {
        String sql = "EXEC P_ALTERPK 'PK_T_SCH_JOB', 'T_SCH_JOB', 'FID', '1'";
        DB.execute((DBRoute)DBRoute.basedata, (String)sql);
        this.getView().showMessage(ResManager.loadKDString((String)"\u4e3b\u952e\u5df2\u4fee\u590d\u6210\u529f\u3002", (String)"JobPkRepairToolPlugin_3", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
    }

    private List<Object[]> getParamss(List<Map<String, Object>> list, int selectRow) {
        ArrayList<Object[]> paramss = new ArrayList<Object[]>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> data = list.get(i);
            if (selectRow != i) {
                data.put(FID, String.valueOf(DB.genLongId((String)"T_SCH_JOB")));
            }
            ArrayList<Object> params = new ArrayList<Object>(data.size());
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                String column = entry.getKey();
                Object val = entry.getValue();
                if (("fcreatetime".equalsIgnoreCase(column) || "fmodifytime".equalsIgnoreCase(column)) && val instanceof Long) {
                    val = new Timestamp((Long)val);
                }
                params.add(val);
            }
            paramss.add(params.toArray());
        }
        return paramss;
    }

    private String getInsertSQL(Map<String, Object> data) {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append("T_SCH_JOB").append("(");
        StringBuilder places = new StringBuilder("(");
        for (String column : data.keySet()) {
            sb.append(column).append(',');
            places.append("?,");
        }
        sb.setLength(sb.length() - 1);
        places.setLength(places.length() - 1);
        return sb.append(") values ").append((CharSequence)places).append(")").toString();
    }
}

