/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.formplugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mservice.endpoint.EndPointDispatchServiceHelper;
import kd.bos.schedule.api.ServerManager;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.service.ServiceFactory;

public class SchDebugPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_masterchange"});
    }

    public void click(EventObject evt) {
        Object src = evt.getSource();
        if (!(src instanceof Control)) {
            return;
        }
        Control ctrl = (Control)src;
        switch (ctrl.getKey()) {
            case "btn_masterchange": {
                this.btn_masterchange();
            }
        }
    }

    private void btn_masterchange() {
        String masterRpcIp = SchDebugPlugin.getMasterRpcIp();
        EndPointDispatchServiceHelper.invoke((String)masterRpcIp, (String)"kd.bos.schedule.server.ScheduleService", (String)"masterChanged", (Object[])new Object[0]);
        if (ZkConfig.isSupportZk()) {
            int secend = ZkConfig.getSelfCheck() * 1000;
            this.getView().showTipNotification(String.format("ZkConfig is Zk ,please wait %s secend.", secend));
        } else {
            this.getView().showTipNotification(String.format("ZkConfig is Redis, please go to monitor and paused master Service : %s", masterRpcIp));
        }
    }

    private static String getMasterRpcIp() {
        String masterRpcIp = null;
        ServerManager sm = (ServerManager)ServiceFactory.getService(ServerManager.class);
        Map serverInfo = sm.getMasterServerInfo();
        if (serverInfo != null) {
            masterRpcIp = (String)serverInfo.get("masterName");
        }
        if (StringUtils.isEmpty(masterRpcIp)) {
            ErrorCode ec = new ErrorCode("SCHEDULE_SERVER_HAS_ALREADY_STARTED", "masterRpcIp is null");
            throw new KDException(ec, new Object[0]);
        }
        return masterRpcIp;
    }
}

