/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.schedule.api.ExecutorServerInfo;
import kd.bos.schedule.api.ServerManager;
import kd.bos.service.ServiceFactory;

public class ScheduleCardPlugin
extends AbstractFormPlugin {
    private static final String ENTRYENTITY_1 = "entryentity1";

    public void initialize() {
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.addProgressListener(new ProgresssListener(){

            public void onProgress(ProgressEvent arg0) {
                ScheduleCardPlugin.this.deleteAllEntry();
                ScheduleCardPlugin.this.loadData();
            }
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.start();
    }

    private void deleteAllEntry() {
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRYENTITY_1);
    }

    public void afterCreateNewData(EventObject e) {
        this.loadData();
    }

    private void loadData() {
        ServerManager sm = (ServerManager)ServiceFactory.getService(ServerManager.class);
        List lst = sm.queryExecutorServerStatus();
        Map serverInfo = sm.getMasterServerInfo();
        if (lst != null) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY_1, lst.size());
            int i = 0;
            for (ExecutorServerInfo info : lst) {
                this.getModel().setValue("excutestarttime", (Object)new Date(info.getStartTime()), i);
                this.getModel().setValue("excutesucesscnt", (Object)info.getCompleted(), i);
                this.getModel().setValue("excuteothercnt", (Object)info.getFailed(), i);
                String group = info.getDetail().getOrDefault("curAppGroup", "defaultGroup");
                String excutename = info.getName() + (StringUtils.isEmpty((CharSequence)group) || "defaultGroup".equals(group) ? "" : " (" + group + ")");
                this.getModel().setValue("excutename", (Object)excutename, i);
                ++i;
            }
        }
        this.getModel().setValue("mainstarttime", serverInfo.get("startTime"), 0);
        this.getModel().setValue("mainname", serverInfo.get("masterName"), 0);
        if ("true".equals(serverInfo.get("isStarted").toString()) && sm.isScheduleServiceStarted()) {
            this.getModel().setValue("mainstatues", (Object)ResManager.loadKDString((String)"\u8fd0\u884c\u6b63\u5e38", (String)"ScheduleCardPlugin_0", (String)"bos-schedule-formplugin", (Object[])new Object[0]), 0);
            this.getModel().setValue("serverstatus", (Object)Boolean.TRUE, 0);
        } else {
            this.getModel().setValue("mainstatues", (Object)ResManager.loadKDString((String)"\u8fd0\u884c\u5f02\u5e38", (String)"ScheduleCardPlugin_1", (String)"bos-schedule-formplugin", (Object[])new Object[0]), 0);
            this.getModel().setValue("serverstatus", (Object)Boolean.FALSE, 0);
        }
    }
}

