/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.formplugin;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.schedule.dataentity.DeployScheduleEntity;
import kd.bos.schedule.dataentity.DeployScriptEntity;
import kd.bos.schedule.dataentity.TaskDefineMainEntity;
import kd.bos.schedule.dataentity.dao.ScheduleModelBinder;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.FileUtils;

class ScheduleExportUtil {
    private static final Log log = LogFactory.getLog(ScheduleExportUtil.class);
    private static final String SCHEDULE_DIR = "schedule";
    protected static final String DEPLOY_SCHEDULE_DATA = "deployDatas";
    protected static final String DEPLOY_SCRIPT_DATA = "deployScriptDatas";

    ScheduleExportUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDeployFileDownloadUrl(List<DeployScheduleEntity> datas) throws IOException {
        String downLoadUrl = null;
        String userdir = System.getProperty("java.io.tmpdir");
        if (!userdir.endsWith(File.separator)) {
            userdir = userdir + File.separator;
        }
        String tempZipPath = userdir + Hashing.sha256().hashString((CharSequence)RequestContext.get().getTraceId(), Charsets.UTF_8).toString();
        String scheduleDataPath = tempZipPath + File.separator + SCHEDULE_DIR;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String fileName = "schexport_" + sdf.format(new Date());
            ScheduleModelBinder binder = new ScheduleModelBinder();
            DcxmlSerializer dcxmlSerializer = new DcxmlSerializer((DcBinder)binder);
            dcxmlSerializer.setNewlines(true);
            dcxmlSerializer.setIndent(true);
            dcxmlSerializer.setNeedDBIgnore(true);
            File dir = ScheduleExportUtil.createTempFileDir(scheduleDataPath);
            HashMap<String, String> allDataNameMap = new HashMap<String, String>(datas.size());
            HashSet<String> scriptIds = new HashSet<String>(8);
            for (DeployScheduleEntity data : datas) {
                File file = File.createTempFile(String.format("schedule_%s", data.getScheduleMainEntity().getNumber()), ".schdata", dir);
                ScheduleExportUtil.write2File(file, dcxmlSerializer.serializeToString((Object)data, null));
                String trueFileName = String.format("schedule_%s.schdata", data.getScheduleMainEntity().getNumber());
                allDataNameMap.put(file.getName(), trueFileName);
                List jobTaskMainEntityList = data.getJobTaskMainEntityList();
                if (jobTaskMainEntityList == null) continue;
                for (TaskDefineMainEntity taskDefineMainEntity : jobTaskMainEntityList) {
                    if (!String.valueOf(4).equals(taskDefineMainEntity.getPluginType()) || !StringUtils.isNotBlank((CharSequence)taskDefineMainEntity.getKsScriptId())) continue;
                    scriptIds.add(taskDefineMainEntity.getKsScriptId());
                }
            }
            ScheduleExportUtil.createScriptFile(scriptIds, allDataNameMap, dir);
            downLoadUrl = ScheduleExportUtil.zipFile(tempZipPath, dir, fileName, allDataNameMap);
        }
        catch (Exception e) {
            log.error("Schedule***zipFile error", (Throwable)e);
        }
        finally {
            try {
                String filePath = FileUtils.cleanString((String)tempZipPath);
                File zipFile = new File(filePath).getCanonicalFile();
                if (zipFile.exists()) {
                    ScheduleExportUtil.deleteTempFile(zipFile);
                }
            }
            catch (IOException e) {
                log.error("Schedule***delete tempFile error", (Throwable)e);
            }
        }
        ScheduleExportUtil.buildLogInfo("sch_schedule", "sch_export");
        ScheduleExportUtil.buildLogInfo("sch_job", "job_export");
        ScheduleExportUtil.buildLogInfo("sch_taskdefine", "task_export");
        return downLoadUrl;
    }

    private static void createScriptFile(Set<String> scriptIds, Map<String, String> allDataNameMap, File dir) throws IOException {
        if (!scriptIds.isEmpty()) {
            List scriptDeployFile = MetadataDao.getScriptDeployFile((String[])scriptIds.toArray(new String[0]));
            for (DeployFile deployFile : scriptDeployFile) {
                File scriptFile = File.createTempFile(deployFile.getFileName(), ".ts", dir);
                ScheduleExportUtil.write2File(scriptFile, deployFile.getFileContent());
                allDataNameMap.put(scriptFile.getName(), deployFile.getFileName());
            }
        }
    }

    private static void deleteTempFile(File file) {
        if (!file.isDirectory()) {
            boolean fileDelete = file.delete();
            if (fileDelete) {
                log.debug("{} is deleted", (Object)file.getPath());
            }
        } else if (file.isDirectory()) {
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                File delfile = fileList[i];
                if (!delfile.isDirectory()) {
                    boolean isDelFile = delfile.delete();
                    if (!isDelFile) continue;
                    log.debug("{} is deleted", (Object)delfile.getPath());
                    continue;
                }
                if (!delfile.isDirectory()) continue;
                ScheduleExportUtil.deleteTempFile(fileList[i]);
            }
            boolean fileDelete = file.delete();
            if (fileDelete) {
                log.debug("{} is deleted", (Object)file.getPath());
            }
        }
    }

    private static void buildLogInfo(String formId, String opNumber) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = ScheduleExportUtil.doBuildLogInfo(formId, opNumber);
        logService.addLog(logInfo);
    }

    private static AppLogInfo doBuildLogInfo(String formId, String opNumber) {
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        logInfo.setBizAppID(BizAppServiceHelp.getAppIdByAppNumber((String)"sys"));
        logInfo.setBizObjID(formId);
        logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        logInfo.setOpTime(new Date());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u8c03\u5ea6\u6570\u636e\u5bfc\u51fa", "ScheduleExportUtil_2", "bos-schedule-formplugin");
        logInfo.setOpName(opNumber, opNameBridge);
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u8c03\u5ea6\u6570\u636e\u5bfc\u51fa\u6210\u529f\u3002", "ScheduleExportUtil_1", "bos-schedule-formplugin");
        logInfo.setOpDesc(opDescBridge, new String[0]);
        return logInfo;
    }

    private static File createTempFileDir(String scheduleDataPath) {
        String filePath = FileUtils.cleanString((String)scheduleDataPath);
        File dir = new File(filePath);
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new RuntimeException("create temp dir error,path is " + dir.getAbsolutePath());
            }
        } else {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].delete()) continue;
                throw new RuntimeException("delete file fail,create temp dir error,path is " + dir.getAbsolutePath());
            }
        }
        return dir;
    }

    private static void write2File(File file, String content) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file.getCanonicalFile());
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");){
            writer.write(content);
        }
    }

    private static String zipFile(String tempZipPath, File srcDir, String fileName, Map<String, String> allDataNameMap) throws IOException {
        String zipFileName = String.format("%s.zip", StringUtils.isNotBlank((CharSequence)fileName) ? fileName : "schexport_" + System.currentTimeMillis());
        File zipFile = new File(tempZipPath + File.separator + zipFileName);
        ScheduleExportUtil.doZip(srcDir, zipFile, allDataNameMap);
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFile));){
            String string = tempFileCache.saveAsUrl(zipFileName, (InputStream)in, 7200);
            return string;
        }
    }

    private static void doZip(File dir, File dest, Map<String, String> allDataNameMap) {
        try {
            FileOutputStream fos = new FileOutputStream(dest);
            ZipOutputStream zos = new ZipOutputStream(fos);
            String baseDir = "";
            File[] files = dir.listFiles();
            if (files != null && files.length > 0) {
                for (File f : files) {
                    ScheduleExportUtil.compressFile(f, zos, baseDir, allDataNameMap);
                }
            }
            zos.close();
        }
        catch (Exception ex) {
            throw new KDException(BosErrorCode.bOS, new Object[]{ex.getMessage()});
        }
    }

    private static void compressFile(File file, ZipOutputStream zos, String baseDir, Map<String, String> allDataNameMap) {
        if (!file.exists()) {
            return;
        }
        BufferedInputStream bis = null;
        try {
            int count;
            bis = new BufferedInputStream(new FileInputStream(file));
            String trueFileName = allDataNameMap.getOrDefault(file.getName(), file.getName());
            ZipEntry entry = new ZipEntry(baseDir + trueFileName);
            zos.putNextEntry(entry);
            byte[] buf = new byte[1024];
            while ((count = bis.read(buf)) != -1) {
                zos.write(buf, 0, count);
            }
        }
        catch (ZipException zipException) {
            String message = zipException.getMessage();
            String errorMsg = "";
            if (StringUtils.isNotBlank((CharSequence)message) && message.contains("duplicate entry")) {
                String fileName = allDataNameMap.getOrDefault(file.getName(), file.getName());
                String scheduleNumber = ScheduleExportUtil.getScheduleNumber(fileName);
                errorMsg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u8c03\u5ea6\u8ba1\u5212\uff1a%s", (String)"ScheduleExportUtil_3", (String)"bos-schedule-formplugin", (Object[])new Object[0]), scheduleNumber);
            }
            throw new KDException(BosErrorCode.bOS, new Object[]{errorMsg});
        }
        catch (Exception ex) {
            throw new KDException(BosErrorCode.bOS, new Object[]{ex.getMessage()});
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static String getScheduleNumber(String fileName) {
        String regex = "schedule_(.*?)\\.schdata";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(fileName);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return fileName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> getImportData(String url) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> errFileNames = new ArrayList<String>(10);
        ScheduleModelBinder binder = new ScheduleModelBinder();
        DcxmlSerializer dcxmlSerializer = new DcxmlSerializer((DcBinder)binder);
        dcxmlSerializer.setNeedDBIgnore(true);
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        ArrayList<DeployScheduleEntity> deployScheduleEntities = new ArrayList<DeployScheduleEntity>(10);
        ArrayList<DeployScriptEntity> deployScriptEntitys = new ArrayList<DeployScriptEntity>(8);
        try (InputStream inStream = cache.getInputStream(url);
             ZipInputStream zipIn = new ZipInputStream(inStream);){
            ZipEntry zipEntry;
            while ((zipEntry = zipIn.getNextEntry()) != null) {
                boolean isKingScript;
                if (zipEntry.isDirectory()) continue;
                int readLength = 0;
                int len = 0;
                byte[] buf = new byte[0x500000];
                String fileName = zipEntry.getName();
                fileName = fileName.replace(File.separator, "/");
                boolean isSchedule = StringUtils.endsWith((CharSequence)fileName, (CharSequence)"schdata");
                boolean bl = isKingScript = StringUtils.endsWith((CharSequence)fileName, (CharSequence)".ks") || StringUtils.endsWith((CharSequence)fileName, (CharSequence)".ts");
                if (isSchedule) {
                    while ((readLength = zipIn.read()) != -1) {
                        buf[len] = (byte)readLength;
                        ++len;
                    }
                    String content = new String(buf, 0, len, StandardCharsets.UTF_8);
                    try {
                        deployScheduleEntities.add((DeployScheduleEntity)dcxmlSerializer.deserializeFromString(content, null));
                        continue;
                    }
                    catch (Exception e) {
                        errFileNames.add(fileName);
                        continue;
                    }
                }
                if (isKingScript) {
                    while ((readLength = zipIn.read()) != -1) {
                        buf[len] = (byte)readLength;
                        ++len;
                    }
                    String scriptContent = new String(buf, 0, len, StandardCharsets.UTF_8);
                    DeployScriptEntity deployScriptEntity = new DeployScriptEntity(scriptContent, fileName);
                    deployScriptEntitys.add(deployScriptEntity);
                    continue;
                }
                errFileNames.add(fileName);
            }
        }
        cache.remove(url);
        result.put(DEPLOY_SCHEDULE_DATA, deployScheduleEntities);
        result.put(DEPLOY_SCRIPT_DATA, deployScriptEntitys);
        result.put("errFiles", errFileNames);
        return result;
    }
}

