/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.formplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ScheduleJobParamPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log log = LogFactory.getLog(ScheduleJobParamPlugin.class);
    private static final String CONFIRM = "confirm";
    private static final String CANCEL = "cancel";
    private static final String PARAM_TAG = "param_tag";
    private static final String BASEDATAVALUE = "basedatavalue";
    private static final String BASEDATATYPE = "basedatatype";
    private static final String BASEDATAINFO = "basedatainfo";
    private static final String RETURNDATA = "returnData";
    private static final String PARAMVALUE = "paramvalue";
    private static final String PARAMTYPE = "paramtype";
    private static final String PARAMCALLBACK = "paramCallBack";
    private static final String NUMBER = "number";
    private static final String CACHE_KEY_BASE_ENTITY = "baseentitynumber";
    private static final String BOS_SCHEDULE_FORMPLUGIN = "bos-schedule-formplugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CONFIRM, CANCEL, PARAMVALUE});
        BasedataEdit control = (BasedataEdit)this.getView().getControl(BASEDATAVALUE);
        if (control != null) {
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if (CONFIRM.equals(key)) {
            String paramTag = this.getPageCache().get(PARAM_TAG);
            HashMap<String, Object> returnData = new HashMap<String, Object>(4);
            if (BASEDATAVALUE.equals(paramTag)) {
                String type;
                HashMap<String, Object> basedataInfoMap = new HashMap<String, Object>(16);
                BasedataProp basedataProp = (BasedataProp)this.getModel().getProperty(paramTag);
                DynamicObject basedatatype = (DynamicObject)this.getModel().getValue(BASEDATATYPE);
                if (basedatatype == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"ScheduleJobParamPlugin_2", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> basedataTypeMap = new HashMap<String, Object>();
                basedataTypeMap.put(NUMBER, "bos_formmeta");
                basedataTypeMap.put("id", basedatatype.getPkValue());
                Object pkId = this.getModel().getValue("basedatavalue_id");
                String entityId = basedataProp.getBaseEntityId();
                HashMap<String, Object> basedataValueMap = new HashMap<String, Object>();
                basedataValueMap.put(NUMBER, entityId);
                if (StringUtils.isNotBlank((Object)pkId) && !StringUtils.equals((CharSequence)"0", (CharSequence)pkId.toString())) {
                    basedataValueMap.put("id", pkId);
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)entityId);
                    String nameProp = ((BasedataEntityType)dynamicObject.getDataEntityType()).getNameProperty();
                    Object nameValue = dynamicObject.get(nameProp);
                    String nameStr = nameValue != null ? nameValue.toString() : "";
                    basedataInfoMap.put(PARAMVALUE, nameStr);
                }
                if (StringUtils.equals((CharSequence)PARAMVALUE, (CharSequence)(type = (String)this.getView().getFormShowParameter().getCustomParam(PARAMTYPE)))) {
                    basedataInfoMap.put(BASEDATAVALUE, basedataValueMap);
                }
                basedataInfoMap.put(BASEDATATYPE, basedataTypeMap);
                basedataInfoMap.put("type", "basedata");
                returnData.put(RETURNDATA, basedataInfoMap);
                this.getPageCache().remove(CACHE_KEY_BASE_ENTITY);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                return;
            }
            if (StringUtils.isBlank((Object)this.getModel().getValue(paramTag))) {
                returnData.put(PARAMVALUE, "");
            } else {
                HashMap<String, String> dataMap = new HashMap<String, String>(4);
                String paramDefValue = "";
                switch (paramTag) {
                    case "datetype": {
                        Date date = (Date)this.getModel().getValue("datetype");
                        String pattern = "yyyy-MM-dd";
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                        paramDefValue = simpleDateFormat.format(date);
                        break;
                    }
                    case "datetimetype": {
                        Date datetimetype = (Date)this.getModel().getValue("datetimetype");
                        String patternTime = "yyyy-MM-dd HH:mm:ss";
                        SimpleDateFormat simpleDateFormatTime = new SimpleDateFormat(patternTime);
                        paramDefValue = simpleDateFormatTime.format(datetimetype);
                        break;
                    }
                    case "timetype": {
                        Integer timetype = (Integer)this.getModel().getValue("timetype");
                        paramDefValue = this.formatDuration(timetype);
                        break;
                    }
                    case "booleantype": {
                        paramDefValue = StringUtils.equals((CharSequence)"1", (CharSequence)((String)this.getModel().getValue("booleantype"))) ? "true" : "false";
                        break;
                    }
                    default: {
                        paramDefValue = String.valueOf(this.getModel().getValue(paramTag));
                    }
                }
                dataMap.put("type", "text");
                dataMap.put(PARAMVALUE, paramDefValue);
                returnData.put(RETURNDATA, dataMap);
            }
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        } else if (CANCEL.equals(key)) {
            this.getView().close();
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        Map basedataInfoMap;
        Object basedataDef;
        super.getEntityType(e);
        String basedataInfo = (String)this.getView().getFormShowParameter().getCustomParam(BASEDATAINFO);
        if (StringUtils.isNotBlank((CharSequence)basedataInfo) && (basedataDef = (basedataInfoMap = (Map)SerializationUtils.fromJsonString((String)basedataInfo, Map.class)).get(BASEDATAVALUE)) != null) {
            Map basedataDefMap = (Map)basedataDef;
            String baseentity = (String)basedataDefMap.get(NUMBER);
            this.setEntityType(e, baseentity);
        }
        String baseentity = this.getPageCache().get(CACHE_KEY_BASE_ENTITY);
        this.setEntityType(e, baseentity);
    }

    private void setEntityType(GetEntityTypeEventArgs e, String baseentity) {
        if (StringUtils.isNotBlank((CharSequence)baseentity)) {
            MainEntityType baseType = EntityMetadataCache.getDataEntityType((String)baseentity);
            MainEntityType mainType = null;
            try {
                mainType = (MainEntityType)e.getOriginalEntityType().clone();
            }
            catch (CloneNotSupportedException e1) {
                log.error(e1.getMessage());
            }
            BasedataProp baseProp = (BasedataProp)mainType.findProperty(BASEDATAVALUE);
            baseProp.setComplexType((IDataEntityType)baseType);
            baseProp.setBaseEntityId(baseType.getName());
            DynamicSimpleProperty refIdProp = (DynamicSimpleProperty)mainType.findProperty(baseProp.getRefIdProp().getName());
            mainType.getProperties().remove((Object)refIdProp);
            refIdProp = baseProp.createRefIDProp();
            refIdProp.setPrimaryKey(false);
            if (StringUtils.isBlank((CharSequence)baseProp.getAlias())) {
                refIdProp.setDbIgnore(true);
            } else {
                refIdProp.setAlias(baseProp.getAlias());
                refIdProp.setTableGroup(baseProp.getTableGroup());
            }
            refIdProp.setName(baseProp.getName() + "_id");
            mainType.addProperty((DynamicProperty)refIdProp);
            baseProp.setRefIdPropName(baseProp.getName() + "_id");
            baseProp.setRefIdProp((IDataEntityProperty)refIdProp);
            e.setNewEntityType(mainType);
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String visibles = (String)parameter.getCustomParam("visible");
        String value = (String)parameter.getCustomParam("value");
        List visibleList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)visibles)) {
            visibleList = (List)SerializationUtils.fromJsonString((String)visibles, List.class);
        }
        if (visibleList.size() == 1) {
            this.getPageCache().put(PARAM_TAG, (String)visibleList.get(0));
        } else if (visibleList.size() == 2 && visibleList.contains(BASEDATAVALUE)) {
            this.getPageCache().put(PARAM_TAG, BASEDATAVALUE);
        }
        Boolean isSetRunParam = Boolean.parseBoolean((String)this.getView().getFormShowParameter().getCustomParam("isSetRunParam"));
        for (String visible : visibleList) {
            if (!StringUtils.equals((CharSequence)BASEDATATYPE, (CharSequence)visible) && !StringUtils.equals((CharSequence)BASEDATAVALUE, (CharSequence)visible)) {
                this.getModel().setValue(visible, (Object)value);
                if (isSetRunParam.booleanValue()) {
                    HashMap<String, LocaleString> updateDisplayName = new HashMap<String, LocaleString>(1);
                    updateDisplayName.put("caption", new LocaleString(ResManager.loadKDString((String)"\u53c2\u6570\u503c", (String)"ScheduleJobParamPlugin_3", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])));
                    this.getView().updateControlMetadata(visible, updateDisplayName);
                }
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{visible});
        }
        String basedataInfo = (String)parameter.getCustomParam(BASEDATAINFO);
        if (StringUtils.isNotBlank((CharSequence)basedataInfo)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BASEDATATYPE});
            String type = (String)parameter.getCustomParam(PARAMTYPE);
            Map basedataMap = (Map)SerializationUtils.fromJsonString((String)basedataInfo, Map.class);
            Map basedataTypeMap = (Map)basedataMap.get(BASEDATATYPE);
            Map basedataValueMap = null;
            if (StringUtils.equals((CharSequence)PARAMVALUE, (CharSequence)type) && (basedataValueMap = (Map)basedataMap.get(BASEDATAVALUE)) == null) {
                basedataValueMap = (Map)basedataMap.get(BASEDATAVALUE);
            }
            if (basedataTypeMap != null && basedataValueMap != null) {
                Object pkId = basedataTypeMap.get("id");
                DynamicObject basedataTypeDy = BusinessDataServiceHelper.loadSingle(pkId, (String)"bos_formmeta");
                String basedataValueNumber = (String)basedataValueMap.get(NUMBER);
                this.getPageCache().put(CACHE_KEY_BASE_ENTITY, basedataValueNumber);
                if (basedataValueMap.get("id") != null) {
                    DynamicObject basedataValueDy = BusinessDataServiceHelper.loadSingle(basedataValueMap.get("id"), (String)basedataValueNumber);
                    this.getModel().setValue(BASEDATAVALUE, (Object)basedataValueDy);
                }
                if (basedataTypeMap != null && basedataValueMap != null) {
                    BasedataEdit basedatavalue = (BasedataEdit)this.getView().getControl(BASEDATAVALUE);
                    BasedataProp basedataProp = (BasedataProp)basedatavalue.getProperty();
                    if (StringUtils.isNotBlank((CharSequence)basedataValueNumber)) {
                        basedataProp.setBaseEntityId(basedataValueNumber);
                        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)basedataValueNumber);
                        basedataProp.setComplexType((IDataEntityType)dataEntityType);
                    }
                }
                this.getModel().setValue(BASEDATATYPE, (Object)basedataTypeDy);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if (BASEDATATYPE.equals(name)) {
            this.getModel().setValue(BASEDATAVALUE, null);
            BasedataEdit basedatavalue = (BasedataEdit)this.getView().getControl(BASEDATAVALUE);
            BasedataProp basedataProp = (BasedataProp)basedatavalue.getProperty();
            DynamicObject basedatatype = (DynamicObject)this.getModel().getValue(BASEDATATYPE);
            if (basedatatype == null) {
                return;
            }
            String fnumber = (String)basedatatype.get(NUMBER);
            this.getPageCache().put(CACHE_KEY_BASE_ENTITY, fnumber);
            if (StringUtils.isNotBlank((CharSequence)fnumber)) {
                basedataProp.setBaseEntityId(fnumber);
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)fnumber);
                basedataProp.setComplexType((IDataEntityType)dataEntityType);
            }
            this.getView().updateView();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (PARAMCALLBACK.equals(actionId) && returnData != null) {
            Map dataMap = (Map)returnData;
            if (dataMap.get(PARAMVALUE) != null) {
                this.getModel().setValue(PARAMVALUE, dataMap.get(PARAMVALUE));
            } else {
                this.getModel().setValue(PARAMVALUE, (Object)"");
            }
        }
    }

    private String formatDuration(int duration) {
        if (duration == 0) {
            return "00:00:00";
        }
        String time = String.format("%02d:%2$02d:%3$02d", duration / 3600, duration % 3600 / 60, duration % 60);
        return time;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Object basedataType = this.getModel().getValue(BASEDATATYPE);
        if (basedataType == null) {
            beforeF7SelectEvent.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"ScheduleJobParamPlugin_0", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    public boolean updateParamValue(Object id, String paramValue) {
        boolean isSuccess = true;
        String sql = "update T_SCH_JOBPARAMS set FParamValue = ? where fentryid = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FParamValue", 12, (Object)paramValue), new SqlParameter(":fid", 12, id)};
        Throwable throwable = null;
        try (TXHandle handle = TX.beginNew();){
            boolean bl = DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            return bl;
        }
        catch (Exception e) {
            isSuccess = false;
            log.error((Throwable)e);
            handle.markRollback();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return isSuccess;
    }
}

