/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ScheduleNotifyPlugin
extends AbstractFormPlugin {
    private static final String MSG_CONTENT = "sch_msg_content";
    private static final String TEMPLATECALLBACK = "templateCallBack";
    private static final String MSGCONTENT = "smsgcontent";
    private static final String FSMSGCONTENT = "fsmsgcontent";
    private static final String NOTIFYTYPE = "snotifytype";
    private static final String FSNOTIFYTYPE = "fsnotifytype";
    private static final String MSGTEMPLATE = "msg_template";
    private static final String MSGCHANNEL = "msg_channel";
    private static final String CUSTOM_SUBJECT = "customSubject";
    private Set<String> enableTypes = new HashSet<String>(16);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setMsgChannelItem();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String notifyType = (String)this.getModel().getValue(FSNOTIFYTYPE);
        if (StringUtils.isNotBlank((CharSequence)notifyType)) {
            String[] types = notifyType.split(",");
            ArrayList<String> effectTypes = new ArrayList<String>();
            for (String type : types) {
                if (!this.enableTypes.contains(type) || !StringUtils.isNotBlank((CharSequence)type)) continue;
                effectTypes.add(type);
            }
            this.getModel().setValue(FSNOTIFYTYPE, (Object)effectTypes.stream().collect(Collectors.joining(",")));
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.setMsgChannelItem();
        HashMap<String, String> msgTemplateMap = new HashMap<String, String>(16);
        QFilter[] filters = new QFilter[]{new QFilter("msgentity", "=", (Object)"sch_schedule")};
        DynamicObject[] templatelArray = BusinessDataServiceHelper.load((String)MSGTEMPLATE, (String)"msgtype,msgchannel,msgtemplate", (QFilter[])filters, (String)"createdate asc");
        if (templatelArray != null && templatelArray.length > 0) {
            HashSet<String> notifyTypeSets = new HashSet<String>(10);
            for (DynamicObject dynamicObject : templatelArray) {
                String msgchannel = dynamicObject.getString("msgchannel");
                String msgtemplate = dynamicObject.getLocaleString("msgtemplate").getLocaleValue();
                notifyTypeSets.add(msgchannel);
                msgTemplateMap.put(FSMSGCONTENT, msgtemplate);
            }
            msgTemplateMap.put(FSNOTIFYTYPE, notifyTypeSets.stream().collect(Collectors.joining(",")));
        }
        String fsmsgcontent = (String)msgTemplateMap.get(FSMSGCONTENT);
        this.getModel().setValue(FSNOTIFYTYPE, msgTemplateMap.get(FSNOTIFYTYPE));
        this.getModel().setValue(FSMSGCONTENT, (Object)(fsmsgcontent == null ? "" : fsmsgcontent));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{FSMSGCONTENT});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        String entityName = this.getModel().getDataEntityType().getName();
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        if (FSMSGCONTENT.equals(key)) {
            String fsmsgcontent = (String)this.getView().getModel().getValue(FSMSGCONTENT);
            parameter.setFormId(MSG_CONTENT);
            parameter.setCaption(ResManager.loadKDString((String)"\u6d88\u606f\u5185\u5bb9\u7f16\u8f91", (String)"ScheduleJobNotifyPlugin_0", (String)"bos-schedule-formplugin", (Object[])new Object[0]));
            parameter.setCustomParam("entityNumber", (Object)entityName);
            parameter.setCustomParam("FROM", (Object)"task");
            parameter.setCustomParam("value", (Object)fsmsgcontent);
            parameter.setCustomParam("isInclude", (Object)"true");
            parameter.setCustomParam("includeFields", (Object)SerializationUtils.toJsonString(Arrays.asList("number", "name", "starttime", "endtime", "schprincipal")));
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TEMPLATECALLBACK));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (TEMPLATECALLBACK.equals(actionId) && returnData != null) {
            String content = null;
            Map dataMap = (Map)returnData;
            if (StringUtils.isNotBlank((CharSequence)((String)dataMap.get(CUSTOM_SUBJECT)))) {
                content = (String)dataMap.get(CUSTOM_SUBJECT);
            } else if (StringUtils.isBlank((CharSequence)((String)dataMap.get(CUSTOM_SUBJECT)))) {
                dataMap.remove(CUSTOM_SUBJECT);
                content = "";
            }
            this.getModel().setValue(FSMSGCONTENT, (Object)content);
        }
    }

    private void setMsgChannelItem() {
        DynamicObject[] channelArray = BusinessDataServiceHelper.load((String)MSGCHANNEL, (String)"id, number, name, enable", null);
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(10);
        if (channelArray != null && channelArray.length > 0) {
            for (DynamicObject channelDo : channelArray) {
                OrmLocaleValue name = (OrmLocaleValue)channelDo.get("name");
                String number = channelDo.getString("number");
                Boolean enable = channelDo.getBoolean("enable");
                if (!enable.booleanValue() || "sysnotice".equalsIgnoreCase(number)) continue;
                this.enableTypes.add(number);
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(number);
                comboItem.setCaption(new LocaleString(name != null ? name.getLocaleValue() : ""));
                comboItemList.add(comboItem);
            }
        }
        ComboEdit combo = (ComboEdit)this.getView().getControl(FSNOTIFYTYPE);
        combo.setComboItems(comboItemList);
    }
}

