/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.formplugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.IScheduleEntityInvoker;
import kd.bos.schedule.api.SchEntityType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.next.observable.model.TaskTraceInfo;
import kd.bos.schedule.next.observable.model.TaskTraceStatusEnum;
import kd.bos.schedule.utils.ScheduleDataEntityUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.schedule.ScheduleDataEntityInvoker;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class ScheduleTaskTracePlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log logger = LogFactory.getLog(ScheduleTaskTracePlugin.class);
    private static final String ANALYZE_RESULT = "analyzeresult";
    private static final String CUSTOM_PARAM_TASKID = "taskId";
    private static final String TASK_ID_QUERY = "taskid";
    private static final String JOB_ID_QUERY = "jobid";
    private static final String SCHEDULE_ID_QUERY = "schid";
    private static final String QUERY_CONDITION = "querycondition";
    private static final String TASK_QUERY = "taskQuery";
    private static final String SCHEDULE_QUERY = "scheduleQuery";
    private static final String JOB_QUERY = "jobQuery";
    private static final String TASK_ID_INFO = "taskidinfo";
    private static final String SCH_NUMBER_INFO = "schnumberinfo";
    private static final String SCH_ID_INFO = "schidinfo";
    private static final String JOB_NUMBER_INFO = "jobnumberinfo";
    private static final String JOB_ID_INFO = "jobidinfo";
    private static final String INSTANCE_ID_INFO = "instanceidinfo";
    private static final String TRACE_ID_INFO = "traceidinfo";
    private static final String APP_ID_INFO = "appidinfo";
    private static final String CRON_INFO = "croninfo";
    private static final String BOS_SCHEDULE_FORMPLUGIN = "bos-schedule-formplugin";
    private static final String TASK_TRACE_TABLE = "t_sch_tasktrace";
    private static final String TRACE_ENTRY = "traceentry";
    private static final DBRoute Sch_Route = DBRoute.basedata;
    private static final String EXECUTOR_TRACE = "executorTrace";
    private static final String SERVER_TRACE = "serverTrace";

    public void registerListener(EventObject e) {
        Button queryBtn = (Button)this.getView().getControl("query");
        queryBtn.addClickListener((ClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        ChangeData changeData = e.getChangeSet()[0];
        String changeName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)changeName, (CharSequence)QUERY_CONDITION) && (newValue = changeData.getNewValue()) != null) {
            String queryCondition;
            switch (queryCondition = String.valueOf(newValue)) {
                case "taskQuery": {
                    this.setVisible(TASK_ID_QUERY);
                    this.setInVisible(JOB_ID_QUERY, SCHEDULE_ID_QUERY);
                    this.getModel().setValue(SCHEDULE_ID_QUERY, (Object)"");
                    this.getModel().setValue(JOB_ID_QUERY, (Object)"");
                    break;
                }
                case "scheduleQuery": {
                    this.setVisible(SCHEDULE_ID_QUERY);
                    this.setInVisible(TASK_ID_QUERY, JOB_ID_QUERY);
                    this.getModel().setValue(TASK_ID_QUERY, (Object)"");
                    this.getModel().setValue(JOB_ID_QUERY, (Object)"");
                    break;
                }
                case "jobQuery": {
                    this.setVisible(JOB_ID_QUERY);
                    this.setInVisible(TASK_ID_QUERY, SCHEDULE_ID_QUERY);
                    this.getModel().setValue(TASK_ID_QUERY, (Object)"");
                    this.getModel().setValue(SCHEDULE_ID_QUERY, (Object)"");
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object taskIdObj = this.getView().getFormShowParameter().getCustomParam(CUSTOM_PARAM_TASKID);
        if (StringUtils.isNotBlank((Object)taskIdObj)) {
            String taskId = (String)taskIdObj;
            this.getModel().setValue(TASK_ID_QUERY, (Object)taskId);
            try {
                this.taskTrace();
            }
            catch (Exception exception) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u8ffd\u8e2a\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ScheduleTaskTracePlugin_2", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                logger.error("Schedule***task trace error", (Object)e);
            }
        }
    }

    private void taskTrace() {
        this.getModel().deleteEntryData(TRACE_ENTRY);
        Map<String, TaskTraceInfo> taskTraceInfos = this.queryTaskTrace();
        if (taskTraceInfos == null || taskTraceInfos.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u8f68\u8ff9\uff0c\u4efb\u52a1\u8f68\u8ff9\u53ef\u80fd\u5df2\u7ecf\u6e05\u9664\u6216\u8005\u4efb\u52a1\u8f68\u8ff9\u8fd8\u6ca1\u6709\u751f\u6210\u3002", (String)"ScheduleTaskTracePlugin_3", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        this.resetScheduleInfoAndAnalyzeResult();
        TaskTraceInfo taskTraceInfo = this.mergeToOneTaskTraceInfo(taskTraceInfos);
        if (taskTraceInfo == null) {
            logger.error("Schedule***ScheduleTaskTracePlugin merge to one task trace info error,taskTraceInfos:{}", taskTraceInfos);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u8f68\u8ff9\u5408\u5e76\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ScheduleTaskTracePlugin_5", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (!this.queryAndFillScheduleInfo(taskTraceInfo.getTaskId())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u8fd0\u884c\u4efb\u52a1\uff0c\u8fd0\u884c\u4efb\u52a1\u53ef\u80fd\u5df2\u7ecf\u6e05\u9664\u3002", (String)"ScheduleTaskTracePlugin_4", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        String status = taskTraceInfo.getStatus();
        TaskTraceStatusEnum taskTraceStatusEnum = TaskTraceStatusEnum.getInstance((String)status);
        String analyzeResult = taskTraceStatusEnum.getStatusDesc();
        this.getModel().setValue(ANALYZE_RESULT, (Object)analyzeResult);
        String taskRecord = taskTraceInfo.getTaskRecord();
        List<TaskTraceRecord> taskTraceRecords = this.convertToTaskTraceRecord(taskRecord);
        this.getModel().batchCreateNewEntryRow(TRACE_ENTRY, taskTraceRecords.size());
        DynamicObjectCollection traceEntry = this.getModel().getEntryEntity(TRACE_ENTRY);
        int i = 0;
        for (DynamicObject dynamicObject : traceEntry) {
            dynamicObject.set("time", (Object)taskTraceRecords.get(i).getTime());
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                dateFormat.setTimeZone(KDDateUtils.getUserTimeZone());
                Date date = dateFormat.parse(taskTraceRecords.get(i).getTime());
                dynamicObject.set("time1", (Object)date);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            dynamicObject.set("tasktrace", (Object)taskTraceRecords.get(i).getTasktrace());
            ++i;
        }
        this.getView().updateView(TRACE_ENTRY);
    }

    private TaskTraceInfo mergeToOneTaskTraceInfo(Map<String, TaskTraceInfo> taskTraceInfos) {
        if (taskTraceInfos.size() > 1) {
            TaskTraceInfo serverTaskTrace = taskTraceInfos.get(SERVER_TRACE);
            TaskTraceInfo executorTaskTrace = taskTraceInfos.get(EXECUTOR_TRACE);
            if (serverTaskTrace != null && executorTaskTrace != null) {
                serverTaskTrace.setTaskId(executorTaskTrace.getTaskId());
                serverTaskTrace.setStatus(executorTaskTrace.getStatus());
                StringBuilder record = new StringBuilder(serverTaskTrace.getTaskRecord());
                record.append(executorTaskTrace.getTaskRecord());
                serverTaskTrace.setTaskRecord(record.toString());
                return serverTaskTrace;
            }
        } else {
            Iterator<TaskTraceInfo> iterator = taskTraceInfos.values().iterator();
            if (iterator.hasNext()) {
                TaskTraceInfo value = iterator.next();
                return value;
            }
        }
        return null;
    }

    private List<TaskTraceRecord> convertToTaskTraceRecord(String taskRecord) {
        String[] taskRecords = taskRecord.split("\r\n");
        ArrayList<TaskTraceRecord> taskTraceRecords = new ArrayList<TaskTraceRecord>(taskRecords.length);
        for (String record : taskRecords) {
            String[] timeAndRecord = record.split("#");
            if (timeAndRecord.length == 2) {
                TaskTraceRecord taskTraceRecord = new TaskTraceRecord(timeAndRecord[0], TaskTraceStatusEnum.getInstance((String)timeAndRecord[1]).getStatusDesc());
                taskTraceRecords.add(taskTraceRecord);
                continue;
            }
            if (timeAndRecord.length != 3) continue;
            String statusCode = timeAndRecord[1];
            String generateTime = timeAndRecord[2];
            StringBuilder recordBuilder = new StringBuilder();
            recordBuilder.append(TaskTraceStatusEnum.getInstance((String)statusCode).getStatusDesc()).append("\uff1a").append(generateTime);
            TaskTraceRecord taskTraceRecord = new TaskTraceRecord(timeAndRecord[0], recordBuilder.toString());
            taskTraceRecords.add(taskTraceRecord);
        }
        return taskTraceRecords;
    }

    private Map<String, TaskTraceInfo> queryTaskTrace() {
        Object queryConditionObj = this.getModel().getValue(QUERY_CONDITION);
        Map<String, TaskTraceInfo> taskTraceInfos = null;
        if (queryConditionObj != null) {
            String queryCondition;
            switch (queryCondition = (String)queryConditionObj) {
                case "taskQuery": {
                    Object taskIdObj = this.getModel().getValue(TASK_ID_QUERY);
                    if (StringUtils.isBlank((Object)taskIdObj)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4efb\u52a1Id\u3002", (String)"ScheduleTaskTracePlugin_6", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                        return Collections.emptyMap();
                    }
                    String taskId = String.valueOf(taskIdObj);
                    taskTraceInfos = this.queryTaskTraceByTaskId(taskId);
                    break;
                }
                case "scheduleQuery": {
                    Object scheduleIdObj = this.getModel().getValue(SCHEDULE_ID_QUERY);
                    if (StringUtils.isBlank((Object)scheduleIdObj)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8c03\u5ea6\u8ba1\u5212Id\u3002", (String)"ScheduleTaskTracePlugin_7", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                        return Collections.emptyMap();
                    }
                    String scheduleId = String.valueOf(scheduleIdObj);
                    taskTraceInfos = this.queryTaskTraceByScheduleId(scheduleId);
                    break;
                }
                case "jobQuery": {
                    Object jobIdObj = this.getModel().getValue(JOB_ID_QUERY);
                    if (StringUtils.isBlank((Object)jobIdObj)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8c03\u5ea6\u4f5c\u4e1aId\u3002", (String)"ScheduleTaskTracePlugin_8", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                        return Collections.emptyMap();
                    }
                    String jobId = String.valueOf(jobIdObj);
                    taskTraceInfos = this.queryTaskTraceByJobId(jobId);
                }
            }
        }
        return taskTraceInfos;
    }

    private Map<String, TaskTraceInfo> queryTaskTraceByTaskId(String taskId) {
        TaskTraceInfo serverTaskTrace;
        ScheduleDataEntityInvoker invoker;
        DynamicObject jobDynamicObj;
        HashMap<String, TaskTraceInfo> taskTraceInfos = new HashMap<String, TaskTraceInfo>(2);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (taskInfo == null) {
            return Collections.emptyMap();
        }
        String querySQL = "SELECT FTASKID,FSTATUS,FTASKRECORD,FMODIFYTIME,FGROUPID FROM t_sch_tasktrace WHERE FTASKID = ?";
        Object[] sqlParameters = new SqlParameter[]{new SqlParameter(":FTASKID", 12, (Object)taskId)};
        TaskTraceInfo executorTaskTrace = (TaskTraceInfo)DB.query((DBRoute)Sch_Route, (String)querySQL, (Object[])sqlParameters, rs -> {
            if (rs.next()) {
                TaskTraceInfo taskTraceInfoDB = new TaskTraceInfo();
                taskTraceInfoDB.setTaskId(rs.getString("FTASKID"));
                taskTraceInfoDB.setStatus(rs.getString("FSTATUS"));
                taskTraceInfoDB.setTaskRecord(rs.getString("FTASKRECORD"));
                taskTraceInfoDB.setModifyTime((Date)rs.getDate("FMODIFYTIME"));
                taskTraceInfoDB.setGroupId(rs.getLong("FGROUPID"));
                return taskTraceInfoDB;
            }
            return null;
        });
        if (executorTaskTrace == null) {
            return Collections.emptyMap();
        }
        taskTraceInfos.put(EXECUTOR_TRACE, executorTaskTrace);
        if (taskInfo.getGroupId() != 0L && (jobDynamicObj = (invoker = new ScheduleDataEntityInvoker()).loadSingleFromCache(SchEntityType.Job, (Object)taskInfo.getJobId(), "runmode")) != null && jobDynamicObj.getInt("runmode") == 1 && (serverTaskTrace = this.queryServerTaskTraceByGroupId(taskInfo.getGroupId())) != null) {
            taskTraceInfos.put(SERVER_TRACE, serverTaskTrace);
        }
        return taskTraceInfos;
    }

    private TaskTraceInfo queryServerTaskTraceByGroupId(long groupId) {
        String querySQL = "SELECT FTASKID,FSTATUS,FTASKRECORD,FMODIFYTIME,FGROUPID FROM t_sch_tasktrace WHERE FGROUPID = ?";
        Object[] sqlParameters = new SqlParameter[]{new SqlParameter(":FGROUPID", -5, (Object)groupId)};
        return (TaskTraceInfo)DB.query((DBRoute)Sch_Route, (String)querySQL, (Object[])sqlParameters, rs -> {
            while (rs.next()) {
                if (!StringUtils.equals((CharSequence)rs.getString("FSTATUS"), (CharSequence)TaskTraceStatusEnum.SERVER_SEND_MQ_SUCCESS.getStatusCode())) continue;
                TaskTraceInfo taskTraceInfoDB = new TaskTraceInfo();
                taskTraceInfoDB.setTaskId(rs.getString("FTASKID"));
                taskTraceInfoDB.setStatus(rs.getString("FSTATUS"));
                taskTraceInfoDB.setTaskRecord(rs.getString("FTASKRECORD"));
                taskTraceInfoDB.setModifyTime((Date)rs.getDate("FMODIFYTIME"));
                taskTraceInfoDB.setGroupId(rs.getLong("FGROUPID"));
                return taskTraceInfoDB;
            }
            return null;
        });
    }

    private Map<String, TaskTraceInfo> queryTaskTraceByScheduleId(String scheduleId) {
        boolean isBroadcastMode;
        HashMap<String, TaskTraceInfo> taskTraceInfoMap = new HashMap<String, TaskTraceInfo>(2);
        String querySQL = "SELECT FTASKID,FJOBID,FSTATUS,FTASKRECORD,FMODIFYTIME,FGROUPID FROM t_sch_tasktrace WHERE FSCHEDULEID = ? ORDER BY FMODIFYTIME DESC";
        Object[] sqlParameters = new SqlParameter[]{new SqlParameter(":FSCHEDULEID", 12, (Object)scheduleId)};
        TaskTraceInfo taskTraceInfo = (TaskTraceInfo)DB.query((DBRoute)Sch_Route, (String)querySQL, (Object[])sqlParameters, rs -> {
            if (rs.next()) {
                TaskTraceInfo taskTraceInfoQuery = new TaskTraceInfo();
                taskTraceInfoQuery.setTaskId(rs.getString("FTASKID"));
                taskTraceInfoQuery.setJobId(rs.getString("FJOBID"));
                taskTraceInfoQuery.setStatus(rs.getString("FSTATUS"));
                taskTraceInfoQuery.setTaskRecord(rs.getString("FTASKRECORD"));
                taskTraceInfoQuery.setModifyTime((Date)rs.getDate("FMODIFYTIME"));
                taskTraceInfoQuery.setGroupId(rs.getLong("FGROUPID"));
                return taskTraceInfoQuery;
            }
            return null;
        });
        if (taskTraceInfo == null) {
            return Collections.emptyMap();
        }
        taskTraceInfoMap.put(EXECUTOR_TRACE, taskTraceInfo);
        if (taskTraceInfo.getGroupId() != 0L && (isBroadcastMode = this.isBroadcastMode(taskTraceInfo.getJobId())) && !this.isServerTaskTrace(taskTraceInfo.getStatus())) {
            TaskTraceInfo serverTaskTrace = this.queryServerTaskTraceByGroupId(taskTraceInfo.getGroupId());
            taskTraceInfoMap.put(SERVER_TRACE, serverTaskTrace);
        }
        return taskTraceInfoMap;
    }

    private boolean isBroadcastMode(String jobId) {
        if (StringUtils.isBlank((CharSequence)jobId)) {
            return false;
        }
        ScheduleDataEntityInvoker invoker = new ScheduleDataEntityInvoker();
        DynamicObject jobDynamicObj = invoker.loadSingleFromCache(SchEntityType.Job, (Object)jobId, "runmode");
        return jobDynamicObj != null && jobDynamicObj.getInt("runmode") == 1;
    }

    private boolean isServerTaskTrace(String status) {
        return StringUtils.equals((CharSequence)TaskTraceStatusEnum.SERVER_GENERATE_TIME.getStatusCode(), (CharSequence)status) || StringUtils.equals((CharSequence)TaskTraceStatusEnum.SERVER_ACCOUNT_NOT_EXIST.getStatusCode(), (CharSequence)status) || StringUtils.equals((CharSequence)TaskTraceStatusEnum.SERVER_SCHEDULE_VISITOR_PAUSED.getStatusCode(), (CharSequence)status) || StringUtils.equals((CharSequence)TaskTraceStatusEnum.SERVER_PUSH_LOCAL_QUEUE.getStatusCode(), (CharSequence)status) || StringUtils.equals((CharSequence)TaskTraceStatusEnum.SERVER_POP_LOCAL_QUEUE.getStatusCode(), (CharSequence)status) || StringUtils.equals((CharSequence)TaskTraceStatusEnum.SERVER_BEGIN_SEND_MQ.getStatusCode(), (CharSequence)status) || StringUtils.equals((CharSequence)TaskTraceStatusEnum.SERVER_SEND_MQ_SUCCESS.getStatusCode(), (CharSequence)status) || StringUtils.equals((CharSequence)TaskTraceStatusEnum.SERVER_ERROR.getStatusCode(), (CharSequence)status);
    }

    private Map<String, TaskTraceInfo> queryTaskTraceByJobId(String jobId) {
        boolean isBroadcastMode;
        HashMap<String, TaskTraceInfo> taskTraceInfoMap = new HashMap<String, TaskTraceInfo>(2);
        String querySQL = "SELECT FTASKID,FJOBID,FSTATUS,FTASKRECORD,FMODIFYTIME,FGROUPID FROM t_sch_tasktrace WHERE FJOBID = ? ORDER BY FMODIFYTIME DESC";
        Object[] sqlParameters = new SqlParameter[]{new SqlParameter(":FJOBID", 12, (Object)jobId)};
        TaskTraceInfo taskTraceInfo = (TaskTraceInfo)DB.query((DBRoute)Sch_Route, (String)querySQL, (Object[])sqlParameters, rs -> {
            if (rs.next()) {
                TaskTraceInfo taskTraceInfoQuery = new TaskTraceInfo();
                taskTraceInfoQuery.setTaskId(rs.getString("FTASKID"));
                taskTraceInfoQuery.setJobId(rs.getString("FJOBID"));
                taskTraceInfoQuery.setStatus(rs.getString("FSTATUS"));
                taskTraceInfoQuery.setTaskRecord(rs.getString("FTASKRECORD"));
                taskTraceInfoQuery.setModifyTime((Date)rs.getDate("FMODIFYTIME"));
                taskTraceInfoQuery.setGroupId(rs.getLong("FGROUPID"));
                return taskTraceInfoQuery;
            }
            return null;
        });
        if (taskTraceInfo == null) {
            return Collections.emptyMap();
        }
        taskTraceInfoMap.put(EXECUTOR_TRACE, taskTraceInfo);
        if (taskTraceInfo.getGroupId() != 0L && (isBroadcastMode = this.isBroadcastMode(taskTraceInfo.getJobId())) && !this.isServerTaskTrace(taskTraceInfo.getStatus())) {
            TaskTraceInfo serverTaskTrace = this.queryServerTaskTraceByGroupId(taskTraceInfo.getGroupId());
            taskTraceInfoMap.put(SERVER_TRACE, serverTaskTrace);
        }
        return taskTraceInfoMap;
    }

    public void afterBindData(EventObject e) {
        this.setInVisible(JOB_ID_QUERY, SCHEDULE_ID_QUERY);
    }

    private boolean queryAndFillScheduleInfo(String taskId) {
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (taskInfo == null) {
            return false;
        }
        Map<String, String> scheduleAndJobInfo = this.queryScheduleAndJobInfo(taskInfo);
        this.fillScheduleInfo(taskInfo, scheduleAndJobInfo);
        return true;
    }

    private void fillScheduleInfo(TaskInfo taskInfo, Map<String, String> scheduleAndJobInfo) {
        this.getModel().setValue(TASK_ID_INFO, (Object)taskInfo.getId());
        this.getModel().setValue(SCH_NUMBER_INFO, (Object)scheduleAndJobInfo.get("schNumber"));
        this.getModel().setValue(SCH_ID_INFO, (Object)taskInfo.getScheduleId());
        this.getModel().setValue(JOB_NUMBER_INFO, (Object)scheduleAndJobInfo.get("jobNumber"));
        this.getModel().setValue(JOB_ID_INFO, (Object)taskInfo.getJobId());
        this.getModel().setValue(INSTANCE_ID_INFO, (Object)taskInfo.getInstanceId());
        this.getModel().setValue(TRACE_ID_INFO, (Object)taskInfo.getTraceId());
        this.getModel().setValue(APP_ID_INFO, (Object)taskInfo.getAppid());
        this.getModel().setValue(CRON_INFO, (Object)scheduleAndJobInfo.get("cron"));
    }

    private Map<String, String> queryScheduleAndJobInfo(TaskInfo taskInfo) {
        Map schNumberInfoDojs;
        DynamicObject dynamicObject;
        Map jobNumberDojs;
        HashMap<String, String> scheduleAndJobInfo = new HashMap<String, String>(3);
        String scheduleId = taskInfo.getScheduleId();
        String jobId = taskInfo.getJobId();
        IScheduleEntityInvoker invoker = ScheduleDataEntityUtils.getInvoker();
        if (StringUtils.isNotBlank((CharSequence)jobId) && !CollectionUtils.isEmpty((Map)(jobNumberDojs = invoker.loadFromCache(SchEntityType.Job, new Object[]{jobId}, "number"))) && (dynamicObject = (DynamicObject)jobNumberDojs.get(jobId)) != null) {
            scheduleAndJobInfo.put("jobNumber", dynamicObject.getString("number"));
        }
        if (StringUtils.isNotBlank((CharSequence)scheduleId) && !CollectionUtils.isEmpty((Map)(schNumberInfoDojs = invoker.loadFromCache(SchEntityType.Schedule, new Object[]{scheduleId}, "number, plan"))) && (dynamicObject = (DynamicObject)schNumberInfoDojs.get(scheduleId)) != null) {
            scheduleAndJobInfo.put("schNumber", dynamicObject.getString("number"));
            scheduleAndJobInfo.put("cron", dynamicObject.getString("plan"));
        }
        return scheduleAndJobInfo;
    }

    public void click(EventObject evt) {
        Button queryBtn;
        if (evt.getSource() instanceof Button && StringUtils.equals((CharSequence)(queryBtn = (Button)evt.getSource()).getKey(), (CharSequence)"query")) {
            try {
                this.taskTrace();
            }
            catch (Exception e) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u8ffd\u8e2a\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ScheduleTaskTracePlugin_2", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                logger.error("Schedule***task trace error", (Throwable)e);
            }
        }
    }

    private void setVisible(String ... visibleKeys) {
        HashMap<String, Integer> visible = new HashMap<String, Integer>(1);
        visible.put("vi", 63);
        for (String visibleKey : visibleKeys) {
            this.getView().updateControlMetadata(visibleKey, visible);
        }
    }

    private void setInVisible(String ... inVisibleKeys) {
        HashMap<String, Integer> visible = new HashMap<String, Integer>(1);
        visible.put("vi", 0);
        for (String visibleKey : inVisibleKeys) {
            this.getView().updateControlMetadata(visibleKey, visible);
        }
    }

    private void resetScheduleInfoAndAnalyzeResult() {
        this.getModel().setValue(TASK_ID_INFO, (Object)"");
        this.getModel().setValue(SCH_NUMBER_INFO, (Object)"");
        this.getModel().setValue(SCH_ID_INFO, (Object)"");
        this.getModel().setValue(JOB_NUMBER_INFO, (Object)"");
        this.getModel().setValue(JOB_ID_INFO, (Object)"");
        this.getModel().setValue(INSTANCE_ID_INFO, (Object)"");
        this.getModel().setValue(TRACE_ID_INFO, (Object)"");
        this.getModel().setValue(APP_ID_INFO, (Object)"");
        this.getModel().setValue(CRON_INFO, (Object)"");
        this.getModel().setValue(ANALYZE_RESULT, (Object)ResManager.loadKDString((String)"\u6682\u65e0\u5206\u6790\u3002", (String)"ScheduleTaskTracePlugin_9", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        this.getModel().deleteEntryData(TRACE_ENTRY);
        this.getView().updateView(TRACE_ENTRY);
    }

    private static class TaskTraceRecord {
        private String time;
        private String tasktrace;

        public TaskTraceRecord(String time, String tasktrace) {
            this.time = time;
            this.tasktrace = tasktrace;
        }

        public String getTime() {
            return this.time;
        }

        public void setTime(String time) {
            this.time = time;
        }

        public String getTasktrace() {
            return this.tasktrace;
        }

        public void setTasktrace(String tasktrace) {
            this.tasktrace = tasktrace;
        }
    }
}

